:
#
# Skript zur Installation von trd2 unter Unix/Linux
#
# Zwei Installationalternativen:
# 1) "Flach":
# Alle Files werden in ein Zielverzeichnis kopiert.
# Z.B. in das Arbeitsverzeichnis fuer ein Buchprojekt.
# 2) "TDS":
# Die Files werden nach TDS (s.u.) unter ein Basisverzeichnis abgelegt.
# Z.B. im ~/TeX des Autors oder in die TeX-Installation.
# Voraussetzung: Die TeX-Installation ist TDS kompatibel
# (TDS ist die `TeX Directory Structure', s.a.
# http://www.dante.de/faq/de-tex-faq/html/uebersicht.html und
# http://www.dante.de/CTAN/tds/draft-standard/tds/)
# Dies macht nur Sinn, wenn der TeX-Baum Teil Ihrer TeX-Installation ist,
# d.h. wenn es der "standard texmf tree" ist oder er im texmf.cnf als
# lokaler TeX-Baum (TEXMFLOCAL) eingetragen ist. Denn nur so werden die
# installierten Files von latex, bibtex, makeindex, etc gefunden.
# Vorausgesetzt Sie haben nach der Installation das ls-R file aktualisiert
# (z.B. mit "mktexlsr"; nicht noetig bei Installation unter ~/TeX, denn
# dort sucht TeX ohne Hilfe eines ls-R Files).
#

# Funktion: Return-Code auswerten
function check(){
    if [ $? -ne 0 ]; then
	echo
	echo "Installation abgebrochen."
	echo
	exit
    fi
}

# richtigen TeX-Baum fuer BASEDIR raten
if [ -d /usr/share/texmf.local ]; then
    BASEDIR="/usr/share/texmf.local"
elif [ -d /usr/share/texmf ]; then
    BASEDIR="/usr/share/texmf"
elif [ -d /usr/local/texmf.local ]; then
    BASEDIR="/usr/local/texmf.local"
elif [ -d /usr/local/texmf ]; then
    BASEDIR="/usr/local/texmf"
else
    BASEDIR=""
fi
# nach BASEDIR fragen
echo
echo "Geben Sie das Basisverzeichnis fuer die Installation an."
echo "Entweder einen TeX-Baum, in dem trd2 in Unterverzeichnisse"
echo "nach TDS-Standard installiert wird (z.B. /usr/share/texmf.local oder"
echo "in Ihrem Home: ~/TeX) oder ein Verzeichnis, in das alle Files"
echo "\"flach\" installiert werden."
echo
if [ -n "$BASEDIR" ]; then
    echo "Einfach <Return> fuer den Default: $BASEDIR"
fi
read ANSWER
if [ -n "$ANSWER" ]; then
    BASEDIR="$ANSWER"
fi
if [ -z "$BASEDIR" ]; then
    echo
    echo "Kein Installationsverzeichnis. Installation abgebrochen."
    echo
    exit
fi
TARGETTEX="${BASEDIR}/tex/latex/trd"
TARGETDOC="${BASEDIR}/doc/latex/trd"
TARGETBIB="${BASEDIR}/bibtex/bst/trd"
TARGETIDX="${BASEDIR}/makeindex"
# TDS oder flach?
echo
echo "Die Installation nach TDS schreibt in folgende Verzeichnisse:"
echo " TeX Files nach     $TARGETTEX"
echo " Dokumentation nach $TARGETDOC"
echo " BiB Style nach     $TARGETBIB"
echo " Index Style nach   $TARGETIDX"
echo "Die \"flache\" Installation schreibt"
echo " alles nach         $BASEDIR"
echo "Schon existierende Files werden in beiden Faellen ueberschrieben!"
echo
echo -n "Waehlen Sie die Installationsart: TDS/flach/abbrechen (t/f/a)? "
read ANSWER
if [ "${ANSWER}" = "A" -o "${ANSWER}" = "a" ]; then
    echo
    echo "Installation abgebrochen."
    echo
    exit
elif [ "${ANSWER}" = "F" -o "${ANSWER}" = "f" ]; then
    TARGETTEX="${BASEDIR}"
    TARGETDOC="${BASEDIR}"
    TARGETBIB="${BASEDIR}"
    TARGETIDX="${BASEDIR}"
elif [ "${ANSWER}" = "T" -o "${ANSWER}" = "t" ]; then
    :
fi

# Docstrip-Module texen
tex trd2cls.ins
tex trd2cmfn.ins
echo

# Installation
install -v -d $TARGETTEX; check
for f in trd2book.cls trd2bk10.clo trdfleqn.clo trd2otrm.fd trd2ottt.fd; do
    install -v -m 0644 $f $TARGETTEX; check
done
install -v -m 0644 trd2thp.sty $TARGETTEX; check

install -v -d $TARGETDOC; check
for f in bugs.txt legal.txt manifest.txt NEWS README \
         trd2doc1.pic trd2doc2.pic trd2doc.bbl trd2doc.bib trd2doc.ind \
         trd2doc.tex trd2skel.tex trd2doc.pdf trd2doc.ps; do
    install -v -m 0644 $f $TARGETDOC; check
done

install -v -d $TARGETBIB; check
for f in trd2alpha.bst trd2alphaen.bst trd2num.bst trd2numen.bst; do
    install -v -m 0644 $f $TARGETBIB; check
done

install -v -d $TARGETIDX; check
install -v -m 0644 trd2.ist $TARGETIDX; check

echo
echo "trd2 erfolgreich installiert."
echo