// MidiEventMeter.h
// ----------------
// A UI widget that measures the amount of MIDI data generated by a
// consumer.
//
// Copyright 1999, Be Incorporated.   All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef _MidiEventMeter_h
#define _MidiEventMeter_h

#include <Point.h>
#include <Rect.h>

class BMidiProducer;
class CountEventConsumer;
class BView;

class MidiEventMeter
{
public:
	MidiEventMeter(int32 producerID);
	~MidiEventMeter();

	void Pulse(BView* view);		
	BRect Bounds() const;
	void Draw(BView* view);

private:
	int32 CalcMeterLevel(int32 eventCount) const;
	
	CountEventConsumer* m_counter;
	int32 m_meterLevel;
};

#endif /* _MidiMeterWidget_h */
