#!/usr/bin/perl -w -T
# genquery_site.pl Site-specific info

package genquery_site;
use strict;

#Whether to use a remote (dbi:mysql) or local (dbi:ODBC) database
$genquery'remote_db=1;

#Database name
$genquery'dbname='pdp8info';

#Database password on remote db
$genquery'dbpass='xxx';

#help text on forms
%genquery'formhelp=(
	"userkey","Enter a key you won't forget (for example your mother's maiden name)"
	,"link","Start with http://"
	);

#Drop-down list fields
%genquery'dropdown=(
	"recipe_type","BEVERAGE,APPETIZER,SOUP,BREAD,MAIN DISH,SALAD,DESSERT,OTHER"
	,"resource_type","ARTICLE,BOOK REVIEW,SITE,OTHER"
	);

#enter your integer or float column names here
#NOT IMPLEMENTED YET
%genquery'numeric_columns=(
	'my_column_name',1);

#hidden fields on forms for program control - generate no sql
#if you add a new command parameter add it here
#	'id',1,				#requires custom processing
%genquery'reserved_words=(
	'debug',1,
	'submit',1,
	'table',1,
	'date_created',1,	#mysql automatically updates first timestamp field
	'date_updated',1,
	'orderby',1,
	'stype',1,
	'fields',1);

#userid for logged-in user
$genquery'remote_user=$ENV{'REMOTE_USER'};
		
1;
