#!/usr/bin/perl -w -T

#use CGI;
use CGI::Carp "fatalsToBrowser";
use CGI ":all";
use DBI;
use strict;
require "./genquery.pl";
require "./genquery_site.pl";

my $q=new CGI;
my $debug=$q->param('debug');
if(!defined $debug) {$debug=0}
#$table=$q->param('table');
my $table="pdp8docs";
#$pfields=$q->param('fields');
# Force fields to display for search
my $pfields="id,title,date";
if(!defined $pfields) {$pfields='*'}
#$orderby=$q->param('orderby');
# Force fields to sort on for search
my $orderby="sort,title";
if(!defined $orderby) {$orderby=''}
my $stype=$q->param('stype');
if(!defined $stype) {$stype=''}
	
# If users has entered a search do it and exit
if(defined $q->param('Search')) {
   print $q->header,$q->start_html(-xbase=>'http://www.pdp8.net/pdp8cgi/query_docs/',$table.":Query Results");
#Submit has been pressed
	genquery::printCenter($table.":Query Results");
	my $dbh = genquery::dbOpen();
	my $sql=genquery::GenWhere($dbh, $q,"select "."sort," . $pfields." from ".$table, $stype,
             "docname,title,keywords", 1); 
	if(length($orderby)>0) {$sql.=" order by ".$orderby}
	my $cursor = genquery::dbExecute($dbh, $sql, $debug);
	genquery::GenTable($dbh, $cursor,"view.pl?table=".$table, undef, "id");
        genquery::footer();
	genquery::dbCloseCursor($cursor);
	genquery::dbClose($dbh);
	exit;
}

# Else put up search form
print $q->header,$q->start_html($table.":PDP-8 Document Search");
genquery::printCenter("PDP-8 Document Search");
print
	$q->p,'Enter selection criteria (or none for all documents) and click on <b>Submit Query</b>. &nbsp;&nbsp;',
	$q->start_form(-method=>"get");
my $dbh = genquery::dbOpen();
genquery::GenSpQuery($dbh, $debug,"Search");
genquery::dbClose($dbh);	
print "<p>",$q->submit('submit','Submit Query');
#generate hidden fields as necessary
#This makes for a long URL, might be best not to pass these things
print '<input type=hidden name=fields value="',$pfields,'">';
if ($debug != 0) {
   print '<input type=hidden name=debug value="',$debug,'">';
}
print '<input type=hidden name=table value="',$table,'">';
print '<input type=hidden name=orderby value="',$orderby,'">';
genquery::footer();
print $q->end_form;
exit;

