#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "cc11.h"

#define MAXRETRIES		3

// UBYTE blkbuf[MAXSECS<<9];

ULONG GetBlkVolSize(struct sDevice *dev)
{
	ULONG size;

	size = dev->dev.bios.cyl * dev->dev.bios.hd * dev->dev.bios.sec;
/*
	if(size > 65535)
		return 65535;
*/

	return size;
}

void Blk2CHS(struct sDevice *dev, UWORD blk, UWORD *c, UWORD *h, UWORD *s)
{
  UWORD tmp;

  tmp = dev->dev.bios.hd * dev->dev.bios.sec;	/* Blocks per Cylinder */
  *c	= blk / tmp;				/* Cylinder */
  blk -= (*c)*tmp;				/* remaining blocks */

  *h	= blk / dev->dev.bios.sec;			/* Head */
  blk	-= (*h)*(dev->dev.bios.sec);		/* remaining blocks */

  *s	= blk+1;						/* Sector */
}

void DiskReset(UBYTE nr)
{
	struct REGPACK regs;

	dos_enter();
	regs.r_ax = 0x0000;
	regs.r_dx = nr;
	intr(0x13, &regs);
	dos_exit();
}

UBYTE DiskGetType(UBYTE nr)
{
	struct REGPACK regs;

	dos_enter();
	regs.r_ax = 0x1500;
	regs.r_dx = nr;
	intr(0x13, &regs);
	dos_exit();

	return regs.r_ax>>8;
}

UWORD DiskGetSecs(struct sDevice *dev, UWORD sec, SWORD wcnt)
{
	UWORD secs, secs1, secs2;

	/* Read until end of track */
	secs1 = dev->dev.bios.sec - sec + 1;	/* Sectors until end of track */
	secs2 = wcnt>>8;					/* Total number of sectors */
	secs = (secs2>secs1)?secs1:secs2;
	if(secs > MAXSECS)
		secs = MAXSECS;
	if(secs==0)
		secs = 1;

	return secs;
}

UBYTE DiskRW(int bios, UBYTE *buffer, int wrt, UWORD cyl, UWORD hd, UWORD sec,
					UWORD secs)
{
	UBYTE err;
	int retrycnt;

	xprintf("  Track %s C/H/S %d/%d/%d  (%d sectors)\r\n",
				wrt?"write":"read", cyl, hd, sec, secs);

	retrycnt = MAXRETRIES;
	do
	{
		err = DiskIO(wrt?0x03:0x02, cyl, hd, sec, secs,
							bios, buffer);
		if(err)
		{
			xprintf("  I/O retry\r\n");
			DiskReset(bios);
		}
	}while(err && --retrycnt);

	return err;
}

UBYTE DiskIO(UBYTE cmd, UWORD cyl, UWORD hd, UWORD sec, UWORD secs,
					UBYTE nr, UBYTE *buf)
{
	struct REGPACK regs;

	dos_enter();
	regs.r_ax = cmd<<8 | secs;
	regs.r_cx = cyl<<8 | sec;
	regs.r_dx = hd<<8 | nr;
	regs.r_es = FP_SEG(buf);
	regs.r_bx = FP_OFF(buf);
	intr(0x13, &regs);
	dos_exit();

	return regs.r_ax>>8;
}

void DoBlockIO(struct sDevice *dev)
{
	UBYTE cmd, unit;
	ULONG l;
	UWORD blk;
	SWORD wcnt;
	UWORD cyl, hd, sec;
	UWORD secs, secs2;
	UBYTE *bb;
	UBYTE drvtype, err;
	int access;

	access = dev->access;
	cmd = dev->cmd;
	unit = dev->unit;

	switch(cmd)
	{
		case CMD_READ:
			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					dev->blk = blk;
					dev->wcnt = wcnt;
					xprintf("PAR_READ: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					/* Get BIOS drive type (floppy w/o DC, floppy with DC, or HD) */
					drvtype = DiskGetType(dev->dev.bios.bios);
					if(!drvtype)
					{
						xprintf("ERROR: Bios drive %d not present\r\n", dev->dev.bios.bios);
						SendGetNACK();
						break;
					}

					while(wcnt > 0)
					{
						Blk2CHS(dev, blk, &cyl, &hd, &sec);
						secs = DiskGetSecs(dev, sec, wcnt);
						if(DiskRW(dev->dev.bios.bios, dev->buffer, 0, cyl, hd, sec, secs))
						{
							SendGetNACK();
							break;
						}

						bb = dev->buffer;
						while(secs>0 && wcnt>0)
						{
							if(!SendGetACK())
							{
								wcnt = 0;
								break;
							}
							SndBuffer(bb, (wcnt>=256)?512:(wcnt<<1));

							bb += 512;
							wcnt -= 256;
							secs--;
							blk++;
						}
					}

					break;

				case ACCESS_NETWORK:
					blk = dev->blk;
					wcnt = dev->wcnt;

					xprintf("NET_READ: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					/* Get BIOS drive type (floppy w/o DC, floppy with DC, or HD) */
					drvtype = DiskGetType(dev->dev.bios.bios);
					if(!drvtype)
					{
						xprintf("ERROR: Bios drive %d not present\r\n", dev->dev.bios.bios);
						break;
					}

#if 1
					while(wcnt > 0)
					{
						Blk2CHS(dev, blk, &cyl, &hd, &sec);
						secs = DiskGetSecs(dev, sec, wcnt);
						if(DiskRW(dev->dev.bios.bios, dev->buffer, 0, cyl, hd, sec, secs))
						{
//							break;
						}

						if(!SOCK_WRITE(dev->lsock, dev->buffer, secs<<9))
						{
							xprintf("NET: I/O error writing to socket\r\n");
							break;
						}

						wcnt -= secs<<8;
						blk += secs;
					}
//					sock_flush(dev->lsock);
#else
					while(wcnt > 0)
					{
						Blk2CHS(dev, blk, &cyl, &hd, &sec);
						secs = DiskGetSecs(dev, sec, wcnt);
						if(DiskRW(dev, 0, cyl, hd, sec, secs))
						{
							break;
						}

						bb = dev->buffer;
						while(secs>0 && wcnt>0)
						{
							if(!SOCK_WRITE(dev->lsock, bb, 512))
							{
								wcnt = 0;
								xprintf("NET: I/O error writing to socket\r\n");
								break;
							}

							bb += 512;
							wcnt -= 256;
							secs--;
							blk++;
						}
					}
#endif

					break;
			}
			break;

		case CMD_WRITE:
			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					dev->blk = blk;
					dev->wcnt = wcnt;
					xprintf("PAR_WRITE: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					/* Get BIOS drive type (floppy w/o DC, floppy with DC, or HD) */
					drvtype = DiskGetType(dev->dev.bios.bios);
					if(!drvtype)
					{
						xprintf("ERROR: Bios drive %d not present\r\n", dev->dev.bios.bios);
						SendGetNACK();
						break;
					}

					while(wcnt > 0)
					{
						Blk2CHS(dev, blk, &cyl, &hd, &sec);
#if 0
						xprintf("  Track write C/H/S %d/%d/%d  ", cyl, hd, sec);

						/* Read until end of track */
						secs1 = dev->dev.bios.sec - sec + 1;	/* Sectors until end of track */
						secs2 = wcnt>>8;					/* Total number of sectors */
						secs = (secs2>secs1)?secs1:secs2;
						if(secs > MAXSECS)
							secs = MAXSECS;
						if(secs==0)
							secs = 1;

						xprintf("(%d sectors)\r\n", secs);
#else
						secs = DiskGetSecs(dev, sec, wcnt);
#endif
						secs2 = secs;

						err = 0;
						bb = dev->buffer;
						while(secs2 > 1)
						{
							RcvBuffer(bb, 512);
							if(!SendGetACK())
							{
								wcnt = 0;
								err  = 0xFF;
								break;
							}

							bb += 512;
							wcnt -= 256;
							secs2--;
							blk++;
						}
						if(err)
							break;

						if(wcnt < 256)
							memset(bb, 0, 512);

						/* Receive last words */
						RcvBuffer(bb, (wcnt>=256)?512:(wcnt<<1));
						wcnt -= 256;
						blk++;

#if 0
						retrycnt = MAXRETRIES;
						do
						{
							err = DiskIO(0x03, cyl, hd, sec, secs,
												dev->dev.bios.bios, dev->buffer);
							if(err)
							{
								xprintf("  I/O retry\r\n");
								DiskReset(dev->dev.bios.bios);
							}
						}while(err && --retrycnt);
#else
						err = DiskRW(dev->dev.bios.bios, dev->buffer, 1, cyl, hd, sec, secs);
#endif

						if(err)
						{
							SendGetNACK();
							break;
						}

						if(!SendGetACK())
							break;
					}

					break;

				case ACCESS_NETWORK:
					blk = dev->blk;
					wcnt = dev->wcnt;

					xprintf("NET_WRITE: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					/* Get BIOS drive type (floppy w/o DC, floppy with DC, or HD) */
					drvtype = DiskGetType(dev->dev.bios.bios);
					if(!drvtype)
					{
						xprintf("ERROR: Bios drive %d not present\r\n", dev->dev.bios.bios);
						break;
					}

					while(wcnt > 0)
					{
						Blk2CHS(dev, blk, &cyl, &hd, &sec);
						secs = DiskGetSecs(dev, sec, wcnt);

						if(!SOCK_READ(dev->lsock, dev->buffer, secs<<9))
						{
							xprintf("NET: I/O error writing to socket\r\n");
							break;
						}
/*
						bb = dev->buffer;
						while(secs>0 && wcnt>0)
						{
							if(!SOCK_READ(dev->lsock, bb, 512))
							{
								wcnt = 0;
								xprintf("NET: I/O error writing to socket\r\n");
								break;
							}

							bb += 512;
							wcnt -= 256;
							secs--;
							blk++;
						}
*/

						err = DiskRW(dev->dev.bios.bios, dev->buffer, 1, cyl, hd, sec, secs);

						wcnt -= secs<<8;
						blk += secs;
					}

					break;
			}
			break;

		case CMD_GETVOLSIZ:
			l = GetBlkVolSize(dev);
			blk = (l>65535)?65535:(UWORD)l;

			switch(access)
			{
				case ACCESS_PARALLEL:
					xprintf("PAR_GETVOLSIZ: Unit %d has size %u\r\n", unit, blk);
					if(!SendGetACK()) break;
					SndWord(blk);
					break;

				case ACCESS_NETWORK:
					xprintf("NET_GETVOLSIZ: Unit %d has size %u\r\n", unit, blk);
//					sock_flushnext(dev->lsock);
					sock_write(dev->lsock, (byte *)(&l), 4);
					break;
			}
			break;
	}
}
