#ifndef _CC11_H
#define _CC11_H

#include <stdio.h>

#include <conio.h>
#include <rtos.h>
#include <net.h>

/* Data type definitions */

typedef signed char SBYTE;
typedef unsigned char UBYTE;
typedef signed short SWORD;
typedef unsigned short UWORD;
typedef signed long LONG;
typedef unsigned long ULONG;

/* ParPort I/O ports */

#define LPT_BASE	0x378
#define LPT_DATA	LPT_BASE
#define LPT_STAT	LPT_BASE+1
#define LPT_CTRL	LPT_BASE+2

/* ParPort control bits */

#define CTRL_STROBE	0x01
#define CTRL_AUTOLF	0x02
#define CTRL_INIT		0x04
#define CTRL_SELECT	0x08
#define CTRL_INTENA	0x10
#define CTRL_BIDIR	0x20

/* ParPort commands */

#define CTRLBYTEINIT		0x00
#define CTRLBYTEIN		0x26
#define CTRLBYTEINACK	0x27
#define CTRLBYTEOUT		0x0e
#define CTRLBYTEOUTACK	0x0f

/* Command definitions */

#define CMD_READ			0x01
#define CMD_WRITE			0x02
#define CMD_GETVOLSIZ	0x10

/* Error response definitions */

#define ERR_OK				0x00
#define ERR_NOUNIT		0x01
#define ERR_RDERR			0x02
#define ERR_WRERR			0x03
#define ERR_IOERR			0x04
#define ERR_NETERR		0x05

/* RTOS messages */

#define RTMSG_QUIT		EMSG_USER		/* terminate program */
#define RTMSG_RESTART	EMSG_USER+1		/* restart program */
#define RTMSG_SHDRV		EMSG_USER+2		/* show drives */
#define RTMSG_NEWTELNET	EMSG_USER+3		/* start new telnet daemon */

/* Global definitions */

#define MAXUNITS			8
#define MAXNETPORTS		8

#define MAXSECS			63					/* defines buffer space */
#define NETBUFSIZE		(63*512)			/* network I/O buffer space */
													/* ATTENTION: signed int value */

#define SYNC_CHAR			0xCC

#define TYPE_NONE			0
#define TYPE_BLOCK		1
#define TYPE_FILE			2
#define TYPE_NET			3

#define SOCK_READ(s,b,l)	(sock_read(s,(byte *)(b),l)==l)
#define SOCK_WRITE(s,b,l)	(sock_write(s,(byte *)(b),l)==l)

/* Structure definitions */

struct sFile
{
	FILE *file;
	char *filename;
};

struct sBios
{
	int	bios;				/* BIOS drive number */
	int	use_lba;			/* whether LBA should be used */
	UWORD	cyl, hd, sec;	/* total number of cylinders, heads and sectors/trk */
	UWORD	secsize;			/* bytes per sector */
	ULONG	blk;
};

struct sNet
{
	DWORD			host;
	char			*hostname;
	int			port;
	int			unit;
	tcp_Socket	*sock;
};

enum eDevAccess { ACCESS_NONE=0, ACCESS_PARALLEL, ACCESS_NETWORK };

struct sDevice
{
	int	type;
	ULONG	size;				/* total size in blocks */
	UBYTE	*buffer;			/* I/O buffer */
	int	access;			/* type of current access (par.,net,none) */
	crit_x *cs;				/* critical section */
	tcp_Socket *lsock;	/* socket of local network port daemon */

	/* parameters of last I/O */
	UBYTE	cmd, unit;
	UWORD blk;
	SWORD wcnt;

	union
	{
		struct sFile file;
		struct sBios bios;
		struct sNet net;
	}dev;
};

struct sNetport
{
	tcp_Socket *s;
	void *thread;
};

/* Function prototypes */

/* pario.c */
UBYTE RcvByte(void);
UWORD RcvWord(void);
void SndByte(UBYTE);
void SndWord(UWORD);
void RcvBuffer(UBYTE *, UWORD);
void SndBuffer(UBYTE *, UWORD);

/* fileio.c */
ULONG GetVolSize(FILE *);
void DoFileIO(struct sDevice *);

/* blkio.c */
ULONG GetBlkVolSize(struct sDevice *);
UBYTE DiskIO(UBYTE, UWORD, UWORD, UWORD, UWORD,	UBYTE, UBYTE *);
void DoBlockIO(struct sDevice *);

/* telnet.c */
void tprintf(char *);
void TelnetThread(DWORD);

/* main.c */
void Rcv_RW_Param(UWORD *, SWORD *);
int SendGetACK(void);
void SendGetNACK(void);
void xprintf(char *, ...);
void DoIO(struct sDevice *, int);
void ShowDrives(void);
void Restart(void);

#endif
