#include <stdlib.h>

#include "cc11.h"

/* extern UBYTE *Puffer; */

// UBYTE filebuf[512];

ULONG GetVolSize(FILE *d)
{
	long s;

	dos_enter();
	fseek(d, 0L, SEEK_END);
	s = ftell(d);
	fseek(d, 0L, SEEK_SET);
	dos_exit();

	if(s < 0L)
		return 0L;

	s += 511;	/* round up */
	s >>= 9;		/* number of blocks */
	s = labs(s);

/*
	if(s > 65535)
		return 65535;
*/

	return (ULONG)s;
}

void DoFileIO(struct sDevice *dev)
{
	FILE *Datei;
	ULONG l;
	UWORD blk;
	SWORD wcnt;
	UBYTE cmd, unit;
	int access;

	access = dev->access;
	cmd = dev->cmd;
	unit = dev->unit;
	Datei = dev->dev.file.file;

	switch(cmd)
	{
		case CMD_READ:
			/* Read blocks */

			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					dev->blk = blk;
					dev->wcnt = wcnt;
					xprintf("PAR_READ: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);
					dos_enter();
					fseek(Datei, ((long)blk)<<9, SEEK_SET);
					dos_exit();

					while(wcnt > 0)
					{
						dos_enter();
						fread(dev->buffer, 1, 512, Datei);
						dos_exit();

						if(!SendGetACK()) break;
						SndBuffer(dev->buffer, (wcnt>=256)?512:(wcnt<<1));

						wcnt -= 256;
					}
					break;

				case ACCESS_NETWORK:
					blk = dev->blk;
					wcnt = dev->wcnt;

					xprintf("NET_READ: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					dos_enter();
					fseek(Datei, ((long)blk)<<9, SEEK_SET);
					dos_exit();

					while(wcnt > 0)
					{
						dos_enter();
						fread(dev->buffer, 1, 512, Datei);
						dos_exit();

						if(!SOCK_WRITE(dev->lsock, dev->buffer, 512))
						{
							xprintf("NET: I/O error writing to socket\r\n");
							break;
						}

						wcnt -= 256;
					}
					sock_flush(dev->lsock);
					break;
			}
			break;

		case CMD_WRITE:
			/* Write blocks */

			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					dev->blk = blk;
					dev->wcnt = wcnt;
					xprintf("PAR_WRITE: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);
					dos_enter();
					fseek(Datei, ((long)blk)<<9, SEEK_SET);
					dos_exit();

					while(wcnt > 0)
					{
						RcvBuffer(dev->buffer, (wcnt>=256)?512:(wcnt<<1));

						dos_enter();
						fwrite(dev->buffer, 1, 512, Datei);
						dos_exit();

						if(!SendGetACK()) break;
						wcnt -= 256;
					}
					break;

				case ACCESS_NETWORK:
					blk = dev->blk;
					wcnt = dev->wcnt;

					xprintf("NET_WRITE: Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					dos_enter();
					fseek(Datei, ((long)blk)<<9, SEEK_SET);
					dos_exit();

					while(wcnt > 0)
					{
						if(!SOCK_READ(dev->lsock, dev->buffer, 512))
						{
							xprintf("NET: I/O error reading from socket\r\n");
							break;
						}

						dos_enter();
						fwrite(dev->buffer, 1, 512, Datei);
						dos_exit();

						wcnt -= 256;
					}
					break;
			}
			break;

		case CMD_GETVOLSIZ:
			/* Get Volume Size */

			l = GetVolSize(Datei);
			blk = (l>65535)?65535:(UWORD)l;

			switch(access)
			{
				case ACCESS_PARALLEL:
					xprintf("PAR_GETVOLSIZ: Unit %d has size %u\r\n", unit, blk);
					if(!SendGetACK()) break;
					SndWord(blk);
					break;

				case ACCESS_NETWORK:
					xprintf("NET_GETVOLSIZ: Unit %d has size %u\r\n", unit, blk);
					sock_flushnext(dev->lsock);
					sock_write(dev->lsock, (byte *)(&l), 4);
					break;
			}
			break;
	}
}
