#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "cc11.h"

int WaitSocket(tcp_Socket *s)
{
	while(!sock_established(s))
	{
		if(!tcp_tick(s))
			return 0;
	}

	return 1;
}

void FillCmdBuf(UBYTE *buf, UBYTE cmd, UBYTE unit, UWORD blk, SWORD wcnt)
{
	buf[0] = cmd;
	buf[1] = unit;
	((UWORD *)(buf))[1] = blk;
	((SWORD *)(buf))[2] = wcnt;
}

int SendNetCmd(UBYTE *buf, tcp_Socket *s)
{
	UWORD w;

//	sock_flushnext(s);
	/* send command and parameters */
	if(!SOCK_WRITE(s, buf, 6))
		return ERR_NETERR;

	/* get status */
	if(!SOCK_READ(s, &w, 2))
	{
		return ERR_NETERR;
	}

xprintf("**SendNetCmd returns $%04X\r\n", w);
	return (int)w;
}

void DoNetIO(struct sDevice *dev)
{
	tcp_Socket *s;
	ULONG l;
	UBYTE cmd, unit;
	UWORD blk;
	SWORD wcnt, wcnt2;
	int rdcnt, bcnt, bcnt2;
	UBYTE	cmdbuf[6], *netbuf, *bb;
	int access;

	s = dev->dev.net.sock;
	netbuf = dev->buffer;
	access = dev->access;
	cmd = dev->cmd;
	unit = dev->dev.net.unit;

	if(!WaitSocket(s))
	{
		xprintf("ERROR: No connection to server for unit %d\r\n", unit);
		SendGetNACK();
		return;
	}

	switch(cmd)
	{
		case CMD_READ:
			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					xprintf("CMD_READ: Remote Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					FillCmdBuf(cmdbuf, CMD_READ, unit, blk, wcnt);
					if(SendNetCmd(cmdbuf, s))
					{
						SendGetNACK();
						break;
					}

					while(wcnt > 0)
					{
#if 1
						if(wcnt > (NETBUFSIZE>>1))
						{
							wcnt2 = NETBUFSIZE >> 1;
							bcnt2 = NETBUFSIZE;
						}
						else
						{
							wcnt2 = wcnt;
							bcnt2 = (wcnt+255) >> 8;
							bcnt2 <<= 9;
						}

						rdcnt = sock_read(s, netbuf, bcnt2);
						if(rdcnt != bcnt2)
						{
							xprintf("ERROR: Short read from socket, %d vs. %d bytes\r\n",
										rdcnt, bcnt2);
							SendGetNACK();
							break;
						}

						wcnt -= wcnt2;
						bb = netbuf;
						while(wcnt2 > 0)
						{
							bcnt = (wcnt2>=256)?512:(wcnt2<<1);
							if(!SendGetACK())
							{
								wcnt = 0;
								break;
							}
							SndBuffer(bb, bcnt);
							wcnt2 -= 256;
							bb += 512;
						}
#else
						bcnt = 512;
						rdcnt = sock_read(s, netbuf, bcnt);
						if(rdcnt != bcnt)
						{
							xprintf("ERROR: Short read from socket, %d vs. %d bytes\r\n",
										rdcnt, bcnt);
							SendGetNACK();
							break;
						}

						if(!SendGetACK())
							break;
						SndBuffer(netbuf, bcnt);

						wcnt -= 256;
#endif
					}

					break;
			}
			break;

		case CMD_WRITE:
			switch(access)
			{
				case ACCESS_PARALLEL:
					Rcv_RW_Param(&blk, &wcnt);
					xprintf("CMD_WRITE: Remote Unit %d, Block %u, WCnt %d\r\n",
								unit, blk, wcnt);

					FillCmdBuf(cmdbuf, CMD_WRITE, unit, blk, wcnt);
					if(SendNetCmd(cmdbuf, s))
					{
						SendGetNACK();
						break;
					}

					while(wcnt > 0)
					{
						bcnt = (wcnt>=256)?512:(wcnt<<1);
						if(bcnt < 512)
							memset(netbuf, 0, 512);

						RcvBuffer(netbuf, bcnt);

						rdcnt = sock_write(s, netbuf, 512);
						if(rdcnt != 512)
						{
							xprintf("ERROR: Short write to socket, %d vs. %d bytes\r\n",
										rdcnt, bcnt);
							SendGetNACK();
							break;
						}

						if(!SendGetACK()) break;
						wcnt -= 256;
					}
					sock_flush(s);

					break;
			}
			break;

		case CMD_GETVOLSIZ:
			switch(access)
			{
				case ACCESS_PARALLEL:
					FillCmdBuf(cmdbuf, CMD_GETVOLSIZ, unit, 0, 0);
					if(SendNetCmd(cmdbuf, s))
					{
						SendGetNACK();
						break;
					}

					if(!SOCK_READ(s, &l, 4))
					{
						SendGetNACK();
						break;
					}

					if(!SendGetACK()) break;
					blk = (l>65535)?65535:(UWORD)l;
					xprintf("CMD_GETVOLSIZ: Remote Unit %d has size %u\r\n", unit, blk);
					SndWord(blk);

					break;
			}
			break;
	}
}
