#include "cc11.h"

extern int BreakKey;

UBYTE RcvByte()
{
	UBYTE x;

#if 0
	outp(LPT_CTRL, CTRLBYTEIN);
	while(inp(LPT_STAT)&0x40)			/* wait until -ACK active */
		if(BreakKey) goto s9;
	x = inp(LPT_DATA);
	outp(LPT_CTRL, CTRLBYTEINACK);	/* toggle -STROBE */
	outp(LPT_CTRL, CTRLBYTEIN);
#else
	asm {
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEIN
		  out     dx, al
		  mov     dx, LPT_STAT
	}
s1:
	asm {
		  in      al, dx
		  cmp     [BreakKey], 0
		  jnz     s9
		  and     al, 40h
		  jnz     s1

		  mov     dx, LPT_DATA
		  in      al, dx
		  mov     [x], al
	}
s3:
	asm {
		  mov		dx, LPT_STAT
		  in		al, dx
		  and		al, 80h
		  jnz		s3

		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEINACK
		  out     dx, al
		  mov     al, CTRLBYTEIN
		  out     dx, al
	}
#endif
s9:

	return x;
}

UWORD RcvWord()
{
	UBYTE b1, b2;

	b1 = RcvByte();
	b2 = RcvByte();
	return (b2 << 8) | b1;
}

void SndByte(UBYTE x)
{
#if 0
	outp(LPT_CTRL, CTRLBYTEOUT);
	while(!(inp(LPT_STAT)&0x10))			/* wait until +SELECT_IN active */
		if(BreakKey) goto s9;
	outp(LPT_DATA, x);
	outp(LPT_CTRL, CTRLBYTEOUTACK);		/* toggle -STROBE */
	outp(LPT_CTRL, CTRLBYTEOUT);
#else
	asm {
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEOUT
		  out     dx, al
		  mov     dx, LPT_STAT
	}
s1:
	asm {
		  in      al, dx
		  cmp     [BreakKey], 0
		  jnz     s9
		  and     al, 10h
		  jz     s1

		  mov     dx, LPT_DATA
		  mov		al, byte [x]
		  out		dx, al

		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEOUTACK
		  out     dx, al
		  mov     al, CTRLBYTEOUT
		  out     dx, al

		  mov		dx, LPT_STAT
	}
s2:
	asm {
			/* Wait until byte has been accepted on the remote end */
			/* This is necessery because the DR11-C has no input buffer */
			cmp	[BreakKey], 0
			jnz	s9
			in		al, dx
			and	al, 10h
			jz		s2
	}
#endif
s9:
}

void SndWord(UWORD x)
{
	SndByte(x & 255);	/* send low byte */
	SndByte(x>>8);		/* send high byte */
}

void RcvBuffer(UBYTE *p, UWORD bcnt)
{
#if 0
	outp(LPT_CTRL, CTRLBYTEIN);
	while(!BreakKey && bcnt)
	{
		while(inp(LPT_STAT)&0x40)
			if(BreakKey) goto s9;
		*p++ = inp(LPT_DATA);
		outp(LPT_CTRL, CTRLBYTEINACK);
		outp(LPT_CTRL, CTRLBYTEIN);
		bcnt--;
	}
#else
	UWORD segm, offs;

	segm = FP_SEG(p);
	offs = FP_OFF(p);

	asm {
		  /* Port auf Eingabe schalten */
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEIN
		  out     dx, al

		  /* Parameter in Register bertragen zum schnelleren Zugriff */
		  mov		ax, [segm]
		  mov		es, ax
/*		  mov     bx, word ptr p */
		mov	bx, [offs]
		  mov     cx, [bcnt]

		  /* Hauptschleife ber cx (Anzahl Bytes) */
	}
s1:
	asm {mov     dx, LPT_STAT }
s2:
	asm {
		  cmp     [BreakKey], 0
		  jnz     s9
		  in      al, dx
		  and     al, 40h                 /* warte bis Zeichen vorhanden */
		  jnz     s2							/* ACK Signalleitung */

		  /* Empfange Zeichen */
		  mov     dx, LPT_DATA
		  in      al, dx
//		  mov     byte [bx], al           /* Zeichen in Puffer ablegen */
		mov	byte [es:bx], al
		  inc     bx                      /* Adresse inkrementieren */

		  /* Warte, bis Reset-Eingang des FF inaktiv */
		  mov		dx, LPT_STAT
	}
s3:
	asm {
		  in 		al, dx
		  and		al, 80h
		  jnz		s3

		  /* Quittiere Empfang */
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEINACK
		  out     dx, al
		  mov     al, CTRLBYTEIN
		  out     dx, al

		  /* Weiter mit nchstem Zeichen */
		  loop    s1
	}
#endif
s9:
}

void SndBuffer(UBYTE *p, UWORD bcnt)
{
#if 0
	outp(LPT_CTRL, CTRLBYTEOUT);
	while(!BreakKey && bcnt)
	{
		while(!(inp(LPT_STAT)&0x10))
			if(BreakKey) goto s9;
		outp(LPT_DATA, *p++);
		outp(LPT_CTRL, CTRLBYTEOUTACK);
		outp(LPT_CTRL, CTRLBYTEOUT);
		bcnt--;
	}
#else
	UWORD segm, offs;

	segm = FP_SEG(p);
	offs = FP_OFF(p);

	asm {
		  /* Port auf Ausgabe schalten */
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEOUT
		  out     dx, al

		  /* Parameter in Register bertragen zum schnelleren Zugriff */
//		  mov     bx, word ptr p
		mov	ax, [segm]
		mov	es, ax
		mov	bx, [offs]
		  mov     cx, [bcnt]

		  /* Hauptschleife ber cx (Anzahl Bytes) */
	}
s1:
	asm {mov     dx, LPT_STAT }
s2:
	asm {
		  cmp     [BreakKey], 0
		  jnz     s9
		  in      al, dx
		  and     al, 10h                 /* warte bis Gegenstelle bereit */
		  jz     s2							/* SELECT_IN Signalleitung */

		  /* Sende Zeichen */
//		  mov		al, byte [bx]
		mov	al, byte [es:bx]
		  mov     dx, LPT_DATA
		  out     dx, al
		  inc     bx                      /* Adresse inkrementieren */

		  /* Setze Sendeflag */
		  mov     dx, LPT_CTRL
		  mov     al, CTRLBYTEOUTACK
		  out     dx, al
		  mov     al, CTRLBYTEOUT
		  out     dx, al

		  /* Weiter mit nchstem Zeichen */
		  loop    s1

		  mov		dx, LPT_STAT
	}
s3:
	asm {
			/* Wait until byte has been accepted on the remote end */
			/* This is necessery because the DR11-C has no input buffer */
			cmp	[BreakKey], 0
			jnz	s9
			in		al, dx
			and	al, 10h
			jz		s3
	}
#endif
s9:
}
