#include "cc11.h"

#include <telnetd.h>

int telnet_active = 0;
teld_str *t;

void telnet_welcome(void)
{
	teld_puts(t, "\033[2J\033[H");
	teld_puts(t, "\033[1mCC11 - Remote console\033[0m\r\n");
	teld_puts(t, "CTRL-C to terminate CC11 program\r\n\n");
	teld_puts(t, "D - Show drives\r\n");
	teld_puts(t, "H - Show this help\r\n");
	teld_puts(t, "Q - Terminate telnet session\r\n");
	teld_puts(t, "R - Restart program\r\n\n");
}

void tprintf(char *str)
{
	if(telnet_active)
		teld_puts(t, str);
}

void TelnetThread(DWORD dummy)
{
	UBYTE ch, str[32];
	sockaddr sa;
	int i;

	do
	{
		t = teld_listen(TELNETPORT);
		kwritemessage(kmainthread, RTMSG_NEWTELNET, 0);

		i = sizeof(sa);
		if(getpeername(&t->teld_socket, &sa, &i))
			sprintf(str, "(unknown)");
		inet_ntoa(str, sa.s_ip);
		xprintf("Connection to remote console from %s:%d\r\n", str, sa.s_port);

		telnet_welcome();
		telnet_active = 1;

		do
		{
			ch = teld_getc(t);
			switch(toupper(ch))
			{
				case 3:
					kwritemessage(kmainthread, RTMSG_QUIT, 0);
					break;

				case 'D':
					kwritemessage(kmainthread, RTMSG_SHDRV, 0);
					break;

				case 'H':
					telnet_welcome();
					break;

				case 'Q':
					ch = 255;
					break;

				case 'R':
					Restart();
					break;
			}
		}while(ch!=255);

		telnet_active = 0;
		teld_close(t);
		xprintf("Connection to remote console closed.\r\n");
	}while(1);
}
