/*
 * http_d.c bare bones web server
 */
#include <rtos.h>
#include <net.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <httpd.h>


void userproc( tcp_Socket *s, char *cmd, char *name, char *ext )
{
    html_hdr( s , "hello");
    sock_puts( s, "You asked for ");
    sock_puts( s, name );
    sock_puts( s, ".");
    if (ext) sock_puts( s, ext );
    html_tail( s );
}

main()
{
    int i;

    kdebug = 1;
    rt_init(100);
    kpreemptive = 1;        /* enable pre-emptive multithreading */
    sock_init();            /* initialize network */

    cputs("starting...\r\n");
#define MAXHTTPD 5
    for ( i = 0 ; i < MAXHTTPD; ++i )
        rt_newthread( httpdthread, (DWORD)&userproc, 2048, 0, "httpd worker" );
    do {
        /* nothing */
        rt_yield();
    } while ( 1 );
}


