/*
 * eRTOS SNMP Sample #2 - a more powerful, dynamic SNMP MIB application
 *
 * see snmp_d.c for background
 */

#include <stdio.h>
#include <string.h>
#include <snmp.h>
#include <rtos.h>
#include <net.h>
#include <time.h>

esnmp_oid far local_oids[] =
    { { 0,{1,3,6,1,2,1,1,1,0, -1}, NULL, SNMP_DISPLAYSTR, (DWORD)"eRTOS example" },
      { 0,{1,3,6,1,2,1,1,3,0, -1}, NULL, SNMP_TIMETICKS, 1 },
      { 0,{1,3,6,1,2,1,1,4,0, -1}, NULL, SNMP_DISPLAYSTR, (DWORD)"Contact: joe" },

      /* list terminator */
      { 0,{ -1 }, NULL, 0, 0 }
      };

/* User function called before each MIB walk */
/* this function is called within the SNMPD's thread context */
void prewalkfn( int op,  SNMP_OBJECT *list )
{
    int temp;
                 /* just using LEN and OID part, all other fields unused */
    static esnmp_oid testcase = { 9, { 1,3,6,1,2,1,1,1,0,-1}, NULL, 0, 0 };

    /* we have the semaphore on the table, nothing can access it while  *
     * we are inside this function                                      */

    /***********************************************************/


    /* we can update data */

    /* example, we will set the uptime value */
    /* we are about to call DOS, so block thread switches for the instant */
    kblock();
    /* call Borland fn to get uptime of application in 18/second */
    local_oids[ 1 ].data2 = clock() / 18;
    kunblock();

    /* we don't have to recompile after changes to data values  *
     * where the OID is unchanged                               */

    /***********************************************************/

    /* we can look at the incoming SNMP operation and OID and   *
     * just react if it is a particular one, print out message  */
    if ( _snmp_compare_oid( list, &testcase ) == 0 ) {
        if ( op == SNMP_PDU_GET )
            cputs("Message: getting sysDesc\r\n");

        if ( op == SNMP_PDU_NEXT )
            cputs("Message: getting next one past sysDesc\r\n");
    }

    /***********************************************************/

    /* we can change the MIB table - there are two possibilities,
     *     - we can work with a static table and change its entries
     *     - we can kcalloc() a new tree to whatever size is needed
     */

    /* example, here we will just change an entry's OID value                *
     * note, this example can cause a short loop if GETNEXT is being used to *
     * walk the MIB table.  But don't assume we will be called in sequence   *
     * or just by one SNMP client on one client computer                     */

    temp = local_oids[ 2 ].oid[ 8 ];
    temp = (temp+1) % 8;
    local_oids[2].oid[8] = temp;

    /* we must recompile the MIB table after changes to OIDs */
    snmp_compile_oids( local_oids );

}
void main(int argc, char **argv)
{
    kdebug = 1;
    rt_init( 100 );
    sock_init();

    snmp_compile_oids( local_oids );

    /* tell SNMP server to call our function before walking the MIB table */
    _snmp_prewalk = prewalkfn;

    rt_newthread( snmpthread,  1,2048, 0, "snmpd" );

    while (1) {
        rt_sleep(1000);
    }
}

