#include <stdio.h>
#include <rtos.h>

/*
 * Demonstrate's eRTOS ability to catch stack overflow in child threads.
 * We will recursively call demo() until it crashes
 * In normal cases, will detect overwriting of SS:0 and SP wraparound
 */


/*********************************************************/
void demo(void)
{
    cprintf("\r Current  SS:SP : %04x:%04x  Stack Used : %04x  ", _SS, _SP, rt_stackused( NULL ) );
    rt_sleep(1);
    demo();
}
/*********************************************************/
void test(DWORD arg)
{

    cprintf("\r Starting SS:SP : %04x:%04x\r\n ", _SS, _SP );
    cprintf("with stack length %04x \r\n", kcurthread->th_stacklen );
    demo();
}
/*********************************************************/

main()
{
    int i;

    // changing the next line would all that is needed to make this
    // a pre-emptive multithreaded application

    kdebug = 1;
    rt_init(100);

    kcheckstacksig = 0; /* turn off SP:00 testing, or else we will get *
                         * stack signature error.                      */

    cputs("demonstrate stack overflow...\r\n");

    rt_timerfreq( 100 );
    rt_newthread( test,  1,4096, 0, "worker 1" );

    for ( i = 0 ; i < 1000 ; ++i ) {
        rt_sleep( 10 );
    }
}


