/*
 * basic TTY terminal example demonstrating SIO serial i/o library
 *
 * Gets defaults from TERM.INI, or creates one if none there
 */

#include <dos.h>
#include <stdio.h>
#include <rtos.h>
#include <sio.h>
#include <inifile.h>

main()
{
    int comport = 1;        /* com port */
    WORD port = 0x3f8;      /* its i/o port base */
    int baud;
    int irq = 4;            /* default for com1 */

    int temp;
    DWORD dummy;

    rt_init( 100 );
    kdebug = 3;

    if (( comport = GetIniDWORD( "term.ini", "com", "port", 0 )) == 0 ){
        comport = 1;
        SetIniDWORD("term.ini","com","port", comport );
    }
    if ( comport == 2 ) {
        port = 0x2f8;
        irq = 3;
    }
    if (( baud = GetIniDWORD( "term.ini", "com", "baud", 0 )) == 0 ){
        baud = 9600;
        SetIniDWORD("term.ini","com","baud", baud );
    }


    sio_init( comport, port, irq, 4096, 4096, NULL, 0 );
    sio_setup( comport, baud, 8, 0, 1, 1 );

    cprintf("Press ~ to exit\r\n");

    while ( 1 ) {

        /* poll keyboard for new data */
        if ( kbhit() ) {
            char ch;
            ch = getch();
            /* is it the exit char? */
            if ( ch == '~' ) break;
            sio_writebyte( comport, ch );
        }

        /* poll serial port for new data */
        if ( sio_recv_waiting( comport ) )
            putch( sio_readbyte( comport ));
    }
    sio_close( comport );
}

