/**************************************************************************/
/* TEST10 - show time impact of changing PC timer frequency               */
/**************************************************************************/

#include <stdio.h>
#include <rtos.h>

void beep( void )
{
    int i ;

    for ( i = 0 ; i < 10 ; ++i ) {
        sound( 100 );
        rt_sleep( 100 );
        nosound();
        rt_sleep( 100 );
    }
}

void try_freq( int freq )
{
    printf("trying frequency : %u\n", freq );

    rt_timerfreq( freq );
    beep();
}



int main(int argc, char **argv)
{

    rt_init(100);

    puts("At low timer resolutions, a delay of 100ms will be approximate");
    puts("but it becomes increasingly accurate as we bump up the clock,");
    puts("the accuracy depends on the LCD or lowest common denominator");
    puts("of the clock rate and the beep rate.");
    puts("This example works in 16 bit eRTOS only, not 32 bit");

    try_freq( 18 );
    try_freq( 20 );
    try_freq( 30 );
    try_freq( 50 );

    try_freq( 100 );

    try_freq( 500 );

    try_freq( 1000 );

    try_freq( 10000 );
}

