/* See snmp.h for details */
/****************************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:           DNPAP.H
**      SYSTEM  NAME:           DNPAP
**      VERSION NUMBER:         1.00
**
** DESCRIPTION: This module contains general DNPAP definitions
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:        The DNPAP Group
**      CREATION DATE:          91/12/05
**      CHANGES:				None
*****************************************************************/

#ifndef _DNPAP_H_
#define _DNPAP_H_

#include <dos.h>
#include <time.h>
#include <signal.h>


/* system dependent defines */

#ifndef DNPAPBASE
 #ifdef OS2
 #define DNPAPBASE  "/init"
 #else
 #define DNPAPBASE  "/usr/local/project/init"
 #endif           
#endif

#if !defined OS2_INCLUDED && !defined _OS2EMX_H
typedef char            CHAR;
typedef unsigned char   BYTE;
typedef long            LONG;
typedef unsigned long   ULONG;
typedef short           SHORT;
typedef unsigned short  USHORT;
typedef unsigned char   UCHAR;
typedef int             INT;
typedef unsigned int    UINT;
#endif
typedef unsigned short  WORD;
typedef unsigned long  DWORD;
typedef unsigned long  LWORD;

/*
    there seems to some systems that have FLOAT defined to
    some number, this is a hack to overcome problems
    as a result of this
*/
#ifdef FLOAT
#undef FLOAT
#endif

typedef float          FLOAT;
typedef double         DOUBLE;
typedef unsigned short BOOLEAN;
typedef DWORD          IPADDR;

#if defined(__STDC__) || defined(__cplusplus) || defined(_MSC_VER)
#define __(a) a
#define VAR_PROTO       , ...
#define VAR_ARGS        
#define VAR_DCL
#define VAR_LIST        va_list
#define VAR_END(va)     va_end(va)
#define VAR_START(va,f) va_start(va,f)
#else
#define __(a) ()
#define VAR_PROTO
#define VAR_ARGS        , va_alist
#define VAR_DCL         va_dcl
#define VAR_LIST        va_list
#define VAR_END(va)     va_end(va)
#define VAR_START(va,f) va_start(va)
#endif

/* Put reasonable defaults in some defines */
#ifndef INT_MAX           /* Some say INT_MAX, others say MAXINT */
# define INT_MAX MAXINT
#endif
#ifndef SIG_ERR		  /* Some UNIX flavors don't define a SIG_ERR */
# define SIG_ERR -1
#endif
#ifndef CLOCKS_PER_SEC    /* Resolve a weakpoint of ANSI */
# define CLOCKS_PER_SEC   1000000L  /* number of ticks per seconds */
#endif
#ifndef CDECL		  /* Microsoft junk not used */
# define CDECL
#endif
#ifndef PASCAL		  /* Microsoft junk not used */
# define PASCAL
#endif
#ifndef VOID		  /* Some unix compilers don't know about void */
# define VOID void
#endif
#ifndef CONST		  /* Some unix compilers don't know about const */
# define CONST const
#endif
#ifndef SEEK_SET
# define SEEK_SET 0
# define SEEK_CUR 1
# define SEEK_END 2
#endif
#ifndef TRUE		  /* Not always defined, make sure it is */
# define TRUE 1
# define FALSE 0
#endif
#ifndef NULL
# define NULL ((VOID *)0)
#endif
#ifndef STATIC		  /* Easy changing of static to non-static */
# define STATIC static
#endif
#ifndef FAR
# define FAR _far
#endif
#ifndef HUGE
# define HUGE _huge
#endif
#ifndef INTERRUPT
# define INTERRUPT _interrupt
#endif
#ifndef MK_FP
# define MK_FP(seg,off)   (VOID FAR *)((ULONG)(((USHORT)(off)) | ((ULONG)((USHORT)(seg))) << 16))
#endif

#ifndef PRIVAT
# define PRIVAT static
#endif
#ifndef IMPORT
# define IMPORT extern
#endif
#ifndef EXPORT
# define EXPORT
#endif
#ifndef NUMBEROF
# define NUMBEROF(a) (sizeof(a)/sizeof(*a))
#endif


/******************************************************
* Prototypes for DNPAP library functions.
*******************************************************/

VOID *DnpapMalloc   __((ULONG size));
VOID *DnpapRealloc  __((VOID *memblock, ULONG size));
VOID  DnpapFree     __((VOID *memblock));                
VOID  DnpapAtExit   __((VOID(*func) __((VOID)) ));
VOID  DnpapExit     __((INT status));
VOID  DnpapMessage  __((INT code, LONG ec, CONST char *format VAR_PROTO)); 
VOID  (*DnpapSignal __((INT signum, VOID (*func)(INT))))(INT);

#ifdef LIBRARY
  typedef VOID  *(*DNPAPMALLOCFUN)  __((ULONG size));
  typedef VOID  *(*DNPAPREALLOCFUN) __((VOID *memblock, ULONG size));
  typedef VOID   (*DNPAPFREEFUN)    __((VOID *memblock));                
  typedef VOID   (*DNPAPATEXITFUN)  __((VOID(*func) __((VOID)) ));
  typedef VOID   (*DNPAPEXITFUN)    __((INT status));
  typedef VOID   (*DNPAPMESSAGEFUN) __((INT code, LONG ec, CONST char *format, VOID * vp));
  typedef VOID (*(*DNPAPSIGNALFUN)  __((INT signum, VOID (*func)(INT))))(INT);
						  
  /* These functions install new functions, for the standard dnpap functions */
  /* The standard ones are as simple as possible... */
  /* When called with NULL as argument, they only return the current function */
  DNPAPMALLOCFUN  DnpapSetMallocFun  __((DNPAPMALLOCFUN  dmf));
  DNPAPREALLOCFUN DnpapSetReallocFun __((DNPAPREALLOCFUN drf));
  DNPAPFREEFUN    DnpapSetFreeFun    __((DNPAPFREEFUN    dff));
  DNPAPEXITFUN    DnpapSetExitFun    __((DNPAPEXITFUN    def));
  DNPAPATEXITFUN  DnpapSetAtExitFun  __((DNPAPATEXITFUN  daef));
  DNPAPMESSAGEFUN DnpapSetMessageFun __((DNPAPMESSAGEFUN dmf));
  DNPAPSIGNALFUN  DnpapSetSignalFun  __((DNPAPSIGNALFUN  dsf));
#endif															 


/********************************
* DNPAP general defines
********************************/

#define DNPAP_MIB           1,3,6,1,4,1,464
#define DNPAP_MIBLEN        7

#define BTNG_MIB            DNPAP_MIB,1
#define BTNG_MIBLEN         DNPAP_MIBLEN+1

#ifdef DNPAP_RMON_EXTENSIONS
#define DNPAP_RMON_MIB      DNPAP_MIB,2
#define DNPAP_RMON_MIBLEN   DNPAP_MIBLEN+1
#endif


/******************************** 
* Codes for DnpapMessage 
*********************************/

#define DMC_FATAL    0
#define DMC_ERROR    1
#define DMC_WARNING  2
#define DMC_MESSAGE  3
#define DMC_DEBUG    4
#define DMC_TRACE    5
#define DMC_LOG      6
#define DMC_MAX		16



#define STATISTICS_ERROR             1000L
#define INFO_ERROR                   2000L
#define FILTER_ERROR                 3000L
#define CHANNEL_ERROR                4000L
#define CAPTURE_ERROR                5000L
#define NEURO_ERROR                  6000L
#define LOG_ERROR                    7000L
#define ALARM_ERROR                  8000L
#define EVENT_ERROR                  9000L
#define TEST_ERROR                  10000L
#define HOST_ERROR                  11000L
#define TOPN_ERROR                  12000L
#define MATRIX_ERROR                13000L
#define HISTORY_ERROR               14000L
#define MAXMEM_ERROR                15000L
#define DNPAP_STATISTICS_ERROR      16000L
#define DNPAP_FILTER_ERROR          17000L
#define DNPAP_HOST_ERROR            18000L
#define DNPAP_TOPN_ERROR            19000L
#define DNPAP_MATRIX_ERROR          20000L
#define DNPAP_CAPTURE_ERROR         21000L
#define DNPAP_CHANNEL_ERROR         22000L
#define DNPAP_EVENT_ERROR           23000L
#define PERF_ERROR                  24000L
#define REGISTER_ERROR              25000L
#define DISC_ERROR                  26000L
#define BEHOLDER_ERROR              27000L
#define STATBUF_ERROR               28000L
#define REACH_ERROR                 29000L
#define NEUS_ERROR                  43000L
#define VIP_ERROR                   44000L
#define INI_ERROR                   45000L       
#define MEMORY_ERROR                46000L
#define SNOR_ERROR                  47000L
#define TIMER_ERROR                 48000L
#define MSG_ERROR                   49000L
#define TRANS_ERROR                 50000L
#define MGMT_ERROR                  51000L
#define MAC_ERROR                   52000L
#define NIT_ERROR                   53000L
#define TRICKLET_ERROR              54000L
#define ECHO_ERROR                  55000L 
#define PING_ERROR                  56000L 
#define AGENT_ERROR                 57000L
#define BLOCK_ERROR					58000L
#define NW_ERROR					59000L
#define NWNIT_ERROR					60000L
#define NWICMP_ERROR				61000L
#define GEN_ERROR					62000L
#define MIB_ERROR					63000L
#define IP_ERROR					64000L
#define UDP_ERROR					65000L
#define ICMP_ERROR					66000L
#define NWPF_ERROR					67000L
#define PF_ERROR					68000L
/* ... etc ... */


#endif
