
/*
 * Embedded Math Library
 *
 * Copyright (c) 1987, 1999 Erick Engelke
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

/*------------------------------------------------------------------------*/
typedef long EM;
#define EM_MAXINT    0x7fffffff
#define EM_MAXNEGINT 0xffffffff

#define EM_DEC_DIGITS 4
#define EM_BDIGITS 15L
#define EM_DENOMINATOR  ( 1L << EM_BDIGITS )        /* divisor throughout */
#define EM_DECIMAL_DENOMINATOR      10000
#define EM_SIGN_BIT  0x80000000     /* the sign bit */
#define EM_HIGH_BIT  0x40000000     /* highest order bit */

#define EM_ONE         (  EM_DENOMINATOR )
#define EM_MINUS_ONE   ( -EM_DENOMINATOR )
#define EM_POINT_5     ( EM_ONE >> 1 )
#define EM_ZERO         0
#define EM_INTEGERS    ( ~(EM_ONE - 1))

#define EM_PI           ( 102944L )
#define EM_TWO_PI       ( 205887L )
#define EM_180_OVER_PI  ( 1877464L )
#define EM_90_DEG_RAD   ( 51472L )  /* 1.57079... */

/*------------------------------------------------------------------------*/

#define EM_ADD( a, b ) ( a + b )
#define EM_SUB( a, b ) ( a - b )

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/* Arithmetic Routines                                                    */
/*------------------------------------------------------------------------*/
EM EM_INT( EM x );
EM EM_ROUND( EM x );
EM EM_SGN( EM x );
EM EM_ABS( EM x );
EM EM_MUL( EM a, EM b );
EM EM_DIV( EM num , EM denom );

/*------------------------------------------------------------------------*/
/* Conversion Routines                                                    */
/*------------------------------------------------------------------------*/
EM EM_ASSIGN( long numerator, long denominator);
long emtol( EM em, long divisor );

EM strtoem( char *s );
char *emtostr( EM x, char *s );

/*------------------------------------------------------------------------*/
/* Mathematic Routines                                                    */
/*------------------------------------------------------------------------*/
EM EM_SQR( EM in );
EM EM_LOG10( EM in );
EM EM_POWER10( EM x );
EM EM_LN( EM x );
EM EM_EXP( EM x );
EM EM_POWER( EM x, EM y );
/*------------------------------------------------------------------------*/
/* Trig Routines                                                          */
/*------------------------------------------------------------------------*/
EM EM_COS( EM rad );
EM EM_SIN( EM rad );
EM EM_TAN( EM rad );

EM EM_ATAN( EM x );
EM EM_ASIN( EM x );
EM EM_ACOS( EM x );

EM EM_DEG( EM rad );        /* rads to degrees */
EM EM_RAD( EM deg );        /* degrees to rads */

