#include <stdio.h>
#include <rtos.h>
#include <mem.h>
#include <dos.h>
#include <ctype.h>

#include "morse.h"

morse_type codes[] = {
    { 'A',      {1,0,1,1,1,0,0,0,0,9}},                  /* A */
    { 'B',      {1,1,1,0,1,0,1,0,1,0,0,0,0,9}},
    { 'C',      {1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,9}},
    { 'D',      {1,1,1,0,1,0,1,0,0,0,0,9}},
    { 'E',      {1,0,0,0,0,9}},
    { 'F',      {1,0,1,0,1,1,1,0,1,0,0,0,0,9}},
    { 'G',      {1,1,1,0,1,1,1,0,1,0,0,0,0,9}},
    { 'H',      {1,0,1,0,1,0,1,0,0,0,0,9}},
    { 'I',      {1,0,1,0,0,0,0,9}},
    { 'J',      {1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},
    { 'K',      {1,1,1,0,1,0,1,1,1,0,0,0,0,9}},
    { 'L',      {1,0,1,1,1,0,1,0,1,0,0,0,0,9}},
    { 'M',      {1,1,1,0,1,1,1,0,0,0,0,9}},
    { 'N',      {1,1,1,0,1,0,0,0,0,9}},
    { 'O',      {1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},
    { 'P',      {1,0,1,1,1,0,1,1,1,0,1,0,0,0,0,9}},
    { 'Q',      {1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,9}},
    { 'R',      {1,0,1,1,1,0,1,0,0,0,0,9}},
    { 'S',      {1,0,1,0,1,0,0,0,0,9}},
    { 'T',      {1,1,1,0,0,0,0,9}},
    { 'U',      {1,0,1,0,1,1,1,0,0,0,0,9}},
    { 'V',      {1,0,1,0,1,0,1,1,1,0,0,0,0,9}},
    { 'W',      {1,0,1,1,1,0,1,1,1,0,0,0,0,9}},
    { 'X',      {1,1,1,0,1,0,1,0,1,1,1,0,0,0,0,9}},
    { 'Y',      {1,1,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},
    { 'Z',      {1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,9}},      /* Z */
    { '0',      {1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},      /* 0 */
    { '1',      {1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},          /* 1 */
    { '2',      {1,0,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},              /* 2 */
    { '3',      {1,0,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},                  /* 3 */
    { '4',      {1,0,1,0,1,0,1,0,1,1,1,0,0,0,0,9}},                      /* 4 */
    { '5',      {1,0,1,0,1,0,1,0,1,0,0,0,0,9}},                          /* 5 */
    { '6',      {1,1,1,0,1,0,1,0,1,0,1,0,0,0,0,9}},                      /* 6 */
    { '7',      {1,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,0,9}},                  /* 7 */
    { '8',      {1,1,1,0,1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,9}},              /* 8 */
    { '9',      {1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,0,0,0,0,9}},          /* 9 */
    { ' ',      {0,0,0,0,9}},                                        /* space */
    { '.',      {1,0,1,1,1,0,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,9}},        /* . */
    { ',',      {1,1,1,0,1,1,1,0,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,9}},    /* , */
    { '?',      {1,0,1,0,1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,9}},            /* ? */
    { ':',      {1,1,1,0,1,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,0,9}},        /* : */
    { ';',      {1,1,1,0,1,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,9}},        /* ; */
    { '(',      {1,1,1,0,1,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,9}},    /* ( */
    { '/',      {1,1,1,0,1,0,1,0,1,1,1,0,1,0,0,0,0,9}},                /* / */
    { '_',      {1,1,1,0,1,0,1,0,1,0,1,1,1,0,0,0,0,9}},                /* - */
    { ')',      {1,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,9}},              /* ) AR */
    { '!',      {1,0,1,1,1,0,1,0,1,0,1,0,0,0,0,9}},                  /* ! AS */
    { '=',      {1,1,1,0,1,0,1,0,0,0,1,0,0,0,0,9}},                  /* = DE */
    { '|',      {1,0,1,0,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,9}},          /* | SK */
    { '%',      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9}},        /* % pause */
    { '*',      {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9}},        /* * tone */
      0, {0} };

morse_type* ascii_to_morse( char ch )
{
    morse_type *p;

    for ( p = codes ; p->m_ch != 0 ; p++ )
        if ( p->m_ch == ch ) return( p );
    return( NULL );
}

morse_type* codes_to_morse( BYTE *b, int len )
{
    morse_type *p;
    for ( p = codes ; p->m_ch != 0 ; p++ )
        if ( memcmp( p->m_code, b, len ) == 0 ) return( p );
    return( NULL );
}




