/*
 * DRIVER.H
 *
 * Multi-I/O driver library
 * Copyright 1998,
 * JK microsystems, Inc. - ALL RIGHTS RESERVED
 * http://www.jkmicro.com
 *
 * THIS SOFTWARE IS NOT SHAREWARE, FREEWARE, OR PUBLIC DOMAIN.
 * IT IS THE PROPERTY OF JK microsystems.
 *
 * CUSTOMERS OF JK microsystems MAY MODIFY THE SOURCE CODE
 * AND/OR DISTRIBUTE THE BINARY IMAGE OF THIS SOFTWARE WITHOUT
 * ADDITIONAL COSTS PROVIDED IT IS RUN ONLY ON HARDWARE
 * MANUFACTURED BY JK microsystems.  ALL OTHER USE IS EXPRESSLY
 * PROHIBITED.
 *
 * THIS SOURCE CODE IS NOT TO BE DISCLOSED WITHOUT PRIOR APPROVAL
 * FROM JK microsystems.
 *
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY;
 * WITHOUT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY
 * OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef __driver_h
#define __driver_h

int  GetVersion( void );		/* Least significant digit = minor rev */
						/* Most significant digits = major rev */

void PutA2DChannel( int value );	/* select A/D channel */
int  GetA2D( void );			/* get A/D value from selected channel */

void PutD2AChannel( int value );	/* select D/A channel */
void PutD2A( int value );		/* put value to selected D/A */

void PutDriverChannel( int value );	/* select driver channel */
void PutDriver( int value );		/* turn driver off (zero) or on (non-zero) */

void PutUARTChannel( int value );	/* select UART channel */
void PutUARTBaud( int value );	/* set baud rate, use value from table below 
							230	230.4k baud	
							115	115.2k baud	
							57	57.6k baud	
							38	38.4k baud	
							19	19.2k baud	
							9600	9600 baud	
							4800	4800 baud	
							2400	2400 baud	
							1200	1200 baud		
							600	600 baud	
						*/
int  GetUARTChar( void );		/* wait for character and return it */
void PutUARTChar( int value );	/* wait for Tx ready, and send character */
int  GetUARTRxStatus( void );		/* return 1 if Rx character ready */
int  GetUARTTxStatus( void );		/* return 1 if transmitter empty */

void PutUARTWC( int value );		/* write value to UART Write Configuration register */
void PutUARTWD( int value );		/* write value to UART Write Data register */
int  GetUARTRC( void );			/* get value from UART Read Configuration register */
int  GetUARTRD( void );			/* get value from UART Read Data register */


#endif					/* end if def __driver_h */
