/*
 * therm.exe - display thermometer results
 *           - see README file
 */

#include <rtos.h>
#include <kconio.h>
#include <ldriver.h>
#include <emath.h>


/*********************************************************************/

/*********************************************************************/

/***********************************************************************/
/***********************************************************************/
void therm_thread(DWORD port)
{
    int i, j;
    int a;
    // float temp;
    int degreesF, degreesC;
    EM emF, emC;
    char buffer[ 64 ];
    for ( j = 0 ; j < 10 ; ++j ) {
        for ( i = 0 ; i < 2 ; ++i ) {
            PutA2DChannel( i );
            a = GetA2D();

            /* integer calculations */
            degreesC = (a-2732)/10;
            degreesF = ( (a*9)/5 - 4597 ) / 10;

            /* fixed point, higher accuracy calculations */
            emC = EM_DIV( EM_SUB( EM_ASSIGN(a,1), EM_ASSIGN( 2732 , 1 )), EM_ASSIGN( 10, 1));
            emF = EM_DIV( EM_SUB( EM_MUL(EM_ASSIGN(a,1),EM_ASSIGN(9,5)), EM_ASSIGN( 4597,1)),EM_ASSIGN(10,1));

            cprintf("sensor %u: %i F, %i C,  ", i, degreesF, degreesC );
            cprintf(" %s F, ", emtostr( emF, buffer ));
            cprintf(" %s C  ", emtostr( emC, buffer ));

            cprintf("\r\n");
        }
        rt_sleep( 1000 );
    }
    rt_halt("done");
}
/*********************************************************************/

main ()
{
    int msg;
    DWORD data;

    rt_init (200);
    rt_timerfreq( 100 );
    kpreemptive = 1;

    rt_newthread(therm_thread, 0 , 8192, 0, "therm session" );
    kreadmessage( &msg, &data );
}


