#include <conio.h>
#include <dos.h>

// Microsoft compilers don't have these functions
#ifndef peek
#define peek(a,b) _asm { mov es,a; mov bx,b; mov ax,es:[bx] }
#endif
#ifndef enable
#define enable _enable
#endif
#ifndef disable
#define disable _disable
#endif


int cdecl uart_detect_type(unsigned baseaddr)
{
	// Parts of this routine suggested by Mike Surikov

	// This function returns:
	//   -1 if no UART is installed at the given base address
	//    0 - 8250
	//    1 - 16450
	//    2 - 16550 w/o SCR
	//    3 - 16550
	//    4 - 16550A w/o SCR
	//    5 - 16550A

	unsigned char x, scr=1, ov;
	// First step: see if the LCR is there
	ov=inp(baseaddr+3);
	outp(baseaddr+3,0x1B);
	if( inp(baseaddr+3)!=0x1B ) return -1;
	outp(baseaddr+3,0x03);
	if( inp(baseaddr+3)!=0x03 ) return -1;
	outp(baseaddr+3,ov);
	// Next thing to do is look for the scratch register
	ov=inp(baseaddr+7);
	outp(baseaddr+7,0x55);
	if( inp(baseaddr+7)!=0x55 ) scr=0;
	outp(baseaddr+7,0xAA);
	if( inp(baseaddr+7)!=0xAA ) scr=0;
	outp(baseaddr+7,ov);
	// Then check if there's a FIFO
	outp(baseaddr+2,0x01);
	x=inp(baseaddr+2);
	outp(baseaddr+2,0x00); // Some old-fashioned software relies on this!
	if( !(x&0x80) ) return scr;
	if( !(x&0x40) ) return 2+scr;
	return 4+scr;
}


int cdecl uart_detect_intlevel(unsigned baseaddr)
{
	// returns: -1 if no intlevel found, or intlevel 0-15
	// Don't call it if interrupts are running!! You might lose characters.
	char ier,mcr,imrm,imrs,maskm,masks,irqm,irqs;

	_asm cli;            // disable all CPU interrupts
	ier = inp(baseaddr+1);   // read IER
	outp(baseaddr+1,0);      // disable all UART ints
	while ((inp(baseaddr+5)&0x20)==0);  // wait for the THR to be empty
	mcr = inp(baseaddr+4);   // read MCR
	outp(baseaddr+4,0x0F);   // connect UART to irq line
	imrm = inp(0x21);    // read contents of master ICU mask register
	imrs = inp(0xA1);    // read contents of slave ICU mask register
	outp(0x20,0x0A);     // next read access to 0x20 reads out IRR
	outp(0xA0,0x0A);     // next read access to 0xA0 reads out IRR
	outp(baseaddr+1,2);      // lets generate interrupts...
	maskm = inp(0x20);   // this clears all bits except for the one
	masks = inp(0xA0);   // that corresponds to the int
	outp(baseaddr+1,0);      // drop the int line
	maskm &= ~inp(0x20); // this clears all bits except for the one
	masks &= ~inp(0xA0); // that corresponds to the int
	outp(baseaddr+1,2);      // and raise it again just to be sure...
	maskm &= inp(0x20);  // this clears all bits except for the one
	masks &= inp(0xA0);  // that corresponds to the int
	outp(0x21,~maskm);   // now let us unmask this interrupt only
	outp(0xA1,~masks);
	outp(0x20,0x0C);     // enter polled mode
	outp(0xA0,0x0C);
	irqs = inp(0xA0);    // and accept the interrupt
	irqm = inp(0x20);
	inp(baseaddr+2);         // reset transmitter interrupt in UART
	outp(baseaddr+4,mcr);    // restore old value of MCR
	outp(baseaddr+1,ier);    // restore old value of IER
	if (masks) outp(0xA0,0x20);  // send an EOI to slave
	if (maskm) outp(0x20,0x20);  // send an EOI to master
	outp(0x21,imrm);     // restore old mask register contents
	outp(0xA1,imrs);
	_asm sti;
	if (irqs&0x80)       // slave interrupt occured
	return (irqs&0x07)+8;
	if (irqm&0x80)       // master interrupt occured
	return irqm&0x07;
	return -1;
}


