(*$U+*)
PROGRAM TT;
VAR AR: ARRAY (. 1..1000 .) OF INTEGER;
    I: INTEGER;

(****** TPT.PAS: TURBO-PASCAL-TESTROUTINEN TRACE UND DUMP, MS-DOS-Version ******)

TYPE TPT_STR=STRING(.80.);

VAR TPT_INT1, TPT_INT2: INTEGER;
    TPT_PT, TPT_PT1, TPT_PT2: ^BYTE;
    TPT_ENDE1, TPT_ENDE2: BOOLEAN;
    TPT_CHAR: CHAR;
    TPT_PRINT: BOOLEAN;

PROCEDURE TPT_WRITE (N: BYTE; S: CHAR);
BEGIN CASE N OF
           0: BEGIN WRITE (S);
                    IF TPT_PRINT THEN WRITE (LST,S)
              END;
           1: BEGIN WRITELN (S);
                    IF TPT_PRINT THEN WRITELN (LST,S)
              END
      END
END;

PROCEDURE TPT_HEXOUT (B: BYTE);  (***** EIN BYTE IN HEX AUSGEBEN *****)
TYPE HEXT = SET OF 10..15;
CONST HEX: HEXT = (.10..15.);
VAR I: BYTE;
BEGIN I:=B DIV 16;
      IF I IN HEX THEN TPT_WRITE (0,CHR(I+55))
                  ELSE BEGIN WRITE (I:1);
                             IF TPT_PRINT THEN WRITE(LST,I:1)
                       END;
      I:=B MOD 16;
      IF I IN HEX THEN TPT_WRITE (0,CHR(I+55))
                  ELSE BEGIN WRITE (I:1);
                             IF TPT_PRINT THEN WRITE(LST,I:1)
                       END
END;

PROCEDURE TPT_ASCII(VAR V; SIZE: BYTE);   (***** ASCII AUSGEBEN *****)

VAR I: BYTE;
BEGIN TPT_PT1:=PTR(SEG(V),OFS(V));
      FOR I:=1 TO SIZE DO
          BEGIN IF (TPT_PT1^>31) AND (TPT_PT1^<127)
                   THEN TPT_WRITE (0,CHR(TPT_PT1^))
                   ELSE TPT_WRITE (0,'.');
                TPT_PT1:=PTR(SEG(TPT_PT1),OFS(TPT_PT1)+1)
          END
END;

PROCEDURE TPT_DUMPZEILE (STERN: BOOLEAN);   (***** DUMPZEILE AUSGEBEN *****)

BEGIN TPT_PT:=TPT_PT1;
      TPT_HEXOUT(DSEG DIV 256);
      TPT_HEXOUT(DSEG MOD 256);
      WRITE(':');
      TPT_HEXOUT(OFS(TPT_PT^) DIV 265);
      TPT_HEXOUT(OFS(TPT_PT^) MOD 256);
      IF STERN
         THEN TPT_WRITE (0,'*')
         ELSE TPT_WRITE (0,' ');
      TPT_WRITE (0,' ');
      TPT_WRITE (0,' ');
      FOR TPT_INT1:=1 TO 4 DO
          BEGIN FOR TPT_INT2:=1 TO 4 DO
                    BEGIN TPT_HEXOUT(TPT_PT^);
                          TPT_PT:=PTR(DSEG,OFS(TPT_PT^)+1);
                          IF OFS(TPT_PT^)>=OFS(TPT_PT2^) THEN TPT_ENDE2:=TRUE
                    END;
                TPT_WRITE (0,' ');
                TPT_WRITE (0,' ')
          END;
      TPT_WRITE (0,' ');
      TPT_WRITE (0,' ');
      TPT_ASCII(TPT_PT1^,16);
      TPT_WRITE (1,' ');
      TPT_PT1:=TPT_PT
END;

(*$V-*)

PROCEDURE TPT_DUMPMAIN(TEXT: TPT_STR);
VAR ERST, SPRUNG: BOOLEAN;
    I: INTEGER;
    PT1, PT2: ^BYTE;

FUNCTION GLEICH: BOOLEAN;
VAR GLEICHZEILE: BOOLEAN;
BEGIN GLEICHZEILE:=TRUE;
      PT1:=TPT_PT1;
      I:=1;
      IF ERST
         THEN GLEICH:=FALSE
         ELSE WHILE GLEICHZEILE AND (I<=16) DO
                    BEGIN PT2:=PTR(DSEG,OFS(PT1^)-16);
                          IF PT1^ <> PT2^
                             THEN BEGIN GLEICHZEILE:=FALSE;
                                        I:=17
                                  END
                             ELSE BEGIN PT1:=PTR(DSEG,OFS(PT1^)+1);
                                        I:=I+1
                                  END
                    END;
      GLEICH:=GLEICHZEILE
END;

BEGIN ERST:=TRUE;
      IF OFS(TPT_PT1^)>OFS(TPT_PT2^)
         THEN BEGIN TPT_PT:=TPT_PT1; TPT_PT1:=TPT_PT2; TPT_PT2:=TPT_PT END;
      TPT_ENDE1:=FALSE;
      TPT_ENDE2:=FALSE;
      WRITE ('Print DUMP ',TEXT ,'? Y/N: ');
      TPT_CHAR:=' ';
      WHILE NOT (TPT_CHAR IN (.'Y','y','N','n'.)) DO READ (KBD,TPT_CHAR);
      IF TPT_CHAR IN (.'Y','y'.) THEN TPT_PRINT:=TRUE ELSE TPT_PRINT:=FALSE;
      TPT_WRITE(1,' ');
      WRITELN ('***** DUMP: ',TEXT,' *****');
      IF TPT_PRINT THEN WRITELN (LST,'***** DUMP: ',TEXT,' *****');
      SPRUNG:=FALSE;
      WHILE NOT TPT_ENDE2 DO
            BEGIN IF ERST
                     THEN BEGIN TPT_DUMPZEILE(FALSE);
                                ERST:=FALSE
                          END;
                  IF GLEICH
                     THEN BEGIN TPT_PT1:=PTR(DSEG,OFS(TPT_PT1^)+16);
                                SPRUNG:=TRUE
                          END
                     ELSE BEGIN TPT_DUMPZEILE (SPRUNG);
                                SPRUNG:=FALSE
                          END
            END;
      WRITELN ('***** END OF DUMP ',TEXT,' *****');
      IF TPT_PRINT THEN WRITELN (LST,'***** END OF DUMP ',TEXT,' *****');
      IF NOT TPT_ENDE1 THEN BEGIN WRITE (' Continue program ? press any key!');
                                  READ (KBD,TPT_CHAR);
                                  WRITELN
                            END
END;

(***** UNTERPROGRAMM ZUM AUSGEBEN EINES DUMPS.
       VORHER DUMP BESCHREIBENDEN TEXT,
       DANN ADRESSEN: ALS VARIABLENNAMEN ANZUGEBEN.
       UNTERBRECHEN DURCH DRUECKEN VON CTRL-S        *)

PROCEDURE DUMP(TEXT: TPT_STR; VAR ADR1,ADR2);

BEGIN TPT_PT1:=PTR(DSEG,OFS(ADR1));
      TPT_PT2:=PTR(DSEG,OFS(ADR2));
      TPT_DUMPMAIN(TEXT)
END;

PROCEDURE TRACE(TEXT: TPT_STR; VAR V; SIZE: BYTE);

BEGIN WRITE ('Print TRACE ',TEXT ,'? Y/N: ');
      TPT_CHAR:=' ';
      WHILE NOT (TPT_CHAR IN (.'Y','y','N','n'.)) DO READ (KBD,TPT_CHAR);
      IF TPT_CHAR IN (.'Y','y'.) THEN TPT_PRINT:=TRUE ELSE TPT_PRINT:=FALSE;
      TPT_WRITE(1,' ');
      WRITELN (TEXT);
      IF TPT_PRINT THEN WRITELN (LST,TEXT);
      TPT_PT:=PTR(SEG(V),OFS(V));
      TPT_HEXOUT(ORD(SEG(TPT_PT) DIV 256));
      TPT_HEXOUT(ORD(SEG(TPT_PT) MOD 256));
      WRITE(':');
      TPT_HEXOUT(ORD(OFS(TPT_PT) DIV 265));
      TPT_HEXOUT(ORD(OFS(TPT_PT) MOD 256));
      FOR TPT_INT1:=1 TO 3 DO TPT_WRITE (0,' ');
      TPT_INT1:=0;
      TPT_INT2:=0;
      IF SIZE>16 THEN SIZE:=16;
      WHILE TPT_INT1*4+TPT_INT2<SIZE DO
            BEGIN WHILE TPT_INT2<4 DO
                        BEGIN TPT_HEXOUT(TPT_PT^);
                              TPT_PT:=PTR(DSEG,ORD(OFS(TPT_PT^))+1);
                              TPT_INT2:=TPT_INT2+1
                        END;
                  TPT_INT1:=TPT_INT1+1;
                  TPT_INT2:=0;
                  TPT_WRITE (0,' ');
                  TPT_WRITE (0,' ')
            END;
      TPT_WRITE (0,' ');
      TPT_WRITE (0,' ');
      TPT_ASCII(V,SIZE);
      READ(KBD,TPT_CHAR);
      TPT_WRITE (1,' ')
(*$V+*)
END;

BEGIN FOR I:=1 TO 1000 DO AR(.I.):=I;
      TRACE ('Trace',AR,20);
      DUMP ('Dump',AR(.1.),AR(.100.))
END.