/****************************************************************************

**                                                                         **

**   filetransfer  -  implementation of the file transfer protocol         **

**                    with the ibm-pc.                                     **

**                                                                         **

**   W. LASSNIG,  Informatikpraktikum II (Remote Access), 1984-09-04       **

**                                                                         **

*****************************************************************************

**                                                                         **

**                                                                         **

**   General description of the file transfer protocol:                    **

**   =================================================                     **

**                                                                         **

**                                                                         **

**   -------------------------------------------------                     **

**   | B | P | P | P |                       | C | E |                     **

**   | O | L | N | T | I N F O R M A T I O N | R | O |   PACKET            **

**   | P |   |   |   |                       | C | P |                     **

**   -------------------------------------------------                     **

**                                                                         **

**                                                                         **

**               -----------------------------                             **

**               | P |                       |                             **

**               | T | I N F O R M A T I O N |           APPLICATION LAYER **

**               |   |                       |                             **

**           ---------------------------------                             **

**           | P | P |                       |                             **

**           | N | T | I N F O R M A T I O N |           SESSION LAYER     **

**           |   |   |                       |                             **

**   ---------------------------------------------                         **

**   | B | P | P | P |                       | C |                         **

**   | O | L | N | T | I N F O R M A T I O N | R |       DATA LINK LAYER   **

**   | P |   |   |   |                       | C |                         **

**   ---------------------------------------------                         **

**                                                                         **

**   BOP: Begin of Packet Mark                                             **

**   ---  1 Byte                                                           **

**        'B'                                                              **

**                                                                         **

**   PL:  Packet Length (PN + PT + INFORMATION + CRC)                      **

**   --   1 Byte                                                           **

**        hex25 - hex7E (5 - 94 dezimal)                                   **

**                                                                         **

**   PN:  Packet Number                                                    **

**   --   1 Byte                                                           **

**        hex20 - hex7E (0 - 94 dezimal)                                   **

**                                                                         **

**   PT:  Packet Type                                                      **

**   --   1 Byte                                                           **

**        'D' ... Data Transfere (INFORMATION = Data)                      **

**        'A' ... Acknowledge                                              **

**        'N' ... Not Acknowledge (INFORMATION = Error message,            **

**                2 .. file exists - 3 .. file does not exist)             **

**        'E' ... End of File                                              **

**        'T' ... Terminate File Transfer (INFORMATION = Error message,    **

**                1 .. repeating limit reached)                            **

**        'C' ... Command (INFORMATION = Filename + S (end) / R (eceive)   **

**                + B (inary) / A (scii) )                                 **

**                                                                         **

**   INFORMATION: Binary File: Two Half-Bytes (MSB first)                  **

**   -----------               hex00 - hex0F transformed to hex20 - hex2F  **

**                ASCII-File:  Byte B is transformed as described in       **

**                             rules (1) to (5)                            **

**                                                                         **

**   (1) B in ( [hex20,hex22] & [hex24,hex25] & [hex27,hex7D] )            **

**       ==> B --> B                                                       **

**                                                                         **

**   (2) B in ( [hex00,hex1F] & [hex7E] ) ==> B --> '#' B (Bit 7 inverted) **

**                                                                         **

**   (3) B in [hex23] ==> B --> '#' '#'                                    **

**                                                                         **

**   (4) B in [hex26] ==> B --> '#' '&'                                    **

**                                                                         **

**   (5) Bit 8 is 1 ==> B --> '&' B (Bit 8 is 0) and B goes through        **

**       (1) to (4)                                                        **

**                                                                         **

**   CRC: Cyclic redundancy checking (PN + PT + INFORMATION)               **

**   ---  2 Bytes (computed as described in IEEE-MICRO - June 1983 -       **

**        page 40 - listing 3) transformed to 3 bytes like below:          **

**                                                                         **

**        [x8 x7 x6 x5 x4 x3 x2 x1]   [y8 y7 y6 y5 y4 y3 y2 y1]            **

**                                  |                                      **

**                                  |                                      **

**        [ ( 0 0 x8 x7 x6 x5 x4 x3 ) + hex20 ]                            **

**        [ ( 0 0 x2 x1 y8 y7 y6 y5 ) + hex20 ]                            **

**        [ ( 0 0 0  0  y4 y3 y2 y1 ) + hex20 ]                            **

**                                                                         **

**   EOP: End of Packet                                                    **

**   ---  1 Byte                                                           **

**        NOT IN USE!                                                      **

**                                                                         **

**                                                                         **

****************************************************************************/




#define   REPEATING_LIMIT 5            /* maximum of repeating a packet    */

#define   TIMEOUT_LIMIT   10           /* time for legal input of a packet */

#define   BOP             'B'          /* begin-of-packet mark             */

#define   MAXLEN          94           /* maximum of packet length         */

#define   BLANK           ' '          /* lowest used ascii-character      */

#define   DEL             '~'          /* highest used ascii-character     */

#define   LPL             '%'          /* lowest used packet-length        */




#include    <stdio.h>                   /* standard input-output functions */


#include    <signal.h>                                 /* subroutines for  */

#include    <setjmp.h>                                 /* timeout-handling */


#include    <sgtty.h>                       /* subroutines for i-o-control */




struct sgttyb *remote, *local, *online;       /* variables for i-o-control */


jmp_buf env;                       /* global variable for timeout-handling */


struct lp                                                    /*            */

       {                                                     /*            */

       int packet_number;                                    /* definition */

       int packet_type;                                      /* of global  */

       int information_length;                               /* variable   */

       int information [89];                                 /* last-      */

       int crc [3];                                          /* packet     */

       }                                                     /*            */

       last_packet;                                          /*            */


int    last_receiving_number;                      /* last received packet */




/****************************************************************************

**                                                                         **

**     main program filetransfer                                           **

**                                                                         **

****************************************************************************/




main ()


{


int   i,                                 /* counting                       */

      action,                            /* R...receive  S...send          */

      type,                              /* A...ASCII    B...binary        */

      repeating,                         /* count of sending after error   */

      error_code,                        /* 0...ok - 21...protocoll-error  */

      information_length,                /* Information                    */

      packet_type,                       /* A - N - D - C - T - E          */

      packet_type_help,                  /* A - N - D - C - T - E          */

      packet_array [MAXLEN];             /* Information                    */


char  file [30],                         /* name of file to work with      */

      *calloc ();




if (((remote = calloc (1,sizeof (struct sgttyb))) == NULL) ||   /* reserve */

   ( (local = calloc (1, sizeof (struct sgttyb) ) ) == NULL) || /* memory  */

   ( (online = calloc (1, sizeof (struct sgttyb) ) ) == NULL) ) /* for     */

   {                                                            /* i-o-    */

   goto end_nioc;                                               /* control */

   }                                                            /*         */



ioctl (1, TIOCGETP, local);                                  /* set to     */

ioctl (1, TIOCGETP, online);                                 /* connection */

online->sg_flags = EVENP + ODDP + RAW;                       /* line       */

ioctl (1, TIOCSETP, online);                                 /* mode       */


last_packet.packet_type        = ' ';                        /*            */

last_packet.information_length = 0;                          /*            */

last_packet.packet_number      = 0;                          /*            */

last_packet.crc [0]            = ' ';                        /*            */

last_packet.crc [1]            = ' ';                        /* initialize */

last_packet.crc [2]            = ' ';                        /* of global  */

last_receiving_number          = 0;                          /* variables  */

							     /*            */

for (i = 0; i < MAXLEN - 5; ++i)                             /*            */

    {                                                        /*            */

    last_packet.information [i] = ' ';                       /*            */

    }                                                        /*            */


begin:


repeating = 0;                                /* initialize repeat-counter */


do    {


      session_receiver (&error_code, &packet_type,              /*         */

		       &information_length, packet_array);      /*         */

								/*         */

      if ( (error_code == 21) ||                                /*         */

	 (packet_type == 'T') )                                 /*         */

	 {                                                      /*         */

	 goto end;                                              /* input   */

	 }                                                      /* of      */

								/* command */

      for (i = 0; i <= information_length - 3; ++i)             /* packet  */

	  {                                                     /*         */

	  file [i] = packet_array [i];                          /*         */

	  }                                                     /*         */

      file [information_length - 2] = '\0';                     /*         */

      action = packet_array [information_length - 2];           /*         */

      type = packet_array [information_length - 1];             /*         */

      packet_type_help = packet_type;                           /*         */


      if ( (packet_type_help != 'T') &&                        /*          */

	 (packet_type_help != 'C') )                           /*          */

	 {                                                     /* sending  */

	 packet_type = 'N';                                    /* NACK-    */

	 information_length = 0;                               /* packet   */

	 session_sender (&error_code, packet_type,             /* if not   */

			information_length, packet_array);     /* COMMAND  */

	 if (error_code == 21)                                 /* or TERM. */

	    {                                                  /* received */

	    goto end;                                          /*          */

	    }                                                  /*          */

	 }                                                     /*          */


      if (operation_ok (file, action) == 1)                   /*           */

	 {                                                    /*           */

	 packet_type = 'A';                                   /*           */

	 information_length = 0;                              /*           */

	 session_sender (&error_code, packet_type,            /*           */

			information_length, packet_array);    /*           */

	 if (error_code == 21)                                /*           */

	    {                                                 /* sending   */

	    goto end;                                         /* of NACK-  */

	    }                                                 /* packet if */

	 }                                                    /* action    */

	 else                                                 /* received  */

	 {                                                    /* in COMM.- */

	 packet_type = 'N';                                   /* packet is */

	 information_length = 1;                              /* not       */

	 if (action == 'R')                                   /* possible  */

	    {                                                 /* (MESG = 2 */

	    packet_array [0] = '2';                           /* if file   */

	    }                                                 /* to receive*/

	    else                                              /* exists,   */

	    {                                                 /* MESG = 3  */

	    packet_array [0] = '3';                           /* if file   */

	    }                                                 /* to send   */

	 session_sender (&error_code, packet_type,            /* does not  */

			information_length, packet_array);    /* exist)    */

	 if (error_code == 21)                                /* and jump  */

	    {                                                 /* to begin  */

	    goto end;                                         /*           */

	    }                                                 /*           */

	 goto begin;                                          /*           */

	 }                                                    /*           */


      ++ repeating;                            /* increment repeat counter */


      }


while ( (packet_type_help != 'C') &&

      (repeating <= REPEATING_LIMIT) );


if (repeating > REPEATING_LIMIT)                              /*           */

   {                                                          /* sending   */

   packet_type = 'T';                                         /* NACK-     */

   information_length = 1;                                    /* packet    */

   packet_array [0] = '1';                                    /* if not    */

   session_sender (&error_code, packet_type,                  /* receiving */

		  information_length, packet_array);          /* legal     */

   goto end;                                                  /* COMMAND   */

   }                                                          /*           */


if (action == 'R')                                             /*          */

   {                                                           /*          */

   receive_file (&error_code, file, type);                     /*          */

   }                                                           /* going to */

							       /* action   */

if (action == 'S')                                             /* received */

   {                                                           /* in COMM- */

   send_file (&error_code, file, type);                        /* packet   */

   }                                                           /* (SEND or */

							       /* RECEIVE) */

if (error_code == 21)                                          /*          */

   {                                                           /*          */

   goto end;                                                   /*          */

   }                                                           /*          */


goto begin;


end:


ioctl (1, TIOCSETP, local);                         /* reset to local line */


end_nioc: ;


}




/****************************************************************************

**                                                                         **

**     data-link-layer (receiver)                                          **

**     --------------------------                                          **

**                                                                         **

**     input:  communication line                                          **

**                                                                         **

**     output: error-code                                                  **

**             packet-length (packet-number + packet-type + information)   **

**             packet-array (packet-number + packet-type + information)    **

**                                                                         **

****************************************************************************/




data_link_receiver (error_code, packet_length, packet_array)


int   *error_code,                        /* 0 ... ok                      */

					  /* 1 ... timeout-error           */

					  /* 3 ... illegal character       */

					  /* 4 ... crc-check-error         */

      *packet_length,                     /* packet-number + packet-type + */

      packet_array [];                    /* information (+ crc)           */


{


int   i,                            /* counting                            */

      c,                            /* character from communication line   */

      crc_check (),                 /* function for crc-check              */

      next_char (),                 /* function for getting next character */

      timeout (),                   /* timeout-handling procedure          */

      crc [3];                      /* array for crc-check                 */



for (i = 0; i < MAXLEN; ++ i)                              /*              */

    {                                                      /* erasing      */

    packet_array [i] = ' ';                                /* packet-array */

    }                                                      /*              */


*error_code = 0;                                  /* initialize error-code */


signal (SIGALRM, timeout);              /* jmp to proc. timeout if SIGALRM */


if (setjmp (env) != 0)                             /* 0...ok - 1...timeout */

   {

   *error_code = 1;                                             /*         */

   goto end;                                                    /* timeout */

   }                                                            /* routine */

   else                                                         /*         */

   {


   alarm (TIMEOUT_LIMIT);                                /* set of timeout */


   do    {                                              /*                 */

	 c = next_char ();                              /* input of begin- */

	 }                                              /* of-packet mark  */

   while (c != BOP);                                    /*                 */


   c = next_char ();                             /* input of packet-length */


   if ( (c < LPL) || (c > DEL) )                          /*               */

      {                                                   /* error-routine */

      *error_code = 3;                                    /* for           */

      goto end;                                           /* packet-length */

      }                                                   /*               */


   *packet_length = c - ' ';                         /* converting packet- */

						     /* length to a number */


   i = 0;                                 /* initialize packet-array index */


   do    {                                               /* input of       */

	 c = next_char ();                               /* packet-number, */

	 packet_array [i] = c;                           /* packet-type,   */

	 ++ i;                                           /* information    */

	 }                                               /* and crc        */

   while (i < *packet_length);                           /*                */


   alarm (0);                                          /* reset of timeout */


   }


crc_comp (*packet_length-3, packet_array, crc);           /*               */

							  /*               */

if ( (crc [0] != packet_array [*packet_length-3] ) |      /*               */

   (crc [1] != packet_array [*packet_length-2] ) |        /*               */

   (crc [2] != packet_array [*packet_length-1] ) )        /* error-routine */

   {                                                      /* for crc-check */

   *error_code = 4;                                       /* of the        */

   goto end;                                              /* packet-array  */

   }                                                      /*               */


end:   *packet_length -= 3;                        /* crc no longer in use */


}




/****************************************************************************

**                                                                         **

**     input of next character from communication line                     **

**     -----------------------------------------------                     **

**                                                                         **

**     input:  communication line                                          **

**                                                                         **

**     output: next character from communication line with msb = 0         **

**                                                                         **

****************************************************************************/




next_char ()


{


return (getchar () & 0177);                /* input of next character with */

					   /* killing most-significant-bit */


}




/****************************************************************************

**                                                                         **

**     timeout-subroutine                                                  **

**     ------------------                                                  **

**                                                                         **

**     subroutine for continue after timeout-interrupt                     **

**                                                                         **

****************************************************************************/




timeout ()


{


extern   jmp_buf env;


longjmp (env, 1);              /* set setjmp-call to 1 for calling routine */


}




/****************************************************************************

**                                                                         **

**     data-link-layer (sender)                                            **

**     ------------------------                                            **

**                                                                         **

**     input:  packet-length                                               **

**             packet-array (packet-number + packet-type + information)    **

**                                                                         **

**     output: error-code                                                  **

**             communication line                                          **

**                                                                         **

****************************************************************************/




data_link_sender (error_code, packet_length, packet_array)


int   packet_length,                            /* packet-number + packet- */

      packet_array [],                          /* type + information      */

      *error_code;                              /* 0 ... ok                */

						/* 1 ... timeout           */


{


int   i,                                    /* counting                    */

      crc [3];                              /* crc-code for PN + PT + INFO */


*error_code = 0;                                  /* initialize error-code */

signal (SIGALRM, timeout);              /* jmp to proc. timeout if SIGALRM */


if (setjmp (env) != 0)                             /* 0...ok - 1...timeout */

   {

   *error_code = 1;                                             /*         */

   goto end;                                                    /* timeout */

   }                                                            /* routine */

   else                                                         /*         */

   {


   alarm (TIMEOUT_LIMIT);                                /* set of timeout */


   send_char (BOP);                                  /* sending begin-mark */


   send_char (packet_length + 35);                    /* sending packet-   */

						      /* length (with CRC) */


   for (i = 0; i < packet_length; ++i)                  /* send            */

       {                                                /* packet-number,  */

       send_char (packet_array [i]);                    /* packet-type and */

       }                                                /* information     */


   if ( (last_packet.packet_number ==                          /*          */

      (packet_array [0] - ' ') ) &&                            /*          */

      (last_packet.packet_type != ' ') )                       /*          */

      {                                                        /*          */

      send_char (last_packet.crc [0]);                         /* send CRC */

      send_char (last_packet.crc [1]);                         /* (not     */

      send_char (last_packet.crc [2]);                         /* computed */

      }                                                        /* again if */

      else                                                     /* the same */

      {                                                        /* packet   */

      crc_comp (packet_length, packet_array, crc);             /* as last  */

      send_char (crc [0]);                                     /* time)    */

      send_char (crc [1]);                                     /*          */

      send_char (crc [2]);                                     /*          */

      last_packet.crc [0] = crc [0];                           /*          */

      last_packet.crc [1] = crc [1];                           /*          */

      last_packet.crc [2] = crc [2];                           /*          */

      }                                                        /*          */


   alarm (0);                                          /* reset of timeout */


   }


end: ;


}




/****************************************************************************

**                                                                         **

**     output of next character to communication line                      **

**     ----------------------------------------------                      **

**                                                                         **

**     input:  character to send to communication line                     **

**                                                                         **

**     output: communication line                                          **

**                                                                         **

****************************************************************************/




send_char (character)


int   character;                                      /* character to send */


{


putchar (character);                           /* sending of the character */


}




/****************************************************************************

**                                                                         **

**     crc-computing                                                       **

**     -------------                                                       **

**                                                                         **

**     input:  packet-array (packet-number + packet-type + information)    **

**                                                                         **

**     output: crc                                                         **

**                                                                         **

****************************************************************************/




crc_comp (packet_length, packet_array, crc)


int   packet_length,                        /* packet-number + packet-     */

      packet_array [],                      /* type + information          */

      crc [];                               /* crc-code for PN + PT + INFO */


{


register int counter,

	     a,

	     d,

	     e,

	     h,

	     l,

	     cy,

	     p;


counter = 0;

d = 0;

e = 0;


do    {

YjjbjFKlPDVQ[counter];

      a = a ^ e:"jjjoF2t_ϒÎOO@ODprOprOOO@prOprOprOprOOOprOppOώOOÎOBO@@@pOχOppOςÎOO@ODprOprO@OprOpOςÎOGO@OprOprO@OprOpOςÎOO@ODprOprO@OprOpOςÎOO@O@prOprO@OprOpOςÎOGO@OprOprO@Oain ()


{


int   i,                                 /* counting                       */

      action,                            /* R...receive  S...send          */

      type,                              /* A...ASCII    B...binary        */

      repeating,                         /* count of sending after error   */

      error_code,                        /* 0...ok - 21...protocoll-error  */

      information_length,                /* Information                    */

      packet_type,                       /* A - N - D - C - T - E          */

      packet_type_help,                  /* A - N - D - C - T - E          */

      packet_array [MAXLEN];             /* Information                    */


char  file [30],                         /* name of file to work with      */

      *calloc ();




if (((remote = calloc (1,sizeof (struct sgttyb))) == NULL) ||   /* reserve */

   ( (local = calloc (1, sizeof (struct sgttyb) ) ) == NULL) || /* memory  */

   ( (online = calloc (1, sizeof (struct sgttyb) ) ) == NULL) ) /* for     */

   {                                                            /* i-o-    */

   goto end_nioc;                                               /* control */

   }                                                            /*         */



ioctl (1, TIOCGETP, local);                                  /* set to     */

ioctl (1, TIOCGETP, online);                                 /* connection */

online->sg_flags = EVENP + ODDP + RAW;                       /* line       */

ioctl (1, TIOCSETP, online);                                 /* mode       */


last_packet.packet_type        = ' ';                        /*            */

last_packet.information_length = 0;                          /*            */

last_packet.packet_number      = 0;                          /*            */

last_packet.crc [0]            = ' ';                        /*            */

last_packet.crc [1]            = ' ';                        /* initialize */

last_packet.crc [2]            = ' ';                        /* of global  */

last_receiving_number          = 0;                          /* variables  */

							     /*            */

for (i = 0; i < MAXLEN - 5; ++i)                             /*            */

    {                                                        /*            */

    last_packet.information [i] = ' ';                       /*            */

    }                                                        /*            */


begin:


repeating = 0;        ();                               /* packet-number, */

	 packet_array [i] = c;                           /* packet-type,   */



anfang:


data_link_receiver (error_code, &packet_length, packet_array);  /* input   */

								/* of next */

								/* packet  */


if ( (*error_code != 0) ||                                /*               */

   (packet_array [0] < BLANK) ||                          /*               */

   (packet_array [0] > DEL) ||                            /*               */

   ( (packet_array [1] != 'D') &&                         /* sending of    */

   (packet_array [1] != 'A') &&                           /* last packet   */

   (packet_array [1] != 'N') &&                           /* again if      */

   (packet_array [1] != 'E') &&                           /* illegal       */

   (packet_array [1] != 'T') &&                           /* packet-type,  */

   (packet_array [1] != 'C') ) ||                         /* error-code,   */

   ( ( (last_packet.packet_type == 'D') ||                /* NACK after    */

   (last_packet.packet_type == 'E') ) &&                  /* DATE or       */

   (*packet_type == 'N') ) )                              /* EOF           */

   {                                                      /* or illegal    */

   packet_again (&repeating);                             /* packet-number */

   if (repeating >= REPEATING_LIMIT)                      /* (max. until   */

      {                                                   /* REP.LIMIT)    */

      *error_code = 21;                                   /* and jump to   */

      goto end;                                           /* ANFANG        */

      }                                                   /*               */

   goto anfang;                                           /*               */


   }

   else

   {


   packet_number = packet_array [0] - ' ';       /* computing of packet-   */

   *packet_type = packet_array [1];              /* number and packet-type */

   last_receiving_number = packet_number;        /*                        */


   switch (last_packet.packet_type)

   {

   case 'D': if ( (*packet_type == 'C') ||                    /*           */

		(*packet_type == 'D') )                       /* after     */

		{                                             /* sending   */

		packet_again (&repeating);                    /* DATA      */

		if (repeating >= REPEATING_LIMIT)             /* only      */

		   {                                          /* ACK, EOF, */

		   *error_code = 21;                          /* TERMINATE */

		   goto end;                                  /* and NACK  */

		   }                                          /* are       */

		goto anfang;                                  /* accepted  */

		}                                             /*           */

	     break;

   case 'A': if ( (*packet_type == 'A') ||                    /*           */

		(*packet_type == 'N') )                       /* after     */

		{                                             /* sending   */

		packet_again (&repeating);                    /* ACK only  */

		if (repeating >= REPEATING_LIMIT)             /* DATA,     */

		   {                                          /* COMMAND,  */

		   *error_code = 21;                          /* EOF and   */

		   goto end;                                  /* TERMINATE */

		   }                                          /* are       */

		goto anfang;                                  /* accepted  */

		}                                             /*           */

	     break;

   case 'N': if ( (*packet_type == 'A') ||                    /*           */

		(*packet_type == 'N') )                       /* after     */

		{                                             /* NACK only */

		packet_again (&repeating);                    /* COMMAND,  */

		if (repeating >= REPEATING_LIMIT)             /* DATA,     */

		   {                                          /* EOF and   */

		   *error_code = 21;                          /* TERMINATE */

		   goto end;                                  /* are       */

		   }                                          /* accepted  */

		goto anfang;                                  /*           */

		}                                             /*           */

	     break;

   case 'E': if ( (*packet_type != 'A') &&                    /*           */

		(*packet_type != 'T') &&                      /*           */

		(*packet_type != 'N') &&                      /* after     */

		(*packet_type != 'C') )                       /* sending   */

		{                                             /* EOF only  */

		packet_again (&repeating);                    /* ACK,      */

		if (repeating >= REPEATING_LIMIT)             /* TERMINATE */

		   {                                          /* NACK and  */

		   *error_code = 21;                          /* COMMAND   */

		   goto end;                                  /* are       */

		   }                                          /* accepted  */

		goto anfang;                                  /*           */

		}                                             /*           */

	     break;

   case 'T': if ( (*packet_type != 'A') &&                    /*           */

		(*packet_type != 'N') )                       /* after     */

		{                                             /* sending   */

		packet_again (&repeating);                    /* TERMINATE */

		if (repeating >= REPEATING_LIMIT)             /* only ACK  */

		   {                                          /* and NACK  */

		   *error_code = 21;                          /* are       */

		   goto end;                                  /* accepted  */

		   }                                          /*           */

		goto anfang;                                  /*           */

		}                                             /*           */

	     break;

   case ' ': if ( (*packet_type != 'C') &&                    /*           */

		(*packet_type != 'T') )                       /* for the   */

		{                                             /* first     */

		packet_again (&repeating);                    /* packet    */

		if (repeating >= REPEATING_LIMIT)             /* only      */

		   {                                          /* COMMAND   */

		   *error_code = 21;                          /* and       */

		   goto end;                                  /* TERMINATE */

		   }                                          /* are       */

		goto anfang;                                  /* accepted  */

		}                                             /*           */

	     break;                                           /*           */

   }


   if (last_packet.packet_number == 94)                        /*          */

      {                                                        /*          */

      last_packet.packet_number = -1;                          /*          */

      }                                                        /*          */

   last_number_help = packet_number;                           /*          */

   if ( (last_packet.packet_type == 'A') ||                    /*          */

      (last_packet.packet_type == 'E') )                       /*          */

      {                                                        /*          */

      -- last_number_help;                                     /*          */

      }                                                        /*          */

   if ( ( (last_packet.packet_type != 'E') &&                  /*          */

      (last_number_help != last_packet.packet_number) ) ||     /* check    */

      ( (last_packet.packet_type == 'E') &&                    /* of       */

      (last_number_help != last_packet.packet_number) &&       /* sequence */

      (last_number_help != (last_packet.packet_number - 1))))  /*          */

      {                                                        /*          */

      packet_again (&repeating);                               /* error    */

      if (repeating >= REPEATING_LIMIT)                        /*          */

	 {                                                     /*          */

	 *error_code = 21;                                     /*          */

	 goto end;                                             /*          */

	 }                                                     /*          */

      goto anfang;                                             /*          */

      }                                                        /*          */


   *information_length = packet_length - 2;       /* computing info-length */


   for (i = 0; i < *information_length; ++i)              /* transfer PN + */

       {                                                  /* PT + INFO to  */

       packet_array [i] = packet_array [i+2];             /* INFO in       */

       }                                                  /* packet-array  */


   }


end: ;


}




/****************************************************************************

**                                                                         **

**     sending last packet again                                           **

**     -------------------------                                           **

**                                                                         **

**     input:  repeating                                                   **

**                                                                         **

**     output: repeating                                                   **

**             communication line                                          **

**                                                                         **

****************************************************************************/


packet_again (repeating)


int   *repeating;                          /* count of sending after error */


{


int   packet_array [MAXLEN],                    /* packet-number + packet- */

      packet_length,                            /* type + information      */

      error_code,                               /* 0...ok - 1...timeout    */

      i;                                        /* counting                */


if (last_packet.packet_type == ' ')                           /*           */

   {                                                          /*           */

   packet_array [0] = ' ';                                    /* no packet */

   packet_array [1] = 'N';                                    /* sent      */

   packet_length = 2;                                         /* before -> */

   }                                                          /* send NACK */

   else                                                       /*           */

   {                                                          /*           */

   packet_array [0] = last_packet.packet_number + 32;         /* packet    */

   packet_array [1] = last_packet.packet_type;                /* sent      */

   packet_length = last_packet.information_length + 2;        /* before -> */

   for (i = 2; i < packet_length; ++i)                        /* send it   */

       {                                                      /* again     */

       packet_array [i] = last_packet.information [i-2];      /*           */

       }                                                      /*           */

   }                                                          /*           */


do    {                                                            /* send */

      data_link_sender (&error_code, packet_length, packet_array); /* last */

      ++ *repeating;                                               /* pack */

      }                                                           /* until */

while ( (*repeating < REPEATING_LIMIT) &&                        /* reach  */

      (error_code != 0) );                                      /* REP.LIM */


}




/****************************************************************************

**                                                                         **

**     session-layer (sender)                                              **

**     ----------------------                                              **

**                                                                         **

**     input:  packet-type                                                 **

**             information-length                                          **

**             packet-array (information)                                  **

**                                                                         **

**     output: error-code                                                  **

**             communication line                                          **

**                                                                         **

****************************************************************************/




session_sender (error_code, packet_type, information_length, packet_array)


int   *error_code,                         /* 0...ok - 21...protocol-error */

      packet_type,                         /* A - N - D - C - T - E        */

      information_length,                  /* Information                  */

      packet_array [];                     /* (PN + PT +) Information      */


{


int   packet_length,                       /* PN + PT + Information        */

      repeating,                           /* count of sending after error */

      i;                                   /* counting                     */


*error_code = 0;                                  /* initialize error-code */

repeating = 0;                                    /* and repeat-counter    */


packet_length = information_length + 2;      /* computing of packet_length */


for (i = information_length - 1; i >= 0; --i)             /* transfer INFO */

    {                                                     /* in packet-    */

    packet_array [i+2] = packet_array [i];                /* array for     */

    }                                                     /* DATA-LINK     */


if ( (packet_type == 'A') |                                  /*            */

   (packet_type == 'N') )                                    /*            */

   {                                                         /* computing  */

   packet_array [0] = last_receiving_number + 32;            /* of packet- */

   }                                                         /* number to  */

   else                                                      /* send with  */

   {                                                         /* help of    */

   packet_array [0] = (last_receiving_number + 33);          /* last       */

   if ( (packet_array [0] - 32) > 94)                        /* received   */

      {                                                      /* packet     */

      packet_array [0] = ' ';                                /*            */

      }                                                      /*            */

   }                                                         /*            */


packet_array [1] = packet_type;                  /* set packet-type for DL */


do    {                                                       /* sending   */

      data_link_sender (error_code, packet_length,            /* packet    */

		       packet_array);                         /* until no  */

      ++ repeating;                                           /* error or  */

      }                                                       /* repeating */

while ( (repeating < REPEATING_LIMIT) &&                      /* limit is  */

      (*error_code != 0) );                                   /* reached   */


if (*error_code == 0)                                       /*          */

   {                                                        /*          */

   last_packet.packet_number = packet_array [0] - ' ';      /*          */

   last_packet.packet_type = packet_type;                   /* setting  */

   last_packet.information_length = information_length;     /* of       */

   for (i = 0; i < information_length; ++i)                 /* global   */

       {                                                    /* variable */

       last_packet.information [i] = packet_array [i+2];    /* LAST-    */

       }                                                    /* PACKET   */

   }                                                        /*          */

   else                                                     /*          */

   {                                                        /*          */

   *error_code = 21;                                        /*          */

   }                                                        /*          */


}




/****************************************************************************

**                                                                         **

**     testing called operation                                            **

**     ------------------------                                            **

**                                                                         **

**     input:  file-name                                                   **

**             file-type                                                   **

**             called action (receive or send)                             **

**                                                                         **

**     output: 1 ... called operation possible                             **

**             0 ... called operation not possible                         **

**                                                                         **

****************************************************************************/




operation_ok (file, action)


char  file [];                                /* name of file to work with */


int   action;                                 /* R...receive   S...send    */


{


int   status;                                 /* 1...action is possible    */

					      /* 0...action is impossible  */


FILE *fopen (), *fp;


status = 1;                                   /* initialize status         */


fp = fopen (file, "r");                       /* try to open file for read */


if ( (action == 'S') &&                                     /* if send and */

   (fp == NULL) )                                           /* file does   */

   {                                                        /* not exist   */

   status = 0;                                              /* or receive  */

   }                                                        /* and file    */

							    /* exists,     */

if ( (action == 'R') &&                                     /* status is   */

   (fp != NULL) )                                           /* set to      */

   {                                                        /* ZERO        */

   status = 0;                                              /*             */

   }                                                        /*             */


if (fp != NULL)                                                 /* if file */

   {                                                            /* exists, */

   fclose (fp);                                                 /* close   */

   }                                                            /* it      */


return (status);


}




/****************************************************************************

**                                                                         **

**     sending a file                                                      **

**     --------------                                                      **

**                                                                         **

**     input:  file-name                                                   **

**             file-type (binary or ascii)                                 **

**                                                                         **

**     output: error-code                                                  **

**             called file on communication line                           **

**                                                                         **

****************************************************************************/




send_file (error_code, file, type)


int   *error_code,                         /* 0...ok - 21...protocol-error */

      type;                                /* A...ASCII - B...binary       */


char  file [];                             /* name of file to send         */


{


int   packet_array [MAXLEN],               /* Information                  */

      information_length,                  /* Information                  */

      packet_type,                         /* A - N - D - C - T - E        */

      repeating,                           /* count of sending after error */

      c,                                   /* character to send            */

      i,                                   /* counting                     */

      counter;                             /* counting                     */


FILE  *fopen (), *fp;                      /* definition for files         */




fp = fopen (file, "r");                         /* opening of file to send */


do    {


      counter = 0;                           /* reset of character-counter */


      do    {


	    c = getc (fp);                 /* input of character from file */


	    if ( (c != EOF) &&                                   /* coding */

	       (type == 'B') )                                   /* in case*/

	       {                                                 /* type is*/

	       packet_array [counter] = ( (c & 0360) >> 4) + 32; /* binary */

	       packet_array [counter + 1] = (c & 017) + 32;      /* (see   */

	       counter += 2;                                     /* general*/

	       }                                                 /* descr.)*/


	    if ( (c != EOF) &&                                  /*         */

	       (type == 'A') &&                                 /*         */

	       ( (c & 0200) == 128) )                           /*         */

	       {                                                /*         */

	       packet_array [counter] = '&';                    /*         */

	       ++counter;                                       /*         */

	       c = c & 0177;                                    /*         */

	       }                                                /*         */

								/*         */

	    if ( (c != EOF) &&                                  /*         */

	       (type == 'A') &&                                 /*         */

	       ( (c == '&') || (c == '#') ) )                   /*         */

	       {                                                /*         */

	       packet_array [counter] = '#';                    /*         */

	       ++counter;                                       /*         */

	       }                                                /*         */

								/* coding  */

	    if ( (c != EOF) &&                                  /* in case */

	       (type == 'A') &&                                 /* type is */

	       ( (c < BLANK) || (c > DEL) ) )                   /* ASCII   */

	       {                                                /* (see    */

	       packet_array [counter] = '#';                    /* also    */

	       ++counter;                                       /* general */

	       if ( (c & 0100) == 64)                           /* descr.) */

		  {                                             /*         */

		  c = c & 077;                                  /*         */

		  }                                             /*         */

		  else                                          /*         */

		  {                                             /*         */

		  c = c | 0100;                                 /*         */

		  }                                             /*         */

	       }                                                /*         */

								/*         */

	    if ( (c != EOF) &&                                  /*         */

	       (type == 'A') )                                  /*         */

	       {                                                /*         */

	       packet_array [counter] = c;                      /*         */

	       ++counter;                                       /*         */

	       }                                                /*         */

	    }                                                   /*         */

      while ( (counter <= 86) &&                                /*         */

	    (c != EOF) );                                       /*         */


      packet_type = 'D';                                     /* send       */

      information_length = counter;                          /* data-      */

      session_sender (&error_code, packet_type,              /* package    */

		     information_length, packet_array);      /*            */

							     /* if         */

      if (error_code == 21)                                  /* protocoll- */

	 {                                                   /* error then */

	 goto end;                                           /* stop       */

	 }                                                   /* program    */


      repeating = 0;                                             /*        */

      do    {                                                    /*        */

	    session_receiver (&error_code, &packet_type,         /*        */

			     &information_length, packet_array); /* waiting*/

	    if (error_code == 21)                                /* for    */

	       {                                                 /* ACK-   */

	       goto end;                                         /* packet */

	       }                                                 /*        */

	    ++repeating;                                         /*        */

	    }                                                    /*        */

      while ( (packet_type != 'A') &&                            /*        */

	    (repeating <= REPEATING_LIMIT) );                    /*        */


      if (repeating > REPEATING_LIMIT)                       /*            */

	 {                                                   /*            */

	 packet_type = 'T';                                  /* sending of */

	 information_length = 1;                             /* TERMINATE- */

	 packet_array [0] = '1';                             /* packet if  */

	 session_sender (&error_code, packet_type,           /* no ACK is  */

			information_length, packet_array);   /* received   */

	 error_code = 21;                                    /*            */

	 goto end;                                           /*            */

	 }                                                   /*            */


      }

while (c != EOF);


packet_type = 'E';                                           /* sending of */

information_length = 0;                                      /* EOF-packet */

session_sender (&error_code, packet_type,                    /* if EOF is  */

	       information_length, packet_array);            /* reached    */

							     /*            */

if (error_code == 21)                                        /* if prot.-  */

   {                                                         /* error then */

   goto end;                                                 /* stop the   */

   }                                                         /* program    */


repeating = 0;                                                  /*         */

								/*         */

do    {                                                         /*         */

      session_receiver (&error_code, &packet_type,              /* waiting */

		       &information_length, packet_array);      /* for an  */

      if (error_code == 21)                                     /* ACK-    */

	 {                                                      /* packet  */

	 goto end;                                              /*         */

	 }                                                      /*         */

      ++repeating;                                              /*         */

      }                                                         /*         */

while ( (packet_type != 'A') &&                                 /*         */

      (repeating <= REPEATING_LIMIT) );                         /*         */


if (repeating > REPEATING_LIMIT)                               /*          */

   {                                                           /* sending  */

   packet_type = 'T';                                          /* of EOT   */

   information_length = 1;                                     /* if no    */

   packet_array [0] = '1';                                     /* ACK is   */

   session_sender (&error_code, packet_type,                   /* received */

		  information_length, packet_array);           /*          */

   }                                                           /*          */


end:                                                            /* closing */

								/* of file */

fclose (fp);                                                    /* to send */


}




/****************************************************************************

**                                                                         **

**     receiving a file                                                    **

**     ----------------                                                    **

**                                                                         **

**     input:  file-name                                                   **

**             file-type                                                   **

**             file                                                        **

**                                                                         **

**     output: error-code                                                  **

**             file (on disk)                                              **

**                                                                         **

****************************************************************************/




receive_file (error_code, file, type)


int   *error_code,                         /* 0...ok - 21...protocol-error */

      type;                                /* A...ASCII - B...binary       */


char  file [];                             /* name of file to receive      */


{


int   packet_array [MAXLEN],               /* Information (receive)        */

      packet_array_s [MAXLEN],             /* Information (send)           */

      information_length,                  /* Information                  */

      packet_type,                         /* A - N - D - C - T - E        */

      packet_type_help,                    /* see also packet-type         */

      repeating,                           /* count of repeat after error  */

      c,                                   /* received character           */

      max,                                 /* characters to receive        */

      flag,                                /* 0 ... no '&' received        */

					   /* 1 ... '&' received           */

      counter;                             /* counting                     */


FILE  *fopen (), *fp;                     /* definition for file-operation */


fp = fopen (file, "w");                            /* open file to receive */


do    {


      repeating = 0;                                              /* reset */


      do    {                                                    /* waiting*/

	    session_receiver (&error_code, &packet_type,         /* for    */

			     &information_length, packet_array); /* DATA   */

	    packet_type_help = packet_type;                      /*        */

	    max = information_length - 1;                       /*         */

	    if (error_code == 21)                              /* stop if  */

	       {                                               /* protocol-*/

	       goto end;                                       /* error    */

	       }                                               /* or       */

	    if (packet_type_help == 'T')                       /* EOT is   */

	       {                                               /* received */

	       error_code = 21;                                /*          */

	       goto end;                                       /*          */

	       }                                               /*          */

	    if ( (packet_type_help != 'D') &&                  /* send     */

	       (packet_type_help != 'E') )                     /* NACK if  */

	       {                                               /* illegal  */

	       packet_type = 'N';                              /* packet   */

	       information_length = 0;                          /*         */

	       session_sender (&error_code, packet_type,          /*       */

			      information_length, packet_array_s); /*      */

	       if (error_code == 21)                               /*      */

		  {                                               /* stop  */

		  goto end;                                      /* if     */

		  }                                             /* protocol*/

	       }                                                /* error   */

	       else                                             /*         */

	       {                                                /*         */

	       packet_type = 'A';                               /* else    */

	       information_length = 0;                           /* send   */

	       session_sender (&error_code, packet_type,          /* ACK   */

			      information_length, packet_array_s); /*      */

	       if (error_code == 21)                               /*      */

		  {                                                /*      */

		  goto end;                                        /*      */

		  }                                                /*      */

	       }                                                   /*      */

	    ++repeating;                                           /*      */

	    }                                                      /*      */

      while ( (packet_type_help != 'D') &&                         /*      */

	    (packet_type_help != 'E') &&                           /*      */

	    (packet_type_help != 'T') &&                           /*      */

	    (repeating <= REPEATING_LIMIT) );                      /*      */


      if (repeating > REPEATING_LIMIT)                         /*          */

	 {                                                     /*          */

	 packet_type = 'T';                                    /* sending  */

	 information_length = 1;                               /* EOT if   */

	 packet_array [0] = 1;                                 /* no legal */

	 session_sender (&error_code, packet_type,             /* packet   */

			information_length, packet_array_s);   /* is       */

	 error_code = 21;                                      /* received */

	 goto end;                                             /*          */

	 }                                                     /*          */


      if ( (packet_type_help == 'D') &&                     /*             */

	 (type == 'A') )                                    /*             */

	 {                                                  /*             */

	 counter = 0;                                       /*             */

	 do    {                                            /*             */

	       flag = 0;                                    /*             */

	       c = packet_array [counter];                  /*             */

	       ++counter;                                   /*             */

	       if (c == '&')                                /* encoding    */

		  {                                         /* in case     */

		  flag = 1;                                 /* type is     */

		  ++counter;                                /* ASCII       */

		  }                                         /* (see also   */

	       if (c == '#')                                /* general     */

		  {                                         /* description */

		  c = packet_array [counter];               /*             */

		  ++counter;                                /*             */

		  if ( (c != '#') &&                        /*             */

		     (c != '&') )                           /*             */

		     {                                      /*             */

		     if ( (c & 0100) == 64)                 /*             */

			{                                   /*             */

			c = c & 0277;                       /*             */

			}                                   /*             */

			else                                /*             */

			{                                   /*             */

			c = c | 0100;                       /*             */

			}                                   /*             */

		     }                                      /*             */

		  }                                         /*             */

	       if (flag == 1)                               /*             */

		  {                                         /*             */

		  c = c | 0200;                             /*             */

		  }                                         /*             */

	       putc (c, fp);                                /*             */

	    }                                               /*             */

	 while (counter <= max);                            /*             */

	 }                                                  /*             */


      if ( (packet_type_help == 'D') &&                     /*             */

	 (type == 'B') )                                    /* encoding    */

	 {                                                  /* if type     */

	 counter = 0;                                       /* is binary   */

	 do    {                                            /* (see also   */

	       c = ( (packet_array [counter] - 32) << 4) |  /* general     */

		   (packet_array [counter+1] -32);          /* description */

	       counter += 2;                                /*             */

	       putc (c, fp);                                /*             */

	       }                                            /*             */

	 while (counter <= max);                            /*             */

	 }                                                  /*             */


      }


while ( (packet_type_help != 'E') &&                    /* until EOF or    */

      (packet_type_help != 'T') );                      /* EOT is received */


end:


fclose (fp);                                         /* close file written */


}

          /* EOT is r