COMMENT# 

************************************************
*****   ITOH - DRUCKER - TREIBER - V 1.0   *****
************************************************

FUER WORDSTAR-AUSDRUCK AUF ITOH:
..Q  ESC Q ... ENGSCHRIFT #
;
PAGE 70,132	;ASSEMBLER-FORMATIERUNG FUER AUSDRUCK DES LISTINGS .LST
		;70 ZEILEN JE SEITE, 132 ZEICHEN JE ZEILE
		;BEI A4-FORMAT --> DRUCKER AUF ENGSCHRIFT 
		;SCHALTEN ! ITOH: ESC Q  (1B 51 HEX)
;
;
  ;*************LETZTE BEARBEITUNG   6.10. 1986  !!**************
;
;
;*PA  = BEGINN DER PATCH-AREA
;*CTL = CTLTABLE
;*ESC = ESCTABLE
;*ABT = ACHTBTABLE
;*STO = SPEICHERPLAETZE UND EQUATES
;*2   = BEGINN DES HAUPTPROGRAMMES
;*A0  = STEUER- UND ACHTBIT-ZEICHEN TRENNEN, ALLG. EINSTIEG BEI A0
;*8 = VERARBEITUNGSROUTINEN
;*SU  = SUCHEN EINES ZEICHENS IN EINEM TABLE
;*9 =
;*I = BEGINN DER INITIALISIERUNGS-ROUTINE
;
;
	;---------------------------------;
	;BEGINN DES CODE-SEGMENTS         ;
	;---------------------------------;
;
CSEG    SEGMENT  PUBLIC  PARA 'CODE'
			;
        ASSUME CS:CSEG,DS:CSEG,SS:CSEG
	ORG  100h	;VORBEREITUNG FUER .COM UMWANDLUNG
			;Beim Programmstart eines .COM-Programmes
			;sind alle SEGMENTREGISTER auf das CODE-
			;SEGMENT gesetzt! IP = 0100h  SP = FFFEh
			;CX = Offset Programmende, alle uebrigen
			;Register sind 0000h
INIT	PROC NEAR	;Damit keine Schwierigkeiten mit RETURNS!
	JMP  INIT1	;Erster ausfuehrbarer Befehl f. .COM
;
PAGE
;
;*PA**********************************
;*****				 *****
;*****   P A T C H  -  A R E A   *****
;*****				 *****
;*************************************
;
	ORG   0110h
;
	NEUINT	DB  67h		;NR. DES INTERRUPTS, AUF DEN VEKTOR 
				;DES INT 17h UMGELEITET WERDEN SOLL
;
	PRNUMMER  DW  0		;NUR AUSGABEN AUF PRINTER NUMMER "0h"
				;WERDEN UMKODIERT (=LPT 1)
;
	BIG8	DB  06h 	   ;Laenge d. Sequenz BIT-IMAGE-GRAPHIK
		DB  ESC,"S","0008" ;ESC S 0008 = 8 Bytes Bit-Image-Graphik
;
	UNIMODE	DB  2
		DB  ESC,">"	   ;UNIDIREKTIONALER Druck
;
	BIDMODE DB  2
		DB  ESC,"<"	   ;BIDIREKTIONALER Druck
;
	INCMODE DB  2		   ;INCREMENTAL Print Mode
		DB  ESC,"["
;
	LOGMODE DB  2		   ;LOGIC SEEK Print Mode
		DB  ESC,"]"
;
	LF144	DB  2
		DB  ESC,"T"	   ;...,N1,N0 : n/144 Zoll line feed
;
	FORWARD DB  2
		DB  ESC,"f"	   ;Line feed forward
;
	REVERS  DB  2
		DB  ESC,"r"	   ;Reverse line feed
;
	HLFEED	DB  7		   ;Laenge der Sequenz HALFLINEFEED
		DB  CR,ESC,"T16",CR,LF	
;
	HLRET	DB  18			;Laenge der Sequenz HALFLINEFEED RETURN
		DB  CR,ESC,"T16",CR	;1/3 Zeilenabstand
		DB  ESC,"r",CR,LF,LF,LF ;3 x Reverse line feed
		DB  ESC,"f",CR,LF,LF,CR	;2 x Forward line feed
;
	SLM	DB  2
		DB  ESC,"L"	;SET LEFT MARGIN

	SLF	DB  2		;Laenge der Sequenz STANDARD-LINE-FEED
		DB  ESC,"A"	;= 1/6 Zoll Line-Feed
;
	SCHR	DB  2		;Laenge der Sequenz STANDARD-CHARAKTER-SET
		DB  ESC,"N"	;= Pica (10 CPI)
;
       PROPMODE DB  2		;Proportional Mode, Laenge der Sequenz
		DB  ESC,"P"
;
	SDBIM	DB  4			;Single density Bit Image Graphik
		DB  ESC,"N",ESC,"S"	;Pica Pitch (80 Dots/Zoll) + Bit Im. Gr.
;
	DDBIM	DB  4			;Double density Bit Image Graphik
		DB  ESC,"P",ESC,"S"	;Proportional Mode (160 Dots/Zoll) +
					;Bit Image Grahik - Sequenz
;
	PRINIT	DB  4		;Laenge der Sequenz PRINTER-INITIALISIERUNG
		DB  ESC,"\",0,0	;= PRINTER-RESET (= Zustand nach POWER ON)
;
PAGE
;
;*CTL**********************************************
;***  CTLTABLE  =  TABELLE DER CONTROL-ZEICHEN  ***
;**************************************************
;
CTLTABLE:	;JEDER EINTRAG GENAU.....
	  DB  5	;....BYTES LANG
		;
		;im CTLTABLE steht:
		;
		;*als ERSTES  BYTE  * das zu uebersetzende CTL-ZEICHEN
		;		      00h wenn das ENDE des TABLES erreicht ist
		;*als ZWEITES BYTE = VERARBEITUNGSCODE
		;		    * 00  wenn das Zeichen IGNORIERT werden soll,
		;		      also ein oder mehrere Zeichen nicht zum
                ;                     Drucker gesendet werden sollen
		;		    * FFH wenn eine Sonder-Routine abgearbeitet
		;		      werden muss
		;*als DRITTES BYTE = LAENGE DER FOLGENDEN SEQUENZ
		;		      (Bei anschliessender OFFSET-Adresse 00h)
		;*als WEITERE BYTES * eine Folge von Zeichen   oder die
		;		      OFFSET-Adresse der Sonder-Routine (wird von
		;		      der Initialisierungsroutine ueberschrieben)
		;
		;
	DB   07h, 0,0,0,0		;BEL --> bei ITOH ignorieren
;	DB   09h, 			;HT: Executes Horizontal TAB --> Identisch
;	DB   0Ah, 			;LINE FEED --> Identisch
;	DB   0Bh, 			;VT: Executes Vertikal TAB --> Identisch
;	DB   0Ch,			;FF: FORM FEED --> Identisch
;	DB   ODh,			;CR: Carriage Return --> Identisch
;	DB   0Eh,			;ENLARGED PRINT MODE --> Shift Out = Identisch
	DB   0Fh, 10000001b,2,ESC,"Q"	;SI:Condensed Print Mode --> Compressed Mode
CTLR	DB   12h, 0FFh,0,0,0		;DC2: Cancel Condensed Mode --> *CONDEX*
					;urspruenglicher Zeichensatz wird aus
					;LCHR wieder hergestellt
	DB   14h, 10000001b,1,0Fh,0	;DC4:Cancel Enlarged Print Mode --> SHIFT IN
CTLU	DB   15h, 0FFh,0,0,0		;^U = Paragraph --> OFFSET ACHTBIT
CTLA	DB   01h, 0FFh,0,0,0		;^A --> OFFSET A5
CTLB	DB   02h, 0FFh,0,0,0		;^B --> OFFSET A5
CTLC	DB   03h, 0FFh,0,0,0		;^C --> OFFSET A5
CTLD	DB   04h, 0FFh,0,0,0		;^D --> OFFSET A5
CTLE	DB   05h, 0FFh,0,0,0		;^E --> OFFSET A5
CTLF	DB   06h, 0FFh,0,0,0		;^F --> OFFSET A5
	DB   0,0,0,0,0		;Frei fuer weitere Eintraege
	DB   0			;Beendet CTLTABLE
;
PAGE
;
;*ESC************************************************
;***  ESCTABLE  =  TABELLE DER  ESCAPE-SEQUENZEN  ***
;****************************************************
;
ESCTABLE:	;JEDER EINTRAG GENAU....
	   DB 7	;....BYTES LANG!
		;
		;ESCAPE ist das 1. Byte einer Steuer-Sequenz, im ESCTABLE steht:
		;
		;*als ERSTES  BYTE  * das 2. Byte dieser Sequenz!
		;		      00h wenn das ENDE des TABLES erreicht ist
		;*als ZWEITES BYTE = VERARBEITUNGSCODE
		;		    * 00  wenn das Zeichen IGNORIERT werden soll,
		;		      also ein oder mehrere Zeichen nicht zum 
		;		      Drucker gesendet werden sollen
		;		    * FFH wenn eine Sonder-Routine abgearbeitet
		;		      werden muss
		;*als DRITTES BYTE = LAENGE DER FOLGENDEN SEQUENZ
		;		      (Bei anschliessender OFFSET-Adresse 00h)
		;*als WEITERE BYTES * eine Folge von Charakters, bzw die
		;		      OFFSET-Adresse der Sonder-Routine (wird von
		;		      der Initialisierungsroutine ueberschrieben
		;
		;
		; Weniger haeufig zu erwartende Sequenzen stehen am Ende des table!
;
	DB   0Eh, 10000001b,1,0Eh,0,0,0	  ;ESC SO: Enlarged Print Mode --> Shift Out
	DB   0Fh, 10000001b,2,ESC,"Q",0,0 ;ESC SI: Condensed Print Mode -->
					  ;      Compressed Print-Mode ESC Q
	DB   2Dh, 10001000b,2,ESC,"Y",0,0 ;ESC - 0: Underline OFF --> ESC Y
	DB  0FFh, 10000000b,2,ESC,"X",0,0 ;	 1: Underline ON --> ESC X
	DB   30h, 10010001b,2,1Bh,42h,0,0 ;ESC 0 : Setzt line feed auf 1/8 Zoll --> ESC B
	DB   31h, 10010001b,4,ESC,"T14"   ;ESC 1 : Setzt LF auf 7/72 Zoll --> ESC T 14
	DB   32h, 10010001b,2,1Bh,41h,0,0 ;ESC 2 : Setzt line feed auf 1/6 Zoll --> ESC A
					  ;	Bei IBM u.U. abweichende Interpretation!!
ESC3	DB   33h, 0FFh,0,0,0,0,0  	  ;ESC 3* :n/216 Zoll line feed --> *LF216*
ESC3Ch	DB   3Ch, 0FFh,0,0,0,0,0	  ;ESC < :1 Zeile unidirektional drucken --> nach
						 ;einer Zeile zurueckschalten --> *UNIDIR*
ESC40h	DB   40h, 0FFh,0,0,0,0,0	  ;ESC @ :EPSON: Printer initialization --> RESET
					  ;     v. DRIVER-ROUTINE und PRINTER --> *RESET*
ESCA	DB   41h, 0FFh,0,0,0,0,0	  ;ESC A* :Setzt line feed auf n/72 Zoll --> *LF72*
	DB   45h, 10000001b,2,1Bh,"!",0,0 ;ESC E :Emphasized mode --> Bold Print Select
	DB   46h, 10000001b,2,ESC,22h,0,0 ;ESC F : -  "  - cancel --> - " - Clear ESC "
	DB   47h, 0,1,0,0,0,0		  ;ESC G :Double-strike mode --> Ignorieren
	DB   48h, 0,1,0,0,0,0		  ;ESC H :Cancel - " -	     -->  -  "  -
ESCJ	DB   4Ah, 0FFh,0,0,0,0,0	  ;ESC J*:Executes n/216 " line feed --> *LFEXE*
ESCK	DB   4Bh, 0FFh,0,0,0,0,0	  ;ESC K***...**: Normal density Bit Image Graphik 
					  ;		--> *SDBITGR*
ESCL	DB   4Ch, 0FFh,0,0,0,0,0	  ;ESC L***...**: Dual density Bit Image Graphik 
					  ;		--> *DDBITGR*
	DB   4Dh, 10100001b,2,ESC,"E",0,0 ;ESC M :EPSON: Elite Character -->  (12 CPI)
	DB   50h, 10100001b,2,ESC,"N",0,0 ;ESC P :EPSON: Pica Character -->  (10 CPI)
	DB   55h, 10001001b,2,ESC,"<",0,0 ;ESC U 0:Bidirektionaler Print-Mode
	DB  0FFh, 10001001b,2,ESC,">",0,0 ;	 1:Unidirektionaler Print-Mode
	DB   57h, 10001001b,1,0Fh,0,0,0	  ;ESC W 0:Cancel ENLARGED Print Mode
	DB  0FFh, 10001001b,1,0Eh,0,0,0   ;	 1:Sets ENLARGED Print Mode
ESCY	DB   59h, 0FFh,0,0,0,0,0	  ;ESC Y***...**:Double Speed/DUAL DENSITY BIM 
					  ;		--> *DDBITGR*
ESCZ	DB   5Ah, 0FFh,0,0,0,0,0	  ;ESC Z***...**:QUADRUPLE DENSITY BIM 
					  ;		--> DUAL-DENS. *DDBITGR*
	DB   69h, 10001001b,2,ESC,"]",0,0 ;ESC i 0:EPSON: Normal Print mode --> Logig seek
	DB  0FFh, 10001001b,2,ESC,"[",0,0 ;      1:EPSON: Incremental Print mode
ESC_j	DB   6Ah, 0FFh,0,0,0,0,0	  ;ESC j*:EPSON: executes n/216" reverse line feed 
					  ;		--> *LFREV*
					  ; --> Umrechnen und ausfuehren !
ESC_l	DB   6Ch, 0FFh,0,0,0,0,0	  ;ESC l*:EPSON: Sets left margin --> *LEFTM*
ESCp	DB   70h, 0FFh,0,0,0,0,0	  ;ESC p*:EPSON: Proportional/Normal Space 
					  ;		--> *PROP1*
	DB   73h, 0,2,0,0,0,0		  ;ESC s :EPSON: Half speed printing --> Ignor.
	DB   21h, 0,2,0,0,0,0		  ;ESC ! :EPSON: Print Mode Selection --> Ignor.
	DB   23h, 0,1,0,0,0,0		  ;ESC # :EPSON: MSB-control --> Ignorieren
	DB   25h, 0,3,0,0,0,0		  ;ESC %**:EPSON: Download/ROM - Selection --> Ign.
ESC26h	DB   26h, 0FFh,0,0,0,0,0	  ;ESC & **...*:EPSON: DOWNLOAD-CHAR. --> *ERROR*
ESC2Ah	DB   2Ah, 0FFh,0,0,0,0,0	  ;ESC * **...*:EPSON: BIT-IMAGE-MODE SELECTION 
					  ;		--> *ERROR*
	DB   2Fh, 0,2,0,0,0,0		  ;ESC / *:EPSON:VFU channel selection --> Ignor.
	DB   34h, 0,1,0,0,0,0		  ;ESC 4 :EPSON: Alternate Char.-Set --> Ignorieren
	DB   35h, 0,1,0,0,0,0		  ;ESC 5 :EPSON:	-  "  -
	DB   36h, 0,1,0,0,0,0		  ;ESC 6 :		-  "  -
	DB   37h, 0,1,0,0,0,0		  ;ESC 7 :		-  "  -
	DB   38h, 0,1,0,0,0,0	 	  ;ESC 8 :Ignore Paper End-Signal --> Ignorieren
	DB   39h, 0,1,0,0,0,0	 	  ;ESC 9 :Akzeptiere Paper End-Signal --> Ignor.
	DB   3Ah, 0,4,0,0,0,0		  ;ESC :***:EPSON: ROM to Download Characters 
					  ;		--> Ignorieren
	DB   3Dh, 0,1,0,0,0,0		  ;ESC = :EPSON: MSB 0 setzen --> Ignorieren
	DB   3Eh, 0,1,0,0,0,0		  ;ESC > :EPSON: MSB 1 setzen -->  - " -
	DB   3Fh, 0,3,0,0,0,0		  ;ESC ? :EPSON: BIT-IMAGE-MODE SELECTION -->Ignor.
ESCB	DB   42h, 0FFh,0,0,0,0,0 	  ;ESC B**..*:EPSON: Sets Vert. Tabs (mehrere, 
					  ;		durch 00h beendet) --> *ERROR* 
ESCC	DB   43h, 0FFh,2,0,0,0,0	  ;ESC C*  : Seitenlaenge in Zeilen --> *SEITE*
					  ;ESC C0* : Seitenlaenge in Zoll!! --> *SEITE*
					  ;		bei ITOH nur durch DIP Schalter !
ESCD	DB   44h, 0FFh,0,0,0,0,0	  ;ESC D**..*:Sets Hor. Tabs (mehrere, durch 0h
					  ; beendet --> ERROR-Routine --> *ERROR*
	DB   49h, 0,2,0,0,0,0		  ;ESC I*:EPSON:Control Codes or printable Char.
	DB   4Eh, 0,2,0,0,0,0		  ;ESC N*:Skip-over   --> Ignorieren
	DB   4Fh, 0,1,0,0,0,0		  ;ESC O : -"- Cancel-->   -  "  -
	DB   51h, 0,2,0,0,0,0		  ;ESC Q*:EPSON: Sets right margin --> Ignorieren
	DB   52h, 0,2,0,0,0,0		  ;ESC R*:EPSON: Internat. Char. Set --> Ignor.
	DB   53h, 0,2,0,0,0,0		  ;ESC S 0:Superscript = Hochstellen --> Ignorieren
					  ;      1:Subscript = Tiefstellen --> Ignorieren
	DB   54h, 0,1,0,0,0,0		  ;ESC T :Cancel Super-/Subscript  -->   -  "  -
ESC5Eh	DB   5Eh, 0FFh,0,0,0,0,0	  ;ESC ^ :EPSON: 9 PIN BIT-IMAGE-MODE --> *ERROR*
ESC_b	DB   62h, 0FFh,0,0,0,0,0	  ;ESC b**..*:EPSON: Sets VFU position (mehrere,
					  ; durch 0h beendet --> *ERROR*
	DB   0			 ;Beendet ESC-TABLE
;
;
;
PAGE
;
;*ABT************************************************
;***  ACHTBTABLE  =  TABELLE DER ACHTBIT-ZEICHEN  ***
;****************************************************
;
ACHTBTABLE:	;********** ACHTBIT  BIT-IMAGE-GRAPHIK **********
		;
		; JEDER EINTRAG GENAU....
	  DB 11 ; .... BYTES LANG !!!
		;
		;im ACHTBTABLE steht:
		;
		;*als ERSTES  BYTE  * der DEZ-(HEX-)Wert des zu suchenden ZEICHENS
		;		      00h wenn das ENDE des TABLES erreicht ist
		;*als ZWEITES BYTE = VERARBEITUNGSCODE
		;		    * 00  wenn das Zeichen IGNORIERT werden soll,
		;		      also ein oder mehrere Zeichen nicht zum 
		;		      Drucker gesendet werden sollen
		;		    * FFH wenn eine Sonder-Routine abgearbeitet
		;		      werden muss
		;*als DRITTES BYTE = LAENGE DER FOLGENDEN SEQUENZ
		;		      (Bei anschliessender OFFSET-Adresse 00h)
		;*als WEITERE BYTES * eine Folge von Zeichen bzw die
		;		      OFFSET-Adresse der Sonder-Routine (wird von
		;		      der Initialisierungsroutine ueberschrieben
		;
		; Weniger haeufig zu erwartende Zeichen stehen am Ende des table !
;
	DB   21,11000000b,08h,00h,4Ah,55h,55h,55h,55h,29h,0	;
	DB  129,11000000b,08h,00h,3Ch,41h,40h,41h,7Ch,00h,0	;
	DB  132,11000000b,08h,00h,20h,55h,54h,55h,38h,40h,0	;
	DB  142,11000000b,08h,70h,29h,24h,22h,24h,29h,70h,0	;
	DB  148,11000000b,08h,00h,38h,45h,44h,45h,38h,00h,0	;
	DB  153,11000000b,08h,3Eh,41h,47h,41h,47h,41h,3Eh,0	;
	DB  154,11000000b,08h,3Fh,40h,43h,40h,43h,40h,3Fh,0	;
	DB  225,11000000b,08h,00h,7Eh,01h,41h,49h,36h,00h,0	;
	DB  176,11000111b,8,0,0AAh,0,55h,0,0AAh,0,55h		;
	DB 0FFh,11000111b,8,0,0Ah,0,05h,0,0Ah,0,05h
	DB  177,11000111b,8,0AAh,55h,0AAh,55h,0AAh,55h,0AAh,55h ;
	DB 0FFh,11000111b,8,0Ah,05h,0Ah,05h,0Ah,05h,0Ah,05h
	DB  178,11000111b,8,55h,0FFh,55h,0FFh,55h,0FFh,55h,0FFh ;
	DB 0FFh,11000111b,8,05h,0Fh,05h,0Fh,05h,0Fh,05h,0Fh
	DB  179,11000101b,8,0,0,0,0,0FFh,0,0,0			;
	DB  180,11000101b,8,10h,10h,10h,10h,0FFh,0,0,0		;
	DB  181,11000101b,8,28h,28h,28h,28h,0FFh,0,0,0		;
	DB  182,11000101b,8,10h,10h,10h,0FFh,0,0FFh,10h,10h	;
	DB  183,11000101b,8,10h,10h,10h,0F0h,10h,0F0h,0,0	;
	DB  184,11000101b,8,28h,28h,28h,28h,0F8h,0,0,0		;
	DB  185,11000101b,8,28h,28h,28h,0EFh,0,0FFh,0,0		;
	DB  186,11000101b,8,0,0,0,0FFh,0,0FFh,0,0		;
	DB  187,11000101b,8,28h,28h,28h,0E8h,08h,0F8h,0,0	;
	DB  188,11000000b,8,28h,28h,28h,2fh,20h,3fh,0,0		;
	DB  189,11000000b,8,10h,10h,10h,1Fh,10h,1Fh,0,0		;
	DB  190,11000000b,8,28h,28h,28h,28h,3fh,0,0,0		;
	DB  191,11000101b,8,10h,10h,10h,10h,0F0h,0,0,0		;
	DB  192,11000000b,8,0,0,0,0,1Fh,10h,10h,10h		;
	DB  193,11000000b,8,10h,10h,10h,10h,1Fh,10h,10h,10h	;
	DB  194,11000101b,8,10h,10h,10h,10h,0F0h,10h,10h,10h	;
	DB  195,11000101b,8,0,0,0,0,0FFh,10h,10h,10h		;
	DB  196,11000000b,8,10h,10h,10h,10h,10h,10h,10h,10h	;
	DB  197,11000101b,8,10h,10h,10h,10h,0FFh,10h,10h,10h	;
	DB  198,11000101b,8,0,0,0,0,0FFh,28h,28h,28h		;
	DB  199,11000101b,8,0,0,0,0FFh,0,0FFh,10h,10h		;
	DB  200,11000000b,8,0,0,0,3Fh,20h,2Fh,28h,28h		;
	DB  201,11000101b,8,0,0,0,0F8h,08h,0E8h,28h,28h		;
	DB  202,11000000b,8,28h,28h,28h,2Fh,20h,2Fh,28h,28h	;
	DB  203,11000101b,8,28h,28h,28h,0E8h,08h,0E8h,28h,28h	;
	DB  204,11000101b,8,0,0,0,0FFh,0,0EFh,28h,28h		;
	DB  205,11000000b,8,28h,28h,28h,28h,28h,28h,28h,28h	;
	DB  206,11000101b,8,28h,28h,28h,0EFh,0,0EFh,28h,28h	;
	DB  207,11000000b,8,28h,28h,28h,28h,2Fh,28h,28h,28h	;
	DB  208,11000000b,8,10h,10h,10h,1Fh,10h,1Fh,10h,10h	;
	DB  209,11000101b,8,28h,28h,28h,28h,0E8h,28h,28h,28h	;
	DB  210,11000101b,8,10h,10h,10h,0F0h,10h,0F0h,10h,10h	;
	DB  211,11000000b,8,0,0,0,1Fh,10h,1Fh,10h,10h		;
	DB  212,11000000b,8,0,0,0,0,3Fh,28h,28h,28h		;
	DB  213,11000101b,8,0,0,0,0,0F8h,28h,28h,28h		;
	DB  214,11000101b,8,0,0,0,0F0h,10h,0F0h,10h,10h		;
PAGE
	DB  215,11000101b,8,10h,10h,10h,0FFh,10h,0FFh,10h,10h	;
	DB  216,11000101b,8,28h,28h,28h,28h,0FFh,28h,28h,28h	;
	DB  217,11000000b,8,10h,10h,10h,10h,1Fh,0,0,0		;
	DB  218,11000101b,8,0,0,0,0,0F0h,10h,10h,10h		;
	DB  219,11000101b,8,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh ;
	DB  220,11000101b,8,0E0h,0E0h,0E0h,0E0h,0E0h,0E0h,0E0h,0E0h ;
	DB  221,11000101b,8,0FFh,0FFh,0FFh,0FFh,0,0,0,0		;
	DB  222,11000101b,8,0,0,0,0,0FFh,0FFh,0FFh,0FFh		;
	DB  223,11000000b,8,1Fh,1Fh,1Fh,1Fh,1Fh,1Fh,1Fh,1Fh	;
	DB  241,11000000b,8,0,44h,44h,5Fh,44h,44h,0,0		;
	DB  242,11000000b,8,0,51h,51h,8Ah,8Ah,84h,0,0		;
	DB  243,11000000b,8,0,84h,8Ah,8Ah,51h,51h,0,0		;
	DB    1,11000000b,8,7Eh,81h,95h,0B1h,0B1h,95h,81h,7Eh	  ;01h
	DB    2,11000000b,8,7Eh,0FFh,0E8h,0CFh,0CFh,0E8h,0FFh,7Eh ;02h
	DB    3,10000000b,1,233,0,0,0,0,0,0,0			  ;03h
	DB    4,10000000b,1,234,0,0,0,0,0,0,0			  ;04h
	DB    5,10000000b,1,235,0,0,0,0,0,0,0			  ;05h
	DB    6,10000000b,1,232,0,0,0,0,0,0,0			  ;06h
	DB   16,11000000b,8,0,0FFh,7Eh,3Ch,3Ch,18h,18h,0	;16h
	DB   17,11000000b,8,0,18h,18h,3Ch,3Ch,7Eh,0FFh,0	;17h
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
PAGE
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0,0,0,0,0,0,0,0,0,0,0
	DB  0			;Beendet ACHTBTABLE
;
;
;
;************************************
;** ENDE DER  P A T C H   A R E A  **
;************************************
;
PAGE
;*STO
	;-------------------------------------------------;
	; E Q U A T E S  /  S P E I C H E R P L A E T Z E ;
	;-------------------------------------------------;
;
	ESC  EQU  1Bh
	CR   EQU  0Dh
	LF   EQU  0Ah
;
	VEKTOR  DW	0	;Speicherplatz fuer urspruenglichen
		DW	0	;Vektor des INT 17
;
	TESTFLAG  DW  1938h	;Test ob Treiber bereits installiert ?
;
	HPSP	DW	0  	;Speicherplatz fuer Stack-Pointer und
	HPSS	DW	0   	;Stack-Segment des aufrufenden Hauptprogrammes
;
	UPSP	DW	0  	;Speicherplatz fuer Stack-Pointer und
	UPSS	DW	0  	;Stack-Segment des ITOH- Drucker- Treibers
;
	ENVIRADR DW	0	;Speicher fuer die Environment Adresse
;
	FLAG1	DB	0	;Wird gesetzt, wenn eine Zeile unidirektional
				;zu drucken ist
 	FLAG2	DB	0	;LOWER NIBBLE wird gesetzt (0Fh), wenn eine Zwischenzeile
				;zu drucken ist
				;HIGHER NIBBLE wird gesetzt (FFh), wenn die Zwischenzeile
				;abgearbeitet wird
;
	FLAG3	DB	0	;Flag fuer Proportional Mode
;
	FLAG4	DB	0	;Flag fuer Steuerung von SAVECHAR

	CRLF	DB	0	;Flag fuer Sequenz CR-LF oder LF-CR
;
	CHAR	DB	0	;Zwischenspeicher fuer 1 Zeichen
;
	COUNT	DW	0	;SPEICHER fuer BP nach dem Einlesen einer Zeile 
				;WORD, weil mindestens bis 2048 zu zaehlen ist
;
	HEXCHR  DB 	0,0	;Zwischenspeicher fuer 1- oder 2-Byte HEX Zeichen
;
	DIGIT   DB	0	;Laenge der Sequenz
		DB 	0,0,0,0	;Zwischenspeicher fuer 2- oder 4-Digit ASCII-Zeichen
;
	LLF	DB 0,0,0,0,0,0,0,0,0,0	;LAST-LINE-FEED - Speicher fuer den letzten
					;vom Hauptprogramm gesetzten Zeilenabstand
;
	LCHR	DB 0,0,0,0,0,0,0,0,0,0	;LAST-CHARAKTER-SET-Speicher fuer den letzten
					;vom Hauptprogramm gesetzten Zeilenabstand
;
	BUFFER  DB 2048 DUP (0) 	;Speicher fuer eine Zeile
;
	;---------------------------------;
	;STACK- BEREICH DEFINIEREN        ;
	;---------------------------------;
;
	STAPEL	DB	256 DUP (0)   
;
	STAPELEND DB    0
PAGE
;
;*2****************************************************************************
;******************************************************************************
;***							  ***
;***   BEGINN DES EIGENTLICHEN PRINTER-DRIVER-PROGRAMMS   ***
;***							  ***
;***   EINSPRUNG UEBER ### INT 17h ### BEI ## START ###   ***
;***							  ***
;***							  ***
;***   EINSPRUNG UEBER ### INT 17h ### BEI ## START ###   ***
;***							  ***
;***   UMSTIEGSROUTINE VOM HAUPT- IN DAS UNTERPROGRAMM    ***
;***							  ***
;************************************************************
		;*	
		;* AUFRUF: AL = CHAR.
		;*	   AH = 0,1,2 (0 = drucken)
		;*	   DX = PRINTER-NUMMER
		;*         Alle verwendeten REGISTER GESICHERT
		;* RUECKGABE:
		;*
;
	ORG  1100h	;damit bei Aenderungen in der Patch-Area
			;Programm-Beginn konstant bleibt!
			;
;
START	PROC  NEAR	;Einsprung ueber INT 17h, daher FLAGS,CS,IP
	ASSUME CS:CSEG	;bereits am STACK des Hauptprogrammes
			;
	STI		;Interrupts wieder zulassen
	PUSH  BX
	MOV  BX,CS:PRNUMMER ;Datensegment DS noch nicht gesetzt!!
	CMP  DX,BX      ;SPEZIFIZIERTER PRINTER angesprochen ?
	JNZ  STA1	;ANDERE DRUCKER KEINE KONVERTIERUNG
	CMP  AH,0	;AH=0 --> CHAR IN AL DRUCKEN
	JNZ  STA1	;AH<>0 --> PRINTER-INITIALISIERUNG OD. STATUSABFR.
;
;#######
;*PUT
;
    PUT:	  ;Zeichen in das Unterprogramm uebergeben
	PUSH  CX	;NOCH ALTER STACK VOM HAUPTPROGRAMM
	PUSH  DS
	PUSH  SI
	PUSH  BP
	PUSH  CS
	POP   DS	;DS DES UNTERPROGRAMMES LADEN
	ASSUME  DS:CSEG
	CLI		;INTERRUPTS SPERREN, DA SONST KATASTROPHE
	MOV  HPSS,SS	;STACK-SEGMENT UND -POINTER
	MOV  HPSP,SP	;AUSTAUSCHEN
	MOV  SP,UPSP
	MOV  SS,UPSS
	STI		;INTERRUPTS WIEDER ZULASSEN
	POP  CX
	POP  BX
	POP  BP
	POP  SI
	CALL SAVECHAR   ;CHAR in BUFFER speichern
	RET		;---> A2, wnn GET von A1 aufgerufen
;
   STA1:CALL  PRINT
	POP  BX
	IRET		;Ruecksprung in das Hauptprogramm, wenn
			;Zeichen fuer anderen Drucker bestimmt,
			;oder Drucker-Initialisierung
;
SAVECHAR:			;Jeden Charakter im BUFFER speichern !
	OR  FLAG4,0		;Aufruf von SAVECHAR selbst ?
	JNZ SC2+1		;= RET ... zurueck an die Aufrufstelle von
				;SAVECHAR
	CMP  AL,CR		;Zeile komplett ?
	JE   SC2+1	;Nicht mehr im Buffer speichern sondern Zeile drucken
	CMP  AL,LF
	JE   SC4
;
   SC1:	CMP  BP,2048		;BUFFERENDE erreicht ? Wenn groesser oder gleich
	JGE  SC2			;2048, gehen alle weiteren Zeichen verloren !!
	MOV  BYTE PTR BUFFER+[BP],AL     ;Zeichen im BUFFER ablegen
   SC2:	INC  BP			;Zaehler [BP] um 1 erhoehen
	RET
;
   SC4:	CMP  BP,0	;Erstes Zeichen der Zeile = LF ?
	JE   SC5	;dann LF sofort ausgeben
;
	MOV  FLAG4,0FFh	;Flag fuer Umgehung von SAVECHAR setzen
	PUSH AX		;Zeichen in AL am Stapel sichern
	CALL GET	;Naechstes Zeichen einlesen ...
	CMP  AL,CR	;... und auf CR pruefen
	JE   SC6
			;Keine LF-CR - Sequenz, nur LF, daher ...
	MOV  FLAG4,0	;... Flag ruecksetzen ...
	MOV  CHAR,AL	;... letztes Zeichen zwischenspeichern
	POP  AX		;vorletztes Zeichen wieder vom Stapel holen ...
			;... aber nicht im BUFFER speichern (in Zwischenzeile
	CALL LFINLINE	; wuerde LF stoeren !!)
	MOV  AL,CHAR	;Zwischengespeichertes Zeichen holen ...
	CALL SC1	;... im Zeilen - BUFFER speichern ...
	RET		;... und verarbeiten
;
   SC5: MOV  AL,LF	;LF normal verarbeiten ohne im Buffer zu speichern
	RET

   SC6:			;Sequenz LF-CR empfangen
	MOV  FLAG4,0	;Flag ruecksetzen
	POP  AX		;Stack korrigieren (Vorletztes Zeichen noch am Stack)
	MOV  CRLF,0FFh	;FLAG CRLF setzen
 	MOV  AL,CR
	RET		;Normal verarbeiten
;
LFINLINE:
	MOV  SI,OFFSET INCMODE
	CALL PRSTRING		;ITOH kann nur im Incremental Print Mode ein
	MOV  AL,LF		;LF innerhalb einer Zeile ausfuehren, daher ...
	CALL PRINTX		;... in Incr.Mode umschalten, LF ausgeben und ...
	MOV  SI,OFFSET LOGMODE	;... wieder in den Logic Seek Mode zurueck
	CALL PRSTRING
;
;
;#######
;*GET
;
    GET:	  ;ZEICHEN vom Hauptprogramm HOLEN
	PUSH SI	  ;Register SI, BP, BX, CX sichern
	PUSH BP
	PUSH BX
	PUSH CX
   GET0:CLI
	MOV  UPSS,SS	;STACK-SEGMENT und -POINTER tauschen
	MOV  UPSP,SP
	MOV  SP,HPSP
	MOV  SS,HPSS
	STI
	POP  BP
	POP  SI
	POP  DS
	POP  CX
	POP  BX		;REGISTER WURDEN BEIM UP-BEGINN AM STAPEL ABGELEGT
	IRET		;UNSER PROGR. WURDE DURCH INT 17H AUFGERUFEN
;
;********************************************
;***** RUECKSPRUNG IN DAS HAUPTPROGRAMM *****
;********************************************
;###ENDE DER UMSTIEGS-ROUTINE
;############################
;
PAGE
;
;*A0*************************************
;*** ROUTINE ZUM FESTSTELLEN VON      ***
;*** STEUERZEICHEN UND ACHTBITZEICHEN ***
;****************************************

;#####
A1:	CALL GET	;ERGIBT ALS RETURN-ADRESSE A2
;
    A2:	MOV  BX,OFFSET A1 ;RETURN-ADRESSE (OFFSET) FUER A1 
	PUSH BX		  ;AM STACK ABLEGEN
;
    A0:	CMP  AL,CR	;Zeile komplett ? ...
	JE   A10	;... dann Zwischenzeile abarbeiten
;
	CMP  AL,20h	;CHAR = STEUERZEICHEN ?
	JC   A3    	;JA WENN CARRY
	CMP  AL,80h	;CHAR < 80h
	JNC  A5     	;WENN KEIN CARRY : CHAR  80H = Achtbitzeichen
	CALL NORMAL	;Kein CTL-, kein ACHTBIT-Char = NORM 7 BIT-CHAR
	CALL DURCHF	 
	RET		;---> A1
;
    A3:	CMP  AL,ESC	;Zeichen = ESCAPE ?
	JE   A4
	CALL CONTROL	;Kein ESCAPE, daher CONTROL
	CALL DURCHF
	RET		;---> A1
;
    A4: CALL ESCAPE
	CALL DURCHF
	RET		;---> A1
;
    A5:	CALL ACHTBIT
	CALL DURCHF
	RET		;---> A1: RUECKSPRUNG IN HAUPTPROGRAMM UEBER CALL GET !
;
    A10:CALL LINE2	;Zwischenzeile drucken
	RET		;---> A1
;
PAGE
;
;*8****************************
;*** VERARBEITUNGS-ROUTINEN ***
;*** MIT  CALL   AUFZURUFEN ***
;******************************
;
NORMAL:	MOV CH,0Fh		;***ZUM TESTEN*** Verarbeitungscode in CH
	RET			;setzen: Zeichen unveraendert drucken
;
;
CONTROL: 
	MOV  SI,OFFSET CTLTABLE
	CALL SUCHEN
	RET
;	
ESCAPE:
	CALL GET		;Naechstes Zeichen lesen
	MOV  SI,OFFSET ESCTABLE
	CALL SUCHEN
	CMP  CH,0Fh		;Zeichen nicht gefunden ?
	JE   ES2
	RET
;
    ES2:PUSH AX
	MOV  AL,ESC		;ESC ausgeben
	CALL PRINTX
	POP  AX
	MOV  CH,0Fh		;Unveraendert drucken
	RET
;
ACHTBIT:
	MOV  SI,OFFSET ACHTBTABLE
	CALL SUCHEN	
;
	CMP  CH,0Fh		;Zeichen nicht gefunden ? ...
	JNE  AB2
	MOV  AL,20h		;... dannSPACE ausgeben
	MOV  CH,10000000b	;Verarbeitungscode (fuer Zwischenzeile !!)
    AB2:RET
;
PAGE
;
;*SU*************************************************************
	;***ROUTINE ZUM SUCHEN UND  UMKODIEREN EINES ZEICHENS ***
	;********************************************************
	;AUFRUF-PARAMETER   : SI = ANFANG-ADRESSE DES TABLES (ERSTES
	;		           BYTE  = LAENGE EINES EINTRAGES)
	;		      AL = ZEICHEN , AH = 0 (Zeichen drucken)
	;RUECKGABE-PARAMETER: AL, AH unveraendert
	;		      SI = OFFSET-Adresse des EINTRAGS
	;		      CH = Verarbeitungscode (2.Byte d. Eintrags)
	;		      CL = Anzahl der Bytes (3.Byte des Eintrags)
	;		      BX = OFFSET-ADRESSE einer SONDER-ROUTINE
	;		      DX = LAENGE eines EINTRAGS
;
;		       
;BEDEUTUNG CH-CODE BIT 76543210
;                      
;      ALLGEMEINE VERARBEITUNG   ZWISCHENZEILEN-VERARBEITUNG
;       
;			        
;			        
;Zeich./Sequ. SENDEN 1        1 Zeichen/Sequenz in Zwischenzeile
;  - " -  IGNORIEREN 0        0 SPACE in Zwischenzeile
;                                
; 8-BITGRAPHIK SENDEN  1      1 ZWEITEINTRAG im table fuer Zwischenzeile
;                      0      0 Zwisch.-Zeile = Fortsetzg. d. Unterlaenge
;                               
; SEQU. n. LCHR kopieren 1    1 Fuer Zwischenzeile FLAG2 setzen
;			 0    0    (allenfalls SPACE !)
;			        
;Sequenz nach LLF kopieren 1  1 Naechstes Byte abfragen (Bit 0 = ?)
;			   0  0       (!! ZWEITEINTRAG fuer BIT 0 = 1 !!)
;
;
;SONSTIGE CODES    00h ... ZEICHEN IGNORIEREN
;		   FFh ... SONDER-ROUTINE AUSFUEHREN
;RUECKGABE CODE    0Fh ... ZEICHEN NICHT GEFUNDEN - 
;			   ZEICHEN UNVERAENDERT SENDEN
;
;    IM TABLE STEHT:
		;
		;*als ERSTES  BYTE  * der DEZ-(HEX-)Wert des zu suchenden ZEICHENS
		;		      00h wenn das ENDE des TABLES erreicht ist
		;*als ZWEITES BYTE = VERARBEITUNGSCODE
		;		    * 00  wenn das Zeichen IGNORIERT werden soll,
		;		      also ein oder mehrere Zeichen nicht zum 
		;		      Drucker gesendet werden sollen
		;		    * FFH wenn eine Sonder-Routine abgearbeitet
		;		      werden muss
		;*als DRITTES BYTE = LAENGE DER FOLGENDEN SEQUENZ
		;		      (Bei anschliessender OFFSET-Adresse 00h)
		;*als WEITERE BYTES * eine Folge von Zeichen bzw die
		;		      OFFSET-Adresse der Sonder-Routine (wird von
		;		      der Initialisierungsroutine ueberschrieben
		;
;   ACHTUNG: Das ZEICHEN 00h mu allenfalls an erster Stelle im table stehen,
;	     ein Zweiteintrag mu dann mit 0FFh beginnen, weil 00h den table beendet!!
;
PAGE
;
SUCHEN:
	XOR  DX,DX
	MOV  DL,[SI]	;Laenge eines Eintrags
	INC  SI		;SI auf ersten Eintrag stellen
	XOR  CX,CX
    SU0:MOV  BL,[SI]	;Erstes Zeichen des Eintrags lesen
	CMP  AL,BL	;und vergleichen
	JE   SU2
	CMP  BL,00h	;Ende des table erreicht ??
	JE   SU1
	ADD  SI,DX	;SI auf naechsten Eintrag stellen
	LOOP SU0
;
    SU1:MOV  CH,0Fh	;Zeichen nicht gefunden
	RET
;
    SU2:MOV  CX,WORD PTR [SI+1]	;Verarbeitungscode (in CL, dann) in CH
	XCHG CH,CL 		;Anzahl der Bytes (in CH, dann) in CL
	MOV  BX,WORD PTR [SI+3] ;BX = OFFSET-Adresse einer
				;eventuellen Sonder-Routine
	RET
;
PAGE
;
;*DF************************************
;******* VERARBEITUNGSCODE AUSWERTEN ***
;***************************************
;*******      DURCHFUEHRUNG       ******
;***************************************
;
DURCHF:
	CMP  CH,0FFh		;SONDER-ROUTINE ausfuehren ?
	JE   DF6
;
	CMP  CH,0Fh		;Zeichen nicht gefunden ? ....
	JNE  DF0
	CALL PRINTX		;...dann unveraendert drucken
	RET
;
    DF0:TEST CH,10000000b  	;Zeichen senden (oder ignorieren) ?
	JNZ  DF1		;Bit gesetzt = NOT ZERO !!
	CALL IGNORE
	RET
;
    DF1:TEST CH,00000100b	;FLAG2 setzen ?
	JZ   DF2		;Bit nicht gesetzt = ZERO !!
	MOV  FLAG2,0Fh		;Lower Nibble von FLAG2 auf 0Fh setzen
;
    DF2:TEST CH,01000000b	;BITGRAPHIK senden ?
	JZ   DF3		;wenn ZERO --> keine Bitgraphik senden
	CALL BITGRAPH
;
    DF3:CALL COPY
	RET
;
    DF6:CALL (BX)	;SONDER-ROUTINE ausfuehren
	RET
;
;
COPY:			;Wird auch von PRLINE aufgerufen
	TEST CH,00001000b  ;naechstes Byte abfragen ?
	JZ   CY1
	PUSH DX
	CALL NEXT
	POP  DX
	TEST AL,00000001b  ; Bit gesetzt ? ...
	JZ   CY1
	ADD  SI,DX	   ;... dann ZWEITEINTRAG senden
;
    CY1:		;Wird auch von PRLINE aufgerufen !
	PUSH SI	
	INC  SI		;zweites Byte = Verarbeitungscode
	INC  SI		;drittes Byte = Anzahl der folgenden Zeichen
	CALL PRSTRING
	POP  SI
;
	TEST CH,00100000b	;Sequenz nach LCHR kopieren ?
	JZ   CY2
	MOV  BX,OFFSET LCHR
	CALL STORE
;
    CY2:TEST CH,00010000b	;Sequenz nach LLF (LAST-LINE-FEED) kopieren?
	JZ   CY4
	MOV  BX,OFFSET LLF
	CALL STORE
    CY4:RET
;
PAGE
;
IGNORE:
	XOR  CH,CH	;Anzahl d. zu ignorierenden Zeichen in CL
	OR   CL,CL	;ist CL = 0 , so ist kein weiteres Zeichen
	JZ   IG3	;zu ignorieren. Ebenso, wenn CL = 1 ist !!
	DEC  CL		;Das soeben verarbeitete Zeichen abziehen
	OR   CL,CL	;War CL = 1  ?
	JZ   IG3
    IG2:CALL NEXT	;Naechstes Zeichen holen und - ignorieren
	LOOP IG2	;bis CX = 0 ist
    IG3:RET
;
;
NEXT:
	TEST FLAG2,80h	;wird Zwischenzeile abgearbeitet ?
	JNZ  NE2
	CALL GET	;naechstes Zeichen aus Hauptprogramm holen
	RET
;
    NE2:MOV  AL,[SI]	;naechstes Zeichen aus BUFFER holen
	INC  BP		;Zaehler erhoehen
	RET
;
;
BITGRAPH:
;
	PUSH SI
	MOV  SI,OFFSET BIG8
	CALL PRSTRING
	POP  SI
	RET
;
;
STORE: 			   ;STORE LAST-LINE-FEED od. LAST-CHAR.-SET Jede Sequenz
	PUSH AX		   ;zur Aenderung des Zeilenabstandes oder des Charakter-Sets 
	PUSH CX		   ;muss im TABLE stehen, weil nur die umkodierte Sequenz
	PUSH SI		   ;gespeichert wird !!!
	INC  SI
	INC  SI
	XOR  CX,CX
	MOV  CL,[SI]
	ADD  CL,1	   ;CL = Anzahl der folgenden Bytes der Sequenz, daher + 1,
   STO1:MOV  AL,[SI]	   ;weil auch die ANZAHL DER BYTES als erstes uebertragen wird
	MOV  [BX],AL
	INC  SI
	INC  BX
	LOOP STO1
	POP  SI
	POP  CX
	POP  AX
	RET
;
PAGE
;
;****************************************************************
    ;*** ROUTINE ZU AUFBEREITUNG UND DRUCK EINER ZEICHENFOLGE ***
    ;************************************************************
    ;AUFRUF-PARAMETER : SI = OFFSET-ADR. DER ZEICHENZAHL
    ;		          ANSCHLIESSEND FOLGEN DIE ZEICHEN
    ;			  SI WIRD GEAENDERT !
    ;			DX = wird mit PRNUMMER ueberschrieben
;
PRSTRING:
;
	PUSH  AX
	PUSH  CX
	PUSH  SI
	XOR   CX,CX
	MOV   CL,[SI]	;= Laenge des Strings (max. 255)
	INC   SI
    PS1:MOV   AL,[SI]
	CALL  PRINTX
	INC   SI
	LOOP  PS1
	POP   SI
	POP   CX
	POP   AX
	RET
;
;
PRINTX2:
	OR   FLAG2,0
	JZ   PRINTX
	AND  AL,0Fh	;nur die unteren 4 Bits (obere 4 Pixel)drucken 
PRINTX:	MOV  DX,PRNUMMER
	MOV  AH,0
 PRINT:	PUSH DX
	PUSH AX
   PR1:	INT  0     	;NEUINT wird von Initialisierungsroutine
			;hier eingetragen !
	TEST AH,1	;Test ob Drucker TIMEOUT (AH = 1)
	JNZ  PR2	;Wenn AH = 0 ... alles OK
        POP  DX		;STACK korrigieren
	POP  DX		;DX wie vor dem Aufruf
	RET
;
    PR2:POP  AX
	POP  DX
	JP   PRINT	;Drucken wiederholen
;
PAGE
;
;*ZW******************************************
	;*** VERARBEITEN DER ZWISCHENZEILE ***
	;*************************************
	;
LINE2:
	MOV  AL,CR
	CALL PRINTX	;zunaechst das CR senden
	TEST FLAG2,1	;Ist FLAG2 0Fh ? Zwischenzeile zu drucken? ...
	JZ   L9		;... wenn nicht, JMP nach L9
;
	MOV  FLAG2,0FFh		;waehrend Abarbeitung der Zwischenzeile FLAG2 = 	FFh
	MOV  COUNT,BP		;Zeichenzahl nach dem Einlesen in COUNT sichern
	XOR  BP,BP		;Zaehler ruecksetzen
	MOV  SI,OFFSET HLFEED	;2/3 Zeilenvorschub ausfuehren
	CALL PRSTRING
;
     L2:CMP  BP,COUNT	;Zaehler [BP] mit COUNT (einspeichern) vergleichen
	JE   L9		;wenn Zeilenende erreicht ... JMP L9
	CMP  BP,2048    ;BUFFER uebervoll ?
	JAE  L8		;logischer Vergleich (ohne Vorzeichen)
	MOV  AL,BYTE PTR [BP+BUFFER]  ;naechstes Zeichen aus dem Buffer holen
	INC  BP
;
	CMP  AL,LF	;LF hat in Zwischenzeile nichts verloren !!
	JZ   L2		;... daher ignorieren
;
	CMP  AL,20h	;Steuerzeichen ?
	JC   L3
	CMP  AL,80h	;Achtbitzeichen ?
	JNC  L5
	CALL NORMAL	;Kein Steuer-, od. Achtbitzeichen
;
	CMP  CH,0Fh		;Zeichen nicht gefunden ...
	JNZ  L1			;... dann SPACE ausgeben, damit Zeichen nicht
	MOV  AL,20h		;in die Zwischenzeile gedruckt wird
	MOV  AH,10000000b	
;
     L1:CALL PRLINE
	JMP  L2
;
     L3:CMP  AL,ESC	;Zeichen = ESC ? ...
	JE   L4		;...dann L4
	CALL CONTROL	;gewoehnliches Control-Zeichen
	CALL PRLINE
	JMP  L2
;
     L4:CALL ESCAPE
	CALL PRLINE
	JMP  L2
;
     L5:CALL ACHTBIT
	CALL PRLINE
	JMP  L2
;
     L8:MOV  AL,22h	;Zeichen " in Zwischenzeile drucken
	CALL PRINTX
	INC  BP
	JMP  L2
;
     L9:CALL NEWLINE
	RET
;
;
PAGE
;
PRLINE:			;= "Durchfuehrung" fuer Zwischenzeile
	CMP  CH,0FFh	;Sonder-Routine ?
	JE   PRL8
;
	CMP  CH,0Fh	;Zeichen nicht gefunden, unveraendert drucken
	JZ   PRL9
;
	TEST CH,10000000b  ;Zeichen/Sequenz drucken (oder ignorieren) ?
	JNZ  PRL1
	CALL IGNORE		;wenn Bit 7 nicht gesetzt
	RET
;
   PRL1:TEST CH,00000001b	;Zeichen/Sequenz oder Space in Zwischenzeile ?
	JNZ  PRL2		;wenn Bit 0 nicht gesetzt (= ZERO) ...
	MOV  AL,20h		;... Space ausgeben
	CALL PRINTX
	RET
;
;           ***** in die Zwischenzeile drucken *****
;
   PRL2:TEST CH,00000100b  	;FLAG2 gesetzt ?
	JZ   PRL6	   	;... Jump wenn nein
	TEST CH,01000000b	;Bitgraphik senden ?
	JZ   PRL3
	CALL BITGRAPH		;wenn Bit 6 gesetzt
;
   PRL3:TEST CH,00000010b	;Zweiteintrag im table ?
	JZ   PRL4
	ADD  SI,DX
	CALL CY1		;String senden und allenfalls nach
	RET			;LLF und LCHR kopieren
;
   PRL4:		   ;Kein Zweiteintrag, Fortsetzung der Zeichenunterlaenge
	PUSH SI		   ;in die Zwischenzeile drucken
	INC  SI
	INC  SI	
	XOR  CX,CX
	MOV  CL,[SI]	   ;Anzahl der folgenden Bytes
;
   PRL5:INC  SI		   ;Naechstes Byte des Eintrages
	MOV  AL,[SI]
	PUSH CX
	MOV  CX,7
	SAR  AL,CL	   ;7 mal arithmetisch nach rechts schieben
	POP  CX
	CALL PRINTX2
	LOOP PRL5
	POP  SI
	RET
;
   PRL6:TEST CH,01000000b
	JZ   PRL7
	CALL BITGRAPH
;
   PRL7:CALL COPY		;String senden und allenfalls nach LLF
	RET			;oder LCHR kopieren
;
   PRL8:CALL (BX)
	RET
;
   PRL9:CALL PRINTX
	RET
;
;
NEWLINE:
	MOV  AL,CR	;CR senden, sicherheitshalber, damit Drucker druckt
	CALL PRINTX
	OR   FLAG2,0	;Ist FLAG2 gesetzt, wurde eine Zwischenzeile gedruckt ?
	JZ   NEW1
;
	MOV  SI,OFFSET HLRET	;Zeile wieder zurueckschieben, falls FLAG2
	CALL PRSTRING		;gesetzt war (Zwischenzeile gedruckt)
;
   NEW1:MOV  SI,OFFSET LLF    ;Urspruengl. Zeilenabstand wieder einstellen 
	CALL PRSTRING
	CALL BIDIR		;allenfalls wieder bidirektionaler Druck
	MOV  AL,CR
	CALL PRINTX
;
	OR   CRLF,0		;Soll ein LF gesendet werden ?
	JZ   NEW2
	MOV  AL,LF
	CALL PRINTX
	MOV  AL,CR
	CALL PRINTX
;
   NEW2:XOR  AX,AX		;NEW2 wird auch von REINIT aufgerufen
	MOV  BP,AX
	MOV  COUNT,AX
	MOV  WORD PTR HEXCHR,AX
	MOV  FLAG1,AL
	MOV  FLAG2,AL
	MOV  CRLF,AL
	RET			;AH = 0 ... Drucken war in Ordnung !
;
PAGE
;
;*SO******************************************
;*****   S O N D E R   R O U T I N E N   *****
;*********************************************
;
;
UNIDIR:				;Eine Zeile unidirektional drucken
	MOV FLAG1,0FFh		;FLAG1 setzen
	PUSH SI
	MOV  SI,OFFSET UNIMODE	;= Anzahl der String-Bytes
	CALL PRSTRING
	POP  SI
	RET
;
BIDIR:	OR   FLAG1,0		;War eine Zeile unidirektional zu drucken ?
	JZ   BID2
	MOV  FLAG1,0
	PUSH SI
	MOV  SI,OFFSET BIDMODE	;Wieder bidirektionalen Druck einstellen
	CALL PRSTRING
	POP  SI
   BID2:RET
;
;
PROP1:				;Proportionalschrift EIN/AUS
	CALL NEXT		;Naechstes Zeichen lesen
	TEST AL,01h		;Bit 0 gesetzt ? ...
	JNZ  PROP0
	MOV  FLAG3,0FFh		;...wenn ja --> FLAG3 setzen, Prop. Mode
	PUSH SI
	MOV  SI,OFFSET PROPMODE
	CALL PRSTRING
	POP  SI
	RET
;
  PROP0:OR   FLAG3,0
	JZ   PRO2
	PUSH SI
	MOV  SI,OFFSET LCHR	;wenn FLAG3 gesetzt, dann wieder in 
	CALL PRSTRING		;NORMAL Mode zurueckschalten
	POP  SI
	MOV  FLAG3,0
   PRO2:RET
;
;
CONDEX:				;CONDensed Print Mode EX. Normales Charakter-
	PUSH SI			;Set wiederherstellen
	MOV  SI,OFFSET LCHR
	CALL PRSTRING
	POP  SI
	RET
;
;
SDBITGR:		;SINGLE DENSITY BIT IMAGE GRAPHIK (80 Dots/Zoll)
;
	PUSH SI
	MOV  SI,OFFSET SDBIM
	CALL PRSTRING
	JMP SHORT BIT2
;
DDBITGR:		;DOUBLE DENSITY BIT IMAGE GRAPHIK (160 Dots/Zoll)
;
	PUSH SI
	MOV  SI,OFFSET DDBIM
	CALL PRSTRING
;
   BIT2:PUSH CX
	CALL NEXT		;Naechstes Zeichen einlesen
	MOV  HEXCHR,AL		;Lower Byte
	CALL NEXT
	MOV  HEXCHR+1,AL	;Higher Byte
;
	CALL HEXDIG4		;HEX in ASCII wandeln 
	MOV  SI,OFFSET DIGIT
	CALL PRSTRING
;
	MOV  CX,WORD PTR HEXCHR	;= Anzahl der folgenden Graphik-Bytes
	TEST FLAG2,80h		;FLAG2 = FFh ... Abarbeiten der Zwischenzeile!
	JNZ  BIT5
;
   BIT3:CALL NEXT
	CALL PIXEL		;Bitmuster fuer ITOH auf den Kopf stellen
	CALL PRINTX
	LOOP BIT3
;
   BIT4:OR   FLAG3,0		;FLAG3 gesetzt = Proportional Mode ?
	JNZ  BIT6		;wenn NOT ZERO, dann weiterhin Proportional Mode
	MOV  SI,OFFSET LCHR	;andernfalls letztes Charakterset wiederherstellen
	CALL PRSTRING
	POP  CX
	POP  SI
	RET
;
   BIT5:CALL NEXT
	MOV  AL,0		;Damit bei gemischtem Text + Graphik nicht
	CALL PRINTX		;in die Zwischenzeile gedruckt wird
	LOOP BIT5
	JMP  BIT4
;
   BIT6:MOV  SI,OFFSET PROPMODE ;Proportionalmode allenfalls wiederherstellen
	CALL PRSTRING
	POP  CX
	POP  SI
	RET
;
;
HEXDIG4:			;Wandelt 2 Bytes HEX in 4 DIGIT ASCII um 
	PUSH SI			;HEX Zahl wird aus HEXCHR entnommen
	PUSH BX			;Ergebnis abgelegt in DIGIT (1.Byte = Laenge!)
	PUSH CX
	MOV  CX,WORD PTR HEXCHR 
	MOV  DIGIT,4		;Gueltige Laenge in DIGIT = 4 Bytes
	MOV  SI,1
;
	MOV  BX,1000		;Tausenderstelle ermitteln
	CALL ASCII
	MOV  [DIGIT+SI],AL
	INC  SI
;
    HE3:MOV  BX,100		;Hunderterstelle
	CALL ASCII
	MOV  [DIGIT+SI],AL
	INC  SI
;
    HE2:MOV  BX,10		;Zehnerstelle
	CALL ASCII
	MOV  [DIGIT+SI],AL
	INC  SI
;
	MOV  AL,CL		;Rest < 10 ist noch in CL
	ADD  AL,30h		;HEX 0...9 --> ASCII 30...39
	MOV  [DIGIT+SI],AL
	POP  CX
	POP  BX
	POP  SI
	RET

HEXDIG2:			;Wandelt 1 Byte HEX in 2 DIGIT ASCII um
	PUSH SI			;HEX-Zahl wird aus HEXCHR entnommen
	PUSH BX			;Ergebnis abgelegt in DIGIT (1.Byte = Laenge)
	PUSH CX
	MOV  CX,WORD PTR HEXCHR 
	MOV  DIGIT,2		;Gueltige Laenge in DIGIT = 2 Bytes
	MOV  SI,1
	JMP  HE2
;
HEXDIG3:			;Wandelt 1 Byte HEX in 3 DIGIT ASCII um
	PUSH SI			;HEX-Zahl wird aus HEXCHR entnommen
	PUSH BX			;Ergebnis abgelegt in DIGIT (1.Byte = Laenge)
	PUSH CX
	MOV  CX,WORD PTR HEXCHR 
	MOV  DIGIT,3		;Gueltige Laenge in DIGIT = 3 Bytes
	MOV  SI,1
	JMP  HE3
;
;
;
ASCII:			;Aufruf: HEX-Zahl in CX, DEZ-Zahl in BX
			;Rueckgabe: ASCII-DIGIT in AL
	MOV  AL,0	;AL zunaechst auf 0 setzen
   ASC2:SUB  CX,BX	;Dezimalwert vom HEX-Wert einmal subtrahieren
	JC   ASC4
	ADD  AL,1	;wenn noch kein CARRY aufgetreten, AL um 1 erhoehen
	JMP  ASC2
;
   ASC4:ADD  CX,BX	;weil bei CARRY bereits einmal zuviel subtrahirert wurde
	ADD  AL,30h	;HEX 0...9 --> ASCII 30...39
	RET
;
;
PIXEL:			;ITOH steuert die Nadeln genau umgekehrt an, wie IBM/EPSON
			;Bit 0 = oberste Nadel ! Byte in AL ergibt kopfgestelltes
	PUSH CX		;Bitmuster in AL retour
	MOV  CX,8
   PIX2:RCL  AL,1	; 
	RCR  AH,1	;      AL 
	LOOP PIX2	; CF<76543210< RCL AL,1   8 mal
;			        
	XCHG AL,AH
	POP  CX		; 
	RET		;      AH 
			; CF>01234567> RCR AH,1   8 mal
			;       
;

LFREV:				;Executes (n/216) NN/144 Zoll reverse line feed
	PUSH SI
	MOV  SI,OFFSET REVERS
	CALL PRSTRING
	CALL LFEXE
	MOV  SI,OFFSET FORWARD
	CALL PRSTRING
	POP  SI
	RET
;
;
LFEXE:				;Executes (n/216) NN/144 Zoll forward line feed
	CALL CONVERT
	PUSH SI
	MOV  SI,OFFSET INCMODE	;Incremental Print Mode einstellen, weil ITOH
	CALL PRSTRING		;sonst LF innerhalb einer Zeile ignoriert !
	MOV  AL,LF
	CALL PRINTX
	MOV  SI,OFFSET LOGMODE	;Wieder in den Logic Seek Mode zurueckschalten
	CALL PRSTRING
	POP  SI
	RET
;
;
LF216:				;Rechnet n/216 Zoll line feed in NN/144 Zoll um, schaltet
	CALL CONVERT		;Drucker in den neuen Zeilenabstand und kopiert nach LLF
    LF4:PUSH BX
	PUSH SI
	MOV  BX,OFFSET LLF
	MOV  BYTE PTR [BX],4		;Laenge der Sequenz (ist bekannt!)
	INC  BX
	MOV  SI,OFFSET LF144
	CALL MSTORE
	MOV  SI,OFFSET DIGIT
	CALL MSTORE
	POP  SI
	POP  BX
	RET
;
;
MSTORE: PUSH AX			;MULTISTORE, reiht mehrere Sequenzen aneinander
	PUSH CX			;Quellstring durch SI (= Laenge der Sequenz),
	XOR  CX,CX		;Ziel durch BX adressiert. Die Laenge des ueber-
	MOV  CL,[SI]		;tragenen Strings wird in DL zurueckgegeben
	PUSH CX			;*** LAENGE der einzelnen Sequenz wird nicht
	POP  DX			;mituebertragen !!! ***
	INC  SI
    LF2:MOV  AL,[SI]
	MOV  [BX],AL
	INC  BX
	INC  SI
	LOOP LF2
	POP  CX
	POP  AX
	RET
;
;
CONVERT:		;Rechnet n/216 Zoll (1 Byte HEX) in NN/144 Zoll
			;(2 Digit ASCII) um und speichert Ergebnis in
	PUSH CX		;HEXCHR (HEX) und DIGIT (ASCII)
	CALL NEXT	
	MOV  HEXCHR,AL		;naechstes Zeichen holen und speichern
	MOV  HEXCHR+1,0		;sicherheitshalber, falls nicht rueckgesetzt
	MOV  CX,WORD PTR HEXCHR 
	XOR  AX,AX		;			 CX	AX     AX
	CMP  CX,0		;       KONVERTIERUNG:	       SOLL    IST
	JZ   CON5		;			n/216  n/144  n/144
				;			
   CON4:ADD  AX,1		;			  1	0,67	1
	DEC  CX			;			  2	1,33	1
	JZ   CON5		;			  3	2,0	2
	DEC  CX			;			  4	2,67	3
	JZ   CON5		;			  5	3,33	3
	ADD  AX,1		;			  6	4,0	4
	LOOP CON4		;			  7	4,67	5
   CON5:POP  CX			;			  8	5,33	5
   CON6:CMP  AX,100	;Itoh kann nur max. n=99	  9	6,0	6
	JC   CON7	;ab n=100 kein Carry !		 10	6,67	7
	MOV  AX,99	;auf Maximum = 99 setzen	 11	7,33	7
   CON7:MOV WORD PTR HEXCHR,AX	;zurueckschreiben	 12	8,0	8
;							 13	8,67	9
;
	CALL HEXDIG2		;Umwandeln und speichern
	PUSH SI
	MOV  SI,OFFSET LF144	;Sequenzen zum Drucker senden
	CALL PRSTRING
	MOV  SI,OFFSET DIGIT
	CALL PRSTRING
	POP  SI
	RET
;
;
LF72:			;Wandelt n/72 line feed in NN/144 um
	CALL NEXT	;naechstes Zeichen holen
	SHL  AL,1	;1 x logisch n. links schieben = AL m. 2 multiplizieren
	MOV  AH,0
	CALL CON6	;Umwandeln, speichern und zum Drucker senden
	CALL LF4	;Kombinierte Sequenz in LLF speichern
	RET
;
;
SEITE:			;ESC C setzt Seitenlaenge in Zeilen oder Zoll. 
			;Bei ITOH nur mit DIP - Switch mglich !!
	CALL NEXT
	CMP  AL,"0"	;ist nchstes Zeichen 0 ?
	JE   SEIT2
	RET    		;wenn nicht 0 --> dieses Zeichen ignorieren
;
  SEIT2:CALL NEXT	;wenn 0, dann dieses und das naechste Zeichen
	RET		;ignorieren !
;
;
LEFTM:			;Wandelt 1 Byte HEX in 3 Digit ASCII um und
			;setzt linken Rand des Druckers
	CALL NEXT
	MOV  AH,0		;sicherheitshalber
	MOV  WORD PTR HEXCHR,AX
	CALL HEXDIG3		;umwandeln und speichern
	MOV  SI,OFFSET SLM	;Sequenzen zum Drucker senden
	CALL PRSTRING
	MOV  SI,OFFSET DIGIT
	CALL PRSTRING
	RET
;
;

ERROR:
	MOV  ERR3,AL		;= 2.Byte der ESC-Sequenz
	MOV  DX,OFFSET ERR1
	CALL DISPLAY
	MOV  DX,OFFSET ERR2
	CALL DISPLAY
	MOV  AH,1		;AH = 1 ...Druckerfehler (timeout)
	RET
;
RESET:			  ;RESET von PRINTER und TREIBER - ROUTINE
;
	MOV  SI,OFFSET PRINIT	;PRINTER - RESET ausfuehren
	CALL PRSTRING
;
	MOV BX,OFFSET GET0 ;Ruecksprungadresse in BX uebergeben
;
REINIT:			  ;Routine zur RE-INITIALISIERUNG
			  ;AUFRUF mit CALL oder JUMP! Wegen der STACK-
			  ;Manipulation muss Ruecksprungadresse, bzw.
			  ;Adresse der nach REINIT auszufuehrenden
			  ;Befehle in BX uebergeben werden !
;
	CLI		  ;Interrupts sperren
	MOV  AX,OFFSET STAPEL+255 ;Stackpointer laden
	MOV  SP,AX
	STI		  ;Interrupts wieder zulassen
;
	MOV  AX,OFFSET A2 ;EINSPRUNGADRESSE B1 AUF STACK ABLEGEN,	
	PUSH AX		  ;DAMIT NACH "STACK-TAUSCH" AUS "PUT" 
			  ;MIT RETURN NACH A2 GESPRUNGEN WERDEN KANN
;
	XOR  BP,BP		;*** STACK - AUFBEREITUNG ***
	PUSH BP			;nach PUT --> SI
	PUSH BP			;nach PUT --> BP
	PUSH BP			;nach PUT --> BX
	PUSH BP			;nach PUT --> CX
;
	MOV  UPSS,SS	;STAPELSEGMENT UND STACKPOINTER DES UNTER-
	MOV  UPSP,SP	;PROGRAMMES ABSPEICHERN. 
;
	PUSH BX		;Ruecksprungadresse war in BX aufgehoben, nun
			;am STACK ablegen, damit nach STACK-Aufbe-
			;reitung mit RET zur folgenden Routine
			;gesprungen werden kann ! (GET oder INIT8)
;
;
	MOV  BX,OFFSET LLF	;Speicher fuer LAST LINE FEED
	MOV  SI,OFFSET SLF-2	;Standard Line-feed
	CALL STORE
	MOV  BX,OFFSET LCHR	;Speicher fuer LAST CHARAKTER SET
	MOV  SI,OFFSET SCHR-2	;Standard Charakter Set
	CALL STORE
;
	CALL NEW2		;Zaehler und FLAGS ruecksetzen
	MOV  FLAG3,AL		;Auch FLAG3 ruecksetzen, AX = 0 von NEW2 !
	MOV  FLAG4,AL		;ebenso FLAG4
;
	RET
;
;
DISPLAY:
	MOV  AH,09h               ;Meldung ausgeben, DS:DX zeigt auf Beginn des
	INT  21h      		  ;Textes, dieser ist mit $ abgeschlossen !!
	RET

;
ERR1	DB  CR,LF,LF,"************* ACHTUNG  FEHLER *************",CR,LF,LF,"$"
;
ERR2	DB  "***** SEQUENZ *ESC "
;
ERR3	DB  0,"* NICHT IMPLEMENTIERT !!! *****",CR,LF,LF,"$"

;
;
START   ENDP
;
PAGE
;
;*I****************************************************************************
	;*********************************;
	;    PROGRAMM-INITIALISIERUNG     ;
	;				  ;
	;** ROUTINE BEREITS RESIDENT ?    ;
	;   EINGABE "J" = ENTFERNEN       ;
	;** VEKTOR VON INT 17h AENDERN    ;
	;** RUECKSPRUNGADRESSEN AM STAPEL ;
	;   ABLEGEN			  ;
	;** ERFOLGSMELDUNG AUSGEBEN       ;
	;				  ;
	;** BEENDEN ABER RESIDENT BLEIBEN ;
	;				  ;
	;*********************************;
;
;
;
;
INIT1:	MOV  AH,35h	;DOS-Fktn. 35h = Unterbrechungsvektor
	MOV  AL,17h	;des INT 17h (PRINTER I/O)) feststellen
	INT  21h	;DOS-Interrupt    (Rueckgabe in ES:BX)
;
	MOV  AX,WORD PTR ES:TESTFLAG  ;Wenn bereits im Speicher
	MOV  DX,WORD PTR CS:TESTFLAG  ;Nunmehriger Progr.Aufruf
	CMP  AX,DX
	JE   INIT3	;wenn EQUAL, bereits resident, andernfalls...
;
	MOV  VEKTOR,BX	   ;...alten Interrupt-Vektor sichern
	MOV  VEKTOR+2,ES
;
	PUSH ES		;ES:BX ---> DS:DX  umschaufeln
	PUSH BX		;vorerst am Stack aufheben
;
	MOV  AH,35h	;Feststellen ob NEUINT nicht schon von 
	MOV  AL,NEUINT	;anderen Programmen verwendet
	INT  21h	;VEKTOR in ES:BX muss 0 sein !
	OR   BX,BX
	JNZ  INIT2
	MOV  BX,ES
	OR   BX,BX
	JNZ  INIT2	;Falls belegt ---> Fehlermeldung
;
	MOV  AL,NEUINT
	MOV  BYTE PTR PR1+1,AL   ;NEUINT-Nr bei PRINT eintragen! 
;
	POP  DX		;Alten Interrupt-Vektor (ES:BX am Stack)
	POP  DS   	; = BIOS-PRINTER-ROUTINE INT 17h auf 
	MOV  AH,25h	;NEUINT (DS:DX vom Stack) umleiten
	INT  21h
;
	PUSH CS
	POP  DS		;DS wieder richtig stellen 
;
	MOV  DX,OFFSET START ;Neuen Vektor in (DS:DX = START-
	MOV  AH,25h	     ;Adresse des Treibers) ueber DOS-
	MOV  AL,17h          ;Fktn. 25h auf INT 17h ersetzen
	INT  21h	     ;DOS-Interrupt
;
	MOV  AX,CS:[2Ch]		;Environment Adresse sichern
	MOV  ENVIRADR,AX
;
	MOV  BX,OFFSET INIT8 ;Ruecksprungadresse von REINIT vorerst
			     ;in BX sichern, weil mit JMP zu REINIT
			     ;hingesprungen wird, aber von dort mit
			     ;RET nach INIT8 zurueck !
	JMP  REINIT
;
;
;
 INIT2: MOV  DX,OFFSET ERR1	;ERROR-MELDUNG
	CALL DISPLAY
	MOV  DX,OFFSET M6 	;NEUINT BEREITS VERWENDET
	CALL DISPLAY		;STACK - Korrektur nicht erforderlich, weil
				;Programm ohnedies beendet wird !
	MOV  AH,4Ch	;Programm beenden
	INT  21h
;
;
INIT3:  MOV  AX,WORD PTR ES:PRNUMMER
	ADD  AL,31h
	MOV  BYTE PTR PRN,AL	;fuer korrekte Meldung
	MOV  DX,OFFSET M1
	CALL DISPLAY		;Installationsmeldung ausgeben
	MOV  DX,OFFSET M2
	CALL DISPLAY		;Loeschen ? Speicher frei machen ?
	MOV  AH,01h		; = Tastatureingabe mit Echo
	INT  21h		;DOS-Interrupt
	CMP  AL,4Ah		; = J
	JZ   INIT4
	CMP  AL,6Ah		; = j
	JZ   INIT4
	MOV  DX,OFFSET M1
	CALL DISPLAY
	MOV  AH,4Ch	;Programm beenden
	INT  21h
;
 INIT4: MOV  DX,ES:VEKTOR    ;Urspruenglichen PRINTER-INTERRUPT-VEKTOR
	MOV  DS,ES:VEKTOR+2  ;nach DS:DX laden und ueber DOS-Fktn 25h
	MOV  AH,25h	     ;nach INT 17h zurueckschreiben
	MOV  AL,17h
	INT  21h
;
	XOR  DX,DX	;Auch VEKTOR von NEUINT wieder auf 0 setzen!
	MOV  DS,DX
	MOV  AH,25h
	MOV  AL,ES:NEUINT
	INT  21h
;
	MOV  AH,49h	;Speicher (Code Block) wieder frei machen. Bei 
	INT  21h	;Rueckgabe CARRY FLAG GESETZT (CY=1) = FEHLER !
	PUSH CS
	POP  DS		;DS wieder richtigstellen
	JC   INIT5
;
	MOV  ES,ES:ENVIRADR	;Environment Block wieder frei machen
	MOV  AH,49h
	INT  21h
	JC   INIT5
;
	MOV DX,OFFSET M3 	;Programm aus dem Speicher entfernt
	JMP INIT6
;
  INIT5:MOV  DX,OFFSET ERR1	;ERROR-MELDUNG
	CALL DISPLAY
	MOV  DX,OFFSET M5 	;SYSTEM NEU BOOTEN
  INIT6:CALL DISPLAY
;
	MOV  AH,4Ch	;Programm beenden
	INT  21h
;
;
INIT8:		;**** NORMALE  INITIALISIERUNG ****
		;****  OFFSET - ADRESSEN  DER  ****
		;**** SONDERROUTINEN EINTRAGEN ****
;
	MOV  AX,OFFSET ERROR		;Adressen der SONDERROUTINEN 
	MOV  WORD PTR [ESC26h+3],AX	;in die Eintraege der table 
	MOV  WORD PTR [ESC2Ah+3],AX	;einsetzen
	MOV  WORD PTR [ESCB+3],AX
	MOV  WORD PTR [ESCD+3],AX
	MOV  WORD PTR [ESC5Eh+3],AX
	MOV  WORD PTR [ESC_b+3],AX
;
	MOV  AX,OFFSET UNIDIR
	MOV  WORD PTR [ESC3Ch+3],AX
;
	MOV  AX,OFFSET RESET
	MOV  WORD PTR [ESC40h+3],AX
;
	MOV  AX,OFFSET SDBITGR
	MOV  WORD PTR [ESCK+3],AX
;
	MOV  AX,OFFSET DDBITGR
	MOV  WORD PTR [ESCL+3],AX
	MOV  WORD PTR [ESCY+3],AX
	MOV  WORD PTR [ESCZ+3],AX
;
	MOV  AX,OFFSET A5		;Achtbit - Routine
	MOV  WORD PTR [CTLA+3],AX
	MOV  WORD PTR [CTLB+3],AX
	MOV  WORD PTR [CTLC+3],AX
	MOV  WORD PTR [CTLD+3],AX
	MOV  WORD PTR [CTLE+3],AX
	MOV  WORD PTR [CTLF+3],AX
	MOV  WORD PTR [CTLU+3],AX
;
	MOV  AX,OFFSET LF216
	MOV  WORD PTR [ESC3+3],AX
;
	MOV  AX,OFFSET LF72
	MOV  WORD PTR [ESCA+3],AX
;
	MOV  AX,OFFSET LFEXE
	MOV  WORD PTR [ESCJ+3],AX
;
	MOV  AX,OFFSET LFREV
	MOV  WORD PTR [ESC_j+3],AX
;
	MOV  AX,OFFSET LEFTM
	MOV  WORD PTR [ESC_l+3],AX
;
	MOV  AX,OFFSET SEITE
	MOV  WORD PTR [ESCC+3],AX
;
	MOV  AX,OFFSET CONDEX
	MOV  WORD PTR [CTLR+3],AX
;
;	***** ENDE DER ADRESS - INITIIERUNG *****
;
	MOV  AL,BYTE PTR PRNUMMER
	ADD  AL,31h
	MOV  PRN,AL
;
;
	MOV  DX,OFFSET M1	;Installationsmeldung
	CALL DISPLAY
;
	MOV  DX,OFFSET INIT1	;FESTSTELLEN DER ERSTEN FREIEN ADRESSE 
;				;DES PROGRAMMS, DAMIT PROGRAMMLAENGE BEKANNT
;				;BEENDEN, ABER IM SPEICHER RESIDENT BLEIBEN
				;(INIT-Routine wird nicht mehr benoetigt)

	MOV  CL,4
	SHR  DX,CL
	INC  DX
	MOV  AH,31h
	INT  21h
;
M1	   DB  CR,LF,LF,"*** ITOH-DRUCKER-TREIBER  V 1.0 - SYRO/TGM-N 1986 ***"
	   DB  CR,LF,LF,"*** FUER  PARALLEL - PRINTER  LPT "
     PRN   DB  0,"  INSTALLIERT  ***",CR,LF,LF,"$"
;
M2   	   DB  CR,LF,LF,"SOLL PROGRAMM AUS DEM SPEICHER ENTFERNT"
	   DB  " WERDEN ?  J/N :  $"
;
M3   	   DB  CR,LF,LF,"*** ITOH-DRUCKER-TREIBER AUS DEM SPEICHER"
	   DB  " ENTFERNT ***",CR,LF,LF,"$"
;
M5   	   DB  "* SPEICHER KANN NICHT FREI GEMACHT WERDEN *",CR,LF,LF
	   DB  "********** SYSTEM NEU BOOTEN !!! **********",CR,LF,LF,"$"
;
M6   	   DB  "* NEUER INTERRUPT BEREITS VERWENDET !!! NEUINT AENDERN !!!*"
	   DB  CR,LF,LF,"$"
;
ENDE	   DW  0
;
INIT	ENDP
;
;
CSEG	ENDS
;
END	INIT

