program ht_model    {HOLLING-TANNER/LESLIE-GOWER};

type ee                       = record
                                  a,b,h,k,l,n,p,r,s  : real;
                                  tmax           : integer;
                                end;

{$I INCFILE.INC}


function deltan(p,n:real):real;

begin
  deltan:=e.r*n*(1-n/e.k)-e.a*p*n/(e.l+n);
end;


function deltap(p,n:real):real;

begin
  deltap:=e.s*p*(1-p/(e.b*n));
end;


procedure int;

begin
  k1:=deltan(p,n);
  l1:=deltap(p,n);
  k2:=deltan(p+l1/2,n+k1/2);
  l2:=deltap(p+l1/2,n+k1/2);
  k3:=deltan(p+l2/2,n+k2/2);
  l3:=deltap(p+l2/2,n+k2/2);
  k4:=deltan(p+l3,n+k3);
  l4:=deltap(p+l3,n+k3);
  p:=p+h*(l1+2*l2+2*l3+l4)/6;
  n:=n+h*(k1+2*k2+2*k3+k4)/6;
  if p < 0 then
    p:=0;
  if n < 0 then
    n:=0;
end;


procedure ein;

  procedure werte;

  begin
    window(1,5,30,16);
    clrscr;
    writeln('SCHRITTWEITE = ',h:1:4);
    writeln('T-END        = ',tmax:4);
    if b then
      writeln('BILD         = Punkte')
    else
      writeln('BILD         = Streifen');
    writeln('Po           = ',p:4:0);
    writeln('No           = ',n:4:0);
    writeln('K            = ',e.k:4:0);
    writeln('k            = ',e.l:4:0);
    writeln('a            = ',e.a:2:3);
    writeln('r            = ',e.r:2:3);
    writeln('s            = ',e.s:2:3);
    writeln(chr(224),'            = ',e.b:2:3);
    window(1,17,80,21);
  end;

begin
  clrscr;
  p:=e.p;
  n:=e.n;
  h:=e.h;
  tmax:=e.tmax;
  writeln('KERBL-SCHLUDERBACHER                           (C) 1986  ver. 1.0':72);
  writeln;
  writeln('************HOLLING-TANNER AND LESLIE-GOWER - SYSTEM*************':72);
  repeat
    werte;
    clrscr;
    writeln('(P)o,(N)o,(K),(k),(r),(a),(s),(A)lpha');
    write('(B)ILD,(S)CHRITTWEITE,(T)END,<ENTER> oder <ESC> :');
    read(kbd,c);
    writeln;
    case c of
      'a':begin
            write('a : ');
            readln(e.a);
          end;
      'A':begin
            write(chr(224),' : ');
            readln(e.b);
          end;
      'B':b:=not b;
      'k':begin
            write('k : ');
            readln(e.l);
          end;
      'K':begin
            write('K : ');
            readln(e.k);
          end;
      'N':begin
            repeat
              write('No : ');
              readln(n);
            until n > 0;
          end;
      'P':begin
            repeat
              write('Po : ');
              readln(p);
            until p > 0;
          end;
      'r':begin
            write('r : ');
            readln(e.r);
          end;
      's':begin
            write('s : ');
            readln(e.s);
          end;
      'S':begin
            repeat
              write('SCHRITTWEITE  H = TEND/(640*L) , L = ',l,' , L = 1..',lmax,' : ');
              readln(l);
            until (0<l) and (l<lmax+1);
            j:=640*l;
            h:=tmax/j;
          end;
      'T':begin
            repeat
              write('T-END ( 0 < TMAX < ',dim+1,' !!): ');
              readln(tmax);
            until (tmax>0) and (tmax<dim+1);
            h:=tmax/640;
            j:=640;
            writeln('SCHRITTWEITE WURDE AUF ',h:1:4,' GESETZT');
            delay(3000);
          end;
    end;
  until (c=^M) or (c=^[);
  e.p:=p;
  e.n:=n;
  e.h:=h;
  e.tmax:=tmax;
  window(1,1,80,25);
end;


begin
  b:=true;
  l:=1;
  j:=640;
  lmax:=dim div 640;
  e.tmax:=200{400};
  e.a:=1;
  e.b:=0.5{0.45};
  e.k:=900{1000};
  e.l:=200;
  e.n:=25{60};
  e.p:=5{10};
  e.r:=0.4{0.3};
  e.s:=0.1{0.03};
  e.h:=e.tmax/j;
  repeat
    ein;
    if c<>^[ then
    begin
      aus1;
      for i:=1 to j-1 do
      begin
        ar[1,i]:=p;
        ar[2,i]:=n;
        write('*');
        int;
      end;
      aus2;
      if c<>^[ then
        read(kbd,c);
    end;
  until c = ^[;
  textmode;
  gotoxy(32,13);
  write('PROGRAM BEENDET');
  gotoxy(1,24);
end.
