program on_model         {O'NEILL-MODELL};

type ee                       = record
                                  a,b,d,h,n,p,r,s  : real;
                                  tmax             : integer;
                                end;

{$I INCFILE.INC}


function deltan(p,n:real):real;

begin
  deltan:=e.r*n-e.b*n*p;
end;


function deltap(p,n:real):real;

begin
  deltap:=e.a*e.s*p*n/(p+n)-e.d*p;
end;


procedure int;

begin
  k1:=deltan(p,n);
  l1:=deltap(p,n);
  k2:=deltan(p+l1/2,n+k1/2);
  l2:=deltap(p+l1/2,n+k1/2);
  k3:=deltan(p+l2/2,n+k2/2);
  l3:=deltap(p+l2/2,n+k2/2);
  k4:=deltan(p+l3,n+k3);
  l4:=deltap(p+l3,n+k3);
  p:=p+h*(l1+2*l2+2*l3+l4)/6;
  n:=n+h*(k1+2*k2+2*k3+k4)/6;
  if p < 0 then
    p:=0;
  if n < 0 then
    n:=0;
end;


procedure ein;

  procedure werte;

  begin
    window(1,5,30,16);
    clrscr;
    writeln('SCHRITTWEITE = ',h:1:4);
    writeln('T-END        = ',tmax:4);
    if b then
      writeln('BILD         = Punkte')
    else
      writeln('BILD         = Streifen');
    writeln('Po           = ',p:4:0);
    writeln('No           = ',n:4:0);
    writeln('p            = ',e.b:2:3);
    writeln('d            = ',e.d:2:3);
    writeln('r            = ',e.r:2:3);
    writeln('s            = ',e.s:2:3);
    writeln(chr(224),'            = ',e.a:2:3);
    window(1,17,80,21);
  end;

begin
  clrscr;
  p:=e.p;
  n:=e.n;
  h:=e.h;
  tmax:=e.tmax;
  writeln('KERBL-SCHLUDERBACHER                           (C) 1986  ver. 1.0':72);
  writeln;
  writeln('******************O''NEILL-RAEUBER-BEUTE-SYSTEM*******************':72);
  repeat
    werte;
    clrscr;
    writeln('(P)o,(N)o,(r),(p),(d),(s),(a)lfa');
    write('(B)ILD,(S)CHRITTWEITE,(T)END,<ENTER> oder <ESC> :');
    read(kbd,c);
    writeln(c);
    case c of
      'a':begin
            write(chr(224),' : ');
            readln(e.a);
          end;
      'B':b:=not b;
      'd':begin
            write('d : ');
            readln(e.d);
          end;
      'N':begin
            repeat
              write('No : ');
              readln(n);
            until n > 0;
          end;
      'p':begin
            write('p : ');
            readln(e.b);
          end;
      'P':begin
            repeat
              write('Po : ');
              readln(p);
            until p > 0;
          end;
      'r':begin
            write('r : ');
            readln(e.r);
          end;
      's':begin
            write('s : ');
            readln(e.s);
          end;
      'S':begin
            repeat
              write('SCHRITTWEITE  H = TEND/(640*L) , L = ',l,' , L = 1..',lmax,' : ');
              readln(l);
            until (0<l) and (l<lmax+1);
            j:=640*l;
            h:=tmax/j;
          end;
      'T':begin
            repeat
              write('T-END ( 0 < TMAX < ',dim+1,' !!): ');
              readln(tmax);
            until (tmax>0) and (tmax<dim+1);
            h:=tmax/640;
            j:=640;
            writeln('SCHRITTWEITE WURDE AUF ',h:1:4,' GESETZT');
            delay(3000);
          end;
    end;
  until (c=^M) or (c=^[);
  e.p:=p;
  e.n:=n;
  e.h:=h;
  e.tmax:=tmax;
  window(1,1,80,25);
end;


begin
  b:=true;
  l:=1;
  j:=640;
  lmax:=dim div 640;
  e.tmax:=640;
  e.a:=0.1;
  e.b:=0.002;
  e.d:=0.2;
  e.n:=1500;
  e.p:=50;
  e.r:=0.1;
  e.s:=2.09;
  e.h:=e.tmax/j;
  repeat
    ein;
    if c<>^[ then
    begin
      aus1;
      for i:=1 to j-1 do
      begin
        ar[1,i]:=p;
        ar[2,i]:=n;
        write('*');
        int;
      end;
      aus2;
      if c<>^[ then
        read(kbd,c);
    end;
  until c = ^[;
  textmode;
  gotoxy(32,13);
  write('PROGRAM BEENDET');
  gotoxy(1,24);
end.
