{$C-U-}   { endlich cntrl_c ausschalten ... }
{XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXX                                                                   XXXXX
 XXXXX   M I T   D E R   B I T T E   Z U R   K E N N T N I S N A H M E : XXXXX
 XXXXX                                                                   XXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXX                                                                   XXXXX
 XXXXX   DIESES PROGRAMM WURDE AUSSCHLIESZLICH ZU LEHR-, LERN- UND       XXXXX
 XXXXX   DEMONSTRATIONSZWECKEN UND DAMIT ZUR VERANSCHAULICHUNG DES       XXXXX
 XXXXX   THEORETHISCHEN UNTERRRICHTS AM TGM ZUR VERFGUNG GESTELLT!!     XXXXX
 XXXXX                                                                   XXXXX
 XXXXX   DER QUELLCODE ODER AUCH NUR TEILE DARAUS DRFEN NUR ZUM         XXXXX
 XXXXX   PERSNLICHEN GEBRAUCH WEITERVERWENDET WERDEN!!                  XXXXX
 XXXXX                                                                   XXXXX
 XXXXX   TEILE DES PROGRAMMES (Z.B. DIE MENUPROCEDUR) SIND BEREITS       XXXXX
 XXXXX   FRHER FR KOMMERZIELLE PROGRAMME VON MIR ENTWORFEN WORDEN,     XXXXX
 XXXXX   UND SIND DAHER URHEBERRECHTLICH GESCHTZT!!                     XXXXX
 XXXXX   DER FFT-ALGORITHMUS IST FACHLITERATUR ENTNOMMEN UND DAHER       XXXXX
 XXXXX   WAHRSCHEINLICH AUCH GESCHTZT ...                               XXXXX
 XXXXX                                                                   XXXXX
 XXXXX   DIESER QUELLCODE IST BITTE NICHT WEITERZUGEBEN, SONDERN         XXXXX
 XXXXX   AUSSCHLIESZLICH BER MICH ZU BEZIEHEN UND WIRD DAHER AUCH NICHT XXXXX
 XXXXX   AUS OBIGEN GRNDEN DEM KLUB (pcc) ZUR VERFGUNG STEHEN!         XXXXX
 XXXXX                                                                   XXXXX
 XXXXX   FR EV. AUFTRETENDE FRAGEN STEHE ICH GERNE ZUR VERFGUNG ...    XXXXX
 XXXXX                                                                   XXXXX
 XXXXX              HERZLICHEN DANK FR IHR ENTGEGENKOMMEN,              XXXXX
 XXXXX                                                                   XXXXX
 XXXXX                                MICHAEL ZACHERL                    XXXXX
 XXXXX                                                                   XXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX}



program fft_main;

procedure graphics;                                   external 'a:GRAPH.BIN';
procedure hires;                                      external graphics[6];
procedure plot(x,y,color: integer);                   external graphics[21];
procedure draw(x1,y1,x2,y2,color: integer);           external graphics[24];

const nr_return    = 13;
      nr_backsp    = 08;
      nr_space     = 32;
      nr_low_a     = 97;
      nr_upp_a     = 65;
      nr_low_z     = 122;
      nr_upp_z     = 90;
      nr_cursor_up = 72;
      nr_cursor_dn = 80;
      nr_cursor_rt = 77;
      nr_cursor_lt = 75;

      pi = 3.14159628;      { Kreiszahl }
      x_max = 511;          { maximale x-Koordinate }
      y_max = 199;          { maximale y-Koordinate }
      x_min = 0;            { minimale x-Koordinate }
      y_min = 0;            { minimale y-Koordinate }
      amax = 512;
      y_pos1 = 155;
      y_pos2 = 80;

      checksum = 3219;

type complex = record re: real;
                      im: real;
               end;
     fftpoints = array [1..amax] of complex;
     lstring = string[80];

     signal_points = record sip: array [1..amax] of integer;
                            note: lstring;
                     end;
     calc_type = (nought, am, fm, noise, xtype_sig);

var i: integer;
    p: fftpoints;          { data array }
    si: signal_points;
    m, pkt, pn: integer;
    key: char;
    sel_item: integer;
    kb: file of char;
    author: string[70];
    calc_done: calc_type;

{*****************************************************************************}
procedure swap(var w1, w2: integer);

{Vertauscht w1 mit w2}

var wh: integer;

begin
    wh := w1;
    w1 := w2;
    w2 := wh;
end;
{*****************************************************************************}
procedure frame(x1, y1, x2, y2, attr: integer);
begin
    { x1, y1  +------------------+
              |                  |
              |     x1 < x2,     |
              |                  |
              |     y1 < y2      |
              |                  |
              +------------------+ x2, y2 }

     if x2 < x1 then swap(x1, x2);
     if y2 < y1 then swap(y1, y2);

     draw(x1, y1, x2, y1, attr);
     draw(x1, y1, x1, y2, attr);
     draw(x1, y2, x2, y2, attr);
     draw(x2, y1, x2, y2, attr);
end;
{*****************************************************************************}
procedure cursor(on: boolean);

{Schaltet Cursor ber BIOS ein und aus}


type regpack = record
                   ax, bx, cx, dx, bp, di, si, ds, es, flags : integer;
               end; { regpack }

var register: regpack;
    ah, ch, cl: byte;

begin
    ah := $01;   { INT Function }

    if on then
    begin { Cursor on }
        ch := $06;   { Sart Cursor Line }
        cl := $07;   { End Cursor Line }
    end else
    begin { Cursor off }
        ch := $0f;   { Sart Cursor Line }
        cl := $00;   { End Cursor Line }
    end;

    with register do
    begin
        ax := ah shl 8;
        cx := ch shl 8 + cl;
    end; { with register }

    intr ($10, register);

end;
{*****************************************************************************}
procedure upper_case(var str: lstring);

{Macht im String str aus kleinen groe Buchstaben (nona!)}

var n: integer;
begin
    for n := 1 to 80 do
    begin
        if str[n] in ['a'..'z'] then
            str[n] := chr(ord(str[n])-32);
    end;
end;
{*****************************************************************************}
procedure bell;

{Bellt ...}

var n:integer;

begin
    for n:= 1 to 5 do
    begin
        sound(440);
        delay(17);
        sound(554);
        delay(17);
        sound(659);
        delay(17);
        nosound;
    end;
end;
{*****************************************************************************}
procedure write_at(line, col: integer; str: lstring);

{Eh klar ...}

begin
    gotoxy(col, line);
    write(str);
end;
{*****************************************************************************}
procedure main_menu(var item: integer);

const anz_sel = 7;     {Wieviele Menpunkte ich brauche}

type sel_rec = record sel_txt: string[50];  {Was im Men steht und wo ...}
                        zeile: integer;
                       spalte: integer;
               end;

var cnt: integer;     {Aktueller Menpunkt}
    n: integer;
    sel_arr :array[1..anz_sel] of sel_rec;  {Das gesamte Men ... }

{++++++++++++++++++++++++++++++++++++++++++++}
procedure sel_forw;

{setzt den aktuellen Menpunkt um eines weiter ...}

begin
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(28));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);

    cnt := cnt + 1;
    if cnt > anz_sel then cnt := 1;
    { Neuer Fettdruck }
    highvideo;
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(16));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);
    lowvideo;
end;
{++++++++++++++++++++++++++++++++++++++++++++}
procedure sel_backw;

{setzt den aktuellen Menpunkt um eines zurck ...}

begin
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(28));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);

    cnt := cnt - 1;
    if cnt < 1 then cnt := anz_sel;
    { Neuer Fettdruck }
    highvideo;
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(16));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);
    lowvideo;
end;
{++++++++++++++++++++++++++++++++++++++++++++}
procedure mke_header;

{gibt die Bildschirmmaske aus ...}

var n: integer;
begin
    clrscr;

    cursor(false);
    highvideo;
    write_at(1,25,'FAST - FOURIER - ANALYSE   V 2.0');
    write_at(23,50,'Leertaste ...... selektieren');
    write_at(24,50,'Rckschritt .... selektieren');
    write_at(25,50,'Return  ........ aktivieren');
    lowvideo;
    write_at(3,20,author);

    for n := 1 to anz_sel do {Sel. Feld ausgeben}
    begin
        write_at(sel_arr[n].zeile, sel_arr[n].spalte - 2, chr(28));
        write_at(sel_arr[n].zeile, sel_arr[n].spalte, sel_arr[n].sel_txt);
    end;

    highvideo;
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(16));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);
    lowvideo;
end; {mke_header}
{++++++++++++++++++++++++++++++++++++++++++++}
procedure proceed;

{Menpunkt ist gewhlt ...}

begin
    item := cnt;
    lowvideo;
end;
{++++++++++++++++++++++++++++++++++++++++++++}
procedure search_item;

{Menanwahl per Anfangsbuchstabe}

var str:lstring;
    l_cnt: integer;
begin
    str[1] := key;
    upper_case(str);
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(28));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);

    l_cnt := 0;
    repeat
        l_cnt := l_cnt + 1;
        cnt := cnt + 1;
        if cnt > anz_sel then cnt := 1;
    until (str[1] = sel_arr[cnt].sel_txt[1]) or (l_cnt = anz_sel);
    if l_cnt = anz_sel then bell;

    highvideo;
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte - 2, chr(16));
    write_at(sel_arr[cnt].zeile, sel_arr[cnt].spalte, sel_arr[cnt].sel_txt);
    lowvideo;
end; {search_item}
{++++++++++++++++++++++++++++++++++++++++++++}
begin {main_menu}

    item := 0;
    cnt := 1;
    lowvideo;

    { begin init }

    {Belegung der Mentexte}

    sel_arr[1].sel_txt := 'Amplitudenmodulation';
    sel_arr[2].sel_txt := 'Frequenzmodulation';
    sel_arr[3].sel_txt := 'Zufllige Signale (Rauschen)';
    sel_arr[4].sel_txt := 'Laden eines Signales';
    sel_arr[5].sel_txt := 'Speichern eines Signales';
    sel_arr[6].sel_txt := 'Automode';
    sel_arr[7].sel_txt := 'Programmende';

    {Belegung der Schirmkoordinaten}

    sel_arr[1].zeile :=  6; sel_arr[1].spalte := 30;
    sel_arr[2].zeile :=  8; sel_arr[2].spalte := 30;
    sel_arr[3].zeile := 10; sel_arr[3].spalte := 30;
    sel_arr[4].zeile := 12; sel_arr[4].spalte := 30;
    sel_arr[5].zeile := 14; sel_arr[5].spalte := 30;
    sel_arr[6].zeile := 16; sel_arr[6].spalte := 30;
    sel_arr[7].zeile := 18; sel_arr[7].spalte := 30;



    mke_header;


    repeat
        read(kbd,key);
        case ord(key) of
             nr_return  : proceed;
             nr_backsp  : sel_backw;
             nr_space   : sel_forw;
             nr_low_a..nr_low_z, nr_upp_a..nr_upp_z : search_item;
        end; {case}
    until (item > 0) and (item < anz_sel + 1);
end; {main_menu}
{******************************************************************************}
function zweier_pot(zahl:integer):integer;

{Auch klar, oder?}

var i :integer;
    n :integer;
begin
    n := 1;
    if zahl > 0 then
        for i := 1 to zahl do
            n := n * 2;
    zweier_pot := n;
end;  {zweier_pot}
{******************************************************************************}
procedure fftsub (var p: fftpoints; n: integer; bkind: boolean);

{Die FFT: bergeben wird ein Array von 1 bis 512 v. komplexen Zahlen.
 Mit bkind wird die Transformationsrichtung angegeben ...}


label 1,2;

var kind: real;
    m0: integer;                      { Anzahl der Faltungsstellen }
    m: array [1..10] of integer;
    i, i0, i1, i2, i3, i4, i5: integer;
    f1, f2, f3, f4, f5: real;

begin {fftsub}
    kind := 2 * pi;
    if not bkind then kind := -kind;  { f(w) -> f(t) }

    m[n] := 1;                        { Faltungsstellenindex }
    for i := n - 1 downto 1 do m[i] := m[i + 1] * 2;

    for i0 := 1 to n do
    begin
        i1 := 0;
        m0 := m[i0];
        for i2 := 1 to m[n - i0 + 1] do
        begin
            f1 := i1;
            f2 := 2 * m[1];
            f3 := kind * f1 / f2;
            f4 := cos(f3);
            f5 := sin(f3);
            i3 := 2 * m0 * (i2 - 1);
            for i := 1 to m0 do
            begin
                i4 := i3 + i;
                i5 := i4 + m0;
                f3 := p[i5].re * f4 - p[i5].im * f5;
                f1 := p[i5].im * f4 + p[i5].re * f5;
                p[i5].re := p[i4].re - f3;
                p[i5].im := p[i4].im - f1;
                p[i4].re := p[i4].re + f3;
                p[i4].im := p[i4].im + f1;
            end;
            for i := 2 to n do
            begin
                i5 := i;
                if i1 < m[i] then goto 1;
                i1 := i1 - m[i];
            end;
{L} 1:      i1 := i1 + m[i5];
        end;
    end;
    i1 := 0;
    for i4 := 1 to 2 * m[1] do
    begin
        if i1 > i4 then
        begin
            f3 := p[i4].re;
            f1 := p[i4].im;
            p[i4].re := p[i1 + 1].re;
            p[i4].im := p[i1 + 1].im;
            p[i1 + 1].re := f3;
            p[i1 + 1].im := f1;
        end;
        for i := 1 to n do
        begin
            i5 := i;
            if i1 < m[i] then goto 2;
            i1 := i1 - m[i];
        end;
{L} 2:  i1 := i1 + m[i5];
    end;
    if kind > 0 then
    for i := 1 to 2 * m[1] do
        with p[i] do
        begin
            re := re / f2;
            im := im / f2;
        end;
end;  {fftsub}

{******************************************************************************}
procedure spektrum(p: fftpoints);


{Gibt das errechnete Spektrum aus ...}

const minimum = 0.20;

var r: real;
    n, m: integer;
    e_max: real;
    scale: real;
    first_frequ: integer;
    first_frequ_found: boolean;
    nh: integer;

begin {spektrum}
    e_max := 0;

    first_frequ_found := false;
    for n := 2 to (pkt div 2) do
    begin
        r := sqrt(sqr(p[n].re) + sqr(p[n].im));

        if r > e_max then e_max := r;
        if not first_frequ_found then
           if r > minimum then
           begin
               first_frequ := n;
               first_frequ_found := true;
           end;
    end;

    scale := 80 / e_max;

    frame(639, 0, 520, 199, 1);
    gotoxy(67,24); write('(c) 85, 86 mz');
    draw(520, 176, 639, 176, 1);
    draw(520, 20, 639, 20, 1);
    draw(520, 100, 639, 100, 1);

    gotoxy(6,10);
    write('                            ');

    draw(2, y_pos2, pkt, y_pos2,1);

    for n := 0 to 10 do {Scalierung}
        for m := x_min to x_max div 8 + 1 do
            plot(m * 8 - 2, y_pos2 - (n * 8),1);

    gotoxy(1,1);
    for n := 9 downto 0 do
        writeln(n:1);

    gotoxy(2,12);

    for n := 2 to (pkt div 8) do
    begin
        r := sqrt(sqr(p[n].re) + sqr(p[n].im)) * scale;

        nh := n * 8;

        draw(nh, y_pos2, nh, y_pos2 - round(r),1);
        draw(nh + 1, y_pos2, nh + 1, y_pos2 - round(r),1);
        draw(nh + 2, y_pos2, nh + 2, y_pos2 - round(r),1);
        draw(nh, y_pos2, nh, y_pos2 + 4,1);

        if n mod 5 = 0 then
        begin
            write(n:5);
            draw((n + 1) * 8, y_pos2, (n + 1) * 8, y_pos2 + 9,1);
        end;
    end;
end; {spektrum}
{******************************************************************************}
procedure calc_spektrum(p: fftpoints);

{Berechnug des Spektrums}

begin
    pkt := x_max + 1;
    pn := 9;

    gotoxy(6,10);
    writeln('Berechnung des Spektrums ...');
    fftsub(p, pn, true);                     { f(t) -> f(w) }

    gotoxy(1,1);
    writeln(' ':25);  writeln(' ':25);  writeln(' ':25);


    spektrum(p);
end;
{*****************************************************************************}
procedure do_am(hf_p, nf_p, m_g: real);

{Berechnet AM-Signal ...}

var hf_periods: real;
    nf_periods: real;
    first_val: boolean;
    phi: real;
    u_t : real;
    mg: real;
    gr_omega_t: real;
    a2: integer;
    a1: integer;
    kl_omega_t: real;
    r1, r2: real;
    n1, n2: integer;
    size: integer;
    first_point: integer;

begin{do_am}

        hf_periods := hf_p;
        nf_periods := nf_p;
        mg := m_g;

        hires;

        hf_periods := (x_max + 1) / hf_periods;
        nf_periods := (x_max + 1) / nf_periods;
        a1 := 0;
        first_val := true;

        r1 := 2*pi/hf_periods;
        r2 := 2*pi/nf_periods;

        size := trunc(44 / (1 + mg));

        draw(x_min, y_pos1, x_max, y_pos1,1);

        for i := (x_min + 1) to (x_max + 1) do
        begin
            n2 := i;
            gr_omega_t := n2*r1;
            kl_omega_t := n2*r2;
            u_t :=  (1 + mg * sin(kl_omega_t)) * sin(gr_omega_t);
            a2 := round(-size * u_t) + y_pos1;
            si.sip[i] := a2;
            p[i].re := u_t;
            p[i].im := 0;

            if first_val then
            begin
                first_point := a2;
                n1 := n2;
                a1 := a2;
                first_val := false;
            end;

            draw (n1,a1,n2,a2,1);

            n1 := n2;
            a1 := a2;
        end;

        {connect first point}

        draw (n1,a1,n1+1,first_point,1);


end; {do_am}

{*****************************************************************************}
function corr_input(val: real):boolean;

{Check ob gltige Eingabe, um Abstrze zu verhindern (funktioniert bis jetzt)}

const eps = 0.001;
var hval: real;
begin
    hval := val + 0.0001;   {Dirty Trick um 'nur RET-Eingaben' abzufangen...}
    corr_input := true;
    if (hval < eps) or (hval > 200) or (ioresult > 0) then
       corr_input := false;
end;
{*****************************************************************************}
procedure am_intro;

var hf_p, nf_p, mg: real;

begin

    hf_p := 0;
    nf_p := 0;
    mg := 0;

    clrscr;  textmode;

    write_at(1,24,'A M P L I T U D E N M O D U L A T I O N');

    lowvideo;

    write_at(4,12,
    'Hier wird ein periodisches Signal durch Amplitudenmodulation');
    write_at(5,12,
    'erzeugt. Die Periodendauer dieses Modells betrgt 1'+chr(230)+'s.');
    write_at(6,12,'Geben sie nun die Trgerfrequenz und die ');
    write_at(7,12,'fr den Modulator ein.');
    write_at(8,15,'z.B.: 30 (wrde 30 MHz entsprechen) Trger,');
    write_at(9,15,'      2 (wrde 2 MHz entsprechen) Modulator.');
    write_at(10,12,'Jetzt mu die Eingabe des Modulationsgrades erfolgen:');
    write_at(11,15,'z.B.: Modulationsgrad = 70%');

    highvideo;

    cursor(true);
    repeat
        write_at(16,12,'Trgerfrequenz:                         ');
        gotoxy(28, 16); {$I-} readln(hf_p); {$I+}
    until corr_input(hf_p);
    repeat
        write_at(17,12,'Modulatorfrequenz:                            ');
        gotoxy(31, 17); {$I-} readln(nf_p); {$I+}
    until corr_input(nf_p);
    repeat
        write_at(18,12,'Modulationsgrad [%]:                             ');
        gotoxy(33, 18); {$I-} readln(mg); {$I+}
    until corr_input(mg);
    mg := mg/100;
    cursor(false);

    do_am(hf_p, nf_p, mg);

    calc_spektrum(p);

    gotoxy(70,2); write('- A M -');

    gotoxy(67,5); write('Tragerfreq.');  plot(544, 32, 1); plot(548, 32, 1);
    gotoxy(69,6); write(hf_p:1:2,' MHz');

    gotoxy(67,8); write('Mod.frequenz:');
    gotoxy(69,9); write(nf_p:1:2,' MHz');

    gotoxy(67,11); write('Mod.grad: ');
    gotoxy(69,12); write(mg * 100:1:2,' %');

    calc_done := am;

    read(kbd,key);

end;
{*****************************************************************************}
procedure do_fm(hf_p, nf_p, mi: real);

{Berechnung des FM-Signales}

const size = 44;

var hf_periods: real;
    nf_periods: real;
    first_val: boolean;
    phi: real;
    u_t : real;
    etha: real;
    gr_omega_t: real;
    a2: integer;
    a1: integer;
    kl_omega_t: real;
    r1, r2: real;
    n1, n2: integer;
    first_point: integer;

begin {do_fm}

        hf_periods := hf_p;
        nf_periods := nf_p;
        etha := mi;

        hires;

        hf_periods := (x_max + 1) / hf_periods;
        nf_periods := (x_max + 1) / nf_periods;
        a1 := 0;
        first_val := true;

        r1 := 2*pi/hf_periods;
        r2 := 2*pi/nf_periods;



        draw(x_min, y_pos1, x_max, y_pos1,1);

        for i := (x_min + 1) to (x_max + 1) do
        begin
            n2 := i;
            gr_omega_t := n2*r1;
            kl_omega_t := n2*r2;
            u_t := sin(gr_omega_t - etha * cos(kl_omega_t));
            a2 := round(-size * u_t) + y_pos1;
            si.sip[i] := a2;
            p[i].re := u_t;
            p[i].im := 0;

            if first_val then
            begin
                first_point := a2;
                n1 := n2;
                a1 := a2;
                first_val := false;
            end;

            draw (n1,a1,n2,a2,1);

            n1 := n2;
            a1 := a2;
        end;

        {connect first point}

        draw (n1,a1,n1+1,first_point,1);

end; {do_fm}
{*****************************************************************************}
procedure fm_intro;

var hf_p, nf_p, etha: real;

begin
    hf_p := 0;
    nf_p := 0;
    etha := 0;

    clrscr;  textmode;

    write_at(1,24,'F R E Q U E N Z M O D U L A T I O N');

    lowvideo;

    write_at(4,12,
    'Hier wird ein periodisches Signal durch Frequenzmodulation');
    write_at(5,12,
    'erzeugt. Die Periodendauer dieses Modells betrgt 1'+chr(230)+'s.');
    write_at(6,12,'Geben sie nun die Trgerfrequenz und die ');
    write_at(7,12,'fr den Modulator ein.');
    write_at(8,15,'z.B.: 30 (wrde 30 MHz entsprechen) Trger,');
    write_at(9,15,'      2 (wrde 2 MHz entsprechen) Modulator.');
    write_at(10,12,'Jetzt mu die Eingabe des Modulationsgrades erfolgen:');
    write_at(11,15,'z.B.: Etha = 7');

    highvideo;

    cursor(true);
    repeat
        write_at(16,12,'Trgerfrequenz:                ');
        gotoxy(28, 16); {$I-} readln(hf_p); {$I+}
    until corr_input(hf_p);
    repeat
        write_at(17,12,'Modulatorfrequenz:                ');
        gotoxy(31, 17); {$I-} readln(nf_p); {$I+}
    until corr_input(nf_p);
    repeat
        write_at(18,12,'Etha:                 ');
        gotoxy(18, 18); {$I-} readln(etha); {$I+}
    until corr_input(etha);
    cursor(false);

    do_fm(hf_p, nf_p, etha);

    calc_spektrum(p);

    gotoxy(70,2); write('- F M -');

    gotoxy(67,5); write('Tragerfreq.:');  plot(544, 32, 1); plot(548, 32, 1);
    gotoxy(69,6); write(hf_p:1:2,' MHz');

    gotoxy(67,8); write('Mod.frequenz:');
    gotoxy(69,9); write(nf_p:1:2,' MHz');

    gotoxy(67,11); write('Mod.index: ');
    gotoxy(69,12); write(etha:1:2);

    calc_done := fm;

    read(kbd, key);

end;
{*****************************************************************************}
procedure do_noise;

{Erzeugung eines pseudozuflligen Signales (Rauschen)}

const size = 88;

var first_val: boolean;
    u_t : real;
    a2: integer;
    a1: integer;
    r1, r2: real;
    n1, n2: integer;
    first_point: integer;

begin {do_noise}

        hires;

        a1 := 0;
        first_val := true;

        draw(x_min, y_pos1, x_max, y_pos1,1);

        i := x_min + 1;
        repeat
            n2 := i;
            u_t := random;
            a2 := round(-size * u_t) + y_pos1 + size div 2;
            si.sip[i] := a2;
            p[i].re := u_t;
            p[i].im := 0;

            if first_val then
            begin
                first_point := a2;
                n1 := n2;
                a1 := a2;
                first_val := false;
            end;

            draw (n1,a1,n2,a2,1);

            n1 := n2;
            a1 := a2;

            i := i + 1;
        until i >= x_max + 1;

        {connect first point}

        draw (n1,a1,n1+1,first_point,1);

end; {do_noise}
{*****************************************************************************}
procedure noise_intro;

begin
    clrscr;

    do_noise;

    calc_spektrum(p);

    gotoxy(67,2); write('- RAUSCHEN -');

    calc_done := noise;

    read(kbd, key);

end;
{*****************************************************************************}
procedure show_signal(signal: signal_points);

{Stellt das von der Disk geladene Signal dar}

var first_val: boolean;
    a2: integer;
    a1: integer;
    n1, n2: integer;
    first_point: integer;

begin
    hires;

    a1 := 0;
    first_val := true;

    draw(x_min, y_pos1, x_max, y_pos1,1);

    for i := (x_min + 1) to (x_max + 1) do
    begin
        n2 := i;
        a2 := signal.sip[i];
        p[i].re := a2;
        p[i].im := 0;

        if first_val then
        begin
            first_point := a2;
            n1 := n2;
            a1 := a2;
            first_val := false;
        end;

        draw (n1,a1,n2,a2,1);

        n1 := n2;
        a1 := a2;
    end;

    {connect first point}

    draw (n1,a1,n1+1,first_point,1);

    calc_spektrum(p);

    read(kbd, key);
end;
{*****************************************************************************}
procedure automode;

{Hier macht sich das Programm sebststndig bis eine Taste gedrckt wird ...}

type am_rec = record
                 hf_p, nf_p, mg: real;
              end;

type fm_rec = record
                 hf_p, nf_p, etha: real;
              end;

var i, n: integer;
    am_field: array [1..5] of am_rec;
    fm_field: array [1..5] of fm_rec;

label exit;

begin

    am_field[1].hf_p := 30;
    am_field[1].nf_p := 6;
    am_field[1].mg := 0.7;

    fm_field[1].hf_p := 30;
    fm_field[1].nf_p := 2;
    fm_field[1].etha := 7;

    am_field[2].hf_p := 40;
    am_field[2].nf_p := 10;
    am_field[2].mg := 0.8;

    fm_field[2].hf_p := 30;
    fm_field[2].nf_p := 4;
    fm_field[2].etha := 8;

    am_field[3].hf_p := 45;
    am_field[3].nf_p := 5;
    am_field[3].mg := 0.6;

    fm_field[3].hf_p := 20;
    fm_field[3].nf_p := 2;
    fm_field[3].etha := 8;

    am_field[4].hf_p := 4;
    am_field[4].nf_p := 16;
    am_field[4].mg := 0.6;

    fm_field[4].hf_p := 2;
    fm_field[4].nf_p := 3;
    fm_field[4].etha := 2;

    am_field[5].hf_p := 45;
    am_field[5].nf_p := 3;
    am_field[5].mg := 1.5;

    fm_field[5].hf_p := 3;
    fm_field[5].nf_p := 4;
    fm_field[5].etha := 3;

    n := 1;

    repeat
        for i := 1 to 512 do
            with p[i] do
            begin
                re := 0;
                im := 0;
            end;

        if keypressed then goto exit;

        with am_field[n] do
             do_am(hf_p, nf_p, mg);

        if keypressed then goto exit;

        calc_spektrum(p);

        gotoxy(70,2); write('- A M -');

        with am_field[n] do
        begin
            gotoxy(67,5); write('Tragerfreq.:');
            plot(544, 32, 1); plot(548, 32, 1);
            gotoxy(69,6); write(hf_p:1:2,' MHz');

            gotoxy(67,8); write('Mod.frequenz:');
            gotoxy(69,9); write(nf_p:1:2,' MHz');

            gotoxy(67,11); write('Mod.grad: ');
            gotoxy(69,12); write(100 * mg:1:2,' %');
        end;

        if keypressed then goto exit;

        delay(4000);

        if keypressed then goto exit;

        with fm_field[n] do
             do_fm(hf_p, nf_p, etha);

        if keypressed then goto exit;

        calc_spektrum(p);

        if keypressed then goto exit;

        gotoxy(70,2); write('- F M -');

        with fm_field[n] do
        begin
            gotoxy(67,5); write('Tragerfreq.:');
            plot(544, 32, 1); plot(548, 32, 1);
            gotoxy(69,6); write(hf_p:1:2,' MHz');

            gotoxy(67,8); write('Mod.frequenz:');
            gotoxy(69,9); write(nf_p:1:2,' MHz');

            gotoxy(67,11); write('Mod.index: ');
            gotoxy(69,12); write(etha:1:2);
        end;

        if keypressed then goto exit;

        delay(4000);

        if keypressed then goto exit;

        n := n + 1;

        if n > 5 then n := 1;

    until keypressed;

{L} exit:

end;
{*****************************************************************************}
function fnam_ok(str: lstring): boolean;

{Check ob gltiger Dateiname}

var i: integer;

begin
    fnam_ok := true;
    for i := 1 to length(str) do
        if not ((str[i] in ['A'..'Z']) or (str[i] in ['0'..'9'])) then
            fnam_ok := false;
end;
{*****************************************************************************}
function exist(fname: lstring):boolean;

{Schaut nach ob Datei existiert (Aus Turbomanual)}

var ff: file;

begin
    assign(ff, fname);
    {$I-}
    reset(ff);
    {$I+}
    exist := (ioresult = 0);
    close(ff);
end;
{*****************************************************************************}
procedure store_signal(signal: signal_points);

{Speichert das Signalarray auf Disk}

var si_f: file of signal_points;
    fname: lstring;
    ans: char;

label once_again, exit;

begin
{L} once_again:

    clrscr; textmode;
    write_at(1, 30, ' S I G N A L   S P E I C H E R N ');
    cursor(true);

    if calc_done = nought then
    begin
        write_at(20,10,'Kein Signal erzeugt ...');
        bell;
        delay(5000);
    end else
    begin
        repeat
            write_at(11, 10, 'Dateiname (max. 8 Zeichen): ........ ');
            write(' ':50);
            gotoxy(38,11); readln(fname);
            if fname = '' then goto exit;
            upper_case(fname);
        until (fname <> '') and (length(fname) < 8) and fnam_ok(fname);

        fname := fname + '.SIG';

        if exist(fname) then
        begin
            write_at(15,10,'Datei ' + fname + ' existiert schon !');
            write_at(16,10,'berschreiben ? (J/N) ');
            readln(ans);
            if ans in ['N','n'] then goto once_again;
        end;

        assign(si_f, fname);

        rewrite(si_f);
        write(si_f, signal);
        close(si_f);
    end;
{L} exit:
end;
{*****************************************************************************}
procedure load_signal(var signal: signal_points);

{Ldt das Signalarray von Disk}

var si_f: file of signal_points;
    fname: lstring;
    i: integer;

label once_again, exit;

begin
{L} once_again:

    clrscr; textmode;
    write_at(1, 30, ' S I G N A L   L A D E N ');
    cursor(true);

    repeat
        write_at(11, 10, 'Dateiname (max. 8 Zeichen): ........ ');
        write(' ':50);
        gotoxy(38,11); readln(fname);
        if fname = '' then goto exit;
        upper_case(fname);
    until (fname <> '') and (length(fname) < 8) and fnam_ok(fname);

    fname := fname + '.SIG';

    if not exist(fname) then
       begin
           write_at(15,10,'Datei ' + fname + ' nicht vorhanden');
           bell;
           delay(5000);
           goto once_again;
       end;

    assign(si_f, fname);

    reset(si_f);
    read(si_f, signal);

    close(si_f);

    show_signal(signal);
{L} exit:
end;
{*****************************************************************************}

begin
    calc_done := nought;

    author := 'Written by Michael Zacherl (c) 1985, 1986';

    for i := 1 to 512 do
         si.sip[i] := 0;

    repeat
        for i := 1 to 512 do {Array putzen!!!!}
        begin
            with p[i] do
            begin
                re := 0;
                im := 0;
            end;
        end;

        clrscr;

        cursor(false);

        main_menu(sel_item);

        case sel_item of
             1 : am_intro;
             2 : fm_intro;
             3 : noise_intro;
             4 : load_signal(si);
             5 : store_signal(si);
             6 : automode;
             7 : {abort program};
        end; {case}

    until sel_item = 7;
    cursor(true);
end.
