program fastbox;





(*$I typedef.sys*)
(*$I graphix.sys*)
(*$I kernel.sys*)

type string_array=array (.1..128.) of wrkstring;

var   w,n0,pak,pel,f3db,p2pi,qtc,
      x,y,z,g,fc,fs,qes,vab,qms,rdc,vas,xss,r,fe,d      :real;
      qq,flag,fl1         :integer;
      frage,ask,lwk       :char;
      drucker,speaker         :string(.8.);
      sprecher        :text;


const pi=3.141592654;


(*=================== R E A D D I R ============================*)


function read_dir(search:wrkstring;var dir_entries:string_array):byte;
type fcb = record
             drive:byte;
             name:array [1..8] of char;
             ext:array [1..3] of char;
             curr_blk:integer;
             rec_size:integer;
             size_hi:integer;
             size_lo:integer;
             date:integer;
             time:integer;
             res:array [1..8] of char;
             curr_rec:byte;
             rnd_hi:integer;
             rnd_lo:integer;
           end;
     reg = record
             ax,bx,cx,dx,bp,si,di,ds,es,flgs:integer;
           end;

var fcb1:fcb;
    fcb2:fcb absolute cseg:$0080;
    regs:reg;
    i:integer;
begin
  with regs do
  begin
    ds:=seg(search);
    si:=ofs(search)+1;
    es:=seg(fcb1);
    di:=ofs(fcb1);
    ax:=$2900;
    msdos(regs);
    ds:=seg(fcb1);
    dx:=ofs(fcb1);
    ax:=$1100;
    msdos(regs);
    i:=0;
    if lo(ax)<>$ff then
    begin
      i:=i+1;
      dir_entries[i]:=fcb2.name+'.'+fcb2.ext;
      ax:=0000;
      while lo(ax)<>$FF do
      begin
        ds:=seg(fcb1);
        dx:=ofs(fcb1);
        ax:=$1200;
        msdos(regs);
        if lo(ax)<>$ff then
        begin
          i:=i+1;
          dir_entries[i]:=fcb2.name+'.'+fcb2.ext;
        end;
      end;
    end;
  end;
  read_dir:=i;
end;



(*======================== R A H M E N ===========================*)


procedure rahmen;

var  loop :integer;


begin

     gotoxy(1,1);
     write ('');
     gotoxy(1,24);
     write ('');
     gotoxy(40,1);
     write ('ͻ');
     gotoxy(40,24);
     write ('ͼ');
     for loop:=2 to 23 do begin
             gotoxy(1,loop);
             write ('');
             gotoxy(80,loop);
             write ('');
         end;

     gotoxy(1,3);
     write ('');
     gotoxy(40,3);
     write ('͹');
     gotoxy(1,22);
     write ('');
     gotoxy(40,22);
     write ('Ķ');

end;


(*===================== A B F R A G E =============================*)

procedure abfrage;

var loop  :integer;

begin
     gotoxy(28,2);
     write ('Eingabe der Systemdaten :');
     for loop:=4 to 18 do begin
              gotoxy(40,loop);
              write ('');
         end;
     gotoxy(40,3);
     write ('');
     gotoxy(1,19);
     write ('');
     write ('Ķ');

 end;



(*==================== A B R U F =================================*)

procedure abruf;

begin
     repeat until keypressed;
          read (kbd,ask);
          if ask=#27 then read (kbd,ask);
end;


(*=====================  M E N  I ===============================*)

procedure MENU1;

begin

     lowvideo;
     gotoxy(7,5);
     write ('Resonanzfrequenz:');
     gotoxy(46,5);
     write ('Gleichstromwiderstand:');
     gotoxy(7,8);
     write ('elektrische Gte:');
     gotoxy(46,8);
     write ('mechanische Gte:');
     gotoxy(7,11);
     write ('Nachgiebigkeitsvolumen:');
     gotoxy(46,11);
     write ('Boxenbruttovolumen:');
     gotoxy(7,14);
     write ('Lautsprecherradius:');
     gotoxy(46,14);
     write ('max. Membranhub:');
     gotoxy(7,17);
     write ('Druckerausgabe (j/n):');
     gotoxy(46,17);
     write ('Lautsprechername:');
     gotoxy(38,21);
     write ('Hilfe');
     gotoxy(30,23);
     highvideo;
     write ('END = Ende der Eingabe !');
     gotoxy(31,5);
     lowvideo;
     write (fs:3:0);
     gotoxy(37,5);
     write ('Hz');
     gotoxy(31,8);
     write (qes:1:2);
     gotoxy(31,11);
     write (vas:3:0);
     gotoxy(37,11);
     write ('l');
     gotoxy(31,14);
     write (r:2:1);
     gotoxy(37,14);
     write ('cm');
     gotoxy(31,17);
     write (drucker);
     gotoxy(71,5);
     write (rdc:2:1);
     gotoxy(77,5);
     write ('');
     gotoxy(71,8);
     write (qms:1:2);
     gotoxy(71,11);
     write (vab:3:0);
     gotoxy(77,11);
     write ('l');
     gotoxy(71,14);
     write (xss:2:2);
     gotoxy(77,14);
     write ('mm');
     gotoxy(71,17);
     write (speaker);


end;


 (*==================== E I N G A B E T E I L ======================*)


procedure EINGABE;

var  rg,mb,vak,floot,
     vmax,xx,i,j                          :real;
     err,flop                             :integer;
     inp                                  :string(.8.);

begin

     drucker:='nein';
     qq:=0;
     flag:=6;

     MENU1;

     repeat

           highvideo;
           case fl1 of

               1:  begin
                      lowvideo;
                      gotoxy(7,5);
                      write ('Resonanzfrequenz:');
                      gotoxy(31,5);
                      write ('       ');
                      gotoxy(31,5);
                      write (fs:3:0);
                      gotoxy(37,5);
                      write ('Hz');
                      fl1:=0;
                      highvideo;
                   end;
               2:  begin
                      lowvideo;
                      gotoxy(46,5);
                      write ('Gleichstromwiderstand:');
                      gotoxy(71,5);
                      write ('      ');
                      gotoxy(71,5);
                      write (rdc:2:1);
                      gotoxy(77,5);
                      write ('');
                      fl1:=0;
                      highvideo;
                   end;
               3:  begin
                      lowvideo;
                      gotoxy(7,8);
                      write ('elektrische Gte:');
                      gotoxy(31,8);
                      write ('       ');
                      gotoxy(31,8);
                      write (qes:1:2);
                      fl1:=0;
                      highvideo;
                   end;
               4:  begin
                      lowvideo;
                      gotoxy(46,8);
                      write ('mechanische Gte:');
                      gotoxy(71,8);
                      write ('       ');
                      gotoxy(71,8);
                      write (qms:1:2);
                      fl1:=0;
                      highvideo;
                   end;
               5:  begin
                      lowvideo;
                      gotoxy(7,11);
                      write ('Nachgiebigkeitsvolumen:');
                      gotoxy(31,11);
                      write ('       ');
                      gotoxy(31,11);
                      write (vas:3:0);
                      gotoxy(37,11);
                      write ('l');
                      fl1:=0;
                      highvideo;
                   end;
               6:  begin
                      lowvideo;
                      gotoxy(46,11);
                      write ('Boxenbruttovolumen:');
                      gotoxy(71,11);
                      write ('       ');
                      gotoxy(71,11);
                      write (vab:3:0);
                      gotoxy(77,11);
                      write ('l');
                      fl1:=0;
                      highvideo;
                   end;
               7:  begin
                      lowvideo;
                      gotoxy(7,14);
                      write ('Lautsprecherradius:');
                      gotoxy(31,14);
                      write ('       ');
                      gotoxy(31,14);
                      write (r:2:1);
                      gotoxy(37,14);
                      write ('cm');
                      fl1:=0;
                      highvideo;
                   end;
               8:  begin
                      lowvideo;
                      gotoxy(46,14);
                      write ('max. Membranhub:');
                      gotoxy(71,14);
                      write ('       ');
                      gotoxy(71,14);
                      write (xss:2:2);
                      gotoxy(77,14);
                      write ('mm');
                      fl1:=0;
                      highvideo;
                   end;
               9:  begin
                      lowvideo;
                      gotoxy(7,17);
                      write ('Druckerausgabe (j/n):');
                      gotoxy(31,17);
                      write ('        ');
                      gotoxy(31,17);
                      write (drucker);
                      fl1:=0;
                      highvideo;
                   end;
              10:  begin
                      lowvideo;
                      gotoxy(46,17);
                      write ('Lautsprechername:');
                      gotoxy(71,17);
                      write ('        ');
                      gotoxy(71,17);
                      write (speaker);
                      fl1:=0;
                      highvideo;
                   end;
              11:  begin
                      lowvideo;
                      gotoxy(38,21);
                      write ('Hilfe');
                      fl1:=0;
                      highvideo;
                   end;

           end;
           case flag of
               1:  begin
                      gotoxy(7,5);
                      write ('Resonanzfrequenz:');
                      gotoxy(31,5);
                      write (fs:3:0);
                      gotoxy(37,5);
                      write ('Hz');
                      if (ask=' ') then begin
                                    repeat
                                          gotoxy(31,5);
                                          write ('      ');
                                          gotoxy(31,5);
                                          buflen:=3;
                                          read (inp);
                                          val(inp,fs,err);
                               until (err=0) and (fs>=10) and (fs<150);
                                    floot:=1;
                                    fl1:=1;
                                 end;
                   end;

              2:   begin
                     gotoxy(46,5);
                     write ('Gleichstromwiderstand:');
                     gotoxy(71,5);
                     write (rdc:2:1);
                     gotoxy(77,5);
                     write ('');
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(71,5);
                                         write ('     ');
                                         gotoxy(71,5);
                                         buflen:=4;
                                         read (inp);
                                         val(inp,rdc,err);
                              until (err=0) and (rdc>=1.5) and (rdc<35);
                                   floot:=1;
                                   fl1:=2;
                                 end;

                   end;

              3:   begin
                     gotoxy(7,8);
                     write ('elektrische Gte:');
                     gotoxy(31,8);
                     write (qes:1:2);
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(31,8);
                                         write ('     ');
                                         gotoxy(31,8);
                                         buflen:=4;
                                         read (inp);
                                         val(inp,qes,err);
                              until (err=0) and (qes>=0.2) and (qes<2);
                                   floot:=1;
                                   fl1:=3;
                                 end;
                   end;

              4:   begin
                     gotoxy(46,8);
                     write ('mechanische Gte:');
                     gotoxy(71,8);
                     write (qms:1:2);
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(71,8);
                                         write ('     ');
                                         gotoxy(71,8);
                                         buflen:=4;
                                         read (inp);
                                         val(inp,qms,err);
                              until (err=0) and (qms>=0.2) and (qms<10);
                                   floot:=1;
                                   fl1:=4;
                                 end;
                   end;

              5:   begin
                     gotoxy(7,11);
                     write ('Nachgiebigkeitsvolumen:');
                     gotoxy(31,11);
                     write (vas:3:0);
                     gotoxy(37,11);
                     write ('l');
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(31,11);
                                         write ('      ');
                                         gotoxy(31,11);
                                         buflen:=3;
                                         read (inp);
                                         val(inp,vas,err);
                              until (err=0) and (vas>=1) and (vas<500);
                                   floot:=1;
                                   fl1:=5;
                                 end;
                   end;

              6:   begin
                     gotoxy(46,11);
                     write ('Boxenbruttovolumen:');
                     gotoxy(71,11);
                     write (vab:3:0);
                     gotoxy(77,11);
                     write ('l');
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(71,11);
                                         write ('      ');
                                         gotoxy(71,11);
                                         buflen:=3;
                                         read (inp);
                                         val(inp,vab,err);
                              until (err=0) and  (vab>=1) and (vab<999);
                                   floot:=1;
                                   fl1:=6;
                                 end;
                   end;

              7:   begin
                     gotoxy(7,14);
                     write ('Lautsprecherradius:');
                     gotoxy(31,14);
                     write (r:2:1);
                     gotoxy(37,14);
                     write ('cm');
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(31,14);
                                         write ('      ');
                                         gotoxy(31,14);
                                         buflen:=4;
                                         read (inp);
                                         val(inp,r,err);
                              until (err=0) and (r>=2.5) and (r<50);
                                   floot:=1;
                                   fl1:=7;
                                 end;
                   end;

              8:   begin
                     gotoxy(46,14);
                     write ('max. Membranhub:');
                     gotoxy(71,14);
                     write (xss:2:2);
                     gotoxy(77,14);
                     write ('mm');
                     if (ask=' ') then begin
                                   repeat
                                         gotoxy(71,14);
                                         write ('      ');
                                         gotoxy(71,14);
                                         buflen:=5;
                                         read (inp);
                                         val (inp,xss,err);
                              until (err=0) and (xss>=0.3) and (xss<40);
                                   floot:=1;
                                   fl1:=8;
                                 end;
                   end;

              9:   begin
                     gotoxy(7,17);
                     write ('Druckerausgabe (j/n):');
                     gotoxy(31,17);
                     write (drucker);
                     if (ask=' ') then begin
                                   if drucker='ja' then drucker:='nein'
                                                   else drucker:='ja';
                                   gotoxy(31,17);
                                   write ('      ');
                                   gotoxy(31,17);
                                   write (drucker);
                                   if drucker='ja' then qq:=1
                                                   else qq:=0;
                                   floot:=1;
                                   fl1:=9;
                                end;
                   end;

              10:  begin
                      gotoxy(46,17);
                      write ('Lautsprechername:');
                      gotoxy(71,17);
                      write (speaker);
                      if (ask=' ') and (ask<>'+') then begin
                                    gotoxy(71,17);
                                    write ('       ');
                                    gotoxy(71,17);
                                    buflen:=8;
                                    read (speaker);
                                    floot:=1;
                                    fl1:=10;
                                 end;
                   end;

              11:  begin
                      gotoxy(38,21);
                      write ('Hilfe');
                      fl1:=11;
                      floot:=1;
                  end;
           end;

           fl1:=flag;
           if (floot=0) then abruf
                        else ask:=#13;

           case ask of
             #77,#13:  begin
                        flag:=flag+1;
                     end;
             #75:  begin
                        flag:=flag-1;
                        ask:=#13;
                     end;
             #72:  begin
                        flag:=flag-2;
                        ask:=#13;
                     end;
             #80:  begin
                        flop:=flag;
                        flag:=flag+2;
                     end;
           end;
           if flag>=11 then flag:=flag-10;
           if flag<=0 then flag:=flag+10;
           floot:=0;
     until (ask=#79) and (fs>0);
     xss:=xss/1000;
     r:=r/100;
     vas:=vas/100;
     vab:=vab/100;
     mb:=0.9;
     vak:=vas/vab;
     rg:=1.5;
     qtc:=sqrt(vak+1)*(qes*qms)/(mb*(qes+qms/(1+rg/rdc)));
     clrscr;
     rahmen;
     gotoxy(32,2);
     writeln('Berechnete Daten');
     gotoxy(10,5);
     writeln ('Die Gesamtgte des Systems betrgt: ',qtc:2:2);
     fc:=fs*mb*sqrt(vak+1);
     gotoxy(10,7);
     writeln ('Die Cut-Off-Frequenz ist: ',fc:3:1,' Hz');
     n0:=4*pi*pi*fs*fs*fs*mb*mb*mb*vas*mb/(4.079758e7*qes);
     vmax:=1.05772*xss*xss*fc*fc*fc*fc*r*r*r*r;
     g:=fe/fc;
     x:=g*d*d-2*g+1/(qtc*qtc*g)-2/g;
     y:=g*g+(d*d-2)*(1/(qtc*qtc)-2)+1/(g*g);
     z:=g/(qtc*qtc)-2*g+d*d/g-2/g;
     w:=30;
     xx:=0;
     floot:=0;
     repeat
           floot:=floot+1;
           i:=w*w*w*w-x*w*w*w-y*w*w-z*w-1;
           j:=4*w*w*w-3*w*w*x-2*w*y-z;
           w:=w-i/j;
                 if (i<1e-4) and (i>-1e-4) then xx:=1;
     until  ((w<0) or (w>900) or (xx=1)) or (floot=1000);
     if (xx=1) then begin
                 w:=fc*sqrt(w*g);
                 gotoxy(10,9);
                 writeln ('Die 3-dB-Grenzfrequenz f3 betrgt: ',w:3:2,' Hz');
                 f3db:=w;
             end;
     w:=1;
     floot:=0;
     repeat
           floot:=floot+1;
           if (w<0) or (w>100) then w:=10;
           i:=2*w*w*w*w+x*w*w*w-z*w-2;
           j:=8*w*w*w+3*x*w*w-z;
           w:=w-i/j;
     until ((i<1e-4) and (i>-1e-4)) or (floot=100);
     pak:=vmax*(w*w*w*w+x*w*w*w+y*w*w+z*w+1)/(w*w/(g*g));
     gotoxy(10,11);
     writeln ('Die akustische Leistung betrgt: ',pak:2:3,' W');
     p2pi:=109+10*(ln(pak)/ln(10));
     gotoxy(10,13);
     writeln ('Die akustische Leistung im 2-Raum ist: ',p2pi:3:2,' W');
     pel:=pak/n0;
     gotoxy(10,15);
     writeln ('Das entspricht einer elektrischen Leistung von: ',pel:3:2,' W');
     w:=fc*sqrt(w*g);
     gotoxy(10,17);
     writeln ('Der maximale Hub der Membran ist bei: ',w:2:2,' Hz');
     n0:=n0*100;
     gotoxy(10,19);
     writeln ('Der Wirkungsgrad dabei ist: ',n0:2:3,' %');
     xss:=xss*1000;
     r:=r*100;
     vas:=vas*100;
     vab:=vab*100;
     gotoxy(33,23);
     write ('END = WEITER !');


end;


(*====================== A U S D R. H E L P =====================*)

procedure zeile(trap:real);

begin
     if trap<=9.9999 then write (lst,' ');
     if trap<100 then write (lst,' ');
end;



(*======================= A U S D R U C K ========================*)

procedure druck;

begin
     writeln(lst,#10,#10,#10,#10);
     write (lst,#27,'G');
     writeln(lst,#14,'S Y S T E M D A T E N  ':32,#20,#27,'H');
     writeln(lst,#10,#10,#10);
     write (lst,'     Lautsprecher:      ',' ':36);
     writeln (lst,#27,'G',speaker,#27,'H',#10);
     write (lst,'     Resonanzfrequenz:   ');
     zeile(fs);
     writeln(lst,' ':34,fs:3:2,' Hz');
     writeln(lst,'     Qes: ',' ':51,qes:1:2);
     writeln(lst,'     Qms: ',' ':51,qms:1:2);
     write (lst,'     Gleichstromwiderstand: ');
     zeile(rdc);
     writeln(lst,' ':31,rdc:2:2,' ');
     write (lst,'     Vas: ',' ':49);
     zeile(vas);
     writeln(lst,vas:2:2,' l');
     write (lst,'     Vab: ',' ':49);
     zeile(vab);
     writeln(lst,vab:2:2,' l');
     write (lst,'     Radius:     ',' ':42);
     zeile(r);
     writeln(lst,r:2:2,' cm');
     write (lst,'     Membranhub: ',' ':42);
     zeile(xss);
     writeln(lst,xss:2:2,' mm');
     writeln(lst,#10,#10,#10,#10,#10);
     write (lst,#27,'G');
     writeln(lst,#14,'B E R E C H N U N G  ':30,#20,#27,'H');
     writeln(lst,#10,#10);
     writeln(lst,'     Gesamtgte des Systems: ',' ':32,qtc:2:2);
     write (lst,'     Systemresonanzfrequenz:',' ':31);
     zeile(fc);
     writeln(lst,fc:3:2,' Hz');
     write (lst,'     3-dB-Grenzfrequenz:',' ':35);
     zeile(f3db);
     writeln(lst,f3db:3:2,' Hz');
     write (lst,'     akustische Leistung:',' ':34);
     zeile(pak);
     writeln(lst,pak:2:2,' W');
     write (lst,'     akustische Leistung im 2-Raum:',' ':23);
     zeile(p2pi);
     writeln(lst,p2pi:3:2,' W');
     write (lst,'     ist eine elektr. Leistung von: ',' ':23);
     zeile(pel);
     writeln(lst,pel:3:2,' W');
     write (lst,'     maximaler Membranhub bei:',' ':29);
     zeile(w);
     writeln(lst,w:2:2,' Hz');
     writeln(lst,'     Wirkungsgrad: ',' ':42,n0:2:2,' %');
     writeln(lst,#10,#10,#10,#10,#10,#10,#10);


end;

(*==================== A C H S E N B E S C H R I F T U N G =============*)


procedure achse;

begin
     clearscreen;
     setcolorwhite;
     setbackground(0);

     defineheader(1,'FREQUENZDIAGRAMM');
     setheaderon;
     defineworld(1,0,1000,1000,0);
     selectworld(1);
     drawborder;

end;


(*===================== G R A F I K A U S D R U C K ======================*)


procedure ausdruck;

var   f,yy,xd,y1,x1,hh     :real;
      h        :integer;


begin
     drawtextw(450,50,2,speaker);
     y1:=910;
     x1:=90;
     for h:= 20 to 100 do begin
                       f:=h/fc*h/fc/g;
                       yy:=f*f*f*f/(f*f*f*f+x*f*f*f+y*f*f+z*f+1);
                       yy:=500-410*ln(yy)/ln(10);
                       xd:=700*ln(h/10)/ln(10)-121;
                       if (yy>910) then yy:=910;
                       if (yy<90) then yy:=90;
                       drawline(x1,y1,xd,yy);
                       y1:=yy;
                       x1:=xd;
                   end;
      for h:= 10 to 30 do begin
                       hh:=h*10;
                       f:=hh/fc*hh/fc/g;
                       yy:=f*f*f*f/(f*f*f*f+x*f*f*f+y*f*f+z*f+1);
                       yy:=500-410*ln(yy)/ln(10);
                       xd:=700*ln(hh/10)/ln(10)-121;
                       drawline(x1,y1,xd,yy);
                       y1:=yy;
                       x1:=xd;
                   end;


end;


(*======================= D A T E N  F  R  L S =======================*)

procedure daten;

begin
     fe:=5;
     d:=1;
     fs:=28;
     qes:=0.53;
     qms:=2.44;
     vab:=76;
     vas:=120;
     xss:=20;
     r:=10;
     rdc:=3.7;
     speaker:='WS 20';
     flag:=0;
     fl1:=0;
end;



(*=================D A T E I L E S E N ========================*)

procedure lesen;

begin
     assign(sprecher,lwk+':'+speaker+'.SPK');
     reset (sprecher);
     read (sprecher,fe,d,fs,qes,qms,vab,vas,xss,r,rdc);
end;


(*=================D A T E I S C H R E I =====================*)

procedure schreibe;

begin
     assign(sprecher,lwk+':'+speaker+'.SPK');
     rewrite (sprecher);
     write (sprecher,fe,d,fs,qes,qms,vab,vas,xss,r,rdc);
     close (sprecher);
end;

(*================= D I R E C T O R Y ========================*)

procedure directory;


var  dir:string_array;
     anzahl,i:integer;

begin
     clrscr;
     rahmen;
     gotoxy(32,2);
     write ('LAUTSPRECHERDATEI');
     gotoxy(33,23);
     write ('END = Weiter!');

     highvideo;
     anzahl:=read_dir(lwk+':*.SPK',dir);
     for i:=1 to anzahl do begin
         if i<17 then gotoxy(10,i+4);
         if i>=17 then gotoxy(50,i-13);
         delete(dir(.i.),9,4);
         write (dir(.i.));
     end;
     repeat
           read (kbd,ask);
           if ask=#27 then read (kbd,ask);
     until ask=#79;
end;


(*================= E I N L E S E N  ==========================*)

procedure einlesen;

var    flag: integer;


begin
  repeat
     clrscr;
     rahmen;
     gotoxy(36,2);
     write ('DATENMEN');
     gotoxy(31,5);
     write ('Bitte Eingabe fr:');
     gotoxy(20,8);
     write ('1:   Lautsprecherdatei von A:');
     gotoxy(20,10);
     write ('2:   Lautsprecherdatei von B:');
     gotoxy(20,12);
     write ('3:   Lautsprecher einlesen von A:');
     gotoxy(20,14);
     write ('4:   Lautsprecher einlesen von B:');
     gotoxy(20,16);
     write ('END  Weiter');
     flag:=0;
     repeat
           read(kbd,ask);
           if ask=#27 then read (kbd,ask);
     until (ask>='1') and (ask<='4') or (ask=#79);
     case ask of
         '1':  begin
                   lwk:='A';
                   directory;
               end;
          '2':  begin
                   lwk:='B';
                   directory;
               end;
          '3':  begin
                   lwk:='A';
                   gotoxy(15,20);
                   write ('Lautsprechername: ');
                   buflen:=8;
                   read (speaker);
                   lesen;
                   flag:=1;
               end;
          '4':  begin
                   lwk:='B';
                   gotoxy(15,20);
                   write ('Lautsprechername: ');
                   buflen:=8;
                   read (speaker);
                   lesen;
                   flag:=1;
               end;
           #79: flag:=1;
      end;
  until (flag=1);
end;



(*================= H A U P T T E I L =========================*)



begin

     repeat;
            einlesen;
            clrscr;
            rahmen;
            abfrage;
            EINGABE;
            lwk:='B';
            schreibe;
            if qq=1 then druck;
            repeat
                  abruf;
            until ask=#79;
            initgraphic;
            achse;
            loadscreen('printbox.pic');
            ausdruck;
            if qq=1 then begin
                         hardcopy(false,1);
                         writeln(lst,#12);
                     end;
            repeat
                  abruf;
            until (ask=#79) or (ask='Q');
            leavegraphic;
      until ask='Q';

end.







