;=============================================================================
;                    N P S . A S M   ---  NortonPrintScreen
;=============================================================================
;
;  Treiber zum Ausdrucken von Bildschirmen die Druckersteuerzeichen darstellen
;  mittels der PrintScreen Funktion. Diese Zeichen ( < ASCII 32 ) werden auf 
;  dem Drucker durch ein Zeichen ersetzt das dem Program beim Aufruf in der 
;  Form /[Zeichen] bergeben wird. (Default : ".")
;  Insbesondere gedacht fr NORTON's HardModify, NORTON's Utilities, den Dis-
;  kettendoktor und andere HEX - Editoren.
;   
;  Hinweis : 
;  NP wird durch einen zweiten Aufruf vllig deinstalliert.
;
;  das bliche : MASM NPS;
;                LINK NPS;
;                EXE2BIN NPS.EXE NPS.COM
;
;============================================================================
;
;     *** Bentigt MASM 1.0 zum assemblieren
;
;     entwickelt und realisiert : Andreas Wacker
;                                 Landsbergerstr. 461
;                                 8000 Mnchen 60
;                                 Tel.: 089/880089
;
;=============================================================================

;----------------------------------------------------------------------------
; 		             EQUATES
;----------------------------------------------------------------------------

lf	equ	10			; Line Feed
cr	equ	13			; Carriage Return
	
;----------------------------------------------------------------------------
;                       	CODESEGMENT
;----------------------------------------------------------------------------

cseg 	segment para public 'code'
	assume cs:cseg,ds:cseg,es:nothing
	
        org 	100h

main:	call 	setup

;========================== DATA AT CODESEGMENT =============================

org_vec5	dd 	?
envir_adr       dw      ?
kennung         dw 	'NP'
ersetzung       db      '.'
msg1            db 	13,10,'NPS installed - Druckersteuerzeichen werden'
                db      ' unterdrckt',13,10,'$'
msg2   		db      13,10,'NPS deinstalliert - Druckersteuerzeichen werden'
                db      ' gesendet',13,10,'$'

;-----------------------------------------------------------------------------
;                         new PrintScreen int (5)
;-----------------------------------------------------------------------------

int5   proc far

	sti				; erlaube Interrupts 
	push	ds			; retten aller Register die verndert 
	push    es			;                            \ werden
	push	ax
	push	bx
	push	cx
	push	dx

	xor	ax,ax			
	mov	es,ax

	cmp	byte ptr es:[500h],1	; prfe PrintScreen Status Byte
	jz	exit			; PrintScreen schon aktiv - beende Int.
	mov	byte ptr es:[500h],1	; setze Status Byte

	mov	ah,15			; Bildschirm Status lesen
	int 	10h	
                			; jetzt in al : Mode
					;	   ah : Spalten (40/80)
					;	   bh : aktive Bildschirmseite
	mov	cl,ah			; Anzahl Spalten fr Zhler
	mov	ch,25			; aber immer 25 Zeilen
	call	crlf			; Druckerpuffer leeren 

	push	cx			; cx wird bei int 10h zerstrt
	mov	ah,3			; Cursor Position lesen
	int	10h	
	pop	cx		

	push	dx			; Cursor Position sichern
	xor	dx,dx			; Cursor auf 0,0 setzen

;------ Die folgende Schleife liest den Bildschirm aus
	
read_loop:
	mov	ah,2	
	int	10h
	mov	ah,8			; zeichen lesen
	int	10h

;------ Zeichen prfen

	cmp	al,31			; Zeichen < ASCII 32 ?
	ja	unchanged		; nein -  normal weiter
	mov	al,cs:ersetzung   	; ja   -  ersetze Zeichen 

unchanged:
	push	dx
	xor	dx,dx
	xor	ah,ah
	int	17h
	pop	dx
	
	test	ah,25h			; Drucker ok ??
	jnz	prt_error		; nein 
	inc	dl			; ja  - nchste Bildschirmposition 
	cmp	cl,dl			; Zeilende erreicht ?
	jnz	read_loop		; nein

	xor	dl,dl			; ja - setzte Spalte auf Null
	mov	ah,dl			
	push 	dx
	call 	crlf			; Zeilenvorschub	
	pop	dx
	inc	dh
	cmp	ch,dh
	jnz	read_loop		

    	pop	dx
	mov	ah,2
	int	10h
	
	mov	byte ptr es:[500h],0		; lsche Status Byte
	jmp 	exit

;------ Druckerfehler

prt_error:
	pop	dx			; Cursor an die Stelle setzen, an der 
	mov	ah,2			;                 \ er beim Aufruf war
	int	10h
	mov	byte ptr es:[500h],0FFH	; setze Status Byte auf FEHLER	

exit:
	pop	dx			; wiederherstellen der Register
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	iret

int5	endp

;-----------------------------------------------------------------------------
;                         CRLF
;-----------------------------------------------------------------------------

crlf	proc 	near
	
	xor	dx,dx			; Drucker 0
	xor	ah,ah			; Zeichen drucken
	mov	al,cr			; Zeichen ist CR
	int	17h			; Zeichen senden

	xor	dx,dx			
	xor	ah,ah			
	mov	al,lf      		; Zeichen ist LF
	int	17h			; Zeichen senden

	ret

crlf	endp

;-----------------------------------------------------------------------------
;                         install
;-----------------------------------------------------------------------------

setup  proc near

;----- feststellen ob Parameter in der Kommandzeile 

	cmp	byte ptr cs:[80h],0
	je	la2			; keine Parameter

;------ Lnge des Parameterstrings lesen

	xor 	cx,cx
	xor	si,si
	mov	cl,cs:[80h]

;------ Delimiter suchen

la0:	mov	ah,cs:[81h+si]
        cmp     ah,'/'
        je      la1
	inc	si
	loop	la0	

;------ das auf den Delimiter folgende Zeichen ist die Ersetzung

la1:	inc 	si
	mov	ah,cs:[81h+si]
	mov	cs:ersetzung,ah

;------- Originalvektor int 5h retten

la2:	mov	al,5h			; vector nummer
	mov	ah,35h			; DOS - function : get vector
	int 	21h	
	mov	word ptr cs:org_vec5,bx
	mov	word ptr cs:org_vec5+2,es

;------ NP bereits installiert ????

	mov	ax,es:kennung		
	mov	dx,cs:kennung
	cmp	ax,dx
	je	installed

;------ neuen PrintScreeninterrupt (5h) einhngen :
    
	mov	al,5h			; vector nummer
	mov	dx,offset int5  	; Adresse des neuen vectors
	mov	ah,25h			; DOS - function : set vector
	int 	21h	

;------ Environment Adresse retten

	mov	ax,cs:[2Ch]            	; siehe DOS 3.1 Technical Reference
	mov 	cs:envir_adr,ax        	;                         \ Page 7/11

;----- Meldung da installiert
	
	mov	dx,offset cs:msg1
	mov	ah,9
	int	21h

;------ terminate and stay resident

	mov	dx,offset setup
    	mov     cl,4
	shr	dx,cl
	inc	dx
	mov	ah,31h
	int     21h       

installed:

;------ vector rcksetzen

	mov	dx,word ptr es:org_vec5 
	mov	ax,word ptr es:org_vec5+2
	mov	ds,ax
	mov	al,5h
	mov	ah,25h
	int	21h

;----- free codeblock

	mov	ah,49h
	int	21h	

;----- free environmentblock

	mov	es,es:envir_adr
	mov	ah,49h
	int	21h	

;----- Meldung da deinstalliert
	
	push	cs
	pop	ds
	mov	dx,offset cs:msg2
	mov	ah,9
	int	21h

;------ Programmende
	
	mov	ah,4Ch
	int	21h

setup 	endp

cseg 	ends

	end main

 

     