(* Zeitablesen in TURBO-PASCAL *)
(* --------------------------- *)

var
  z   : char;

type
  Register = record
    case Integer of
      1:(AX,BX,CX,DX,BP,SI,DS,ES,Flags:Integer);
      2:(AL,AH,BL,BH,CL,CH,DL,DH      :Byte);
    end;

  Zeitformat = record
       h,m,s,s100 : Integer
  end;

var
  AltZeit,t : Zeitformat;

procedure ZeitLesen (var Zeit:Zeitformat);
   var    r:Register;
   begin
      r.ah:=$2c;
      MSDOS(r);
      Zeit.h:=r.ch;
      Zeit.m:=r.cl;
      Zeit.s:=r.dh;
      Zeit.s100:=r.dl
   end;

procedure ZeitSetzen (Zeit:Zeitformat);
   var    r:Register;
   begin
      r.ah:=$2d;
      r.ch:=Zeit.h;
      r.cl:=Zeit.m;
      r.dh:=Zeit.s;
      r.dl:=Zeit.s100;
      MSDOS(r);
      if NOT (r.al=0) then WriteLn ('Zeit setzen fehlerhaft')
   end;

procedure WriteZeit (Zeit:Zeitformat);
   begin
      WriteLn (Zeit.h,':',Zeit.m,':',Zeit.s,':',Zeit.s100)
   end;

procedure Jetzt;
   begin
      ZeitLesen (t);
      WriteZeit (t)
   end;

begin
     ClrScr;
     WriteLn ('Zeitmessung');
     WriteLn ('-----------');
     WriteLn ('Zeit zwischen zweimaligem Tastendruck wird');
     WriteLn ('gemessen und angezeigt');
     WriteLn ('Die Systemzeit wird um diesen Betrag verstellt');
     WriteLn ('Drcken Sie eine Taste!');
     Read (kbd,z);
     Write ('Systemzeit bei Beginn :   ');
     Jetzt;
     ZeitLesen (Altzeit);
     t.h:=0;t.m:=0;t.s:=0;t.s100:=0;
     ZeitSetzen (t);
     ZeitLesen (t);
     WriteLn ('Drcken Sie eine Taste!');
     Read (kbd,z);
     Write ('Dauer                 :   ');
     Jetzt;
     WriteLn;
     Write ('Systemzeit bei Ende   :   ');
     WriteZeit (Altzeit);
     WriteLn ('ohne Korrektur');
     WriteLn;
     (* Zeitkorrektur *)
     ZeitLesen (t);
     Write ('Altzeit               :   ');WriteZeit (Altzeit);
     Write ('Mezeit               :   ');WriteZeit (t);
     WriteLn;
     t.s100:=t.s100+Altzeit.s100;
     t.s:=t.s+Altzeit.s;
     t.m:=t.m+Altzeit.m;
     t.h:=t.h+Altzeit.h;
     if t.s100>=100 then begin t.s100:=t.s100-100;t.s:=t.s+1 end;
     if t.s>=60 then begin t.s:=t.s-60;t.m:=t.m+1 end;
     if t.m>=60 then begin t.m:=t.m-60;t.h:=t.h+1 end;
     ZeitSetzen (t);
     Write ('Systemzeit bei Ende   :   ');
     Jetzt;
     WriteLn ('mit Korrektur')
end.
