(* <<<K.PAS>>> *)

 program kermit;

{$I kinit}
{$I kdir}
{$I kopen}
{$I kdisplay}
{$I khelp}
{$I krec}
{$I kterm}
{$I ksend}
{$I krec1}
{$I kcmd}

  begin (* main *)
    lowvideo;
    file_type_var := ascii;
    parity_type_var := no_parity;
    port_type_var := comm;  (* default communications port (reader/punch) *)
    timeout := 5; (* value for timeout, not implemented *)
    chk_type := '1'; (* we can only do type 1 checks *)
    repeat_char := '~'; (* not used right now *)
    done := false;  (* dummy variable for main repeat, stop is via quit proc *)
    base_iobyte := iobyte; (* get the initial iobyte *)
    port := 2; (* port is comm *)
    port_iobyte := (base_iobyte and $fc) or port; (* set port iobyte *)
    debug := false; (* debug mode is off *)
    printing := false; (* print logging is off *)
    file_open := false; (* no files open *)
    print_mode := 'off'; (* print mode string for show *)
    debug_mode := 'off'; (* debug mode string for show *)
    maxtry := 5; (* default maximum retries *)

    repeat
      (* The following parameters are reset on each command *)
      packet_size := init_packet_size; (* our default packet size *)
      repeating := false; (* make sure we don't try repeat prefixing *)
      npad := 0;   (* I don't need padding *)
      pad := chr(0); (* but if I did I'd want null *)
      my_pad_num := 0; (* I won't send padding unless requested *)
      end_of_line := 13; (* expected end of line character *)
      send_eol := 13; (* I'll send a cr to start with *)
      quote_char := '#'; (* I'll use the default quote *)
      quote_8 := '&';    (* I'll use the default 8 bit quote *)
      quoting := false;  (* but I won't ask for it unless binary with parity *)
      prompt; (* send prompt *)
      get_cmd_line; (* execute typed command *)
    until done = true; (* Done is never set, it's just for the loop *)
  end.  (* main *)

(* <<<KINIT.PAS>>> *)

  type
     string1 = string[1];
     string3 = string[3];
     string80 = string[80];
     string15 = string[15];
     string100 = string[150];
     state_vars = (send_init, send_file_header, send_file, send_eof,
                   send_break, receive_init, receive_header, receive_file,
                   send_bye, get_file);
     state_type = array[state_vars] of string[30];
     file_param = (ascii, binary);
     file_type = array[file_param] of string[10];
     parity_param = (no_parity, mark_parity, space_parity, even_parity,
                     odd_parity);
     parity_type = array[parity_param] of string[10];
     port_param = (console, comm, uc1);
     port_type = array[port_param] of string[20];
     packet_param = (break_pack, data_pack, error_pack, header_pack,
                       nak_pack, send_pack, reserved_pack, ack_pack,
                       end_pack, unknown);
     f_modes = (read_open, write_open);
     character = char;

  const
    version = 1.1; (* current version number *)
    buffersize = 128; (* program is not set up for any other size right now *)
    file_str : file_type = ('ASCII', 'Binary');
    parity_str : parity_type = ('None', 'Mark', 'Space', 'Even', 'Odd');
    port_str : port_type = ('Console', 'Reader/Punch', 'User Console');
    state_str : state_type = ('send init', 'send file header', 'send file',
                              'send eof', 'send break', 'receive init',
                              'receive header', 'receive file', 'send bye',
                              'get file');
    escape_char = $1c;  (* ^\  control-backslash *)
    bell = ^G;
    init_packet_size = 40; (* use a small packet for testing *)

  var

    option, bs, cr, lf : char;
    count : integer; (* general purpose count variable *)
    line_command, arg1, arg2, arg3 : string[25]; (* more space for filename *)
    line_buffer : string[80];
    port : integer; (* port value to and/or with iobyte for port setting *)
    done : boolean; (* dummy variable for main proc loop *)
    file_type_var : file_param;
    parity_type_var : parity_param;
    port_type_var : port_param;
    packet_type : packet_param;
    state : state_vars; (* state variable for state switchers *)
    packet_size, timeout, npad, end_of_line : integer;
    pad, quote_char, quote_8, chk_type, repeat_char : char;
    packet_buffer, packet_buffer_data, rec_packet : string[150];
    packet_ok, ack_ok, open_ok, file_done, abort : boolean;
    packet_num, rec_packet_num, packets_sent, packets_bad : integer;
    outfile : file; (* untyped file for read or write *)
    file_open : boolean;
    file_mode : f_modes;
    received_data : string[100];
    quoting : boolean;
    repeating : boolean;
    printing : boolean;
    print_mode : string[3];
    my_pad_char, his_ctl_quote, his_quote_char : char;
    my_pad_num, send_eol : integer;
    debug : boolean;
    debug_mode : string[3];
    iobyte : byte absolute $0003; (* CP/M standard iobyte location *)
    base_iobyte : byte; (* starting iobyte *)
    port_iobyte : byte; (* iobyte for kermit comm port *)
    retry : boolean; (* if you want to force a retry on send or receive packet *)
    maxtry : integer;
    fcb : array[1..36] of byte; (* fcb for dir command *)
    dma : array[1..128] of byte; (* dma buffer for dir command *)
    filebuffer : array[1..buffersize] of char; (* file record read *)
    file_records : integer; (* number of 128 byte records in disk file *)
    filepointer : integer; (* where we are in the record *)
    buffer_num : integer; (* how many 128 byte records have we read or written *)
    receive_done : boolean; (* signals the end of receive command *)

  function tab(spaces : integer) : string80;

    (* This function generates a string of spaces for formatting printing *)

    var count : integer;
        temp : string[80];

    begin (* tab *)
      temp := '';
      for count := 1 to spaces do
        temp := temp + ' ';
      tab := temp;
    end; (* tab *)

  function ctl(character : char) : char;

    (* This function transforms a character to/from a control character *)

    begin
      ctl := chr(ord(character) xor $40);
    end;

  function char40(number : integer) : char;
    (* add 40 octal to a number for conversion to printable character *)

    begin
      char40 := chr(number + 32);
    end;

  function unchar(character : char) : integer;
    (* subtract 40 octal from character for conversion back to a number *)

    begin
      unchar := ord(character) - 32;
    end;

  procedure ltrim(var line : string80);

    (* removes leading spaces from a line for parsing the command line *)

    begin (* ltrim *)
      while line[1] = ' ' do
        delete(line,1,1);
    end; (* ltrim *)

  procedure rtrim(var line: string80);

    (* removes trailing spaces from a string to parse the command line *)

    begin (* rtrim *)
      while line[length(line)] = ' ' do
        delete(line,length(line),1);
    end; (* rtrim *)

(* <<<KDIR.PAS>>> *)

    procedure adjust_fn(fileref : string15; var drive : string1;
                        var filename : string15; var filetype : string3);

      (* This procedure converts a string into the standard CP/M format
         for processing. This format is all upper case, and inserts ?'s
         into the string if the wildcards ? or * are found in the string.
         Finally, the string is expanded so spaces are placed in any
         unfilled positions in the name.  these are placed in the middle of
         the filename, i.e.  abc.de is converted to 'abc     . de'.
      *)

      var
        insert_pos, count : integer;

      begin
        for count := 1 to length(fileref) do (* convert to upper case *)
          if (fileref[count] in ['a'..'z']) then
            fileref[count] := chr(ord(fileref[count]) and $df);
        if pos('.', fileref) <> 0 then (* separate the file name and type *)
          begin
            filename := copy(fileref, 1, pos('.', fileref) - 1);
            filetype := copy(fileref, pos('.', fileref) + 1, 3);
          end
        else
          begin
            filename := fileref;
            filetype := ''; (* no file type in this case *)
          end;
        if pos(':', filename) <> 0 then (* check for drive spec *)
          begin
            drive := copy(filename, 1, pos(':', filename) - 1);
            delete(filename, 1, pos(':', filename));
            if filename = '' then
              begin
                filename := '*';
                filetype := '*';
              end;
          end
        else
          drive := '!'; (* dummy value for param *)

        while (pos('*',filename) <> 0) do (* find any '*' wildcards *)
          begin
          insert_pos := pos('*', filename); (* find the spot *)
          delete(filename, insert_pos, 1);  (* get rid of * *)
          while (length(filename) < 8) do
            (* insert ?'s until filename is filled. Note that the first '*'
               will fill the string, so any other *'s in the name will be
               deleted and replaced with a single '?'.  '*k*' will be
               converted to '??????k?'
            *)
            insert('?', filename, insert_pos);
        end;
        while pos('*',filetype) <> 0 do (* do the same for the filetype *)
          begin
            insert_pos := pos('*', filetype);
            delete(filetype, insert_pos, 1);
            while (length(filetype) < 3) do
              insert('?', filetype, insert_pos);
          end;
        while length(filename) < 8 do (* fill out the filename with spaces *)
          filename := filename + ' ';
        while length(filetype) < 3 do (* do the same for the filetype *)
          filetype := filetype + ' ';
      end; (* adjust_fn *)

    procedure init_fcb(infile : string15);

      (* initialize an fcb with a filename and filetype for use with BDOS
         calls
      *)

      var
        count : integer;
        drive : string1;
        filename : string[15];
        filetype : string[3];

      begin

        adjust_fn(infile, drive, filename, filetype); (* put filespec in proper form *)
        if drive in ['A'..'P'] then
          fcb[1] := ord(drive) - 64 (* store the drive spec *)
        else
          fcb[1] := 0; (* use default drive *)
        for count := 1 to 8 do (* put in the filename. Array operation, not string *)
          fcb[1 + count] := ord(filename[count]);
        for count := 1 to 3 do (* same for filetype. Must be integers here *)
          fcb[9 + count] := ord(filetype[count]);
        for count := 13 to 36 do (* rest of FCB is 0's *)
          fcb[count] := 0;
      end;

    procedure searchfirst(var result : integer);

      (* search for first BDOS call.  Result is position in DMA buffer of
         filespec, or 255 if no file is found *)

      begin
        result := bdos($11, addr(fcb));
      end;

    procedure searchnext(var result : integer);

      (* search for next BDOS call. Result is same as above *)

      begin
        result := bdos($12, addr(fcb));
      end;

  procedure dir; (* generate directory listing *)

    (* generate a directory listing.  This is a CP/M dependent procedure and
       would have to be changed for other operating systems.  No size
       information is printed
    *)

    var
      filename : string[15];
      filetype : string[3];
      index, count, result : integer;

  begin
    if arg1 = '' then
      arg1 := '*.*'; (* we'll read all the filenames *)
    init_fcb(arg1);  (* set up the FCB *)
    bdos($1a, addr(dma)); (* set up the dma address *)
    searchfirst(result);  (* look for the first directory entry *)
    count := 0; (* cont for formatting output into 4 per line *)
    if result <> 255 then (* write the first filename *)
      begin
        writeln;
        writeln('Directory listing for ', arg1);
        writeln;
        for index := ((result * 32) + 1) to ((result * 32) + 9) do
          write(chr(dma[index]));
        write('.');
        for index := ((result * 32) + 10) to ((result * 32) + 12) do
            write(chr(dma[index]));
        write(' : ');
        count := count + 1;
      end
    else
      writeln('no file'); (* guess it doen't exist *)
    while (result <> 255) do
      begin
        searchnext(result); (* keep looking *)
        if result <> 255 then
          begin
            count := count + 1; (* bump the display counter *)
            for index := (result * 32) + 1 to ((result * 32) + 9) do
              write(chr(dma[index]));
            write('.');
            for index := ((result * 32) + 10) to ((result * 32) + 12) do
              write(chr(dma[index]));
            if ((count mod 5) = 0) then
              writeln
            else
              write(' : ');
        end;
    end;
    writeln;
  end;

  procedure delfile; (* delete the selected files *)

    var
      result : integer;
      fileref : string15;

    procedure deletefile(var result : integer);

      begin
        result := bdos($13, addr(fcb));
      end;

    begin (* delfile *)
      if arg1 = '' then
        begin
          writeln;
          write('Enter file(s) to erase: ');
          readln(arg1);
        end;
      init_fcb(arg1);
      deletefile(result);
      if result in [0..3] then
        writeln('File(s) deleted.')
      else
        writeln('File(s) not found.');
      writeln;
    end; (* delfile *)

(* <<<KOPEN.PAS>>> *)
(*--------------------------------------------------------------------*)

  procedure open_file(file_mode : f_modes; fileref : string15);

    (* This procedure attempts to open a file for writing or reading
       using standard Turbo Pascal procedures.  If the file is opened
       successfully, open_ok is returned, and file_open is returned true
    *)

    var
      count, space_pos : integer;
      drive : string1;
      temp_fn : string[20];
      filename : string[15];
      filetype : string[3];

    procedure open_for_write(fileref : string15; var open_ok : boolean);

      (* On an open for write, if reset is successful, the file already
         exists.  In this version, we never want to destroy an existing
         file, so the file is never rewritten
      *)

      begin
        assign(outfile, fileref); (* assign filvar *)
        {$I-} (* turn off io checking *)
        reset(outfile); (* try to open it *)
        {$I+} (* allow error checking again *)
        if ioresult <> 0 then (* 0 for open, not 0 for not found *)
          begin  (* filename is new file, open it *)
            rewrite(outfile);
            file_records := filesize(outfile); (* get the size of the file *)
            open_ok := true; (* flags for calling procedure *)
            file_open := true;
            buffer_num := 0; (* we are at the first buffer of data *)
          end
        else
          open_ok := false; (* The file already existed *)
      end;

    begin (* open_file *)
      case file_mode of
        read_open : begin
                      assign(outfile, fileref); (* try to open file *)
                      {$I-}
                      reset(outfile);
                      {$I+}
                      if ioresult = 0 then (* yes, it exists *)
                        begin
                          open_ok := true;
                          file_open := true;
                          file_records := filesize(outfile);
                          gotoxy(62,7); (* display filesize for progress report *)
                          write((file_records * 128):6);
                          buffer_num := 0;
                        end
                      else  (* couldn't open file *)
                        begin
                          open_ok := false;
                          gotoxy(1,8);
                          write('File ', fileref, ' does not exist.');
                        end;
                    end;
        write_open : begin
                       open_for_write(fileref, open_ok); (* try on entry *)
                       if not open_ok then
                          (* File already existed, so we'll try to build a
                             unique filename for the file and open that. For
                             reasons I don't remember, it will only try to
                             insert '&' signs until all the unfilled
                             character positions in the filename are used up.
                             The original filename will always be present.
                          *)

                         begin
                           temp_fn := fileref;
                           repeat
                             adjust_fn(temp_fn, drive, filename, filetype);
                             temp_fn := filename + '.' + filetype;
                             if drive <> '!' then
                               temp_fn := drive + ':' + temp_fn;
                             space_pos := pos(' ',temp_fn);
                             if space_pos <> 0 then
                               begin
                                 delete(temp_fn,space_pos,1);
                                 insert('&',temp_fn,space_pos);
                                 while pos(' ',temp_fn) <> 0 do
                                   delete(temp_fn,pos(' ',temp_fn),1);
                                 open_for_write(temp_fn, open_ok);
                               end;
                           until (open_ok) or (space_pos = 0);
                           gotoxy(1,9);
                           if open_ok then (* print the new filename *)
                             if (temp_fn <> fileref) then
                               write('Filename ',fileref, ' changed to: ', temp_fn)
                             else
                               write('Filename: ',temp_fn)
                           else
                             write('Filename ', fileref, ' could not be opened.');
                         end;
                     end;
      end; (* case *)
    end; (* open_file *)

(* <<<KDISPLAY.PAS>>> *)
  (* There are three procedures in this file.  Probably two of them could be
     combined, but it was simpler this way for now.  Anyway, these set up
     the displays for send and receive mode, and updates the display after
     a packet is sent or received.
  *)


  procedure displayt; (* display the send and receive states *)


    begin
      gotoxy(1,1);
      writeln('Turbo Pascal Kermit Version ', version:3:1);
      gotoxy(5,7);
      write('Bytes transferred: ');
      gotoxy(40,7);
      write('Bytes to transfer: ');
      gotoxy(5,3);
      write('Packets Sent:');
      gotoxy(5,5);
      write('Retries:');
    end;

  procedure displayr; (* display the send and receive states *)

    begin
      gotoxy(1,1);
      writeln('Turbo Pascal Kermit Version ', version:3:1);
      gotoxy(5,7);
      write('Bytes transferred: ');
      gotoxy(5,3);
      write('Packets Received:');
      gotoxy(5,5);
      write('Retries:');
    end;

  procedure update(packets_sent,packets_bad : integer); (* update the display *)

    begin
      gotoxy(24,3);
      write(packets_sent:6);
      gotoxy(24,5);
      write(packets_bad:6);
      gotoxy(24,7);
      write((buffer_num * 128):6);
    end;

(* <<<KHELP.PAS>>> *)
  procedure show; (* show the current parameters *)

    (* This procedure lists the current state of parameters for Kermit.
       There is a little cleanup to do in this area, as some are for
       future expansion and some will be implemented when a DEC-20 style
       command parser is implemented.
    *)

    begin (* show *)
      writeln('Current state of parameters are:');
      writeln;
      writeln(tab(2), 'Filetype (Filetype): ', file_str[file_type_var],'.');
      writeln(tab(2), 'Parity (PArity): ', parity_str[parity_type_var],'.');
      writeln(tab(2), 'Port: (POrt):', port_str[port_type_var],'.');
      writeln(tab(2), 'Escape sequence (constant): ^\ - C (Control-backslash ''C''.');
      writeln(tab(2), 'Packet size (Size): ', packet_size,'.');
      writeln(tab(2), 'Number of pad characters (Npad): ', npad,'.');
      writeln(tab(2), 'Pad character to send (PAD): char(',pad,').');
      writeln(tab(2), 'Check type (Checktype): ',chk_type,'.');
      writeln(tab(2), 'Debug mode (Debug): ', debug_mode, '.');
      writeln(tab(2), 'Number of retries: ', maxtry, '.');
      writeln(tab(2), 'Printer mode (PRinter): ', print_mode, '.');
      writeln;
      writeln('To change a parameter, type: SET <parameter> <value>');
      writeln('Valid parameters are shown in parentheses. Abbreviations are capitalized.');
    end; (* show *)


  procedure help;

    (* This procedure just lists the valid commands that can be typed on Turbo
       Kermit.
    *)

    begin
      clrscr;
      writeln('The following are valid commands:');
      writeln(tab(5),'Bye - Logout host, return to CP/M.');
      writeln(tab(5),'Connect - Connect to remote host and act as a terminal.');
      writeln(tab(5),'Exit - Return to CP/M.');
      writeln(tab(5),'Finish - Shut down remote server.');
      writeln(tab(5),'Get - Get the specified file(s) from the host.');
      writeln(tab(5),'Help - Display this help message.');
      writeln(tab(5),'Quit - Return to CP/M.');
      writeln(tab(5),'Receive - Receive a file from remote host.');
      writeln(tab(5),'SENd - Send a file to remote host.');
      writeln(tab(5),'SET - Set local Kermit parameter.');
      writeln(tab(5),'SHow - Show the current parameters.');
      writeln(tab(5),'Ctrl-D to abort transfer.');
      writeln;
      writeln(tab(3),'Allowable abbreviations are shown in capital letters.');
    end;

(*----------------------------------------------------------------*)

  procedure set_param; (* set a prameter *)

    (* This procedure is several case statements that read the arguments
       and try to adjust the parameters accordingly.  It will probably be
       replaced at a later time with a DEC-20 style command parser, so not
       much work will be done on it now to clean it up.
    *)

    var
      temp, code : integer;

    begin (* set_param *)
      case arg1[1] of
        'D', 'd' : begin
                     if (arg2 = 'ON') or (arg2 = 'on') then
                       begin
                         debug := true;
                         debug_mode := 'on';
                       end
                     else
                       begin
                         debug := false;
                         debug_mode := 'off';
                       end;
                     writeln('Debug mode is now ', debug_mode);
                   end;
        'F', 'f' : begin
                     case arg2[1] of
                       'A', 'a' : file_type_var := ascii;
                       'B', 'b' : file_type_var := binary;
                       else
                         writeln('Unknown file type.');
                     end; (* case *)
                     writeln('Filetype set to:  ', file_str[file_type_var]);
                   end;
        'P', 'p' : begin
                     case arg1[2] of
                       'A','a' : begin
                                   case arg2[1] of
                                     'N', 'n' : parity_type_var := no_parity;
                                     'M', 'm' : parity_type_var := mark_parity;
                                     'S', 's' : parity_type_var := space_parity;
                                     'E', 'e' : parity_type_var := even_parity;
                                     'O', 'o' : parity_type_var := odd_parity;
                                     else
                                     writeln('Parity type ', arg2, ' not allowed.');
                                   end; (* case *)
                                   writeln('Parity set to: ', parity_str[parity_type_var]);
                                 end;
                     'O','o' : begin
                                 case arg2[1] of
                                   'R', 'r' : begin
                                                port_type_var := comm;
                                                port := 2;
                                                port_iobyte :=
                                                  (base_iobyte and $fc) or port;
                                              end;
                                   'U', 'u' : begin
                                                port_type_var := uc1;
                                                port := 3;
                                                port_iobyte := (base_iobyte
                                                  and $fc) or port;
                                              end;
                                   else
                                     writeln('Invalid port selection.');
                                 end; (* case *)
                                 writeln('Port set to ', port_str[port_type_var]);
                               end;
                     'R','r' : begin
                                 if (arg2 = 'ON') or (arg2 = 'on') then
                                   begin
                                     printing := true;
                                     print_mode := 'on';
                                   end
                                 else
                                   begin
                                     printing := false;
                                     print_mode := 'off';
                                   end;
                                 writeln('Print logging is now ', print_mode);
                               end;
                     end; (* case *)
                   end;
        'R', 'r' : begin
                     val(arg2, temp, code);
                     if code <> 0 then
                       writeln('Retry count ', arg2, ' not allowed.')
                     else
                       begin
                         maxtry := temp;
                         writeln('Retry count set to ', retry, '.');
                       end;
                   end;
        else
          begin
            writeln('Parameter ', arg1, ' not allowed.');
          end;
      end; (* case *)
    end; (* set_param *)

(* <<<KREC.PAS>>> *)
(* receive related procedures are kept in this file *)

  procedure get_char(var character : integer);
    (* get an incoming character from a packet *)

    var
      temp, rec_data, rec_stat : integer;

    begin
      temp := 0;
      character := 0;
      abort := false;
      retry := false;

      repeat
        iobyte := port_iobyte; (* try to get char from kermit channel *)
        rec_stat := bios(1);
        if rec_stat <> 0 then (* there is a character pending *)
          if port_type_var = comm then (* handle comm with reader BDOS call *)
            character := bios(6)
          else
            character := bios(2); (* use console i/o for others *)
        iobyte := base_iobyte; (* check for a character from keyboard *)
        temp := bdos(6,$ff);
        if temp <> 0 then
          begin
            case temp of
              4 : abort := true; (* ^D aborts for now *)
              $0d : retry := true; (* cr forces end of packet *)
            end; (* case *)
          end;
      until ((rec_stat <> 0) or abort or retry); (* condition for exit *)
      if parity_type_var <> no_parity  then
        character := character and $7f; (* strip the parity bit *)
    end;

  procedure receive_packet;
    (* get a complete packet.  *)

    var
      rec_char, temp : integer;
      check_char, temp_char : char;
      check_ok : boolean;
      checksum, count, index : integer;


      procedure get_p_length;

        (* After getting a ^A, start of packet, the next character should be
           the length of the packet.  This procedure was pulled out of the
           main receive procedure to make it easier to handle a new packet
           coming in before the old one finished (characters lost, etc.)
        *)

        begin
          if not (abort or retry) then (* skip if forced by operator *)
            begin
              get_char(rec_char); (* we get a character *)
              checksum := rec_char; (* first char to checksum *)
              count := rec_char - 32; (* whats our packet length *)
            end;
        end;

    begin (* rec_packet *)
      checksum := 0; (* start with no checksum *)
      rec_packet := ''; (* no data in packet *)
      check_ok := false; (* if we haven't got a packet, it can't be any good *)
      packet_ok := false; (* same here *)
      repeat  (* get ^A *)
        get_char(rec_char);
      until ((rec_char = 1) or abort or retry);
      get_p_length; (* we got a ^A so we need the length of the packet *)
      if not (abort or retry) then
        begin
          repeat
            get_char(rec_char); (* should be packet type and data *)
            if rec_char = 1 then (* got new start of packet *)
              begin              (* clear ourselves out again *)
                rec_packet := '';
                get_p_length; (* get new length *)
              end
            else  (* must be a character *)
              begin
                rec_packet := rec_packet + chr(rec_char); (* add to packet *)
                checksum := checksum + rec_char; (* add in the checksum *)
                count := count - 1; (* decrement the character counter *)
              end;
          until (abort) or retry or (count = 0);
          packets_sent := packets_sent + 1; (* sent is a misnomer here *)
          if debug then (* show what we got *)
            begin
              gotoxy(1,12);
              write('rpack: ');
              for count := 1 to length(rec_packet) do (* print the packet *)
                begin
                  temp_char := rec_packet[count]; (* dummy for printing *)
                  if (temp_char > chr(127)) then (* 8th bit set *)
                    begin
                      write(''''); (* print ' to show 8th bit set *)
                      temp_char := chr(ord(temp_char) and $7f); (* strip eighth bit *)
                    end;                              (* and fall through *)
                  if (temp_char < ' ') then (* print ctl char with ^ *)
                    write('^' + ctl(temp_char))
                  else
                    write(temp_char); (* must be printable *)
                end;
            end;
          if not abort then (* lets check what we can about packet *)
            begin
              checksum := checksum - rec_char; (* subtract chksum char *)
              check_char := char40((checksum + ((checksum and 192) div 64))
                and 63);
              if debug then (* show the checksum expected and received *)
                begin
                  gotoxy(1,15);
                  write('Received checksum: ',rec_packet[length(rec_packet)],
                         ' Calculated checksum: ', check_char);
                end;
              if check_char = rec_packet[length(rec_packet)] then
                check_ok := true; (* good checksum *)
              rec_packet_num := unchar(rec_packet[1]); (* what kind of packet *)
              case rec_packet[2] of
                'B' : packet_type := break_pack;
                'D' : packet_type := data_pack;
                'E' : packet_type := error_pack;
                'F' : packet_type := header_pack;
                'N' : packet_type := nak_pack;
                'S' : packet_type := send_pack;
                'T' : packet_type := reserved_pack;
                'Y' : packet_type := ack_pack;
                'Z' : packet_type := end_pack;
                else packet_type := unknown;
              end; (* case *)
              if length(rec_packet) > 3 then (* clean off the packet number,
                                                packet type, and checksum *)
                begin
                  delete(rec_packet,1,2);
                  delete(rec_packet,length(rec_packet),1);
                end;
              if (check_ok) and (packet_type <> unknown) then
                packet_ok := true;
              if debug then
                begin
                  gotoxy(1,18);
                  write('packet ok: ',packet_ok);
                end;
            end;
        end;
    end; (* rec_packet *)

(* <<<KTERM.PAS>>> *)

(*----------------------------------------------------------------*)

  procedure send_char(character : integer);

    (* This procedure sends a character out of the port specified by
       the default condition or set by 'set port' command.  The currently
       supported ports are reader/punch and UC1:.  The output to the reader
       punch port is via the bios call to punch out.  This is to (hopefully)
       be able to output 8 bit data so binary files can be transfered
       directly.  The output to UC1: is done by changing the IOBYTE so
       the CON: port is UC1: and using a bios call.
       Notes: 1. The Digital Research manual specifies that input and output
                 to the console and reader punch port is done with the high
                 order bit set to 0.  I have heard from reliable sources that
                 this is not necessarily so, but it could cause a problem on
                 some systems.

       Input : integer value of character to be sent.
       Output : none.
       Variables affected: none;
    *)

    begin
      case port_type_var of
        comm : bios(5, character);
        uc1 : begin
                iobyte := port_iobyte; (* use current port *)
                bios(3, character);
                iobyte := base_iobyte; (* return to original port for console *)
              end;
      end; (* case *)
    end;

(*---------------------------------------------------------------*)

  procedure term; (* virtual terminal mode *)

    (* Term is the virtual terminal mode. Anything typed at the terminal
       is sent to the currently selected port, and anything the port
       receives is sent to the terminal.
       The terminal is port CON: and the default port is RDR:/PUN:.
       ^\C aborts the virtual terminal mode.  Cleanup is done by deleting all
       cahracters in the input buffer at the time the connection is opened.
       All I/O is done via bios calls.  No parity checking/stripping is done.
       Note: If I/O using read() and write() is done during port status
             checking, some incoming characters may be lost. I'm not sure
             why but it can hang you up totally.

       Input: none.
       Output : none.
       Variables affected: none.
    *)

    var
      letter, temp : integer;
      connect_exit : boolean;


    begin (* term *)
      connect_exit := false;
      temp := 0;
      writeln('Connected to remote host. Type Control-backslash c to return');
      writeln('to local Kermit.');
      iobyte := port_iobyte;
      while (bios(1) <> 0) do  (* clear the input buffer *)
        bios(2);
      repeat
        iobyte := port_iobyte;
        if bios(1) <> 0 then
          begin
            if port_type_var = comm then
              letter := bios(6)
            else
              letter := bios(2);
            iobyte := base_iobyte;
            bios(3, letter);
            if printing then
              bios(4, letter);
          end;
      iobyte := base_iobyte; (* make sure we're back at console *)
      if bios(1) <> 0 then
        begin
          letter := bios(2);
            case letter of (* check for escape sequence *)
              escape_char : begin
                              if temp = escape_char then
                                send_char(escape_char)
                              else
                                temp := escape_char;
                            end;
              $43, $63 : begin  (* handle upper and lower case  'C' *)
                           if temp = escape_char then
                             connect_exit := true
                           else
                             send_char(letter);
                           temp := 0;
                         end;
              else
                begin
                  if temp = escape_char then
                    begin
                      send_char(escape_char);
                      write(con, bell);
                    end;
                  send_char(letter);
                      temp := 0;
                    end;
            end; (* case *)
          end;
      until connect_exit;
      iobyte := base_iobyte; (* make sure we're back at CON: *)
    end; (* term *)

(* <<<KSEND.PAS>>> *)
    procedure check_init(var check_ok : boolean); (* check send init packet *)

      (* This procedure looks at the send init packet or the ack for one
         and matches the data to see if we can communicate.  IT sets up
         what it can if I can live with what the other guy wants.  I don't
         want to be picky if I can help it.  If he doesn't tell me everything
         I make some assumptions that should allow communications.
      *)

      var
        packet_length : integer;

      begin  (* we've got a packet we can work with *)
        if rec_packet_num = packet_num mod 64 then
          check_ok := true;
        packet_length := length(rec_packet);
        if packet_length >= 1 then
          begin
            if unchar(rec_packet[1]) in [4..94] then
              packet_size := unchar(rec_packet[1])
            else
              check_ok := false; (* packets < 4 and > 94 make no sense *)
          end;
        if check_ok then (* let's find out what he wants *)
          begin
            if packet_length >= 3 then (* skip timeout, I can't *)
              my_pad_num := unchar(rec_packet[3]); (* number of pad chars *)
            if packet_length >= 4 then
              my_pad_char := ctl(rec_packet[4]);
            if packet_length >= 5 then
              send_eol := unchar(rec_packet[5]);
            if packet_length >= 6 then
              begin
                if rec_packet[6] = ' ' then
                  his_ctl_quote := quote_char
                else
                  his_ctl_quote := rec_packet[6];
              end
            else
              his_ctl_quote := quote_char;
            if packet_length >= 7 then
              case rec_packet[7] of
                'N' : if quoting then (* we're deadlocked *)
                        check_ok := false;
                'Y' : ; (* we don't care, quoting is all set up *)
                '!'..'>','`'..'~' : begin (* we'll use his quote char *)
                                      quoting := true;
                                      quote_8 := rec_packet[7];
                                    end;
                else
                  check_ok := false; (* he didn't send me a valid char *)
              end (* case *)
            else
              if quoting then
                check_ok := false; (* I'm trying to quote and he won't
                                    acknowledge it *)
          end;
      end; (* check_init *)

  procedure check_ack; (* check ack states for most packets *)

    begin
      ack_ok := false; (* we'll assume a bad packet and prove otherwise *)
      receive_packet;
      if packet_ok and (not abort) then
        begin
          case packet_type of
            ack_pack : if rec_packet_num = packet_num mod 64 then
                         ack_ok := true; (* we better be exact on this one *)
            nak_pack : begin
                         if rec_packet_num = 0 then
                           rec_packet_num := 63
                         else rec_packet_num := rec_packet_num - 1;
                         if rec_packet_num = (packet_num mod 64) then
                           ack_ok := true; (* nak for next is ack for current *)
                       end;
            error_pack : begin (* he must be upset at me *)
                           gotoxy(1,9);
                           write(rec_packet);
                           abort := true;
                         end;
            else
              ack_ok := false; (* if it's another type try to keep sending
                                  I don't know if this is right, but it
                                  sounds logical. *)
          end; (* case *)
        end
      else
        ack_ok := false;
      if debug then
        begin
          gotoxy(1,16);
          write('ack_ok: ', ack_ok,'  packet_num: ',packet_num,
            '  rec_packet_num: ',rec_packet_num);
        end;
      if ack_ok = false then
        packets_bad := packets_bad + 1;
    end;

  procedure send_packet;

    (* This will send a packet that has been prepared by build packet, which
       does most of the work.
    *)

    var
      temp_char : char;

    begin (* send_packet *)
      iobyte := (iobyte and $fc) or port; (* set port *)
      while bios(1) <> 0 do
        bios(2); (* clear input buffer as Columbia recommends *)
      iobyte := (iobyte and $fc) or 1; (* set port to con: *)
      update(packets_sent, packets_bad); (* update the display with new info *)
      if debug then
        begin
          gotoxy(1,17);
          write('Packet length: ', length(packet_buffer));
          gotoxy(1,13);
          write('spack: ');
          for count := 1 to length(packet_buffer) do
            begin
              temp_char := packet_buffer[count]; (* make dummy var *)
              if ord(temp_char) > 127 then       (* 8th bit set *)
                begin
                  temp_char := chr(ord(temp_char) and $7f); (* strip 8th bit *)
                  write('''');  (* show ' for 8th bit and fall through *)
                end;
              if temp_char < ' ' then
                write('^' + ctl(temp_char))
              else write(temp_char);
            end;
        end;
      for count := 1 to length(packet_buffer) do
        send_char(ord(packet_buffer[count]));
    end; (* send_packet *)

(*----------------------------------------------------------------*)

  procedure build_packet;

      (* This procedure tacks on the things we need for a packet such as
         parity, checksum, padding, and the ^A.
      *)

      var
        checksum, count, index, bit_count : integer;
        temp_pack : string[150];

      begin (* build_packet *)
        checksum := 0;
        packet_buffer := ^A + char40(length(packet_buffer_data) + 2) +
                                char40(packet_num mod 64) + packet_buffer_data;
        for count := 2 to length(packet_buffer) do
          begin
            checksum := checksum + ord(packet_buffer[count]);
          end;
        checksum := ((checksum + ((checksum and 192) div 64)) and 63);
        packet_buffer := packet_buffer + char40(checksum) + chr(send_eol);
        if my_pad_num > 0 then (* add in the padding requested *)
          for count := 1 to my_pad_num do
            packet_buffer := my_pad_char + packet_buffer;
        case parity_type_var of
          mark_parity : for count := 1 to length(packet_buffer) do
                   packet_buffer[count] := chr(ord(packet_buffer[count]) or $80);
          space_parity : for count := 1 to length(packet_buffer) do
                   packet_buffer[count] := chr(ord(packet_buffer[count]) and $7f);
          even_parity, odd_parity : begin
                        for count := 1 to length(packet_buffer) do
                          begin
                            bit_count := 0;
                            temp_pack := packet_buffer;
                            for index := 1 to 7 do
                              begin
                                temp_pack[count] := chr(ord(temp_pack[count])
                                   shr 1);
                                if (ord(temp_pack[count]) and $01 = 1) then
                                  bit_count := bit_count + 1;
                              end;
                            if odd(bit_count) and (parity_type_var =
                              even_parity) then
                              packet_buffer[count] :=
                                chr(ord(packet_buffer[count]) or $80);
                            if (not odd(bit_count)) and (parity_type_var =
                              odd_parity) then
                              packet_buffer[count] :=
                                chr(ord(packet_buffer[count]) or $80);
                          end;
                      end;
        end; (* case *)
      end; (* build_packet *)

(*----------------------------------------------------------------*)

  procedure quit; (* return to CP/M. *)

    begin (* quit *)
      gotoxy(1,23); (* get cursor back below display *)
      halt;
    end; (* quit *)

  procedure finish; (* finish with server - bye, finish, logout, commands *)

    var
      try : integer;

    begin (* finish *)
      case line_command[1] of
        'F','f' : packet_buffer_data := 'GF';
        'B','b','L','l' : packet_buffer_data := 'GL';
      end; (* case *)
      packet_num := 0;
      try := 0;
      build_packet;
      repeat
        try := try + 1;
        send_packet;
        check_ack;
      until (abort) or (ack_ok) or (try > maxtry);
      if (try > maxtry) or abort then
        begin
          gotoxy(1,9);
          writeln('Unable to logout server.');
        end
        else
          case line_command[1] of   (* we only halt if 'bye' and we logged out *)
            'B','b' : halt;
          end; (* case *)
      gotoxy(1,23); (* get cursor back below display *)
    end; (* finish *)

(*----------------------------------------------------------------*)

  procedure send; (* send a file to remote host *)

    const
      eof_packet = 'Z';
      break_packet = 'B';

    var
      try : integer;
      send_done : boolean;

    procedure get_file_data; (* read in the file data *)

      var
        char_count : integer;
        temp : char;
        temp_data : string[120];
        end_of_file : boolean;

      begin
        packet_buffer_data := 'D';
        char_count := 1;
        end_of_file := false;
        while not (((filepointer > buffersize) and eof(outfile)) or
          (char_count >= (packet_size - 4)) or end_of_file) do
          begin
           if (filepointer > buffersize) then
             begin
               blockread(outfile, filebuffer, 1);
               filepointer := 1;
               buffer_num := buffer_num + 1;
             end;
           temp := filebuffer[filepointer];
           filepointer := filepointer + 1;
           if (ord(temp) > $7f) and quoting then
             begin
               packet_buffer_data := packet_buffer_data + quote_8;  (* add 8 bit quote char *)
               char_count := char_count + 1;
               temp := chr(ord(temp) and $7f);  (* strip high bit *)
             end;                               (* and fall through *)
           if (ord(temp) and $7f) < ord(' ') then
             begin
               packet_buffer_data :=
                 packet_buffer_data + quote_char + ctl(temp);
               char_count := char_count + 2;
             end
           else
             begin
               if (ord(temp) and $7f) = ord(quote_char) then
                 begin
                   packet_buffer_data := packet_buffer_data + quote_char;
                   char_count := char_count + 1;
                 end;
               packet_buffer_data := packet_buffer_data + temp;
               char_count := char_count + 1;
             end;
           if (file_type_var = ascii) then
             if temp = ^Z then
               begin
                 end_of_file := true;
                 delete(packet_buffer_data,length(packet_buffer_data) - 1, 2);
                  (* delete ^Z at end of packet *)
               end;
        end; (* while *)
        if (end_of_file or ((filepointer > buffersize) and eof(outfile))) then
          begin
            file_done := true;
            close(outfile);
          end
        else
          file_done := false;
      end;

    procedure sinit; (* do send init packet *)

      begin
        packet_num := 0;
        try := 0;
        if (parity_type_var <> no_parity) and (file_type_var = binary) then
            quote_8 := '&'  (* let's try to quote chars with 8'th bit set *)
                            (* We have to if we're to transmit binary *)
        else
          quote_8 := 'Y'; (* I'm willing to quote *)
        if repeating then
          repeat_char := '~'
        else
          repeat_char := ' ';
        packet_buffer_data :=  'S' + char40(packet_size) + char40(timeout)
                               + char40(npad) + ctl(pad) + char40(end_of_line)
                               + quote_char + quote_8 + chk_type
                               + repeat_char;
        build_packet;
        repeat
          ack_ok := false; (* assume its bad until proved otherwise *)
          packets_sent := packets_sent + 1;
          send_packet;
          receive_packet;
          if debug then
            begin
              gotoxy(1,22);
              write('got incoming packet');
            end;
          if (packet_ok and (packet_type = ack_pack) and (not abort)) then
            check_init(ack_ok);
          try := try + 1;
        until ack_ok or abort or (try = maxtry);
        if ack_ok then
          state := send_file_header
        else abort := true;
      end; (* sinit *)

    procedure sheader; (* send file header *)

      begin
        packet_num := packet_num + 1; (* next packet *)
        packet_buffer_data := 'F' + arg1;
        build_packet;
        try := 0;
        repeat
          send_packet;
          check_ack;
          try := try + 1;
        until ack_ok or abort or (try = maxtry);
        if ack_ok then
          state := send_file
        else
          abort := true;
      end; (* sinit *)


    procedure sfile; (* send the file data *)

      begin
        gotoxy(40,2);
        write('Sending...');
        repeat
          packet_num := packet_num + 1;
          get_file_data;
          if length(packet_buffer_data) > 1 then (* packet has data in it *)
            begin
              build_packet;
              try := 0;
              repeat
                send_packet;
                check_ack;
                try := try + 1;
              until ack_ok or abort or (try = maxtry);
            end;
        until file_done or abort or (try = maxtry);
        if file_done then
          state := send_eof
        else
          abort := true;
      end;

    procedure seof; (* send EOF packet *)

      begin
        packet_num := (packet_num + 1) mod 64;
        packet_buffer_data := eof_packet;
        build_packet;
        try := 0;
        repeat
          send_packet;
          check_ack;
          try := try + 1;
        until ack_ok or abort or (try = maxtry);
        if ack_ok then
          state := send_break
        else
          abort := true;
      end;

    procedure sbreak;

      begin
        state := send_break;
        packet_num := (packet_num + 1) mod 64;
        packet_buffer_data := break_packet;
        build_packet;
        try := 0;
        repeat
          send_packet;
          check_ack;
          try := try + 1;
        until ack_ok or abort or ( try = maxtry);
        if ack_ok then
          send_done := true
        else
          abort := true;
        end; (* sbreak *)

    begin (* send *)
      clrscr;
      packets_sent := 0;
      packets_bad := 0;
      send_done := false;
      displayt;
      open_file(read_open, arg1);
      if open_ok then
        begin
          filepointer := buffersize + 1; (* postion pointer beyond end of
                                            buffer so we get a record on entry
                                         *)
          state := send_init;
          repeat
            case state of
              send_init : sinit;
              send_file_header : sheader;
              send_file : sfile;
              send_eof : seof;
              send_break : sbreak;
            end; (* case *)
          until abort or send_done;
          if send_done then
            begin
              gotoxy(40,2);
              write('Completed.     ', bell);
            end
          else
            begin
              gotoxy(40,2);
              write('Aborted        ', bell);
            end;
          if abort and debug then
            begin
              gotoxy(1,18);
              writeln('Abort conditions were:');
              writeln('State during abort was: ', state_str[state]);
              writeln('Quoting was: ',quoting);
            end;
        end;
        gotoxy(1,23);
    end; (* send *)

(*----------------------------------------------------------------*)

  procedure send_ack;

    var
      q_var : char;

    begin (* send_ack *)
      if (state = receive_init) or (state = get_file) then
        begin
          if quoting then
            q_var := quote_8
          else
            q_var := 'N';
          packet_buffer_data :=  'Y' + char40(packet_size) + char40(timeout)
                               + char40(npad) + ctl(pad) + char40(end_of_line)
                               + quote_char + q_var + chk_type;

        end
      else
        packet_buffer_data := 'Y';
      build_packet;
      send_packet;
    end; (* send_ack *)

(*----------------------------------------------------------------*)

  procedure send_nak;

    begin
      packet_buffer_data := 'N';
      build_packet;
      send_packet;
    end;

(* <<<KREC1.PAS>>> *)
(*----------------------------------------------------------------*)

  procedure rheader;

    (* This procedure receives packets and looks for the file header
       packet.  If a good file header packet is found, it attempts to
       open the file.  If the file is opened suceesfully, the state
       changes to receive_file.  If the file cannot be opened ( the
       file open procedure will attempt to create a unique filename if
       the sepcified file already exists) an error packet is returned
       to the requesting kermit.  This procedure also handles send init
       packets and break packets as specified in the Kermit Protocol
       Manual.
    *)

    var
      try : integer;

    begin
      repeat
        receive_packet;
        if packet_ok then
          case packet_type of
            header_pack : begin
                            open_file(write_open, rec_packet);
                            if open_ok then
                              begin
                                filepointer := 1; (* postion at beginning of
                                                     buffer *)
                                packet_num := rec_packet_num;
                                gotoxy(40,2);
                                write('Receiving...   ');
                                send_ack;
                                state := receive_file;
                              end
                            else
                              begin
                                packet_buffer := 'ECannot open file';
                                build_packet;
                                send_packet;
                                abort := true;
                                gotoxy(1,9);
                                writeln('Cannot open file: ',rec_packet);
                              end;
                          end;
            send_pack : begin
                          packet_num := rec_packet_num;
                          send_ack;
                        end;
            break_pack : begin
                           packet_num := rec_packet_num;
                           send_ack;
                           abort := true;
                           gotoxy(60,1);
                           write('Completed.');
                           gotoxy(1,10);
                         end;
            end_pack : begin
                         packet_num := rec_packet_num;
                         send_ack;
                       end;
            unknown : begin
                        abort := true;
                        packet_num := rec_packet_num;
                        packet_buffer := 'EUnknown packet type.';
                        build_packet;
                        send_packet;
                        gotoxy(60,1);
                        write('Aborted.');
                        gotoxy(1,10);
                      end;
          end (* case *)
        else
          begin
            try := try + 1;
            packets_bad := packets_bad + 1;
            send_nak;
            if try = maxtry then
              begin
                abort := true;
                packet_num := 0;
                packet_buffer := 'ECannot get file header.';
                build_packet;
                send_packet;
                gotoxy(1,9);
                writeln('Cannot get file header.');
              end;
          end;
      until abort or (state = receive_file);
    end;

  procedure get; (* initiate server send *)

    (* This procedure attempts to initiate a server send.  It will send
       an 'R' packet with the filename specified in arg2 as typed by the
       user.  If a valid send init packet is received, the state changes
       receive_header.  If a valid send init packet cannot be received,
       an error packet is sent to the other Kermit after the specified
       number of retries.
    *)

    var
      try : integer;
      init_ok : boolean;

    begin
      clrscr;
      displayr;
      packet_num := 0;
      packet_buffer_data := 'R' + arg1;
      build_packet;
      try := 0;
      repeat
        send_packet;
        receive_packet;
        if packet_ok and (packet_type = send_pack) then
          begin
            packet_num := rec_packet_num; (* insure we've got packet num ok *)
            check_init(init_ok);
            if init_ok then
              begin
                send_ack;
                state := receive_header;
              end;
          end;
        if packet_type = error_pack then
          begin
            gotoxy(1,9);
            writeln(rec_packet);
            abort := true;
          end;
        if not (init_ok or abort) then
          begin
            packets_bad := packets_bad + 1;
            try := try + 1;
            send_nak;
          end;
        if ((try = maxtry)  or abort) then
          begin
            abort := true;
            packet_buffer_data := 'ECannot get send init packet';
            build_packet;
            send_packet;
            gotoxy(1,9);
            writeln('Cannot get send_init packet.');
          end;
      until abort or (state = receive_header);
    end;

  procedure rinit;

    (* This procedure waits for a send init packet.  It is used when a
       receive command is typed by the user.  Therefore this procedure
       will hang here until a valid send init packet is received, or the
       user aborts the process from the keyboard.
    *)

    var
      try : integer;
      init_ok : boolean;

    begin
      clrscr;
      displayr;
      try := 0;
      repeat
        receive_packet;
        if packet_ok and (packet_type = send_pack) then
          begin
            packet_num := rec_packet_num;
            check_init(init_ok);
            if init_ok then
              begin
                send_ack;
                state := receive_header;
              end;
          end
        else
          begin
            packets_bad := packets_bad + 1;
            send_nak;
            try := try + 1;
            if try = maxtry then
              begin
                abort := true;
                packet_buffer_data := 'ECannot get send init packet';
                build_packet;
                send_packet;
                gotoxy(1,9);
                writeln('Cannot get send_init packet.');
              end;
          end;
      until abort or (state = receive_header);
    end;

  procedure expand_packet;

    (* This procedure  performs any conversions neccessary on the
       received packet data.  Presently it only looks for the
       control quoting character and changes the character following it
       to the actual control character.  It may be expanded at a later
       time to handle repeat counts and eighth bit quoting.
       Note: The output data - 'received data' is set to null at the
             beginning of the procedure.  In order to have the string
             length correct, each new character is concatenated, not
             referenced by its position in the string.

       Input: rec_packet (global)
       Output: received_data (global)
    *)

    var
      inpos : integer;

    begin
      received_data := '';
      inpos := 1;
      while inpos <= length(rec_packet) do
        begin
          if (rec_packet[inpos] = quote_8)  and quoting then
            begin
              inpos := inpos + 1;
              if rec_packet[inpos] = his_ctl_quote  then
                 begin
                   inpos := inpos + 1;
                   received_data := received_data +
                                      ctl(chr(ord(rec_packet[inpos]) or $80));
                 end
              else
                  received_data := received_data + rec_packet[inpos];
              inpos := inpos + 1;
            end
          else
            begin
              if (ord(rec_packet[inpos]) and $7f) = ord(his_ctl_quote) then
                begin
                  inpos := inpos + 1;
                  if (ord(rec_packet[inpos]) and $7f) = ord(his_ctl_quote) then
                    received_data := received_data + rec_packet[inpos]
                  else
                    received_data := received_data + ctl(rec_packet[inpos]);
                end
              else
                begin
                  received_data := received_data + rec_packet[inpos];
                end;
              inpos := inpos + 1;
            end;
        end; (* while *)
    end;

  procedure rfile;

    (* This procedure receives file data from the remote Kermit.  It
       will continue until a break packet, end of transmission packet,
       or an unknown packet is received.  If there are too many retries,
       the procedure will abort, and an error packet will be sent to the
       other Kermit.
    *)

    var
      count, try : integer;

    begin
      repeat
        receive_packet;
        try := 0;
        case packet_ok of
          false : begin
                    try := try + 1;
                    if try = maxtry then
                      begin
                        abort := true;
                        packet_buffer := 'EToo many retries.';
                        build_packet;
                        send_packet;
                      end
                    else
                     send_nak;
                  end;
          true : begin
                   if packet_num = rec_packet_num then
                     send_ack
                   else
                     begin
                       packet_num := rec_packet_num;
                       case packet_type of
                         data_pack :
                           begin
                             expand_packet;
                             for count := 1 to length(received_data) do
                               begin
                                 if filepointer > buffersize then
                                   begin
                                     blockwrite(outfile,filebuffer,1);
                                     filepointer := 1;
                                     buffer_num := buffer_num + 1;
                                   end;
                                 filebuffer[filepointer] := received_data[count];
                                 filepointer := filepointer + 1;
                               end;
                             send_ack;
                           end;
                         end_pack :
                           begin
                             if file_open then (* send last record *)
                               begin
                                 if file_type_var = ascii then
                                   if filepointer <= buffersize then
                                     filebuffer[filepointer] := ^Z;
                                 blockwrite(outfile,filebuffer,1);
                                 close(outfile);
                                 file_open := false;
                               end;
                             send_ack;
                             state := receive_init;
                           end;
                         break_pack :
                           begin
                             if file_open then (* write last record *)
                               begin
                                 if file_type_var = ascii then
                                   if filepointer <= buffersize then
                                     filebuffer[filepointer] := ^Z;
                                 blockwrite(outfile,filebuffer,1);
                                 close(outfile);
                                 file_open := false;
                               end;
                             send_ack;
                             receive_done := true;
                           end;
                         unknown : begin
                                     send_nak;
                                   end;
                         else (* valid but wrong kind of packet *)
                           begin
                             abort := true;
                           end;
                       end; (* case *)
                     end;
                 end;
        end; (* case *)
      until abort or receive_done;
    end;

  procedure receive; (* receive state switcher *)

    (* This is the receive state switcher.  It will pass control to the
       apporpriate procedure as determined by each procedure above.
    *)

    begin
      packets_sent := 0;
      packets_bad := 0;
      buffer_num := 0;; (* for the byte count display *)
      receive_done := false;
      repeat
        case state of
          get_file : get;
          receive_init : rinit;
          receive_header : rheader;
          receive_file : rfile;
        end; (* case *)
      until (abort or receive_done);
      gotoxy(40,2);
      if receive_done then
        write('Completed.      ')
      else
        write('Aborted.        ');
      write(^G);
      gotoxy(1,10); (* get the cursor back below the display *)
    end; (* receive *)

(* <<<KCMD.PAS>>> *)

  procedure parse; (* separate the words on the command line *)

    begin (* parse *)
      line_command := '';
      arg1 := '';
      arg2 := '';
      arg3 := '';
      ltrim(line_buffer);
      if length(line_buffer) > 0 then
        rtrim(line_buffer);
      if length(line_buffer) > 0 then
        begin
          if pos(' ',line_buffer) > 0 then
            line_command := copy(line_buffer,1,pos(' ',line_buffer))
          else
            line_command := line_buffer;
        end;
      if pos(' ',line_buffer) > 0 then
        delete(line_buffer,1,pos(' ',line_buffer))
      else
        line_buffer := '';
      ltrim(line_buffer);
      if length(line_buffer) > 0 then
        begin
          if pos(' ',line_buffer) > 0 then
            arg1 := copy(line_buffer,1,pos(' ',line_buffer))
          else
            arg1 := line_buffer;
        end;
      if pos(' ', line_buffer) > 0 then
        delete(line_buffer,1,pos(' ',line_buffer))
      else
        line_buffer := '';
      ltrim(line_buffer);
      if length(line_buffer) > 0 then
        begin
          if pos(' ',line_buffer) > 0 then
            arg2 := copy(line_buffer,1,pos(' ',line_buffer))
          else
            arg2 := line_buffer;
        end;
      if pos(' ', line_buffer) > 0 then
        delete(line_buffer,1,pos(' ',line_buffer))
      else
        line_buffer := '';
      ltrim(line_buffer);
      if length(line_buffer) > 0 then
        begin
          if pos(' ',line_buffer) > 0 then
            arg3 := copy(line_buffer,1,pos(' ',line_buffer))
          else
            arg3 := line_buffer;
        end;
    end; (* parse *)

(*----------------------------------------------------------------*)

  procedure prompt; (* write the prompt message *)

    begin
      write('TKermit>');
    end;

(*----------------------------------------------------------------*)

  procedure get_cmd_line; (* read the command line *)

    begin
      readln(line_buffer);
      if length(line_buffer) > 0 then
        begin
          parse;
          case line_command[1] of
            'C','c' : term;
            'D','d' : dir;
            'E','e' : begin
                        case line_command[2] of
                          'R','r' : delfile;
                          'X','x' : quit;
                        end; (* case *)
                      end;
            'B','b','L','l','F','f' : finish;
            'G','g' : begin
                        clrscr;
                        state := get_file;
                        receive;
                      end;
            'H','h' : help;
            'Q','q' : quit;
            'R','r' : begin
                        clrscr;
                        state := receive_init;
                        receive;
                      end;
            'S','s' : begin
                        case line_command[2] of
                          'E','e' : case line_command[3] of
                                      'N','n' : send;
                                      'T','t' : set_param;
                                    end; (* case *)
                          'H','h' : show;
                        end; (* case *)
                      end; (* case s *)
            else
                writeln('Unimplemented command, type Help for list of commands.');
          end; (* case *)
        end;
    end;
