/*  "c64boot.c"  initial download program for Unix systems   *
 * program to download files to C64, modelled on C64BOOT.CLU
 *  sends lines, one at a time, each followed by a checksum.
 * the C64 validates cksum and returns "OK" or "NG".
 * last line cksum sent with leading "-" to signify eof.
 *  Although written on a Unix system, the C code contains
 *  no kernal calls and should be fairly portable.
 *  Written by:  Alastair Mayer, U. of Guelph, 2-Apr-85
 *               ( acdmayer@uoguelph.bitnet )
 */
#include <stdio.h>
#define BUFFMAX 256
#define EOS '\0'

main(argc,argv)
int argc;
char *argv[];
{

   char received[BUFFMAX],
        line[BUFFMAX];
   char *c;
   int  checksum = 0;
   int eof = 0;
   FILE *fd;

   if (argc>1)
      fd = fopen(argv[1],"r");
   if (fd == NULL) {
      fprintf(stderr,"%s: can't open '%s'\n",argv[0],argv[1]);
      exit(-1);
      }
   while (strcmp(received,"OK"))
       scanf("%[?\n]%*c",received);
      /* wait for starting "OK" */

   while ( (! eof) || (strcmp(received,"NG")==0)) {
       if (strcmp(received,"OK")==0) {
          line[0] = EOS;  /* clear it first */
          eof = (fscanf(fd,"%[?\n]%*c",line) < 0);
          }
       checksum = 0;
       for (c=line; *c ; c++) {
          putchar(*c);
          checksum += *c;
          }
       putchar('\n');
       if (eof) putchar('-');
       checksum &= 0177;
       putchar(checksum);
       putchar('\n');
       received[0] = EOS;  /* clear it in case we don't read anything */
       scanf("%[?\n]%*c",received);
       }
}
