
@make(manual)
@Style<Justification On, Hyphenation On, WidestBlank 1.4, Spacing 1,
        Spread 1, Indent 0, HyphenBreak Off, DoubleSided>
@modify(hd1,spacing 2,above 1,below 1)
@modify(hd2,spacing 2,above 1,below 1)
@modify(hd3,spacing 2,above 1,below 1)
@modify(hd4,spacing 2,above 1,below 1)
@PageHeading<Center "">

@tabclear
@tabs(12,42,54)
@begin(TitlePage2)
@begin(Titlebox)
@majorheading(KERMIT-65 USERS GUIDE)
@heading<Commodore 64 Version 1.7(52)>
@end(Titlebox)
@begin(heading)
Eric Lavitsky

Center For Computer and Information Services
Rutgers University
Piscataway, New Jersey

This Copy Was Produced On:
@value(weekday), @value(Date) at @value(time)
Using Scribe @value(scribeversion)
@end(heading)
@end(TitlePage2)

@set(page=1)
@PageHeading(Even,Left="Page @ref(page)",Right="@b<C64 KERMIT User Guide>")
@PageHeading(Odd,Left="@b<@Title[Chapter]>",Right="Page @ref(page)")

@chapter(Introduction)
@section(Overview)

@begin<description,leftmargin +12,indent -12,spread 0>
@i(Authors:)@\David Dermott, DREA
	@\Eric Lavitsky, Rutgers University
	@\Michael Marchiondo, University of New Mexico
	@\Frank Prindle, Naval Air Development Center

@i(Documentation:)@\Eric Lavitsky,
Rutgers University

@i(Version:)@\1.7(52)

@i(Date:)@\August 1985
@end<description>

@i<C-64 Kermit-65 Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\No
^X/^Y interruption:@\Yes
Filename collision avoidance:@\Yes
Can time out:@\Yes
8th-bit prefixing:@\Yes
Repeat count prefixing:@\No
Alternate block checks:@\No
Terminal emulation:@\Yes
Communication settings:@\Yes
Transmit BREAK:@\Yes
IBM communication:@\Yes
Transaction logging:@\No
Session logging (raw download):@\No
Raw upload:@\No
Act as server:@\No
Talk to server:@\Yes
Advanced commands for servers:@\No
Local file management:@\Yes
Handle file attributes:@\No
Command/init files:@\Yes
Printer control:@\No
@end(format)

KERMIT-65 is a program that implements the KERMIT file transfer
protocol for the Commodore 64 micro computer system. It is written
in 6502 assembly language and should run on any C64. KERMIT-65 also
Converts your C64 into a powerful computer terminal. It emulates the
popular Digital Equipment Corporation VT52 terminal or a simple
glass TTY.  The program handles all conversion of Commodore to
standard ASCII and can display all 96 standard ASCII characters. 

@tabs(12,42,54)
@section(System Requirements)

What you will need:
@begin(itemize, spread 0)

C64 and Disk drive

Modem - any will do (300/1200, VIC, RS232)

Supermon64.V1	(or any equivalent relocatable monitor)

@end(itemize)

@chapter(Implementation Notes)
@section(Known Bugs, Restrictions)


C64 KERMIT-65 is still under development and may have some minor
defficiencies. 

	The known bugs and restrictions are as follows:
@begin(itemize,spread 0)
 The SET BAUD option is not fully implemented. To get speeds under
300 baud, you will have to set the RS232-REGISTERS directly. Special
patches to the Kernel RS232 routines have been implemented to allow
reliable operation at 1200 baud. 1800 and 2400 baud have not been so
patched. 

 If you change the RS232-REGISTERS directly, the change will not be
reflected in the BAUD, PARITY, or WORD-SIZE parameters.

 If a KERMIT.INI file is not present on the disk, the parameters in
memory get garbaged to an unusable state and must be reset by hand.

 To create a new KERMIT.INI file with the SAVE command, the old
KERMIT.INI file must first be scratched with the DISK command :
(DISK S0:KERMIT.INI).
@end(itemize)

@section(HINTS)


  If you wish to  edit BASIC programs on  the mainframe system,  you
should convert them to  text files on the  C64 before you send  them
since the  BASIC interpreters  store  keywords as  single  character
tokens. If the receiving system does not handle eight-bit ASCII or
CBM ASCII characters well, KERMIT-65 should have its FILE-BYTE-SIZE
set to SEVEN-BIT. It will send standard seven-bit ASCII to the
receiving KERMIT. When KERMIT-65 is receiving from such a system,
this will pick up the seven-bit characters and write out CBM ASCII
on the disk file.

@section(Notes)

Please note that typing a '^X' (control-x) at anytime during a file
transaction will quit the current transaction, closing the current
file. Kermit can also be forced to 'timeout' by typing a space at
any point in the transaction. Kermit will then resend the current
packet. 

@section(KERMIT Runtime Memory Map)

@begin(format)
Location@\Description
--------@\------------------------------------

$0801-$83ff@\Kermit program area (Reserved Area)
$8400-$87ff@\Video matrix for both 40 and 80 column modes
$8800-$8fff@\Character set 1 ram for 40 column mode
$9000-$90ff@\RS-232 output buffer
$9100-$91ff@\RS-232 input buffer
$9200-$9fff@\Reserved for future use
$a000-$bfff@\Hires screen (80 columns)
@end(format)

@section(Future Plans)

The following items are under consideration for implementation in
future versions of Kermit. Please mail any comments or suggestions
to the authors, or implement it yourself and notify the authors.

@begin(enumerate)
Disk routines could be changed (Use TALK routines instead of CHRIN)

Cursor blink rate in parser must be slowed down

For sending files, jiffy wait should be a function of current baud rate!

Implement 4 & 5 with a flag indicating connect or command mode.

Ability to pause display in parser (CBM key)

Add disk commands:
@tabclear
@tabdivide(7)
@begin(format)

@\Kermit-65>SCRATCH file
@\Kermit-65>RENAME newfile=oldfile
@end(format)

Change status display scheme for transfer:
@begin(verbatim)

 -----------------------------------------------------------------

	Packets: 0		   Status...
	Retries: 0
	Filename: FILENAME.EXT

 -----------------------------------------------------------------

	Packets: 0		   Status...
	Retries: 0
	Filename: FILENAME.EXT

	Additional Data	
		Seq Number		00
		Number Of Data Chars	00
		Packet Checksum		00

 -----------------------------------------------------------------

	etc., etc... something like this anyway - The screen
	shouldn't constantly be cleared and redrawn. All pertinent
	fields should be written once and then updated as 
	necessary.

	Implement using plot function to move cursor to correct
	position. For Verbose debug, display packet info two lines
	beneath filename. 

 -----------------------------------------------------------------
@end(verbatim)

Ability to change screen colors:
@begin(format)

@\@\Kermit-65>SET COLOR nn

@end(format)

Add capability of selecting default drive and unit number for transfer.

Implement wildcard send  - need info on 1541 DOS for this!

Disk command parsing should use CMUNQS (unquoted string) parse.
@end(enumerate)

@chapter(Running KERMIT)
@section(Booting KERMIT)

Insert your working KERMIT-65 disk into the 1541 drive label side up.
Type the following:
@begin(verbatim)

	LOAD"KERMIT",8 <cr>
	RUN <cr>
@end(verbatim)

 The screen will come up with the following message:

@begin(format)

@\@b[Commodore 64 Kermit Version 1.7(52)]
@\@b[40 Column Mode - ? For Help]

@\@b[Kermit-65>]

@end(format)

 You are now in the KERMIT-65 parser which is modeled after the COMND parser
of the TOPS-20 Operating System from Digital Equipment Corporation. You may
now type commands to the parser to set options or begin actions.

During interactive operation, you may use the ?-prompting help feature
("?") and recognition (ESC) features while typing commands (The ESC
character is presently ^[ - control Left Bracket or the left arrow
key).  A question mark typed at any point in a command displays the
options available at that point; typing an ESC character causes the
current keyword to be completed (or default value to be supplied).
If you have not typed sufficient characters to uniquely specify the
keyword or filename (or if there is no default value) then a beep
will be sounded and you may continue typing.  Keywords may be
abbreviated to any prefix that is unique. 

@section(Commands in KERMIT)

Commands available in version 1.7 of Kermit-65 are:
@tabclear
@tabdivide(7)
@begin(format)
@b[
@\BYE@\CONNECT@\DIRECTORY@\DISK@\EXIT@\FINISH
@\GET@\QUIT@\RECEIVE@\RESTORE@\SAVE@\SEND
@\SET@\SHOW@\STATUS]
@end(format)

@begin(description)
@b[BYE]@\@\    This command will cause  Kermit-65  to tell a server Kermit
          at the other end of the connection to exit from Kermit and,
          if applicable, terminate its job (or  process, etc.).
@blankspace(1 lines)

@begin(center)                     
@b[KERMIT-65>]BYE
@end(center)

@end(description)
@begin(description)
@b[CONNECT]@\@\The  CONNECT  command will allow you to connect to a  remote
          job over the terminal line as a virtual terminal. The format
          of the CONNECT command is:
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]CONNECT
@end(center)

@\@\To get back to the Kermit parser, type the escape character
followed by a 'C'. The default escape character is ^Y (control-Y),
so to return to Kermit-65 you would type '^YC'. There are other
options to the escape character, these may be seen by typing a '?'
after typing the escape character:

@begin(verbatim)
	ONE OF THE FOLLOWING:
	    ? - THIS HELP MESSAGE.
	    B - SEND A BREAK SIGNAL.
	    C - CLOSE THE CONNECTION.
	    S - STATUS OF CONNECTION.
	    0 - SEND A NULL.
	    ESCAPE-CHAR - TRANSMIT THE ESCAPE CHARACTER.
@end(verbatim)

@end(description)

@begin(description)
@b[DIRECTORY]@\@\The DIRECTORY command will return a directory of
the the specified files. The format is:
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]DIRECTORY [file-specification]
@end(center)

@\For example:

@tabclear
@tabdivide(12)
@begin(format)
@\DIRECTORY     @\Directory of all files on drive 0
@\DIRECTORY ker*@\Directory of files KER*
@\DIRECTORY k?w @\Files 3 chars long, beg w/K, end w/W
@end(format)
@tabclear
@tabdivide(7)

@\You may pause the directory display by typing a space and continue 
it by typing any character.

@end(description)

@begin(description)
@b[DISK]@\@\The DISK command will allow you to send commands
directly to the disk drive controller. An empty command field will
return the error status of the disk drive, if any. 
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]DISK  [string]
@end(center)

@\For example:

@tabclear
@tabdivide(12)
@begin(format)
@\DISK S0:K*  @\-- delete K* on drive 0:
@\DISK I0     @\-- initialize BAM on drive 0:
@\DISK        @\-- print error status, if any
@end(format)
@tabclear
@tabdivide(7)

@end(description)

@begin(description)
@b[EXIT]@\@\The EXIT command will cause Kermit to return to BASIC command
level. This command is the same as the QUIT command. An example of
this command is: 
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]EXIT
@end(center)

@end(description)
@begin(description)
@b[FINISH]@\@\This command will cause  Kermit-65  to tell a server Kermit
          at  the  other end of the connection to exit  from  Kermit.
          When  Kermit-65  receives the acknowledgement that  this is
          being done, Kermit-65 will prompt for another command.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]FINISH
@end(center)

@end(description)
@begin(description)
@b[GET]@\@\   This command can only be used in 'user' mode.  It will cause
          Kermit-65  to  request  that the other Kermit (which must be
          running  in  server mode)  transmit  the  specifed  file  to
          Kermit-65.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]GET file-specification
@end(center)

@\@\Where "file-specification"  is a  valid file  specification for  the
system on which the other Kermit is running.
@end(description)

@begin(description)
@b[QUIT]@\@\  This command will cause Kermit-65 to return to BASIC command
          level. This is the same as the EXIT command.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]QUIT
@end(center)

@end(description)
@begin(description)
@b[RECEIVE]@\@\The RECEIVE command is used to  put  Kermit-65  into  remote
          mode  waiting for a single file transfer transaction.  If no
          file specification is given, Kermit-65 will wait for a  file
          transfer  initialization sequence from the other Kermit.  If
          a file specification is given, that file specification  will
          be  used  to  store the received file(s), regardless of what
          name is supplied by the other Kermit.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]RECEIVE
@end(center)

          or

@begin(center)
@b[KERMIT-65>]RECEIVE file-specification
@end(center)

@\@\Where "file-specification" is any valid  CBM  DOS  file specification.
@end(description)

@begin(description)
@b[RESTORE]@\@\The RESTORE command is used to restore kermit
parameters that have been previously saved with the SAVE command.
Kermit will search the disk for a file name KERMIT.INI. If the file
is present on disk, Kermit will load in the parameters contained
therein and restart itself with those parameters. 
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]RESTORE
@end(center)

@end(description)

@begin(description)
@b[SAVE]@\@\The SAVE command will save the current Kermit settings
and parameters in a file called KERMIT.INI . The parameters may
later be restored with the RESTORE command.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SAVE
@end(center)

@end(description)

@begin(description)
@b[SEND]@\@\  The  SEND  command will allow you  to send  a  file  to  the
          other  Kermit.  The command format is:
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SEND file-specification
@end(center)

@\@\Where "file-specification" is any normal CBM DOS file specification.
@end(description)

@begin(description)
@b[SET]@\@\   The SET command is used to set various parameters in Kermit.
          The format of the command is:
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET <option> <suboption> ...
@end(center)

@\@\The options available to SET are:
@end(description)

@begin(format)
@tabclear
@tabdivide(4)
@b[
@\BAUD@\DEBUGGING@\EIGHT-BIT-QUOTING
@\ESCAPE@\FILE-BYTE-SIZE@\FILE-TYPE
@\FILE-WARNING@\FLOW-CONTROL@\IBM
@\LOCAL-ECHO@\PARITY@\RECEIVE
@\RS232-REGISTERS@\SCREEN-WIDTH@\SEND
@\VT52-EMULATION@\WORD-SIZE]
@end(format)
@tabclear
@tabdivide(7)

@\@\A description of the options and suboptions follows.

@begin(description)
@b[SET BAUD]@\@\The SET BAUD command is used to set the speed at
which communications will take place.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET BAUD value
@end(center)

@\@\Where value is from the following table:

@begin(format)
@tabclear
@tabdivide(8)
@b[
@\@\50@\75
@\@\110@\150
@\@\300@\1200
@\@\1800@\2400]
@end(format)
@tabclear
@tabdivide(7)
@end(description)

@begin(description)
@b[SET DEBUGGING]@\@\The SET DEBUGGING command is used to set  the
debug  type  out on the user's terminal. 
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET DEBUGGING keyword
@end(center)

@\@\Where keyword is either OFF, TERSE, or VERBOSE.  OFF  causes
all debugging output to be suppressed.  TERSE directs a copy
of each packet to the screen printing any control characters
as '^char'.  VERBOSE  prints identifying text for each field
in the header  and  prints the actual data  section  of  the
packet in the same manner TERSE uses.
@end(description)

@begin(description)
@b[SET EIGHT-BIT-QUOTING]@\This  command  will turn on or turn  off  the
          eight-bit-quoting feature.  If set ON,  it forces  Kermit-65
          to  use  eight-bit-quoting  which may be handy  if  it  must
          receive  a text file in which some or all of the  characters
          are  not in CBM ASCII.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET EIGHT-BIT-QUOTING keyword
@end(center)

@\@\Where keyword is ON or OFF.

@end(description)

@begin(description)
@b[SET ESCAPE]@\@\ This command will set  the  escape  character
          for  the CONNECT processing.  The command will take the  hex
          value of the character to use as the escape character.  This
          is the character which is used to "escape" back to KERMIT-65
          after using the CONNECT command. It defaults to ^Y (hex 19).
          It is usually a good idea to set this character to something
          which is not used  (or at least not used very much)  on  the
          system to which KERMIT-65 is CONNECTing.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET ESCAPE hex-character-value
@end(center)

@\@\Where   hex-character-value  is  the  ASCII  value  of   the
character to use as the escape character (in hex).
@end(description)

@begin(description)
@b[SET FILE-BYTE-SIZE]@\This command sets  the  byte  size  KERMIT-65
          will use for files being received or transmitted.  SEVEN-BIT
          bytes should be used for ASCII text files which  are  to  be
          used  as text files on the  CBM  DOS system. EIGHT-BIT bytes
          should  be  used for binary files being transferred  to  and
          from the  C64.  This  allows the file to be returned without
          any changes.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET FILE-BYTE-SIZE size
@end(center)

@\@\Where size is SEVEN-BIT or EIGHT-BIT.
@end(description)

@begin(description)
@b[SET FILE-TYPE]@\This  command tells Kermit-65 what type of  file
          is  being  sent  or  received.  It is  important  that  this
          parameter  is  set correctly since it is used  to  determine
          the  exact  file  length when sending files in  addition  to
          determining  special  processing which may have to  be  done
          (i.e.  When  receiving a text  file,  write  all  characters
          in CBM ASCII.). The format of this command is:
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET FILE-TYPE type
@end(center)

@\@\Where type is ASCII, BINARY, PETASCI or SCRIPT. BINARY is  a
core image (and is normally transferred in eight-bit mode). ASCII 
is any file of ASCII text. PETASCI is a CBM ASCII file. SCRIPT is a
file produced by the SPEEDSCRIPT wordprocessor, which was published
in the Gazzette! Magazine.
@end(description)

@begin(description)
@b[SET FILE-WARNING]@\This command determines what  KERMIT-65  will
          do  when  it  receives  a file with a file name that already
          exists.  If FILE-WARNING is turned ON,  KERMIT-65  will  not
          supersede  the old file.  Instead it will create a file with
          the original file name plus a '.0' appended to it.  It  will
          increment the 'version' number until it succeeds in creating
          a  unique file name.  If  FILE-WARNING  is turned  OFF  (the
          default), Kermit-65 will supersede the old file.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET FILE-WARNING keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET FLOW-CONTROL]@\The SET FLOW-CONTROL command will enable the
	  selection of XON/XOFF flow control if desired. This option
	  is recommended set for communication speeds of 1200 baud
	  or higher.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET FLOW-CONTROL keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET IBM]@\@\The  SET IBM  command  allows  KERMIT-65   to
          be  put  into  a  mode  which will allow transfers to an IBM
          host.  This causes KERMIT-65 to wait for the IBM  turnaround
          character (XON, CTRL-Q) before sending any characters to the
          other Kermit.  It also forces the parity type  to  be  mark,
          the word length to be seven-bit, turns on local echo for the
	  CONNECT command and turns off flow-control.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET IBM keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET LOCAL-ECHO]@\ The SET LOCAL-ECHO command specifies  whether
          characters  should  be  echoed  locally  when  CONNECTing to
          another system.  If LOCAL-ECHO is set to ON,  any  character
          typed  on  the  terminal  will  be echoed immediately to the
          terminal, as well as being sent to  the  other  system.   If
          LOCAL-ECHO is set to OFF (the default), the characters typed
          on the terminal are only sent to  the  other  system  (which
          would normally be echoing the characters).
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET LOCAL-ECHO keyword
@end(center)

@\@\Where keyword is either ON or OFF.
@end(description)

@begin(description)
@b[SET PARITY]@\@\      This command determines the type of parity to
          use   on   the  transmission  line.   Kermit  normally  uses
          characters which consist of eight data bits with  no  parity
          bit.   For  systems  or  transmission  media which require a
          specific parity type, Kermit can send  characters  as  seven
          data bits plus a parity bit.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET PARITY keyword
@end(center)

@\@\Where keyword is one of:

@begin(enumerate)
@b[NONE] (default) - eight data bits and no parity bit.

@b[MARK] - seven data bits with the parity bit set to one.

@b[SPACE] - seven data bits with the parity bit set to zero.

@b[EVEN] - seven data bits with the parity bit set  to  make
the overall parity even.

@b[ODD] - seven data bits with the parity bit  set  to  make
the overall parity odd.
@end(enumerate)

@end(description)

@begin(description)
@b[SET RECEIVE]@\@\     It is  possible  to  set  various  parameters
          associated  with  the  receiving of the data from the remote
          Kermit.  SET RECEIVE will enable  you  to  set  the  various
          receive parameters.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET RECEIVE <suboption>
@end(center)

@\@\The suboptions of this SET command are:

@end(description)

@begin(format)
@tabclear
@tabdivide(6)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@begin(description)
@b[SET RECEIVE EIGHT-BIT-QUOTE-CHAR]@\ This    command    sets    the
          character  to  be  used (when necessary) to quote characters
          which have the eighth bit (parity bit) set.  This is used to
          transfer eight-bit bytes on a transmission medium which only
          supports seven data bits.  The default value  is  26  (ASCII
          "&").  Eight-bit-quoting  will only be used if both Kermit's
          can handle it, and the tranmission medium does not  transmit
          8 data bits (as indicated by the SET PARITY command).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE EIGHT-BIT-QUOTE-CHAR nn
@end(center)

@\@\Where  nn  is the ASCII value of the character  (in hex)  to
use for quoting characters which have the eighth bit set.
@end(description)

@begin(description)
@b[SET RECEIVE END-OF-LINE]@\This will set the end of line  character that
          KERMIT-65  expects  to receive from the remote Kermit.  This
          is the character which terminates  a  packet.   The  default
          value is 0F (ASCII CR, CTRL-M).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE END-OF-LINE nn
@end(center)

@\@\Where nn is the ASCII value of the character to use for  the
end of line character (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE PACKET-LENGTH]@\       This  will  set  the   receive
          packet length.  The value for this parameter must be between
          10 and  96.   Packet  lengths  outside  of  this  range  are
          illegal.  The default value is 5E (94 decimal).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PACKET-LENGTH nn
@end(center)

@end(description)
@begin(description)
@b[SET RECEIVE PAD-CHAR]@\This parameter is the padding character  that
          is expected from the remote Kermit.  The parameter must be a
          hex  number  in the range of  0  to  1F  or  7F.  All  other
          values are illegal.  The default value is 0 (an ASCII NUL).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PAD-CHAR nn
@end(center)

@\@\Where nn is the  ASCII value of  the character to be  used as a  pad
character (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE PADDING]@\This command will set the number  of  padding
          characters that will be expected from the other Kermit.  The
          default value is 0.

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE PADDING nn
@end(center)

@\@\Where nn is the hex number of padding characters to use.
@end(description)

@begin(description)
@b[SET RECEIVE QUOTE-CHAR]@\This will  set  the  quoting  character  that
          KERMIT-65  will  expect  on  incoming messages.  This is the
          character used to quote  control  characters.   The  default
          value is 23 (ASCII "#").

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE QUOTE-CHAR nn
@end(center)

@\@\Where  nn is the ASCII value of the  quoting  character  (in hex).
@end(description)

@begin(description)
@b[SET RECEIVE TIMEOUT]@\This will set the number of seconds that
Kermit will wait for acknowledgement before it will retry sding or
receiving the current packet (during a RECEIVE or GET). The default
value is 15 seconds. 

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET RECEIVE TIMEOUT nn
@end(center)

@\@\Where nn is the number of seconds to wait for a message from the
remote kermit (in hex).
@end(description)

@begin(description)
@b[SET RS232-REGISTERS]@\This sets the 2 registers for controlling
the baud rate, parity etc. The 2 registers are treated as a 16 bit
hex integer. The first 2 digits are the SECOND register and the last
2 digits are the FIRST register. If only 2 digits are entered, the
second register is cleared. Examples:

@blankspace(1 line)
@\@b[KERMIT-65>]SET RS232-REGISTERS 0006 (or SET RS 06) sets the
registers to 06,00 for 300 baud, 8 bit, no parity (this is the default)

@\@b[KERMIT-65>]SET RS232-REGISTERS A026 sets the registers to 26,A0
for 300 baud, 7 bit, parity mark.


@\See the C64 reference manual for a complete description of all
the bits in the 2 registers. 
@end(decription)

@begin(description)
@b[SET SCREEN-WIDTH]@\ This option will let you choose the working screen
width for Kermit. 40 columns is the default, but many mainframes
will operate better with an 80 column screen width. The 80 column
option requires no extra hardware. The 80 column screen is
implemented using a hires bit mapped screen and can be viewed on any
TV or monitor. Choosing this option will restart Kermit in the
selected mode (all options set up to this point will remain intact).
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET SCREEN-WIDTH keyword
@end(center)

@\@\Where keyword is either 40-COLUMNS or 80-COLUMNS

@end(description)

@begin(description)
@b[SET SEND]@\@\It is possible to set various parameters associated with the
          sending  of  data  to  the  remote  Kermit.  SET  SEND  will
          enable you  to  set  the  various  SEND  parameters.   These
          parameters  should not normally be set since, as part of the
          transfer initialization process, the  two  Kermits  exchange
          their  RECEIVE  parameters.  The capability of setting these
          parameters is provided so that the  transfer  initialization
          can  be  completed  even  if  the default parameters are not
          correct.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET SEND <suboption>
@end(center)

@\@\The suboptions of this SET command are:

@end(description)

@begin(format)
@tabclear
@tabdivide(6)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT
]
@end(format)
@tabclear
@tabdivide(7)

@begin(description)
@b[SET SEND EIGHT-BIT-QUOTE-CHAR]@\    This    command    sets    the
          character  to  be  used (when necessary) to quote characters
          which have the eighth bit (parity bit) set.  This is used to
          transfer eight-bit bytes on a transmission medium which only
          supports seven data bits.  The default value  is  26  (ASCII
          "&").  Eight-bit-quoting  will only be used if both Kermit's
          can handle it, and the tranmission medium does not  transmit
          8 data bits (as indicated by the SET PARITY command).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND EIGHT-BIT-QUOTE-CHAR nn
@end(center)

@\@\Where  nn  is the ASCII value of the character  (in hex)  to
use for quoting characters which have the eighth bit set.
@end(description)

@begin(description)
@b[SET SEND END-OF-LINE]@\This will set the end of line  character that
          KERMIT-65  will  send  to  the  remote  Kermit.  This is the
          character which terminates a packet.  The default  value  is
          0F (ASCII CR, CTRL-M).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND END-OF-LINE nn
@end(center)

@\@\Where nn is the ASCII value of the character to use  for the
end of line character (in hex).
@end(description)

@begin(description)
@b[SET SEND PACKET-LENGTH]@\This will set the send  packet  length.   The
          value  for this parameter must be between 10 and 96.  Packet
          lengths outside of this  range  are  illegal.   The  default
          value is 5E (94 decimal).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PACKET-LENGTH nn
@end(center)

@end(description)
@begin(description)
@b[SET SEND PAD-CHAR]@\This parameter is the padding character  that
          is  sent  to  the  remote  Kermit.  The parameter must be an
          hex  number in the range of  0  to  1F  or  7F.   All  other
          values are illegal.  The default value is 0 (an ASCII NUL).

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PAD-CHAR nn
@end(center)

@\@\Where nn  is the ASCII value of the character to be used  as
a pad character (in hex).
@end(description)

@begin(description)
@b[SET SEND PADDING]@\ This command will set the number  of  padding
          characters  that  will  be  sent  to  the other Kermit.  The
          default value is 0.

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND PADDING nn
@end(center)

@\@\Where nn is the hex number of padding characters to use.
@end(description)

@begin(description)
@b[SET SEND QUOTE-CHAR]@\This will  set  the  quoting  character  that
          KERMIT-65  will  send  in  outgoing  messages.  This is  the
          character used to quote  control  characters.   The  default
          value is 23 (ASCII "#").

@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET SEND QUOTE-CHAR nn
@end(center)

@\@\Where nn  is the ASCII value of the  quoting  character  (in hex).
@end(description)

@begin(description)
@b[SET SEND TIMEOUT]@\Set the time in seconds that Kermit will
wait for an acknowledgement before it will retry sending or
receiving the current packet (during a SEND). The default value is
15 seconds.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET SEND TIMEOUT nn
@end(center)

@\Where nn is the number of seconds to wait for a message from the
remote kermit (in hex).
@end(description)
@begin(description)
@b[SET VT52-EMULATION]@\This   switch   determines  whether   or   not
          Kermit-65  will  act like a VT52 when it is  CONNECTed to  a
          remote Kermit. The possible values for the switch are ON and
          OFF. The default is ON.
@blankspace(1 line)
@begin(center)
@b[KERMIT-65>]SET VT52-EMULATION OFF
@end(center)

@end(description)

@begin(description)
@b[SET WORD-SIZE]@\@\This option will set the word length for
communication.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SET WORD-SIZE size
@end(center)

@\@\Where size is either SEVEN-BIT or EIGHT-BIT
@end(description)

@begin(description)
@b[SHOW]@\@\The  SHOW  command  will  allow  you  to  show  the  various
          parameters  that  are  set with the SET command.
@blankspace(1 lines)

@begin(center)
@b[KERMIT-65>]SHOW <option> <suboption>...
@end(center)

@\@\The options available to SHOW are:

@end(description)

@begin(format)
@tabclear
@tabdivide(4)
@b[
@\ALL@\BAUD@\DEBUGGING
@\EIGHT-BIT-QUOTING@\ESCAPE@\FILE-BYTE-SIZE
@\FILE-TYPE@\FILE-WARNING@\FLOW-CONTROL
@\IBM@\LOCAL-ECHO@\PARITY
@\RECEIVE@\RS232-REGISTERS@\SEND
@\VT52-EMULATION@\WORD-SIZE]
@end(format)
@tabclear
@tabdivide(7)

@\@\A description of the options and suboptions follows.

@begin(description)
@b[SHOW ALL]@\@\The SHOW ALL command will cause all of the parameters to  be
          listed.

@end(description)

@begin(description)
@b[SHOW BAUD]@\@\Shows the current Baud rate.

@end(description)

@begin(description)
@b[SHOW DEBUGGING]@\@\Display  whether  debugging  is  off, in terse
          mode, or in verbose mode.

@end(description)
@begin(description)
@b[SHOW EIGHT-BIT-QUOTING]@\Shows   whether  or  not  Kermit-65  is  using
          eight-bit-quoting on file transfers.

@end(description)
@begin(description)
@b[SHOW ESCAPE]@\@\   This  will display  the character  being  used
          to escape from a connection to a remote Kermit.

@end(description)
@begin(description)
@b[SHOW FILE-BYTE-SIZE]@\This  command shows whether Kermit is treating
          seven  bits or all eight bits as significant when writing to
          a file.

@end(description)
@begin(description)
@b[SHOW FILE-TYPE]@\@\ Shows  what type of file  Kermit-65 is reading
          or writing.

@end(description)

@begin(description)
@b[SHOW FILE-WARNING]@\Shows whether or not Kermit-65 will check if a
          file  exists on receive, and try to modify the name used for
          the file if it does.

@end(description)

@begin(description)
@b[SHOW FLOW-CONTROL]@\Shows whether or not Kermit-65 is using
	  XON/XOFF flow control for communication.

@end(description)

@begin(description)
@b[SHOW IBM]@\@\Shows  whether or not Kermit-65 is being  used
          to talk to an IBM mainframe.

@end(description)
@begin(description)
@b[SHOW LOCAL-ECHO]@\Shows  whether  or not Kermit-65 will  print a
          copy of characters on the screen which are typed by the user
          and sent to the mainframe during connect processing.
   
@end(description)
@begin(description)
@b[SHOW PARITY]@\@\Shows   the  type  of  parity  being  used  by
          Kermit-65 in order to talk to the other Kermit.

@end(description)
@begin(description)
@b[SHOW RECEIVE]@\@\Shows  the  setting of  a  particular  receive
          packet parameter. The suboptions available are:

@end(description)

@begin(format)
@tabclear
@tabdivide(5)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@\@\These are analogous to the SET RECEIVE options given above.

@begin(description)
@b[SHOW RS232-REGISTERS]@\Shows the value of the 2 RS232 registers
as a single 16 bit hex value.
@end(description)

@begin(description)
@b[SHOW SEND]@\@\ Shows   the  setting  of  a  particular   send
          packet parameter. The suboptions available are:

@end(description)

@begin(format)
@tabclear
@tabdivide(5)
@b[
@\EIGHT-BIT-QUOTE-CHAR@\END-OF-LINE@\PACKET-LENGTH
@\PAD-CHAR@\@\PADDING@\QUOTE-CHAR
@\TIMEOUT]
@end(format)
@tabclear
@tabdivide(7)

@\@\These are analogous to the SET SEND options given above.

@begin(description)
@b[SHOW VT52-EMULATION]@\Shows  whether or not Kermit-65 is acting like
          a  VT52  when  talking  to  another  Kermit  during  connect
          processing.

@end(description)

@begin(description)
@b[SHOW WORD-SIZE]@\Shows the current word-length for communication.

@end(description)

@begin(description)
@b[STATUS]@\@\The current status of Kermit-65  will  be  displayed.   This
          includes  the  number  of characters that have been sent and
          received from  the  remote  Kermit.   Also  included  is the
          amount of characters which were actual data and the overhead
          for both send and receive.

@end(description)

@section(INIT Files)

 C64 KERMIT-65 has the ability to load preset parameters from disk
automatically upon startup. When Kermit is first started, it will
search the disk for a file called 'KERMIT.INI'. This file must
contain Kermit parameters in a special format and order. Such a file
is provided in the distribution. Kermit will load these parameters
into memory and use them untill they are changed by the user.

 The init file provided with the distribution has the following
defaults set:

@begin(format, leftmargin +2)
@tabclear()@tabset(3.5inches,4.0inches)
Debugging Is@\TERSE
Vt52 Emulation Is@\ON
Ibm-Mode Is@\OFF
Local-Echo Is@\OFF
Baud-Rate Is@\1200
Parity Is@\None
Word-Size Is@\EIGHT-BIT
Flow-Control Is@\ON
Eight-Bit-Quoting Is@\OFF
File-Warning Is@\ON
Escape Character Is@\^y
File-Type Mode Is@\ASCII
File-Byte-Size Is@\SEVEN-BIT
RS232 Registers =@\$0000
Receive
  Padding Character Is@\^@@
  Amount Of Padding Is@\00
  Eight-Bit-Quoting Char Is@\&
  End-Of-Line Character Is@\^m
  Packet-Length	Is@\5d
  Quote Character Is@\#
  Timeout Character Is@\04
Send
  Padding Character Is@\^@@
  Amount Of Padding Is@\00
  Eight-Bit-Quoting Char Is@\&
  End-Of-Line Character Is@\^m
  Packet-Length	Is@\5d
  Quote Character Is@\#
  Timeout Character Is@\04
@end(format)

@chapter(KERMIT-65 SYSTEM INSTALLATION GUIDE)

@section(THE FILES)

  The following files should be supplied on the distribution tape:

@begin(itemize)
C64BOOT.BAS	- Initial bootstrap program to load C64KER.HEX

C64BOOT.C  	- C program at mainframe to talk to C64BOOT.BAS

C64BOOT.FOR	- FORTRAN program at mainframe to talk to C64BOOT.BAS

C64DXL.BAS	- Hex disk file loader in BASIC

C64DXL.HEX	- Assembled version of Disk Hex load program 

C64DXL.M65	- Source of program to load KERMIT-65 from C64 diskette

C64KER.BIN	- Assembled version of KERMIT-65 (Eight-bit Binary Object code)

C64KER.HEX	- Assembled version of KERMIT-65

C64KER.INI	- Init file for KERMIT-65

C64KER.M65	- CROSS assembler source for KERMIT-65

CROSS.MAC	- CROSS Microprocessor Assembler (Source)

CROSS.EXE	- CROSS Microprocessor Assembler (Object)

@end(itemize)

@section(Building KERMIT-65)

@begin(verbatim)
.R CROSS<cr>			! Run CROSS Microprocessor Assembler

*C64KER.HEX/PTP:KIM=C64KER.M65/M65	! Generate .HEX file

@end(verbatim)
 This command will produce an ASCII HEX file which can be downline
loaded onto the C64 using C64BOOT. If a listing is desired, one can
be produced by adding ",C64KER.LST" after the "/PTP:KIM" in the
command line to CROSS. Note that CROSS tends to pad its' output
files with NULLS. You may want to strip them with the editor of your
choice to cut down the files' size (which will also cut down on the
time recquired to transmit the file).

@section(General Procedures and Conventions)

Before working with KERMIT on the C64 do the following:
@enumerate(
Make sure all equipment is turned off.

Remove all cartridges from your C64 computer.

Turn on your disk drive and monitor.

Turn on your C64 computer.

Turn on your printer.

Insert your working disk into the disk drive.

Follow the procedures outlined below to bring up KERMIT.
)

@section(Loading an assembled file)

  The procedure to bootstrap an assembled KERMIT object file from a 
mainframe to the C64 is as follows:

1) On the C64, Load and run SUPERMON machine language monitor or
equivalent. Preferably should be in address $C800-$CFFF.

2) Type in the BASIC program C64BOOT.BAS on the C64. This is a
simple file transfer protocol for receiving '.HEX' files. It is
recommended that the user save this program as it may be needed to
bootstrap newer versions of KERMIT, or C64DXL in the future.

3) Run C64BOOT.BAS on the C64. The procedure is: 

@begin(verbatim)

	LOAD"C64BOOT.BAS",8
	RUN<cr>

	NOW IN DUMB TERMINAL MODE.  PRESS F1 KEY
	TO BEGIN RECEIVING FILE. (MAKE SURE THAT
	HOST IS SET FOR HALF-DUPLEX.)


@end(verbatim)

4) Call and login to the mainframe on which KERMIT-65 resides.

5) Compile and execute C64BOOT.FOR. This will be used along with C64BOOT.BAS
on the C64 to load C64DXL.HEX AND C64KER.HEX. Once C64BOOT is executing on the
mainframe, give control back to the C64.

6) First download C64DXL.HEX

@begin(verbatim)
	<F1>
	LOCAL FILENAME? C64DXL.HEX

@end(verbatim)
 C64BOOT will display status messages about what it is receiving on
the screen as well as saving the data on disk.

7) Then download C64KER.HEX

@begin(verbatim)
	<F1>
	LOCAL FILENAME? C64KER.HEX

@end(verbatim)
 C64BOOT will display status messages about what it is receiving on
the screen as well as saving the data on disk. WARNING: This file
will take lots of space (about 205 sectors), so make sure the disk
is reasonably empty.

8) Then download C64KER.INI

@begin(verbatim)
	<F1>
	LOCAL FILENAME? C64KER.INI

@end(verbatim)

9) Logout (if you wish) and exit C64BOOT.BAS

10) Type in and save C64DXL.BAS. Run C64DXL.BAS

@begin(verbatim)

	LOAD"C64DXL.BAS",8
	RUN<cr>
	Name Of File? C64DXL.HEX<cr>

 C64DXL will display what it is loading into memory.
@end(verbatim)

11) Save C64DXL. Type the following: (if you haven't already, load
Supermon at C7ED)

@begin(verbatim)

 SYS 51181 (to enter Supermon)
 .S "C64DXL.C000",08,C000,C2EE<cr>

@end(verbatim)

12) Start executing C64DXL.

@begin(verbatim)
 LOAD "C64DXL.C000",8,1<cr>
 SYS 49152<cr>
 Hex Object File Loader
 Object File Name? C64KER.HEX <cr>

C64DXL will display what it is loading into memory.

13) When done, enter SUPERMON and save the file:

 .S "KERMIT",08,0801,xxxx+1<cr>

 Where xxxx is the last address diplayed by C64DXL
@end(verbatim)

 The new version of Kermit is now on disk.
 
@section(Loading a new version of KERMIT-65)

Once KERMIT-65 is on the users system, it can be used to load new versions
of KERMIT-65.  There are two ways of doing this.  One will work in any
enviroment where the initial bootstrap procedure works, since it depends
only on the capability of transferring text files.  The other method
depends upon the capability of being able to obtain and transfer
a binary file.

@section(Loading from a .HEX file)

1) Use Kermit to transfer C64DXL over to your C64 (If you already
have C64DXL, skip to step 4). C64DXL is a disk hex loader that will
take CROSS format .HEX files on your C64 and load them into memory:

@begin(verbatim)

	LOAD"KERMIT",8<cr>
	RUN<cr>
	(Do your mainframe Kermit setup here)
	KERMIT-65>GET C64DXL.HEX<cr> (or RECEIVE C64DXL.HEX)

2) Type in and save C64DXL.BAS. Run C64DXL.BAS
@begin(verbatim)

	LOAD"C64DXL.BAS",8
	RUN<cr>
	Name Of File? C64DXL.HEX<cr>

 C64DXL will display what it is loading into memory.

@end(verbatim)
3) Save C64DXL. Type the following:
  
 SYS 51181 (to enter Supermon)
 .S "C64DXL.C000",08,C000,C2EE<cr>

@end(verbatim)
4) Use Kermit-65 to transfer the new version of itself over.
Make the C64 file a Text file. WARNING: This file will take
LOTS of space (about 205 sectors), so make sure the disk is 
reasonably empty.

5) Start executing C64DXL.

@begin(verbatim)
 LOAD "C64DXL.C000",8,1<cr>
 SYS 49152<cr>
 Hex Object File Loader
 Object File Name? C64KER.HEX <cr>

C64DXL will display what it is loading into memory.

6) When done, enter SUPERMON and save the file:

 .S "KERMIT",08,0801,xxxx+1<cr>

 Where xxxx is the last address diplayed by C64DXL
@end(verbatim)

 The new version of Kermit is now on disk.
 
7) If you don't already have a KERMIT.INI file, you should transfer
this file over from the mainframe. See the section on init files for
more information.

@section(Loading from the binary version)

 There is yet another way to Bootstrap a new version of KERMIT  onto
an C64. If the user has an older version of KERMIT-65 which supports
binary mode transfer, and has access  to a machine with a valid  copy
of C64KER.BIN, they can simply  transfer C64KER.BIN using their  version
of KERMIT. Be sure to set  the File-byte-size to Eight-bit, and  the
File-type-mode to Binary before transferring  the file since this  is
the actual object  code.  Also be  sure that the  sending Kermit  is
also set  for  doing  a  binary  transfer.  No  special  loading  or
conversion is needed. If no KERMIT.INI file is present, it should
also be transferred to the C64. See the section on init files for
more information.

@appendix(Character and Control Code Definitions)
@appendixsection(Keyboard Layout)

Because of the unusual layout of the C64 keyboard, the
desire to support all ascii characters, and a personal
need to find the ESC and DEL keys in their usual positions,
the following key substitutions apply (note- ^x is short-
hand for CONTROL-x):

@table<@verbatim[

	TO SEND		TYPE
	-------		----
	\		BRITISH-POUND
	^\		^BRITISH-POUND
	^_		^=
	^		UP-ARROW
	^^		^UP-ARROW
	^[ (ESC)	^[ or LEFT ARROW
	_		F1
	|		F2
	`		F3
	~		F4
	{		F5
	}		F6
	^H (BS)		F7
	^T		F8
	DEL (RUB)	Commodore DEL
	^J (NL)		SHIFT/RETURN or ^J
	^S (DC3)	^S or HOME
	^Q (DC1)	^Q or CURSOR DOWN
	^I (TAB)	^I (ie. No separate TAB key)
]>
 
@comment( Certain other keys also preform other actions:)

 Note that if  the FLOW-CONTROL  option has been  set, pressing  the
COMMODORE key will place the terminal program in a suspended display
mode (ie. the cursor will freeze  at it's current position), and  ^S
will be sent to the host computer when the RS-232 input buffer fills
up.  Similarly, pressing the COMMODORE key will remove the  terminal
from the suspended display mode and  send a ^Q to the host  computer
only if a  ^S had  previously been sent  and the  buffer has  become
nearly empty.  This enables  the COMMODORE key to  be used like  the
SCROLL/ NO-SCROLL key on DEC  terminals.  Suspended display mode  is
indicated to the user  by the cursor blinking
much faster than normal, an indication that the COMMODORE key  must
be pressed to resume displaying the received text.  The program  may
also send ^S and ^Q  to the host computer on  it's own from time  to
time if it detects an  impending RS-232 buffer overflow condition  -
this normally will only  occur while printing a  number of short  or
blank lines while scrolling the screen  up (or down), since 4 to  15
characters are received into  the RS-232 buffer  during the time  it
takes to scroll the whole screen.  In any case, this automatic  flow
control is fully synchronized with the flow control necessitated  by
the use of the  COMMODORE key to suspend  and resume the display  of
received text.  Depressing the ^S and ^Q keys (or their  substitutes
indicated above) unconditionally sends those ASCII characters to the
remote host computer without any local effect.

 This terminal program does `not' support flow control in the
opposite direction - receiving ^S from the host computer will not
lock the keyboard or have any other effect, nor will ^Q.


@table(@verbatim<
>)

@begin(group)
@appendixSection{GLASS terminal}

The GLASS TTY terminal type prints all characters except ASCII 0-31 and 
ASCII 127.  Most control codes are ignored.  The following, however, are
recognized:


@Table{@Verbatim{
	CHARACTER	EFFECT
	---------	------
	^G (BEL)	sounds a beep
	^H (BS)		cursor backspaces
 	^I (TAB)	cursor moves right to next tab stop
	^J (NL)		cursor moves down one line with scrolling
	^M (CR)		cursor moves to start of line

}@Caption{Control Codes For Glass TTY}}
@end(group)

Tab stops are pre-defined and fixed at every 8 columns beginning
with column 0 (ie. 0, 8, 16, 24, ...). 

@appendixSection{VT-52 Terminal}

The VT-52 terminal prints the same characters as the GLASS TTY.  It reacts to
control characters the same as the GLASS, except when ESC (decimal 27) is
received. Kermit will treat the next character received specially; if it
isn't in the following table, KERMIT ignores the character; if it is in
the table, the action is as indicated.

@Table{@Verbatim{
	CHARACTER	EFFECT
	---------	------
	^[A		cursor moves up one line
	^[B		cursor moves down
	^[C		cursor moves right one char.
	^[D		cursor moves left one char.
	^[H		cursor homes
	^[I		cursor moves up one line with scrolling
	^[J		clears from cursor to end of screen
	^[K		clears from cursor to end of line
	^[Ylc		cursor moves to line l-$20, col c-$20
	^[Z		sends DEC VT-52 terminal id string
	^[n		turns off reverse video
	^[o		turns on reverse video
}@Caption{Escape Sequences for VT-52}}

@newpage

 VAX UNIX users (Berkeley 4.1bsd) will find that the following
"termcap" entries effectively describe this terminal program
for use with the terminal dependent UNIX programs (eg. vi,
emacs, more, rogue, etc.):

@figure<@verbatim[
  qc|c64|C64|Commodore 64:co#40:li#25:\
          :up=\EA:do=\EB:cl=\EH\EJ:am:bs:\
          :bw:ho=\EH:nd=\EC:so=\Eo:\
          :se=\En:cm=\EY%+ %+ :\
          :ce=\EK:sr=\EI:pt:
]>

 VAX VMS users can probably get away with the following (although
some VMS programs [eg. edt] require an auxilliary keypad, and do
not work especially well in 40 column mode):

@figure<@verbatim(
          set term /dev=vt52
          set term /pag=25
          set term /wid=40
)>

 TOPS-20 users can run "emacs" and the like after the following:

@figure(@verbatim<
          term vt52
          term length 25
          term width 40
          term pause com
>)

@appendix(C64BOOT.BAS - BOOTSTRAP PROGRAM FOR C64DXL)
@begin(verbatim)
@include(KER:C64BOOT.BAS)
@end(verbatim)

@appendix(C64BOOT.C - MAINFRAME SIDE OF BOOTSTRAP)
@begin(verbatim)
@include(KER:C64BOOT.C)
@end(verbatim)

