@Make<text>@device<pagedfile>
@Define<Q,FaceCode R>
@define<appendix=text,above 2, below 1,need 4,initialize "* ">
@define<appendixsection=text,above 1,below 1,need 4,initialize ". ">
@heading<SuperBrain Info>

@Appendix<Floppy Disks>
@label<-flop>

@Index[Diskette]
 Floppy disks (flexible disks, diskettes), provide economical
"removable media", i.e. a cheap way to store files offline such that
they can be restored at a later time.  Floppies come in two sizes: 8
inch and 5-1/4 inch diameters, and they can be single-@|sided,
double-@|sided, or single-@|sided reversible.  They can be
hard-@|sectored (sectors are identified by holes punched in the disk)
or soft-@|sectored (sectors are marked by recorded bit patterns).
They can be single, double, or quad density.  Microcomputers made by
different manufacturers may employ any combination of these
characterics in supporting their floppies; in general, floppy disks
are incompatible between any two models of microcomputer, and
sometimes even between software releases on the same model.

Floppy disk drives are generally quite small and slow compared to more
expensive media.  A typical 5-1/4 inch floppy has a formatted capacity
of about 150K bytes, turns at 300 RPM, transfers data at about
32K bytes per second, and has a seek (track access) time of 250
milliseconds.  A large 3330-@|type disk drive may have a capacity 100-@|200
megabytes, turns at 3000 RPM, transfers data at up to 800K bytes per
second, and has a seek time of 36 milliseconds.  A typical magnetic
tape system can store 40 megabytes on a 12-inch reel (at 1600 bits per
inch), travels at 75 inches per second, and can transfer 120K bytes
per second (access, of course, is sequential, not random).  A floppy
disk drive is vastly cheaper than a hard disk drive or a tape drive,
and the floppy disk itself is significantly cheaper than a magnetic
tape (a hard disk is quite large and is not normally considered
"removable").  At $4 to $6 apiece, 5-1/4 inch floppies are the most
affordable removable storage medium.

Floppies consist of a flexible platter mounted permanently inside a
square cardboard jacket.  The platter turns inside the
jacket.  The machine's read-@|write head actually comes in contact
with the surface of the platter through a slot in the jacket.  The
rubbing of the platter against the inside of the jacket and the
read-@|write head can cause the the floppy to wear out after prolonged
or repeated use.

The jacket, in turn, is often kept in a paper envelope.  The floppy is
taken out of the paper envelope and inserted in the drive with its
jacket on.

Floppies should never be removed from their cardboard jackets.  The shiny
surface of the diskette should never be touched; always handle
diskettes by their jackets.  Diskettes should be stored in
box or solid container.  Never have the diskettes in their drives while
the power is being turned on or off.  Don't bend or otherwise mutilate
the diskette.  Don't allow liquids or moisture to come in contact with
the diskette.  Don't place diskettes where they might be subject to
magnetic fields, temperature extremes, dust, or other contaminants.  Don't
write on the jacket with a ball point pen.

@Appendix<The SuperBrain>

@label<-Brain>
 The @Index[Superbrain] SuperBrain is a Z80-@|based 8-bit
@Index[Microcomputer] microcomputer manufactured by Intertec Data
Systems Corp.  It is equipped with two double-@|density 5-1/4 inch
"minifloppy" @Index[Diskette] disk drives with a capacity of
approximately 160K characters each.  The smallest unit of storage on
the floppy is 2K.  CP/M allows up to 64 files to be stored on a single
floppy.  The SuperBrain runs the Intertec Data Systems version of the
CP/M operating system.

@AppendixSection<Using the SuperBrain>

 The SuperBrain is a very simple machine to use.  To start it, flip up
the toggle switch located on the back.  This is known as a @i<cold
start>.  On a @Index[Cold Start] cold start the micro is automatically
@Index[Bootstrap] "booted", i.e. the @Index[CP/M] CP/M operating
system is loaded into memory from the system floppy and started.  This
should cause the following message to appear:
 @Begin<Example>
64K SUPERBRAIN DOS VER 3.1 FOR CP/M 2.2

A>
@End<Example>
 The "@q(A>)" is the micro's prompt.  It corresponds to the "@@" on the
DEC-20.  The letter to the left of the ">" (@q(A) in this case) indicates
which floppy disk drive you are presently using (the one on the left
is A).  If you are on the B disk the prompt will be "@q(B>)".  To switch
from the A disk (which is the system disk, and to which you are
"connected" by default) to the B disk, just type the command "B:" in
response to the "A>" prompt:
@begin<example>
A>@u<B:>
B>
@end<example>

@Index[Warm Start]
 There are two red keys located at the bottom corners of the main keypad.
If these two keys are depressed at the same time a @i<warm start> takes
place; this means that whatever program may be running is interrupted,
the operating system is reinitialized, and you are put back at CP/M
command level.  Warm starting the SuperBrain is like control-C'ing the
DEC-20, except that CP/M programs can not be continued.  For most
purposes, there is no real difference between a cold and warm start.

@AppendixSection<SuperBrain Floppies>
@Label<-BrainFlop>

@Index[Diskette]
 The SuperBrain uses a pair of 5-1/4 inch single-@|sided, double
density, soft-@|sectored floppies, A (left) and B (right).

 The @Index[System Floppy] system floppy diskette should be mounted in
Drive A, and should not normally be removed.  The system disk contains
the CP/M operating system and utilities, and the SuperBrain version of
Kermit, Kermit-80.  The SuperBrain should be turned off when not in
use to minimize wear and tear on the system floppy.

Drive B is available for user floppies.  All floppies must be
formatted before use (see Appendix @ref<-format>); the entire
formatted capacity of the B floppy may be used for storage of user files
-- no system files need reside on the B disk.

@Index[Diskettes, Loading]
 Drive B is the vertical opening on the right.  To insert a diskette in
Drive B, open the drive by applying a very slight outward pressure on
the small flat door located in the center of the opening.  Insert the
diskette with the label facing right,
@i<away> from the screen, notched edge up.  Make sure the diskette is
all the way in by applying a gentle pressure on the rear edge of the
diskette.  Once you are certain that the diskette is fully inserted,
you may close the disk drive door by applying a slight pressure on the
door, pulling it back in the direction from which it was originally
opened.

@AppendixSection<CP/M Commands>

@Index[CP/M]
 Once the micro has been started, you may give it commands.  Commands may
be typed whenever the prompt is present.  Backspace or delete can be used
to erase a character already typed.  Control-X or control-U will erase the
entire current line.  Upper and lower case letters may be used
interchangeably.  All commands are terminated by a carriage return.  CP/M
has only five built-in commands, and they all deal with files; all other
functions are done by invoking programs.

CP/M file specifications are of
the form @q(DEV:XXXXXXXX.YYY), where
@begin<description>
 @q(DEV:)@\is a @i<device name>,
normally the A:@ or B:@ floppy.  If omitted, the device name defaults
to your connected diskette.

@q(XXXXXXXX)@\is a @i<filename> of 8 characters.

@q(YYY)@\is the @i<file type>, 3 characters.
 @end<description>
 File names and file types may contain letters, digits, and some
special characters, including dash, dollar sign, and underscore, but
no imbedded spaces (just like TOPS-20 filenames, except that TOPS-20
file specification fields do not have trailing spaces).  Upper and
lower case letters are equivalent.

 "Wildcard" file-@|group specifications are permitted in file names
and file types (but not device names) within certain contexts; a "@q(*)"
matches a whole field, a "@q(?)"  matches a single character, including
space.  Examples: "@q(*.F??)" specifies all files whose @i<types> start
with F and are 1, 2, or 3 characters long; "@q(F?.*)" specifies all
files whose names start with F and are no more than two characters
long (before the trailing spaces).

The five CP/M commands are:
 @Begin<Description>
DIR <file>@\Lists the the names of the specified files.  The
default file specification is "*.*".  Example: @w<"@q(DIR B:*.FOR)">.

ERA <file>@\Erases (deletes) the specified file(s); wildcards allowed.

REN <file> <file>@\Renames a file; the new file name goes first, e.g.
@w<"@q(REN NEW.FOR=OLD.FOR)">.

SAVE@\Saves the specified number of memory pages into a file.  You won't need
to use this command.

TYPE <file>@\Types the specified file on the screen, e.g.
@w<"@q(TYPE FOO.FOR)">.
 @End<Description>
The most important programs are the following:
 @Begin<Description>
STAT@\Gives statistics on disk usage.

PIP@\@u<P>eripheral @u<I>nterchange @u<P>rogram.  Copies files.  In
response to the "@q(*)" prompt, give a command of the form
 @example<disk:outfile=disk:infile>
 Wildcards ("@q(*)" for a whole field or "@q(?)"  for a letter) can be used.
Examples: "@q(A:=B:*.*)" to copy a whole disk, "@q(A:=B:*.FOR)" to copy all
the Fortran programs from disk B to disk A.  If the disk specification
is omitted, your "connected" disk is assumed.  Command line arguments
are accepted, e.g. "@q(PIP A:=B:*.*)".

 @End<Description>
 For further information on SuperBrain commands and programs, consult
the SuperBrain manual or a CP/M handbook.


@AppendixSection<Formatting a SuperBrain Floppy Diskette>

@label<-format>
@Index[Diskettes, Formatting]@Index[Formatting a Diskette]
 You must @i<format> all new previously unused diskettes
before attempting to transfer data to them.  This is necessary because
all information is stored on diskettes in what is known as @i<soft
sectored format> which necessitates the writing of certain control
information on the disks before user programs can be stored on them.
Here's how to format a diskette.

First, obtain a new blank diskette.  Load the system diskette into
Drive A and the blank diskette into Drive B.  Boot the system.  In
response to the "A>" prompt, enter the command "FORMAT" at the
keyboard.  Remember to depress the key marked RETURN to enter the
command.  The operating system should now respond by asking you to
select the type of diskette being formatted (S or D).  This questions
asks whether the diskette to be formatted is single sided or double
sided.  The SuperBrains at the Columbia Computer Center are single
sided, so enter "S".  The operating system will now ask you to put a
fresh floppy in Drive B; answer "F" when this is done.  At this point
you will hear the disk drive reset to track 0 and begin the formatting
process.  When a disk is formatted, the read/@|write head positions to
track 0 and rewrites each track (there are a total of 35 on each
diskette).  The screen will also display the current track that is
being formatted; this number should range from 0 to 34.

After the disk has been completely formatted, the operating system
will respond by asking you whether to @i<reboot> the operating system
or whether you wish to format another disk.  If you wish to format
another disk, remove the newly formatted disk from Drive B and insert
a new blank diskette into Drive B.  You may now proceed to format this
new diskette by once again entering the letter "F".  If you do not
wish to format any more diskettes, simply depress RETURN.
