


KERMIT(1)           UNIX Programmer's Manual            KERMIT(1)



NAME
     kermit - file transfer, virt. terminal over tty link

SYNOPSIS
     kermit c[lbe] [_l_i_n_e] [_b_a_u_d] [_e_s_c]

     kermit r[ddilb] [_l_i_n_e] [_b_a_u_d]

     kermit s[ddilb] [_l_i_n_e] [_b_a_u_d] _f_i_l_e ...

DESCRIPTION
     _K_e_r_m_i_t provides reliable file transfer and primitive virtual
     terminal communication between machines.  It has been imple-
     mented on many different computers, including microproces-
     sors (see below).  The files transferred may be arbitrary
     ASCII data (7-bit characters) and may be of any length.  The
     file transfer protocol uses small (96 character) checksummed
     packets, with ACK/NACK responses and timeouts.  _K_e_r_m_i_t
     currently uses a five second timeout and ten retries.

     The arguments to _k_e_r_m_i_t are a set of flags (no spaces
     between the flags), three optional args (which, if included,
     must be in the same order as the flags which indicate their
     presence), and, if this is a Send operation a list of one or
     more files.  (It is similar in some way to the _t_a_r command
     structure).

     _K_e_r_m_i_t has three modes, Connect, Send, and Receive.  The
     first is for a virtual terminal connection, the other two
     for file transfer.  These modes are specified by the first
     flag, which should be c, s, or r, respectively.  Exactly one
     mode must be specified.

     The d flag (debug) makes _k_e_r_m_i_t a bit more verbose.  The
     states _k_e_r_m_i_t goes through are printed along with other
     traces of it's operation.  A second d flag will cause _k_e_r_m_i_t
     to give an even more detailed trace.

     The i flag (image) allows slightly more efficient file
     transfer between Unix machines.  Normally (on Kermits
     defined to run on Unix systems) newline is mapped to CRLF on
     output, CR's are discarded on input, and bytes are masked to
     7 bits.  If this is set, no mapping is done on newlines, and
     all eight bits of each byte are sent or received.  This is
     the default for non-Unix kermits.

     The l flag (line) specifies the tty line that _k_e_r_m_i_t should
     use to communicate with the other machine.  This is speci-
     fied as a regular filename, like "/dev/ttyh1".  If no l
     option is specified, standard input is used and _k_e_r_m_i_t
     assumes it is running on the remote host (ie. NOT the
     machine to which your terminal is attached).



Printed 9/22/83               local                             1






KERMIT(1)           UNIX Programmer's Manual            KERMIT(1)



     The b flag (baud) sets the baud rate on the line specified
     by the l flag.  No changes are made if the b flag is not
     used.  Legal speeds are: 110, 150, 300, 1200, 2400, 4800,
     9600.  Note that this version of _k_e_r_m_i_t supports this option
     on Unix systems only.

     The e flag (escape) allows the user to set the first charac-
     ter of the two character escape sequence for Connect mode.
     When the escape character is typed, _k_e_r_m_i_t will hold it and
     wait for the next character.  If the next character is c or
     C, _k_e_r_m_i_t will close the connection with the remote host.
     If the second character is the same as the escape character,
     the escape character itself is passed.  Any character other
     than these two results in a bell being sent to the user's
     terminal and no characters passwd to the remote host.  All
     other typed characters are passed through unchanged.  The
     default escape character is '^'.

     The file arguments are only meaningful to a Send _k_e_r_m_i_t.
     The Receiving _k_e_r_m_i_t will attempt to store the file with the
     same name that was used to send it.  Unix _k_e_r_m_i_ts normally
     convert outgoing file names to uppercase and incoming ones
     to lower case (see the f flag).  If a filename contains a
     slash (/) all outgoing kermits will strip off the leading
     part of the name through the last slash.

EXAMPLE
     For this example we will assume two Unix machines.  We are
     logged onto "unixa" (the local machine), and want to commun-
     icate with "unixb" (the remote machine).  There is a modem
     on "/dev/tty03".

     We want to connect to "unixb", then transfer "file1" to that
     machine.

     We type:   kermit clb /dev/tty03 1200

     Kermit answers:   Kermit: connected...

     Now we dial the remote machine and connect the modem.  Any-
     thing typed on the terminal will be sent to the remote
     machine and any output from that machine will be displayed
     on our terminal.  We hit RETURN, get a "login:" prompt and
     login.

     Now we need to start a _k_e_r_m_i_t on the remote machine so that
     we can send the file over.  First we start up the remote,
     (in this case receiving) _k_e_r_m_i_t, then the local, (sending)
     one.  Remember that we are talking to unixb right now.

     We type:   kermit r
          (there is now a Receive _k_e_r_m_i_t on unixb)



Printed 9/22/83               local                             2






KERMIT(1)           UNIX Programmer's Manual            KERMIT(1)



     We type ^ (the escape character) and then c to kill the
     local (Connecting) _k_e_r_m_i_t.

     Kermit answers:   Kermit: disconnected.

     We type:   kermit slb /dev/tty03 1200 file1

     Kermit answers:     Sending file1 as FILE1

     When the transmission is finished, _k_e_r_m_i_t will type either
     "Send complete", or "Send failed.", depending on the success
     of the transfer.  If we now wanted to transfer a file from
     unixb (remote) to unixa (local), we would use these com-
     mands:

          kermit clb /dev/tty03 1200
            (connected to unixb)
          kermit s file9
          ^c (up-arrow c not control-c)
            (talking to unixa again)
          kermit rl /dev/tty03 1200

     After all the transfers were done, we should connect again,
     log off of unixb, kill the Connect _k_e_r_m_i_t and hang up the
     phone.

     Detail on other implementations and on the protocol is given
     in the _K_e_r_m_i_t _U_s_e_r_s _G_u_i_d_e, and the _K_e_r_m_i_t _P_r_o_t_o_c_o_l _H_a_n_d_b_o_o_k.

FEATURES
     _K_e_r_m_i_t can interact strangely with the tty driver.  In par-
     ticular, a tty with "hangup on last close" set (stty hup),
     will reset to 300 Baud between _k_e_r_m_i_t commands.  It will
     also hang up a modem at that time.  It is better to run with
     "stty -hup", and use "stty 0" to explicitly hang up the
     modem.

     The KERMIT Protocol uses only printing ASCII characters,
     Ctrl-A, and CRLF.  Ctrl-S/Ctrl-Q flow control can be used
     "underneath" the Kermit protocol (TANDEM line discipline on
     Berkeley Unix).

     Since BREAK is not an ASCII character, _k_e_r_m_i_t cannot send a
     BREAK to the remote machine.  On some systems, a BREAK will
     be read as a NUL.

     This _k_e_r_m_i_t does have timeouts when run under Unix, so the
     protocol is stable when communicating with "dumb" kermits
     (that don't have timeouts).

OTHER IMPLEMENTATIONS
     _K_e_r_m_i_t_s have been written for TOPS-20, TOPS-10, IBM VM/CMS,



Printed 9/22/83               local                             3






KERMIT(1)           UNIX Programmer's Manual            KERMIT(1)



     Unix, VAX/VMS, RT-11, MS-DOS, CP/M, and Apple DOS.  The Unix
     _k_e_r_m_i_t in use at Ford Aerospace has been tested on v6/PWB,
     v7, Onyx System III, Bell System V, and Berkeley 4.1.  More
     information is given in the _K_e_r_m_i_t _U_s_e_r_s _G_u_i_d_e.

SEE ALSO
     stty(1)

     _K_e_r_m_i_t _U_s_e_r_s _G_u_i_d_e, Fourth Edition (4 May 83), Frank da
     Cruz, Daphne Tzoar, Bill Catchings

     _K_e_r_m_i_t _P_r_o_t_o_c_o_l _M_a_n_u_a_l, Protocol Version 3 (29 April 83),
     Frank da Cruz, Bill Catchings

     Both of the above documents are from the Columbia University
     Center for Computing Activities, New York, New York, 10027.

AUTHORS
     KERMIT kernel by Bill Catchings, Columbia University Center
     for Computing Activities

     KERMIT-Unix adaptation by Chris Maio and Bob Cattani, Colum-
     bia University Computer Science Dept.

     Local mods for v6, System III, and System V by Walter Under-
     wood.  Includes bug fixes from Jim Guyton at RAND-Unix.

DIAGNOSTICS
     cannot open _d_e_v_i_c_e
          The file named in the _l_i_n_e argument did not exist or
          had the wrong permissions.

     bad line speed
          The _b_a_u_d argument was not a legal speed.

     Could not create _f_i_l_e
          A Receive _k_e_r_m_i_t could not create the file being sent
          to it.

     nothing to connect to
          A Connect _k_e_r_m_i_t was started without a _l_i_n_e argument.

BUGS AND CAVEATS
     There is no locking on the use of the outgoing line.
     Several users could run _k_e_r_m_i_t (or anything else) on the
     line simultaneously.

     The acronym (_KL10 _Error-free _Reciprocal _Micro _Interconnect
     over _TTY lines) is charming, but strained.

     This implementation does not send or process error-message
     packets.



Printed 9/22/83               local                             4






KERMIT(1)           UNIX Programmer's Manual            KERMIT(1)



     Eight-bit quoting is not implemented.






















































Printed 9/22/83               local                             5



