@part(APPLEN,root="KER:KUSER")
@PageHeading(Even,Left="Page @ref(page)",Right="@b<APPLE-DOS KERMIT>")
@PageHeading(Odd,Left="@b<APPLE-DOS KERMIT>",Right="Page @ref(page)")
@Chapter<APPLE-DOS KERMIT>
@label<-apple>
@Index[DOS 3.3]
@Index(APPLE ][+)
@begin<description,leftmargin +12,indent -12,spread 0>
@i(Authors:)@\Antonino N. J. Mione, Stevens Institute of Technology
	@\Peter Trei, Columbia University

@i(Documentation:)@\Antonino N.J. Mione,
Stevens Institute of Technology
	@\Peter Trei, Columbia University

@i(Version:)@\2.1(45)

@i(Date:)@\July 1984
@end<description>
@i<Kermit-65 Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\No
@q<^X/^Y> interruption:@\No
Filename collision avoidance:@\Yes
Can time out:@\No
8th-bit prefixing:@\Yes
Repeat count prefixing:@\No
Alternate block checks:@\No
Terminal emulation:@\Yes (VT52)
Communication settings:@\Yes; local echo, parity
Transmit BREAK:@\Yes
IBM communication:@\Yes
Transaction logging:@\No
Session logging (raw download):@\No
Raw upload:@\No
Act as server:@\No
Talk to server:@\Yes
Advanced commands for servers:@\No
Local file management:@\No
Handle file attributes:@\No
Command/init files:@\No
Printer control:@\No
@end<format>


KERMIT-65 is a program that implements the KERMIT file transfer protocol for
the Apple ][ micro computer system. It is written in 6502 assembly language
and should run on any Apple ][ or Apple ][ Plus system running DOS 3.3.
This section will describe the things you should know about the DOS 3.3 file
system in order to make effective use of KERMIT, and then it will describe the
special features of the KERMIT-65 program.

@Section<The DOS 3.3 File System>

Items of importance which will be discussed in this section include
Filenames and File Characteristics.

@Subheading<Apple DOS Filenames>

Filenames under Apple DOS may contain almost any ASCII character (including
space). It is not recommended that special characters, (i.e. control
characters or spaces) be used in a filename to be transferred by Kermit-65
since they may cause problems when parsing the filename.

Filenames may be up to 40 characters in length. No wildcarding of any kind
can be done in KERMIT-65.

@Subheading<Apple DOS File Characteristics>

All files in Apple DOS have a file type associated with them which is
contained in the directory entry for the file but is not part of the filename
itself. There are four types of files in DOS 3.3. They are:
@begin(itemize)
APPLESOFT BASIC

INTEGER BASIC

BINARY

TEXT
@end(itemize)

All file types have their data stored in eight-bit bytes although not all
of them need the eighth bit. The two file types containing basic programs
required the eighth bit due to the nature of the data being stored. BINARY
files are images of memory copied into a file. Often, these are machine code
programs. These files require all eight bits. TEXT files normally contain
only printable or carriage control characters. They are stored in the form
of seven-bit ASCII characters but the eighth bit should always be set since
Apples manipulate all text internally as 'NEGATIVE ASCII'.

When transmitting text files, the byte size should be set to seven-bit. When
transmitting anything else, the user must insure that both Kermits are
handling eight bit data so that no information is lost. If an eight-bit data
path is not available (i.e. the remote Kermit needs to do parity checking
with the eigth bit), then eight-bit quoting should be used. Of course,
BINARY files
as well as Apple BASIC files will not have much meaning on a different system.
If the user desires to edit a BASIC file on a mainframe, for instance, he must
convert it to a TEXT file before sending it over. After receiving the file
back on the Apple, the user may convert it back to BASIC once again. The
reason BASIC files would be meaningless to a different machine is that the
Apple stores BASIC keywords as single character tokens to save space and
processing time. To convert a BASIC program to and from a TEXT file, consult
the Apple DOS 3.3 Manual.

File information can be obtained by issuing the CATALOG command. For
example:
@begin(example)
]CATALOG

 DISK VOLUME 010

   *A 002 HELLO
    B 078 KERMIT
    A 002 READER
    T 005 TESTFILE

]
@end(example)

When KERMIT-65 is receiving a file, the file it creates on diskette will
be of the type indicated by the FILE-TYPE parameter.
The file will always be left in an unlocked state after
it is closed by KERMIT-65. When sending a file, KERMIT-65 will
use the FILE-TYPE parameter to determine how to detect an End-of-file
condition. Thus, it is important to have this set properly in all cases.
  
@subheading<Recommendations for archiving files>

When using a large system for archiving purposes, there is no reason to
convert Apple Basic programs into text files before sending them since
there is no need to edit them on the mainframe.

The FILE-TYPE parameter must always be set correctly when sending and
receiving files. Also, when sending files which require eight-bit
FILE-BYTE-SIZEs, this parameter must also be set properly since
KERMIT-65 does not change it automatically based on FILE-TYPE.

The procedure for archiving TEXT files is:
@begin(itemize)
Run Kermit on remote system

SET FILE-BYTE-SIZE SEVEN-BIT    ! On KERMIT-65

SET FILE-TYPE-MODE TEXT         ! On KERMIT-65

Send files
@end(itemize)

The procedure for archiving APPLESOFT, INTEGER, and BINARY files is:
@begin(itemize)
Run Kermit on remote system

Set File-byte-size to Eight-bit ! On Remote Kermit

SET FILE-BYTE-SIZE EIGHT-BIT    ! On KERMIT-65

SET FILE-TYPE-MODE APPLESOFT    ! (or INTEGER, or BINARY) On KERMIT-65

Send files
@end(itemize)

@section<Program Operation>

@heading<Hardware Considerations>

Prior to using KERMIT-65 for transferring files, the modem
interface must be set to handle data in a certain manner. Firstly,
the data format should be 8 data bits and 1 stop bit. Secondly, the
card should be set to no parity. The baud rate (if adjustable) must
be set to whatever rate the modem can handle. For the Apple Com card
and the D.C. Hayes Micromodem, these parameters are set correctly by
default, so very little has to be done. For the Apple Super Serial
Card, however, these have to be set before using KERMIT-65. In all
cases, use the same procedure to connect to the mainframe host as
is indicated in the section below on Installing KERMIT.

Some mainframes cannot handle data in the format of 8 data bits
and 1 stop bit because they may need parity checking (i.e. most
IBM machines). In this case, 7 data bits and 1 stop bit plus some
parity setting (other than none) will usually work. When talking
with such mainframes, binary and basic files on the Apple cannot
be transferred unless Eighth-bit-quoting is used.

@Heading<Conversing with KERMIT-65>

KERMIT-65's prompt is "@q(KERMIT-65>)".

To run KERMIT-65 and issue commands to it, type the following:

@Begin(Example)

]@ux[BRUN KERMIT]

STEVENS/CU - APPLE ][ KERMIT-65 - VER 2.1

Kermit-65>@ux[SEND TESTFILE]

@i(file is sent)

Kermit-65>@ux[STATUS]

@i(performance statistics are printed)

Kermit-65>@i[Other commands]
                .
                .
                .

Kermit-65>@ux[EXIT]
]
@end(example)

KERMIT-65 uses a TOPS-20 style command parser.

@index<Help>
During interactive operation, you may use the ?-prompting help feature
@index<?-prompting> ("?") and
@index<Recognition>recognition (ESC) features while typing commands.  A
question mark typed at any point in a command displays the options available at
that point; typing an ESC character causes the current keyword to
be completed (or default value to be supplied).  If you have not
typed sufficient characters to uniquely specify the keyword or filename (or if
there is no default value) then a beep will be sounded and you may continue
typing. Keywords may be abbreviated to any prefix that is unique.

There are several different Apple]['s which can run KERMIT-65. Kermit
will have no problems running on an Apple ][ or Apple ][+ system. It will
run on the Apple //e as well, however, the 80-column board cannot be used
at this time.

Of the different communication devices available for the Apple ][, three are
supported:
@begin(itemize)
Apple Com Card

D.C. Hayes Micromodem

Apple Super Serial Card
@end(itemize)
It is possible that other cards may have operational characteristics
very similar or identical to one of the devices above. If this is the
case, it may work using one of the currently available device drivers.
The user may want to try each of the above options to see if any of them
work.

KERMIT-65 must be told which device is being used so that it may run with
the correct device driver. It also must be told in which slot the card
resides. This may be done with the 'SET' command (documented below).

@Section<Remote and Local Operation>

KERMIT-65 is normally run in local mode. It may be run as a remote Kermit as
well although there is no advantage to doing things that way. KERMIT-65
supports User-mode commands for talking to a Server. It does not currently
support server mode.

@Section<KERMIT-65 Commands>

@Heading<The SEND Command>
@Index[Filespec]@Index[SEND]
Syntax: @q<SEND @i{filespec}>

The SEND command causes a file to be sent from the Apple to the
remote system. The Filespec is the name of the file on the Apple
diskette to be sent. The parser will not accept control characters and
certain special characters in a filename (i.e. a comma), so the user may have
to rename the file before it is sent. The user may also have
problems in filename compatibility with remote Kermits. If the remote
Kermit does not have the facilities to beat the filename into a format that
its system likes, the user may have to rename the file before sending it.
The default disk drive used for file transfers is the drive used to
boot the system or the last drive accessed with a DOS command. This
can be changed with the 'SET DEFAULT-DISK' command (explained below). Either
the slot or the drive or both may be altered.

As a file is being sent, the screen displays either 'SENDING PACKET...'
or 'WAITING PACKET...' followed by the absolute packet number since start of
transmission. If a packet must be transmitted several times and it reaches
the maximum retry count, the transfer will fail and the 'KERMIT-65>' prompt
will return. If the remote Kermit sends an error packet, the text of the
packet will be displayed on the screen and the prompt will return.

Currently, a packet can be retransmitted manually by typing anything on the
keyboard. If a 'Q' is typed, the entire transmission will be aborted.

@Heading<The RECEIVE Command>
@Index[RECEIVE]
Syntax: @q<RECEIVE [@i{filespec}]>

The RECEIVE command tells KERMIT-65 to receive a file or file group from the
other system.  If only one file is being received, you may include the optional
@i{filespec} as the name to store the incoming file under; otherwise, the name
is taken from the incoming file header.  If the name in the header is not
a legal filename in DOS 3.3, KERMIT-65 will attempt to change it into
something legal. There are very few things that are illegal in
DOS 3.3. If FILE-WARNING is on and an incoming file has a name identical to
a file already existing on the diskette, KERMIT-65 will issue a warning to
the user and attempt to modify the filename to make it unique.

@Heading<GET>
@index<GET>
Syntax: @q<GET @i{remote-filespec}>

The GET command requests a remote KERMIT server to send the file or file group
specified by @i<remote-filespec>.  This command can be used with a KERMIT
server on the other end.

The remote filespec is any string that can be a legal file specification for
the remote system; it is not parsed or validated locally.

If the remote KERMIT is not capable of server functions, then you will probably
get an error message back from it like "Illegal packet type".  In this case,
you must connect to the other Kermit, give a SEND command, escape back, and
give a RECEIVE command.

@Heading<The CONNECT Command>
@index<CONNECT>
Syntax: @q<CONNECT>

Establish a terminal connection to the remote system. Get back to KERMIT-65
by typing the escape character followed by
the letter C.  The escape character is Control-@@ by default.  When you type
the escape character, several single-@|character commands are possible:

@Begin(Description,leftmargin +6,indent -4, spread 0)
@q<B>@\Send a BREAK Signal.

@q<C>@\Close the connection and return to KERMIT-65.

@q<S>@\Show status of the connection.

@q<0>@\Send a null.

@q<Connect-escape>@\Send the Connect-escape character itself.

@q<?>@\List all the possible single-character arguments.
@End(Description)
You can use the SET ESCAPE command to define a different escape character.

When 'CONNECTED', KERMIT-65 will be passing characters entered on the
keyboard to the remote system, and passing characters from the remote system
to the Apple screen. If VT52-EMULATION is turned on, Kermit will trap escape
codes and simulate the appropriate functions of a VT52 terminal.

On an Apple ][+ with an incomplete keyboard, special characters can be
obtained by prefixing regular characters with a right-arrow. Also,
Uppercase is shown in inverse and lowercase characters are displayed as
normal uppercase characters.

Here are the rules for using the special 2/2+ input, to get all printable
ASCII characters, and how they appear on the screen: 

Special meanings are applied in various contexts to certain characters.
The left and right arrow keys do special things, and sometimes the escape
key does as well.

For letters, the keyboard is always in either default UPPERCASE mode or
default lowercase mode.  When in UPPERCASE, all letters typed are sent out as
uppercase. In lowercase, all letters are sent as lowercase. To reverse the
case for the next character only, hit the right-arrow ("prefix") key. To
switch the default case, hit the prefix-key twice in a row.

For funny characters, the prefix key is also used to get the unusual
punctuation characters which are not on the Apple keyboard. Here they are:
(To represent the prefix character I am using the letter p).

@begin(verbatim)
	To get			Type	Appearence

	Left Square Bracket	p(	[
	Right Square Bracket	p)	]
	Left Curly Bracket	p<	{
	Right Curly Bracket	p>	}
	Underline		p-	_
	Backslash		p/	\
	Tilde (wiggle)		p^	~
	Vertical Line		p.	|
@end(verbatim)

The left-arrow key sends a rubout.

With left-arrow and right arrow doing special things, its a little
hard to enter their characters (^H and ^U respectivly). There is therefore
an escape from prefix mode sequence. If you type prefix-ESC, the next
character is sent without any interpretation.

Currently, it is impossible to turn this special input and display
on and off, so its a bit of a pain if you are on a Apple 2e.

@Heading<The HELP Command>
@Index<HELP>

Syntax: @q<HELP> 

Typing HELP alone prints a brief summary of the KERMIT-65 commands.

@Heading<The EXIT and QUIT Commands>
@Index<EXIT>

Syntax: @q<EXIT>

Exit from KERMIT-65.  You can restart the program,
provided you haven't run anything else, by typing 'CALL 2049'.

@Index<QUIT>

Syntax: @q<QUIT>

This is merely a synonym for EXIT.

@Heading<The SET Command>

Syntax: @q<SET @i{parameter} [@i{option}] [@i{value}]>

Establish or modify various parameters for file transfer or terminal
connection.  You can examine their values with the SHOW command.  The following
parameters may be SET:
@Begin(Description,spread 0.5)
DEBUGGING@\TERSE or VERBOSE packet information.

DEFAULT-DISK@\Which Diskette drive is used for file transfer?

DEVICE-DRIVER@\Which communication device is being used?

EIGHT-BIT-QUOTING@\Should eight-bit-quoting be used?

ESCAPE@\Character for terminal connection.

FILE-BYTE-SIZE@\SEVEN or EIGHT significant bits in a byte.

FILE-TYPE@\Of Apple DOS file being sent/received.

FILE-WARNING@\Warn users if incoming file exists?

IBM@\For communicating with an IBM mainframe

KEYBOARD@\][+ or //e keyboard.

LOCAL-ECHO@\Full or half duplex switch.

PARITY@\Character parity to use

RECEIVE@\Various parameters for receiving files

SEND@\Various parameters for sending files

SLOT@\Which slot # is communication device in?

VT52-EMULATION@\Should Kermit emulate a VT52 when connected?
@End(Description)

@Subheading<SET DEBUGGING>
@Index<Debugging>
Syntax: @q<SET DEBUGGING @i{options}>

Record the packet traffic on your terminal. 
@index<TERSE>@index<VERBOSE>
Options are:
@Begin(Description)
TERSE@\Show packet info only (brief).

VERBOSE@\Display packet field descriptions with packet info (lengthy).

OFF@\Don't display debugging information (this is the default).
@End(Description)

@Subheading<SET DEFAULT-DISK>
@index<DEFAULT-DISK>
Syntax: @q<SET DEFAULT-DISK @i{parameter} @i{value}>

This command will tell KERMIT-65 which disk drive should be used for
file transfers. The two parameters which may be set separately are
SLOT and DRIVE. The value for SLOT ranges from 1 to 7. The value
for DRIVE is either 1 or 2.

@Subheading<SET DEVICE-DRIVER>
@index<DEVICE-DRIVER>
Syntax: @q<SET DEVICE-DRIVER @i{parameter keyword}>

This command will tell KERMIT-65 what type of communication device is
being used. Currently, three different cards are supported, however, other
unsupported cards may work similar enough to one of the three available
that it may be possible to use them. KERMIT-65 must also be told
where the card is in the machine (see the SET SLOT command).
The options for this set command are:

@Begin(Description)
APPLE-COM-CARD@\The old Apple communication card (300 baud).

DC-HAYES@\The D.C. Hayes Micromodem II (300 baud).

SUPER-SERIAL-CARD@\The Apple Super Serial Card (300-19.2k baud).
@End(Description)

@Subheading<SET ESCAPE>
@Index<Escape Character for CONNECT>
Syntax: @q<SET ESCAPE @i{hexidecimal-number}>

Specify the control character you want to use to "escape" from remote
connections back to KERMIT-65.  The default is 0 (Control-@@).  The number is
the hex value of the ASCII control character, 1 to 37, for instance 2 is
Control-B.

@Subheading<SET FILE-BYTE-SIZE>
@index<FILE-BYTE-SIZE>
Syntax: @q<SET FILE-BYTE-SIZE @i{parameter}>

@Index<Byte Size>Byte size for Apple DOS file I/O.  The choices are
SEVEN-BIT or EIGHT-BIT.
@Begin(Description,leftmargin +8,indent -8)
SEVEN-BIT@\When sending a file, shut the H.O. bit. When receiving, turn
the H.O. bit on. This is done since text files are the only files which should
be sent as SEVEN-BIT files and text files only make sense to the Apple if
they are encoded in 'negative ascii' values.

EIGHT-BIT@\Always send and receive the bytes intact. All 8 bits are
significant.
@End(Description)

@Subheading<SET FILE-TYPE>
@index<FILE-TYPE>
Syntax: @q<SET FILE-TYPE @i{parameter keyword}>
@index<APPLESOFT>@index<INTEGER>@index<TEXT>@index<BINARY>

This will inform KERMIT-65 what type of DOS file is being sent or
received. It is important that this is set correctly since KERMIT-65 must
create a file of the appropriate type when receiving (and it has no way of
knowing what kind of file it is). When KERMIT-65 is sending, it must also
know the type of file since that tells it how to detect the actual
end-of-file. The options for this parameter are APPLESOFT, INTEGER, TEXT and
BINARY.

@Begin(Description,leftmargin +8,indent -8)
APPLESOFT@\The file being sent/received is an Applesoft Basic program.

INTEGER@\The file being sent/received is an Integer Basic program.

TEXT@\The file being sent/received is an ASCII Text file.

BINARY@\The file being sent/received is a Binary image.
@End(Description)

@Subheading<SET FILE-WARNING>
@index<FILE-WARNING>
Syntax: @q<SET FILE-WARNING ON @i(or) OFF>

This tells KERMIT-65 whether to warn the user about incoming filenames
conflicting with existing files or not.

@subheading<SET IBM>
@index<IBM>
Syntax: @q<SET IBM ON @i(or) OFF>

SET IBM actually sets a number of parameters. When setting it on, the
command also turns on LOCAL-ECHO (half-duplex) and sets PARITY to MARK.
When setting IBM OFF, LOCAL-ECHO will revert back to OFF and PARITY
will be set to NONE.
It should be used when doing file transfers with an IBM or
similar mainframe.

@subheading<SET KEYBOARD>
@index<KEYBOARD>
Syntax: @q<SET KEYBOARD 2P @i{or} 2E>

SET KEYBOARD tells KERMIT-65 if the user has a full keyboard (2E) or not (2P).
If the user is on an Apple ][+, this should be set to 2P (which is the
default). When set to that, certain character translations are available
by using the right-arrow key as a prefix character.

@subheading<SET SLOT>
@index<SLOT>
Syntax: @q<SET SLOT @i{parameter}>

This option tells KERMIT-65 in which slot the communication
device is located. The range for the parameter is 1-7.

@Heading<The SHOW Command>
@Index<SHOW>
Syntax: @q<SHOW> [@i<option>]

The SHOW command displays various information:
@Begin(Description,spread 0.5)
ALL@\All parameter settings (this is quite long).

DEBUGGING@\Debugging mode.

DEFAULT-DISK@\Which Diskette drive is used for file transfer?

DEVICE-DRIVER@\Which communication device is being used?

EIGHT-BIT-QUOTING@\Should eight-bit-quoting be used?

ESCAPE@\Character for terminal connection.

FILE-BYTE-SIZE@\SEVEN or EIGHT significant bits in a byte.

FILE-TYPE@\Of Apple DOS file being sent/received.

FILE-WARNING@\Warn users if incoming file exists?

IBM@\For communicating with an IBM mainframe

KEYBOARD@\][+ or //e keyboard.

LOCAL-ECHO@\Full or half duplex switch.

PARITY@\Character parity to use

RECEIVE@\Various parameters for receiving files

SEND@\Various parameters for sending files

SLOT@\Which slot # is communication device in?

VT52-EMULATION@\Should Kermit emulate a VT52 when connected?
@End(Description)
The above options are analogous to the equivalent SET commands.

@Heading<The STATUS Command>
Give statistics about the most recent file transfer. This includes information
such as number of characters sent/received, number of data characters
sent/received, and last error encountered.

@Section<Customizing, Building, and Installing KERMIT-65>

@Heading<Standard Installation>

@Subheading<The Procedure>

	The procedure to bootstrap an assembled KERMIT object file
to the Apple is as follows:

@begin(enumerate)
On the Apple, Type in the APPLBT.BAS program supplied
(See below). It is recommended that the user save this
program as it may be needed to bootstrap newer versions of
KERMIT or APPHXL in the future. Also, type the APPLESOFT program
in with none of the REMs. It will execute quicker and take
up less room.

Call and login to the mainframe on which the KERMIT-65 object file
resides. Do the following:
@begin(itemize)

@u(])IN#n          ! Where n is between 1 and 7

For Communication card, do the following:
@begin(itemize)

Dial number for computer system.

Seat phone receiver in modem cradle.

@u(])<Cntrl/A><Cntrl/F>     !Full duplex, 300 baud
@end(itemize)

For the D.C. Hayes Micromodem, do the following:
@begin(itemize)

@u(])<Cntrl/A><Cntrl/F>     ! Full duplex, 300 baud

@u(MICROMODEM II: BEGIN TERM) <Cntrl/A><Cntrl/Q>

@u(MICROMODEM II: DIALING:) nnn-nnnn<cr>  ! nnn-nnnn is number of computer system
@end(itemize)

For the Apple Super Serial Card, do the following:
@begin(itemize)
@u(])<Cntrl/A>

@u(APPLE SSC:)0D	! 8 data bits, 1 stop bit

@u(])<Cntrl/A>

@u(APPLE SSC:)0P	! Force no parity

@u(])<Cntrl/A>

@u(APPLE SSC:)nB	! n = 6 for 300 baud, n = 8 for 1200 baud

Dial number for computer system.

Seat phone receiver in modem cradle.

@u(])<Cntrl/A>

@u(APPLE SSC:)T		! Terminal mode, now talking to remote host
@end(itemize)
@end(itemize)

In your directory on the mainframe, the following files
should be present:
@begin(itemize)

APPLBT.FOR

APPHXL.HEX

APPLEK.HEX
@end(itemize)
Compile and execute APPLBT.FOR. This will be used
along with APPLBT.BAS on the Apple to load the
APPHXL program. Once APPLBT is executing on
the mainframe, give control back to the Apple
and then run APPLBT.BAS on the Apple. For either the
Communication Card or the D.C. Hayes Micromodem,
the procedure is:
@begin(itemize)
<Cntrl/A><Cntrl/X><cr>    ! Give control to Apple's Brain

@u(])LOAD APPLBT.BAS<cr>

@u(])LOMEM:9500<cr>

@u(])RUN<cr>
@end(itemize)

Relocate and save APPHXL. Type the following:
@begin(itemize)
@u(])CALL -151<cr>       ! Enter Apple's system monitor

@u(*)9000<2000.2280M<cr> ! Move APPHXL from $2000 to $9000

@u(*)<Cntrl/C><cr>       ! Reenter APPLESOFT

@u(])BSAVE APPHXL,A$9000,L$280<cr>  ! Save APPHXL to disk
@end(itemize)

Now simply start executing APPHXL.
@begin(itemize)
@u(])CALL -151<cr>       ! Enter monitor

@u(*)9000G<cr>           ! Start APPHXL

@u(SLOT FOR MODEM CARD? (1 TO 7) )n   ! 'n' is slot # of card (no <cr>)

@u(ENTER FILENAME TO LOAD )APPLEK.HEX<cr> ! Tell APPHXL what to load
@end(itemize)
APPHXL will print the byte count and load address for each line it is
receiving as it loads it into memory. At the end of each line, it will
print '[OK]' if the line was received properly or '[CHECKSUM ERROR]' if
there was a problem with it.


When APPHXL finishes type the following to the Apple:
@begin(verbatim)
	@u(])BSAVE KERMIT,A$801,L$4E00<cr> ! Save KERMIT to disk
@end(verbatim)

The user may set up a turn-key system by having the
hello file on the disk load and run KERMIT. The user may
also run KERMIT-65, change the defaults which are supplied in the
program such as SLOT and DEVICE-DRIVER, and then resave KERMIT-65.
The next time it is run, the user will not have to set these
values again.
If the user does not set up a turn-key system, he must
start KERMIT-65 by typing:
@begin(verbatim)
@u(])BRUN KERMIT<cr>        ! Execute KERMIT-65 on the Apple
@end(verbatim)
The Apple will display the following:
@begin(example)
	STEVENS/CU - APPLE ][ KERMIT-65  VER. 2.1
	KERMIT-65>
@end(example)
The user is now ready to transfer files.
@end(enumerate)

NOTE: For those users with the Apple Super Serial Card, the
<cntrl/A> intercept character should be shut off by typing <cntrl/A>Z
to the card before Kermit is run. The reason for this is that
Kermit uses <cntrl/A> as a Start-of-Header character and this character
may never reach the program if the card is taking it to be a command.

@Subheading<APPLBT.BAS - The APPLESOFT Bootstrap program>

@begin(verbatim,longlines keep)
10  REM  - LOADER FOR HXLOAD
11  OAD = 0
100 N$ = "0123456789ABCDEF"
110 D$ =  CHR$ (4)
130  PRINT D$;"IN#2" : REM CHANGE '2' TO SLOT OF COMM. CARD IF NECESSARY
135  PRINT  CHR$ (1); CHR$ (6)
136  PRINT D$;"PR#2" : REM CHANGE '2' TO SLOT OF COMM. CARD IF NECESSARY
137  PR#2  : REM THIS LINE SHOULD BE HERE ONLY FOR THE APPLE COMM. CARD
140 C3 = 0
150  HOME 
199  REM  - REQUEST NEXT LINE
200  REM - PUT A DOT ON THE SCREEN FOR EACH LINE RECEIVED 
201 C3 = C3 + 1: POKE 1024 + C3, ASC (".")
202 L$ = "":Y2% = 1: PRINT 
203  GET A$:L$ = L$ + A$:Y2% = Y2% + 1: IF Y2% < 81 THEN 203
205 C1 = 0:C2 = 0:I = 0
208  IF  LEFT$ (L$,1) >  = "0" AND  LEFT$ (L$,1) <  = "9" THEN 220
210 L$ =  RIGHT$ (L$, LEN (L$) - 1): GOTO 208
220 LL =  LEN (L$)
249  REM - FETCH THE DATA BYTE COUNT FOR THIS LINE
250  GOSUB 1000:C1 = C1 + B:CO = B
255  IF CO = 0 THEN 990
259  REM - CONSTRUCT THE LOAD ADDRESS FOR THIS LINE
260  GOSUB 1000:C1 = C1 + B:AD = B: GOSUB 1000:C1 = C1 + B
     :AD = AD * 256 + B
265 REM - IF THE LATEST VERSION OF CROSS IS USED, THIS SHOULD NOT
     BE NEEDED : REM AD = AD - 28672
266  IF AD < OAD THEN 990
267 OAD = AD
270  FOR X = 0 TO CO - 1
275  REM - GO GET A BYTE AND PUT IT IN THE NEXT MEMORY LOCATION
280  GOSUB 1000:C1 = C1 + B
290  POKE AD + X,B
300  NEXT X
310  GOSUB 1000:C2 = B: GOSUB 1000:C2 = C2 * 256 + B
320  IF C1<>C2 THEN POKE 1024+C3,ASC("E")
330  GOTO 201
990  FOR X = 1 TO 1000: NEXT X
995  PRINT D$;"IN#0": PRINT D$;"PR#0": HOME : END 
999  REM  - GET BYTE
1000  GOSUB 1501:B = N1: GOSUB 1501:B = B * 16 + N1
1010  RETURN 
1500  REM - GET NIBBLE 
1501  IF  LEN (L$) = 0 THEN N1 = 0: RETURN 
1510 H$ =  LEFT$ (L$,1)
1511  IF  LEN (L$) = 1 THEN L$ = "": GOTO 1525
1515 L$ =  RIGHT$ (L$, LEN (L$) - 1)
1520  REM - RETURN VALUE OF HEX NIBBLE
1525  FOR X1 = 1 TO 16
1530  IF H$ =  MID$ (N$,X1,1) THEN 1610
1540  NEXT X1
1550 REM - DIGIT WAS NOT FOUND, RETURN ZERO
1560 N1 = 0: RETURN 
1600  REM 
1610 N1 = X1 - 1: RETURN 

@end(verbatim)

@subheading<APPLBT.FOR - The Mainframe Bootstrap program>

@begin(verbatim)
      CHARACTER LINE*80,SENTNL*1
      OPEN (UNIT=00,FILE='APPHXL.HEX',MODE='ASCII')
   10 READ (UNIT=05,FMT=20) SENTNL
   20 FORMAT (A1)
      READ (UNIT=00,FMT=25,END=999) LINE
   25 FORMAT(A80)
      WRITE (UNIT=05,FMT=30) LINE
   30 FORMAT(A80)
      GO TO 10
  999 READ (UNIT=05,FMT=20) SENTNL
      STOP
      END

@end(verbatim)

@Heading<Alternative Installation Procedures>
@subheading<HEXloading from Diskette>

Once the user has a working version of KERMIT-65 on his system,
he can use this to load the .HEX files of future versions of KERMIT.
There is another hexload program available called APPDXL. This program
will load a hex file from an Apple diskette into memory. To use this
procedure, do the following:

@begin(enumerate)

Start executing APPHXL.
@begin(itemize)
@u(])BLOAD APPHXL        ! Get APPHXL into memory

@u(])CALL -151<cr>       ! Enter monitor

@u(*)9000G<cr>           ! Start APPHXL

@u(SLOT FOR MODEM CARD? (1 TO 7) )n   ! 'n' is slot # of card (no <cr>)

@u(ENTER FILENAME TO LOAD )APPDXL.HEX<cr> ! Tell APPHXL what to load
@end(itemize)
APPHXL will print what it is receiving on the screen
as well as loading it into memory.

Relocate and save APPDXL. Type the following:
@begin(itemize)
@u(])CALL -151<cr>       ! Enter Apple's system monitor

@u(*)9000<2000.2500M<cr> ! Move APPDXL from $2000 to $9000

@u(*)<Cntrl/C><cr>       ! Reenter APPLESOFT

@u(])BSAVE APPDXL,A$9000,L$500<cr>  ! Save APPDXL to disk
@end(itemize)

Use Kermit-65 to transfer the new version of itself over.
Make the Apple file a Text file. WARNING: This file will take
LOTS of space (about 180 sectors) so make sure the disk is reasonably empty.
The transfer takes a LONG time also, so please be patient.

Start executing APPDXL.
@begin(itemize)
@u(])BRUN APPDXL<cr>     ! Start APPDXL

@u(ENTER FILENAME TO LOAD )APPLEK.HEX<cr> ! Tell APPDXL what to load
@end(itemize)

When APPDXL finishes type the following to the Apple:
@begin(verbatim)
	@u(])BSAVE KERMIT,A$801,L$4E00<cr> ! Save KERMIT to disk
@end(verbatim)

@end(enumerate)

The new version of Kermit is now on disk.

@subheading<Using KERMIT-65 to transfer APPLEK.BIN>

There is yet another way to Bootstrap a new version of KERMIT onto
an Apple. If the user has an older version of KERMIT-65 and has access
to a machine with a valid copy of APPLEK.BIN, they can simply transfer
APPLEK.BIN using their version of KERMIT. Be sure to set the File-byte-size
to Eight-bit, and the File-type-mode to Binary before transfering the file
since this is the actual object code. No special loading or
conversion is needed. The file will be placed on the disk
and ready to run.

@heading<Files Supplied for KERMIT-65>

	The following files should be supplied on the distribution tape:

@begin(itemize)
APPLBT.BAS	- Initial bootstrap program to load APPHXL

APPLBT.FOR	- Program on mainframe to talk to APPLBT.BAS

APPHXL.M65	- Source of program to load KERMIT-65

APPHXL.HEX	- Assembled version of Hex load program

APPDXL.M65	- Source of program to load KERMIT-65 from Apple diskette

APPDXL.HEX	- Assembled version of Disk Hex load program

APPLEK.M65	- Source for the KERMIT-65 program

APPLEK.HEX	- Assembled version of KERMIT-65

APPLEK.BIN	- Assembled version of KERMIT-65 (Eight-bit Binary object code)

CROSS.MAC	- CROSS Microprocessor Assembler (Source)

CROSS.EXE	- CROSS Microprocessor Assembler (Object)
@end(itemize)

@heading<Customizing and Building KERMIT-65>

The source code to KERMIT-65 is in 6502 Assembler. It has been
formatted for CROSS which is a micro-Cross Assembler program which
runs on DECsystem-10s and DECSYSTEM-20s. Customizations would be made
the easiest if CROSS were available.

KERMIT-65 currently supports the following communications devices:
@begin(itemize)
FTASER - The Apple Communication card

FTHAYS - The D.C. Hayes Micromodem.

FTSSC  - The Apple Super Serial Card
@end(itemize)
All device drivers are included in the assembled version and may be used
by issuing a 'SET DEVICE-DRIVER' command to Kermit. If any of the
device drivers are not needed, it(they) may be excluded by setting the
appropriate feature test to zero in the Feature test section of the
source code. Excluding one or more device drivers can reduce
the size of the object code greatly. DO NOT disable all device drivers since
KERMIT-65 will then have no way of talking over the communication device.

	The feature test FTCOM must be set to the type of computer for
which KERMIT-65 is being assembled. The only machine KERMIT-65 is available for
currently is the Apple ][. This parameter must be set to FTAPPL.

After setting any options necessary in APPLEK.M65, rename it
to KERMIT.M65, and do the following:
@begin(itemize)
@u(.)R CROSS<cr>       ! Run CROSS Microprocessor Assembler

@u(*)KERMIT.HEX/PTP:KIM=KERMIT.M65/M65	! Generate .HEX file
@end(itemize)
This command will produce an ASCII HEX file which can be downline
loaded onto the Apple using APPHXL.
If a listing is desired, one can be produced by adding ",KERMIT.LST" after the
"/PTP:KIM" in the command line to CROSS.

@case(device,x9700="@COMMENT<BEGIN DUPLEX KLUDGE>
  @SendEnd(#Index `@begin<Transparent,PageBreak UntilOdd>@end<Transparent>')
  @COMMENT<END DUPLEX KLUDGE>")

