PAGE     70,120
;
CODE     SEGMENT
         ASSUME    CS:CODE, DS:CODE, ES:CODE
;
CR       EQU       0DH
LF       EQU       0AH
BELL     EQU       07H
INTADRS  EQU       5H*4
SEGADRS  EQU       62H*4
WHOAMI   EQU       1234H
ZEILEN   EQU       15
SPALTEN  EQU       45
VORSCHUB EQU       160-(SPALTEN*2)
DRUMAX   EQU       4
DRUANZ   EQU       3
;
ORG      100H
;
START:   JMP       SETUP
;
;
INTHNDLR:
         PUSH      AX
         PUSH      DS
         PUSHF
         PUSH      CS
         POP       DS
         CMP       USED,1
         JZ        FATALR
         MOV       PRTSCR,0
         MOV       USED,1
         CLI
         MOV       AX,SS
         MOV       SAVESS,AX
         MOV       SAVESP,SP
         MOV       AX,DS
         MOV       SS,AX
         MOV       SP,OFFSET ESTACK
         STI
         PUSH      BX
         PUSH      CX
         PUSH      DX
         PUSH      ES
         PUSH      SI
         PUSH      DI
         PUSH      BP
         CALL      DRUCKER
         POP       BP
         POP       DI
         POP       SI
         POP       ES
         POP       DX
         POP       CX
         POP       BX
         CLI
         MOV       AX,SAVESS
         MOV       SS,AX
         MOV       SP,SAVESP
         STI
         MOV       USED,0
         CMP       PRTSCR,0
         JNZ       PRINT
FATALR:  POPF
         POP       DS
         POP       AX
         IRET
PRINT:   POPF
         POP       DS
         POP       AX
         JMP       CS:[OLDJUMP]
;
;==========================================================
;DRUCKER: MENUE UND AUSWAHL
;
DRUCKER: CALL      SICHER
         CALL      SCHREIB
         MOV       BH,0
         MOV       AH,3
         INT       10H
         MOV       SAVECU,DX
         MOV       DH,ZEILEN-2
         MOV       DL,36
         MOV       AH,2
         INT       10H
KLO:     MOV       AX,0
         INT       16H
         CMP       AL,"1"
         JS        KLO
         CMP       AL,"8"+1
         JNS       KLO
         CMP       AL,"6"
         JNZ       WEI1
         MOV       PRTSCR,1
         JMP       RETURN
WEI1:    CMP       AL,"7"
         JNZ       WEI2
         CALL      VORW
         JMP       KLO
WEI2:    CMP       AL,"8"
         JNZ       WEI3
         CALL      ZURU
         JMP       KLO
WEI3:    CMP       AL,"5"
         JZ        RETURN
         CALL      PRIDRU
         JNC       KLO
RETURN:  MOV       DX,SAVECU
         MOV       AH,2
         MOV       BH,0
         INT       10H
         CALL      RESTAU
         RET
;
;==========================================================
;VORW: DRUCKER+1
;
VORW:    INC       DRUNUM
         CMP       DRUNUM,DRUMAX+1
         JNZ       NZG
         MOV       DRUNUM,0
NZG:     CALL      EINGES
         RET
;
;==========================================================
;ZURU: DRUCKER-1
;
ZURU:    DEC       DRUNUM
         CMP       DRUNUM,0-1
         JNZ       NZK
         MOV       DRUNUM,DRUMAX
NZK:     CALL      EINGES
         RET
;
;==========================================================
;PRIDRU: DRUCKERROUTINE
;
PRIDRU:  PUSH      AX
         MOV       AL,DRUNUM
         MOV       AH,0
         MOV       CL,12
         MUL       CL
         MOV       SI,OFFSET DRUZEI
         ADD       SI,AX
         POP       AX
         SUB       AL,"1"
         MOV       AH,0
         MOV       CL,DRUANZ
         MUL       CL
         ADD       SI,AX
         MOV       CX,DRUANZ
LODRU:   MOV       AL,BYTE [SI-1]
         MOV       DX,0
         MOV       AH,0
         INT       17H
         INC       SI
         LOOP      LODRU
         STC
RETDRU:  RET
;
;==========================================================
;SCHREIB: SCHREIBT TITEL
;
SCHREIB: MOV       SI,8000H
         MOV       DI,OFFSET BENU
         MOV       CX,ZEILEN
LO3:     PUSH      CX
         MOV       CX,SPALTEN
LO4:     MOV       AL,BYTE [DI-1]
         MOV       ES:BYTE [SI-1],AL
         INC       SI
         INC       DI
         MOV       ES:BYTE PTR [SI],60H
         INC       SI
         LOOP      LO4
         ADD       SI,VORSCHUB
         POP       CX
         LOOP      LO3
         CALL      EINGES
         RET
;
;==========================================================
;RESTAU: RESTAURIERT ALTEN BILDSCHIRM
;
RESTAU:  MOV       SI,OFFSET VORH
         MOV       AX,0B000H
         MOV       ES,AX
         MOV       DI,8000H
         MOV       CX,ZEILEN*2
LO5:     PUSH      CX
         MOV       CX,SPALTEN*2
LO6:     MOV       AL,BYTE [SI-1]
         MOV       ES:BYTE [DI-1],AL
         INC       SI
         INC       DI
         LOOP      LO6
         ADD       DI,VORSCHUB
         POP       CX
         LOOP      LO5
         RET
;
         DW 1                          ;PROGRAMM-NUMMER
;
;==========================================================
;SICHER: SICHERT ALTEN BILDSCHIRM
;
SICHER:  MOV       SI,OFFSET VORH
         MOV       AX,0B000H
         MOV       ES,AX
         MOV       DI,8000H
         MOV       CX,ZEILEN*2
LO1:     PUSH      CX
         MOV       CX,SPALTEN*2
LO2:     MOV       AL,ES:BYTE [DI-1]
         MOV       BYTE [SI-1],AL
         INC       SI
         INC       DI
         LOOP      LO2
         ADD       DI,VORSCHUB
         POP       CX
         LOOP      LO1
         RET
;
;==========================================================
;EINGES: SCHREIBT DEN EINGESTELLTEN DRUCKER AUF DEN
;        BILDSCHIRM
;
EINGES:  MOV       AX,0B000H
         MOV       ES,AX
         MOV       SI,8000H+11*160+27*2
         MOV       DI,OFFSET DRUNAME
         MOV       AX,16
         MOV       CL,DRUNUM
         MUL       CL
         ADD       DI,AX
         MOV       CX,16
DRUSCH:  MOV       AL,BYTE [DI-1]
         MOV       ES:BYTE [SI-1],AL
         INC       DI
         INC       SI
         INC       SI
         LOOP      DRUSCH
         RET
;
OLDJUMP  DD 0
IDENTY   DW WHOAMI
         DW 1000 DUP (?)
ESTACK   DW 1
SAVESP   DW 0
SAVESS   DW 0
SAVEDS   DW 0
VORH     DB SPALTEN*ZEILEN*4+4 DUP (?)
SAVECU   DW 1
PRTSCR   DB 0
USED     DB 0
DRUNUM   DB 0
BENU     DB "ͻ"
         DB "            Druckerverstellung             "
         DB "            Copyright (c) 1987             "
         DB "               OPTIMAL-SOFT                "
         DB "                 T.Friedl                  "
         DB "͹"
         DB "   1=10 Zeichen/Zoll   2=12 Zeichen/Zoll   "
         DB "   3=16 Zeichen/Zoll   4=20 Zeichen/Zoll   "
         DB "   5=Unverndert       6=Bildschirmdruck   "
         DB "   7=Drucker vor       8=Drucker zurck    "
         DB "Ķ"
         DB "   Eingestellter Drucker:                  "
         DB "Ķ"
         DB "   Bitte whlen Sie unter 1-8 aus:         "
         DB "ͼ"
DRUNAME: DB "EPSON FX-85     "
         DB "MANNESMANN MT180"
         DB "ANADEX          "
         DB "OLIVETTI PR15B  "
         DB "FACIT           "
DRUZEI:  DB 27,33,0,27,33,1,27,33,4,27,33,5
         DB 27,33,0,27,33,1,27,33,4,27,33,5
         DB 27,33,0,27,33,1,27,33,4,27,33,5
         DB 27,33,0,27,33,1,27,33,4,27,33,5
         DB 27,33,0,27,33,1,27,33,4,27,33,5
;
;==========================================================
;SETUP: INSTALLIERT HANDLER
;
SETUP:   MOV       AX,0
         MOV       ES,AX
         MOV       DI,SEGADRS+2
         MOV       AX,ES:[DI]
         MOV       ES,AX
         MOV       DI,OFFSET IDENTY
         MOV       CX,ES:[DI]
         CMP       CX,WHOAMI
         JNZ       INSTALL
         MOV       DX,OFFSET INSTA
         MOV       AH,9
         INT       21H
         INT       20H
         DW        2                   ; VERKAUFSNUMMER
INSTALL: MOV       DI,SEGADRS+2
         MOV       AX,0
         MOV       ES,AX
         MOV       AX,DS
         MOV       ES:[DI],AX
         MOV       SI,OFFSET OLDJUMP
         MOV       DI,INTADRS
         MOV       BX,ES:[DI]
         MOV       AX,ES:[DI+2]
         MOV       [SI],BX
         MOV       [SI+2],AX
         MOV       BX,OFFSET INTHNDLR
         MOV       AX,DS
         CLI
         MOV       ES:[DI],BX
         MOV       ES:[DI+2],AX
         STI
         PUSH      DS
         POP       ES
         MOV       DX,OFFSET NEU
         MOV       AH,9
         INT       21H
         MOV       DX,OFFSET SETUP
         INC       DX
         INT       27H
;
INSTA:   DB "Druckereinstellprogramm schon installiert.",CR,LF
         DB "Zur Aktivierung <SCRPRT> drcken.",CR,LF,"$"
NEU:     DB "Residenter Teil des Druckereinstellprogramms installiert.",CR,LF
         DB "$"
;
CODE     ENDS
         END      START
