;	     SHIFT IN .... ENGSCHRIFT
PAGE 70,132	;ASSEMBLER-FORMATIERUNG FUER AUSDRUCK DES LISTINGS .LST
		;70 ZEILEN JE SEITE, 132 ZEICHEN JE ZEILE
;
;
COMMENT $
*********
FUER AUSDRUCK DES LISTINGS
BEI A4-FORMAT  DRUCKER AUF ENGSCHRIFT
SCHALTEN ! SHIFT IN (0Fh ... ALT 15)
	    SHIFT IN .... ENGSCHRIFT

*****************************************************************
*****  Drucker-Treiber fr SEIKOSHA SL-80AI 24-Nadeldrucker *****
*****	    fr sinnvollen Ausdruck von 8-BIT-GRAPHIK	    *****
*****	 im SINGLE-DENSE und DOUBLE-DENSE Graphik-Modus     *****
*****	 NHERUNGSWEISE   IM   QUADRUPLE-DENSE-MODUS !!     *****
*****  Verwendbar fr alle 8-bit-Graphikprogramme, die den  *****
*****  Ausdruck ber den BIOS-INTERRUPT INT 17h durchfhren *****
*****************************************************************

*********$
;
;
COMMENT $
*********

************  LETZTE BEARBEITUNG  29. 5. 1987  ****************


*PA  = BEGINN DER PATCH-AREA
*ESC = ESCTABLE
*STO = SPEICHERPLAETZE UND EQUATES
*2   = BEGINN DES HAUPTPROGRAMMES
*A0  = STEUER- UND NORMAL-ZEICHEN TRENNEN, ALLG. EINSTIEG BEI A0
*SU  = SUCHEN EINES ZEICHENS IN EINEM TABLE
*I = BEGINN DER INITIALISIERUNGS-ROUTINE

*********$
;
;
	;---------------------------------;
	;BEGINN DES CODE-SEGMENTS	  ;
	;---------------------------------;
;
CSEG	SEGMENT  PUBLIC  PARA 'CODE'
			;
	ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG
	ORG  100h	;VORBEREITUNG FUER .COM UMWANDLUNG
			;Beim Programmstart eines .COM-Programmes
			;sind alle SEGMENTREGISTER auf das CODE-
			;SEGMENT gesetzt! IP = 0100h  SP = FFFEh
			;CX = Offset Programmende, alle uebrigen
			;Register sind 0000h
INIT	PROC NEAR	;Damit keine Schwierigkeiten mit RETURNS!
	JMP  INIT1	;Erster ausfuehrbarer Befehl f. .COM
;
;
;*PA**********************************
;*****				 *****
;*****	 P A T C H  -  A R E A	 *****
;*****				 *****
;*************************************
;
;
	PRNUMMER  DW  0 	;NUR AUSGABEN AUF PRINTER NUMMER "0h"
				;WERDEN UMKODIERT (=LPT 1)
;
	SDGR	DB  3		;Lnge der Sequenz Single-Density Graphik
		DB  ESC,"*",32  ;statt ESC K
;
	DDGR	DB  3		;Double-Density Graphik
		DB  ESC,"*",33  ;statt ESC L
;
	DSGR	DB  3		;Double-Density/Double-Speed Graphik
		DB  ESC,"*",33  ;statt ESC Y   --> DDENSE
;
	QDGR	DB  3		;Quadruple-Density Graphik --> DDENSE
		DB  ESC,"*",33  ;= ESC Z , nherungsweise Convertierung !!
;
	CRTI	DB  3		;CRT-Graphik I
		DB  ESC,"*",4   ;keine Convertierung !!
;
	CRTII	DB  3		;CRT-Graphik II
		DB  ESC,"*",38
;
	TDGR	DB  3		;Triple-Density (24-Pin) Graphik
		DB  ESC,"*",39
;
	PRINIT	DB  2
		DB  ESC,"@"
;
;
;*ESC************************************************
;***  ESCTABLE	=  TABELLE DER	ESCAPE-SEQUENZEN  ***
;****************************************************
;
ESCTABLE:	;JEDER EINTRAG GENAU....
	   DB 3 ;....BYTES LANG!
		;
		;ESCAPE ist das 1. Byte einer Steuer-Sequenz, im ESCTABLE steht:
		;
		;*als ERSTES  BYTE  * das 2. Byte dieser Sequenz!
		;		      00h wenn das ENDE des TABLES erreicht ist
		;*als WEITERE BYTES * die OFFSET-Adresse der Verarbeitungs-Routine
		;
;
	DB   "K"
	DW   OFFSET SDENSE
	DB   "L"
	DW   OFFSET DDENSE
	DB   "Y"
	DW   OFFSET DSPEED
	DB   "Z"
	DW   OFFSET QDENSE
	DB   "*"
	DW   OFFSET MODE
	DB   "?"
	DW   OFFSET REASSIGN
	DB   "@"
	DW   OFFSET RESET
				;Die folgenden Sequenzen werden zwar nicht
				;umkodiert, zur Unterscheidung ist jedoch
				;ein "Aussieben" notwendig!
				;
	DB   "J"                ;Forward linefeed
	DW   OFFSET DREIBYTE
	DB   "j"                ;Reverse linefeed
	DW   OFFSET DREIBYTE
	DB   "x"                ;Korrespondenzqualitt
	DW   OFFSET DREIBYTE
	DB   "p"                ;Proportionalschrift
	DW   OFFSET DREIBYTE
	DB   "S"                ;Super/Subscript
	DW   OFFSET DREIBYTE
	DB   "W"                ;Breitschrift (bis Ende-Befehl)
	DW   OFFSET DREIBYTE
	DB   "3"                ;Zeilenabstand setzen (n/216)
	DW   OFFSET DREIBYTE
	DB   "A"                ;Zeilenabstand setzen (n/72)
	DW   OFFSET DREIBYTE
	DB   "-"                ;Unterstreichen
	DW   OFFSET DREIBYTE
	DB   "C"                ;Seitenlnge setzen
	DW   OFFSET PAGELENGTH
	DB   "U"                ;Uni-/bidirektional drucken
	DW   OFFSET DREIBYTE
	DB   "D"                ;Horizontal-Tabulator setzen
	DW   OFFSET TAB
	DB   "Q"                ;rechten Rand setzen
	DW   OFFSET DREIBYTE
	DB   "l"                ;linken Rand setzen
	DW   OFFSET DREIBYTE
	DB   "X"                ;rechten und linken Rand setzen
	DW   OFFSET VIERBYTE
	DB   "a"                ;Zeilenausrichtung
	DW   OFFSET DREIBYTE
	DB   "N"                ;berspringen von Zeilen
	DW   OFFSET DREIBYTE
	DB   "!"                ;Kombination mehrerer Druckarten
	DW   OFFSET DREIBYTE
	DB   "R"                ;Nationalen Zeichensatz whlen
	DW   OFFSET DREIBYTE
	DB   "/"                ;TAB-Spur auswhlen
	DW   OFFSET DREIBYTE
	DB   "i"                ;Direktdruck ohne Druckbefehl
	DW   OFFSET DREIBYTE
	DB   19h		;Einzelblatteinzug
	DW   OFFSET DREIBYTE
	DB   "5"                ;Interpretation des CR-Befehls
	DW   OFFSET DREIBYTE
	DB   " "                ;Zeichenabstand festlegen
	DW   OFFSET DREIBYTE
	DB   "$"                ;Punktposition absolut
	DW   OFFSET VIERBYTE
	DB   "\"                ;Punktposition relativ
	DW   OFFSET VIERBYTE
;
	DB   0		;beendet ESCTABLE
;
;
;*STO
	;-------------------------------------------------;
	; E Q U A T E S  /  S P E I C H E R P L A E T Z E ;
	;-------------------------------------------------;
;
	ESC  EQU  1Bh
	CR   EQU  0Dh
	LF   EQU  0Ah
;
	DIFF = (OFFSET TESTFLAG2)-(OFFSET TESTFLAG1)
;
	EVEN		;Wegen der Suche von "Testflag1" im RAM mu
			;dieses an einer "geraden" Adresse beginnen
;
	TESTFLAG1 DW  1987h	;1. Test ob Treiber bereits im Speicher ?
;
	INT17	DD	0	;Speicherplatz fuer urspruenglichen
				;Vektor des INT 17 .... PRINTER-Interrupt
;
	INT23	DD	0	;Speicherplatz fr ursprnglichen Vektor
				;des INT 23 .... CTL-BREAK-Adresse

	HPSP	DW	0	;Speicherplatz fuer Stack-Pointer und
	HPSS	DW	0	;Stack-Segment des aufrufenden Hauptprogrammes
;
	UPSP	DW	0	;Speicherplatz fuer Stack-Pointer und
	UPSS	DW	0	;Stack-Segment des Seikosha-Drucker- Treibers
;
	VEKTOR	DD	0	;Speicherplatz fr OFFSET und SEGMENT des
				;Hauptprogrammes (fr CTL-BREAK)
;
	FLAG1	DB	0FFh	;SINGLE-DENSE	 ESC K	   wenn ungleich FFh,
	FLAG2	DB	0FFh	;DOUBLE-DENSE	 ESC L	   dann wurde ein
	FLAG3	DB	0FFh	;DD-DOUBLE-SPEED ESC Y	   REASSIGN der
	FLAG4	DB	0FFh	;QUADR.-DENSE	 ESC Z	   Graphik-Density
				;			   vorgenommen
;
	FLAG5	DB	0	;wird bei - nach dem Halbieren der Anzahl der
				;Graphik-Bytes - ungerader Zahl gesetzt
;
	AKTIVFLAG DW	0FFh	;Flag ob Treiber AKTIV (FFh)/INAKTIV (00h)
;
;
	TESTFLAG2 DW  0000h	;2. Test ob Treiber installiert ? Nach
				;Installation mit TESTFLAG1 berschrieben !
;
;
	;---------------------------------;
	;STACK- BEREICH DEFINIEREN	  ;
	;---------------------------------;
;
	STAPEL	DB	256 DUP (0)
;
	STAPELEND DB	0
;
;
;*2****************************************************************************
;******************************************************************************
;***							  ***
;***   BEGINN DES EIGENTLICHEN PRINTER-DRIVER-PROGRAMMS   ***
;***							  ***
;***   EINSPRUNG UEBER ### INT 17h ### BEI ## START ###   ***
;***							  ***
;***   UMSTIEGSROUTINE VOM HAUPT- IN DAS UNTERPROGRAMM	  ***
;***							  ***
;************************************************************
		;*
		;* AUFRUF: AL = CHAR.
		;*	   AH = 0,1,2 (0 = drucken)
		;*	   DX = PRINTER-NUMMER
		;*	   Alle verwendeten REGISTER GESICHERT
		;* RUECKGABE:
		;*	   AH = Drucker-Status
;
	ORG   400h	;damit bei Aenderungen in der Patch-Area
			;Programm-Beginn konstant bleibt!
			;
;
START	PROC  NEAR	;Einsprung ueber INT 17h, daher FLAGS,CS,IP
	ASSUME CS:CSEG	;bereits am STACK des Hauptprogrammes
			;
	PUSH BX 		;noch Stack des Hauptprogrammes
	PUSH BP
	PUSH ES
;
	CLI			;Interrupts sperren
	PUSH AX
	XOR  BX,BX
	MOV  ES,BX		;ES auf 0 (= Vektor-table) setzen
	MOV  BX,(23h*4h+2)	;Segment des CTL-BREAK-Vektors
	MOV  AX,ES:[BX]
	MOV  BX,CS
	CMP  AX,BX		;Ist CTL-BREAK-Adresse umgeleitet?
	JE   STA3
	CALL SETBREAK		;wenn nicht, umleiten
;
  STA3: POP  AX
	STI			;Interrupts wieder zulassen
;
	MOV  BX,CS:AKTIVFLAG	;Datensegment DS noch nicht gesetzt!!
	OR   BX,BX
	JZ   STA1
	MOV  BX,CS:PRNUMMER
	CMP  DX,BX	;SPEZIFIZIERTER PRINTER angesprochen ?
	JNZ  STA1	;ANDERE DRUCKER KEINE KONVERTIERUNG
	CMP  AH,0	;AH=0 --> CHAR IN AL DRUCKEN
	JNZ  STA1	;AH<>0 --> PRINTER-INITIALISIERUNG OD. STATUSABFR.
;
;#######
;*PUT
;
    PUT:		;Zeichen in das Unterprogramm uebergeben
			;NOCH ALTER STACK VOM HAUPTPROGRAMM
	PUSH  CX
	PUSH  DX
	PUSH  DS
	PUSH  SI
	PUSH  CS
	POP   DS	;DS DES UNTERPROGRAMMES LADEN
	ASSUME	DS:CSEG
	CLI		;INTERRUPTS SPERREN, DA SONST KATASTROPHE
	MOV  HPSS,SS	;STACK-SEGMENT UND -POINTER
	MOV  HPSP,SP	;AUSTAUSCHEN
	MOV  SS,UPSS
	MOV  SP,UPSP
	STI		;INTERRUPTS WIEDER ZULASSEN
	POP  CX
	POP  BX
	POP  BP
	POP  SI
	RET		;---> A2, wenn GET von A1 aufgerufen
;
   STA1:PUSH DS
	PUSH CS
	POP  DS 	;Datensegment setzen
	CALL PRINT
	POP  DS 	;Datensegment wieder rcksetzen
	POP  ES
	POP  BP
	POP  BX
	IRET		;Ruecksprung in das Hauptprogramm, wenn
			;Zeichen fuer anderen Drucker bestimmt,
			;oder Drucker-Initialisierung
;
;
;#######
;*GET
;
    GET:	  ;ZEICHEN vom Hauptprogramm HOLEN
	PUSH SI   ;Register SI, BP, BX, CX sichern
	PUSH BP
	PUSH BX
	PUSH CX
   GET0:CLI
	MOV  UPSS,SS	;STACK-SEGMENT und -POINTER tauschen
	MOV  UPSP,SP
	MOV  SS,HPSS
	MOV  SP,HPSP
	STI
	POP  SI
	POP  DS
	POP  DX
	POP  CX
	POP  ES
	POP  BP
	POP  BX 	;REGISTER WURDEN BEIM UP-BEGINN AM STAPEL ABGELEGT
	IRET		;UNSER PROGR. WURDE DURCH INT 17H AUFGERUFEN
;
;********************************************
;***** RUECKSPRUNG IN DAS HAUPTPROGRAMM *****
;********************************************
;###ENDE DER UMSTIEGS-ROUTINE
;############################
;
;
;*A0*************************************
;*** ROUTINE ZUM FESTSTELLEN VON      ***
;*** STEUERZEICHEN UND ACHTBITZEICHEN ***
;****************************************

;#####
			;
A1:	CALL GET	;ERGIBT ALS RETURN-ADRESSE A2
			;
    A2: MOV  BX,OFFSET A1 ;RETURN-ADRESSE (OFFSET) FUER A1
	PUSH BX 	  ;AM STACK ABLEGEN
;
	CMP  AL,ESC	;Zeichen = ESCAPE ?
	JE   ESCAPE
    A5: CALL PRINTX
	RET		;---> A1
;
;
ESCAPE:
	CALL GET		;Naechstes Zeichen lesen
	MOV  SI,OFFSET ESCTABLE
	JMP  SUCHEN
			;

;
;*SU************************************************
	;***ROUTINE ZUM SUCHEN EINER ESC-SEQUENZ ***
	;*******************************************
	;AUFRUF-PARAMETER   : SI = ANFANG-ADRESSE DES TABLES (ERSTES
	;			   BYTE  = LAENGE EINES EINTRAGES)
	;		      AL = ZEICHEN , AH = 0 (Zeichen drucken)
	;RUECKGABE-PARAMETER: KEINE !!
	;
	;
	;IM TABLE STEHT:
	;
	;*als ERSTES  BYTE  * der DEZ-(HEX-)Wert des zu suchenden ZEICHENS
	;		      00h wenn das ENDE des TABLES erreicht ist
	;*als WEITERE BYTES * OFFSET-Adresse der Verarbeitungs-Routine
	;
	;ACHTUNG: Das ZEICHEN 00h mu allenfalls an erster Stelle
	;im table stehen
	;
SUCHEN:
	XOR  DX,DX
	MOV  DL,[SI]	;Lnge eines Eintrags
	INC  SI 	;SI auf ersten Eintrag stellen
	XOR  CX,CX
    SU0:MOV  BL,[SI]	;Erstes Zeichen des Eintrags lesen
	CMP  AL,BL	;und vergleichen
	JE   SU2
	CMP  BL,00h	;Ende des table erreicht ??
	JE   SU1
	ADD  SI,DX	;SI auf nchsten Eintrag stellen
	LOOP SU0
;
    SU1:		;Sequenz nicht gefunden ...
	CALL SENDEN	;... ESC ausgeben ...
	RET		;... und Zeichen unverndert drucken
;
    SU2:MOV  BX,WORD PTR [SI+1] ;BX = OFFSET-Adresse der
				;Verarbeitungs-Routine
	JMP  BX 		;Verzweigung zur Routine mit JMP,
				;ausfhren, und von dort mit RET zurck
;
;
;****************************************************************
    ;*** ROUTINE ZU AUFBEREITUNG UND DRUCK EINER ZEICHENFOLGE ***
    ;************************************************************
    ;AUFRUF-PARAMETER : SI = OFFSET-ADR. DER ZEICHENANZAHL
    ;			  ANSCHLIESSEND FOLGEN DIE ZEICHEN
;
PRSTRING:
;
	PUSH  AX
	PUSH  CX
	PUSH  DX
	PUSH  SI
	XOR   CX,CX
	MOV   CL,[SI]	;= Lnge des Strings (max. 255)
	INC   SI
    PS1:MOV   AL,[SI]
	CALL  PRINTX
	INC   SI
	LOOP  PS1
	POP   SI
	POP   DX
	POP   CX
	POP   AX
	RET
;
;
PRINTX: MOV  DX,PRNUMMER
	XOR  AH,AH
PRINT:	PUSHF			;weil aus der BIOS-Routine mit
	CALL DWORD PTR INT17	;IRET zurckgesprungen wird
	RET
;
;****************************************************
;*********** GRAPHIK-VERARBEITUNGSROUTINEN **********
;****************************************************
;
ASSIGN: 	;wenn Zuordnung der ESC K,L,Y,Z Graphik gendert wurde
	JMP  MODE1
;
;
SDENSE: 		;ESC K n1 n2  ... 8 bit Standard-Dichte
	CMP  FLAG1,0FFh
	JE   SD1
	MOV  AL,FLAG1
	JMP  SHORT ASSIGN
   SD1: MOV  SI,OFFSET SDGR
	CALL PRSTRING
	CALL GRAPHIK1	;mit Convertierung in 24-Nadel-Modus
	RET
;
;
DDENSE: 		;ESC L n1 n2  ... 8 bit Doppelte Dichte
	CMP  FLAG2,0FFh
	JE   DD1
	MOV  AL,FLAG2
	JMP  SHORT ASSIGN
   DD1: MOV  SI,OFFSET DDGR
	CALL PRSTRING
	CALL GRAPHIK1	;mit Convertierung in 24-Nadel-Modus
	RET
;
;
DSPEED: 			;ESC Y n1 n2  ... 8 bit Doppelte Dichte und
	CMP  FLAG3,0FFh 	;doppelte Geschwindigkeit
	JE   DS1		; --> DDENSE bei normaler Geschwindigkeit
	MOV  AL,FLAG3
	JMP  SHORT ASSIGN
   DS1: MOV  SI,OFFSET DSGR
	CALL PRSTRING
	CALL GRAPHIK1		;mit Convertierung in 24-Nadel-Modus
	RET
;
;
QDENSE: 			;ESC Z n1 n2  ... 8 bit Quadruple Density
	CMP  FLAG4,0FFh 	;Seikosha kann im 24-Nadel-Modus nur einf che,
	JE   QD1		;zweifache oder dreifache Dichte aber keine
	MOV  AL,FLAG4		;vierfache !!! Daher convertiert dieser Treiber
	JMP  SHORT ASSIGN	;den QUADRUPLE-DENSITY-MODUS als DOUBLE-DENSE
   QD1: MOV  SI,OFFSET QDGR	;unter Zusammenfassung zweier aufeinander-
	CALL PRSTRING		;folgender Graphik-Bytes !!
	CALL GRAPHIK3		;Nherungsweise  Convertierung in den
	RET			;24-Nadel-Modus !!!!
;
;
MODE:			;ESC * m n1 n2	 ...  m = Graphik-Modus
	CALL GET
	XOR  SI,SI
 MODE1: CMP  AL,0
	JE   SDENSE+0Ch
	CMP  AL,1
	JE   DDENSE+0Ch
	CMP  AL,2
	JE   DSPEED+0Ch
	CMP  AL,3
	JE   QDENSE+0Ch
	CMP  AL,4
	JE   CRTGRI
	CMP  AL,6
	JE   CRTGRII
	CMP  AL,32
	JE   SD24GR
	CMP  AL,33
	JE   DD24GR
	CMP  AL,38
	JE   CRT24II
	JMP  TD24GR	;Falls nichts anderes, mu es dreifache Dichte sein!
;
;
CRTGRI: 			;ESC * 4 n1 n2	... Convertierung in den
	MOV  SI,OFFSET CRTI	;24-Nadel-Modus nicht mglich!
	CALL PRSTRING
	CALL GRAPHIK2		;ohne Convertierung in 24-Nadel-Modus !!!!
	RET
;
;
CRTGRII:			;ESC * 6 n1 n2
	MOV  SI,OFFSET CRTII
	CALL PRSTRING
	CALL GRAPHIK1	;mit Convertierung in 24-Nadel-Modus
	RET
;
;
SD24GR: 			;ESC * 32 n1 n2
	MOV  SI,OFFSET SDGR
	CALL PRSTRING
	CALL GRAPHIK2		;Normal verarbeiten
	RET
;
;
DD24GR: 			;ESC * 33 n1 n2
	MOV  SI,OFFSET DDGR
	CALL PRSTRING
	CALL GRAPHIK2		;Normal verarbeiten
	RET
;
;
CRT24II:			;ESC * 38 n1 n2
	MOV  SI,OFFSET CRTII
	CALL PRSTRING
	CALL GRAPHIK2		;Normal verarbeiten
	RET
;
;
TD24GR: 			;ESC * 39 n1 n2
	MOV  SI,OFFSET TDGR
	CALL PRSTRING
	CALL GRAPHIK2		;Normal verarbeiten
	RET
;
;
GRAPHIK1:			;Convertierung in den 24-Nadel-Modus
	CALL GRBYTES
	MOV  AL,CL
	CALL PRINTX
	MOV  AL,CH
	CALL PRINTX
;
   GR1: CALL GET
	PUSH BX
	PUSH CX
	MOV  CX,3
	CALL CONVERT
	POP  CX
	POP  BX
	LOOP GR1
	RET
;
;
GRAPHIK2:			;keine Convertierung, normale Verarbeitung
	CALL GET
	MOV  CL,AL
	CALL PRINTX
	CALL GET
	MOV  CH,AL
	CALL PRINTX
   GR2: CALL GET
	CALL PRINTX
	LOOP GR2
	RET
;
;
GRAPHIK3:			;Nherungsweise Convertierung in den
	CALL GRBYTES		;24-Nadel-Modus fr QUADRUPLE-DENSITY
	MOV  CX,BX		;Zhlerregister laden
	MOV  AL,BL
	CALL PRINTX
	MOV  AL,BH
	CALL PRINTX
	CMP  FLAG5,0
	JE   GR3		;wenn Byte-Anzahl gerade --> springen ...
	DEC  CX 		;.. sonst Zhlerregister um 1 vermindern
;
   GR3: CALL GET
	MOV  BL,AL
	CALL GET
	OR   AL,BL		;aus 2 Bytes eines machen !
	PUSH CX
	MOV  CX,3
	CALL CONVERT
	POP  CX
	LOOP GR3
;
	CMP  FLAG5,0
	JE   GR4
	CALL GET
	MOV  CX,3
	CALL CONVERT
   GR4: RET
;
;
GRBYTES:
	MOV  FLAG5,0		;"UNGERADE"-Flag rcksetzen
	CALL GET
	MOV  BL,AL		;Zahl der Graphik-Bytes einlesen ...
	CALL GET
	MOV  BH,AL
	MOV  CX,BX		;... und in das Zhlerregister bertragen,
	SHR  BX,1		;Zahl der Graphik-Bytes halbieren
	JNC  GRB1		;wenn Anzahl ungerade, dann...
	INC  BX 		;... BX um 1 erhhen und "UNGERADE"-Flag =
	MOV  FLAG5,0FFh 	;FLAG5 setzen
  GRB1: RET
;
;
CONVERT:
	XOR  BX,BX
   CON7:SHL  AL,1
	JNC  CON6
	OR   BH,11000000b
   CON6:SHL  AL,1
	JNC  CON5
	OR   BH,00111000b
   CON5:SHL  AL,1
	JNC  CON4
	OR   BH,00000110b
   CON4:SHL  AL,1
	JNC  CON3
	OR   BH,00000001b
	OR   BL,11000000b
   CON3:PUSH AX
	PUSH BX
	MOV  AL,BH
	CALL PRINTX
	POP  BX
	POP  AX
	MOV  BH,BL
	XOR  BL,BL
	SAL  AL,1
	JNC  CON2
	OR   BH,00110000b
   CON2:SAL  AL,1
	JNC  CON1
	OR   BH,00001110b
   CON1:SAL  AL,1
	JNC  CON0
	OR   BH,00000001b
	OR   BL,10000000b
   CON0:SAL  AL,1
	JNC  CON9
	OR   BL,01110000b	;Convertierung beendet, die Nadeln 21-24
				;werden nicht angesteuert !
   CON9:PUSH BX
	MOV  AL,BH
	CALL PRINTX
	POP  BX
	MOV  AL,BL
	CALL PRINTX
	RET
;
;
REASSIGN:
	CALL GET
	MOV  BL,AL
	CALL GET
	CMP  BL,"K"
	JNE  RE2
	MOV  FLAG1,AL
   RE2: CMP  BL,"L"
	JNE  RE3
	MOV  FLAG2,AL
   RE3: CMP  BL,"Y"
	JNE  RE4
	MOV  FLAG3,AL
   RE4: MOV  FLAG4,AL
	RET
;
;
SENDEN: PUSH AX
	MOV  AL,ESC	;... ESC ausgeben ...
	CALL PRINTX	;... und Zeichen unverndert drucken
	POP  AX
	CALL PRINTX
	RET
;
;
DREIBYTE:
	CALL SENDEN
	CALL GET
	CALL PRINTX
	RET
;
;
VIERBYTE:
	CALL DREIBYTE
	CALL GET
	CALL PRINTX
	RET
;
;
PAGELENGTH:
	CALL SENDEN
	CALL GET
	CMP  AL,0
	JNE  PL1
	CALL PRINTX	;wenn 00, dieses und nchstes Byte senden
	CALL GET
   PL1: CALL PRINTX
	RET
;
;
TAB:	CALL SENDEN
  TAB1: CALL GET
	CMP  AL,0
	JE   TAB2
	CALL PRINTX
	JMP  TAB1
;
  TAB2: CALL PRINTX
	RET
;
;
SETBREAK:			;Interrupts noch gesperrt, Segmente noch
				;nicht gesetzt, ES = 0 (Seg. der Vektortabelle)
	MOV  CS:INT23+2,AX	;Segment (noch in AX) in INT23 +2 speichern
	MOV  BX,23h*4
	MOV  AX,ES:[BX]
	MOV  CS:INT23,AX	;Offset in INT23 abspeichern
;
	MOV  AX,OFFSET BREAK	;Neuen Vektor fr  CTL-BREAK
	MOV  ES:[BX],AX 	;(Umleitungs ber den Treiber)
	MOV  AX,CS		;auf INT 23h ersetzen
	MOV  ES:[BX+2],AX
	RET
;
;
BREAK:	CLI			;Bei CTL-BREAK wird die Bearbeitung
	PUSH DS 		;unkontrolliert  abgebrochen, daher mu
	PUSH CS 		;die PRINTER-ROUTINE (aber nicht der Drucker !),
	POP  DS 		;wenn sie verwendet wurde, wieder in den Aus-
	MOV  HPSS,SS		;gangszustand versetzt werden ... zunchst
	MOV  HPSP,SP		;Datensegment setzen und
	MOV  SS,UPSS		;STACK-SEGMENT und -POINTER tauschen ...
	MOV  SP,UPSP
	STI
	MOV  BX,OFFSET BRK2
	JMP  REINIT		;... nun Re-Initialisierung ausfhren ...
;
  BRK2: CLI
	MOV  SS,HPSS		;... nun STACK-SEGMENT und -POINTER wieder
	MOV  SP,HPSP		;zurcktauschen und Datensegment wieder
	POP  DS 		;richtigstellen ...
;
JMP  DWORD PTR CS:INT23 	;... und die normale DOS-Routine fr
				;CTL-BREAK ausfhren (INT bleiben gesperrt)
;
;
RESET:			  ;RESET von PRINTER und TREIBER - ROUTINE
;
	PUSH CX 		;CX sichern
;
	MOV  SI,OFFSET PRINIT	;PRINTER - RESET ausfuehren
	CALL PRSTRING
;
	MOV  CX,0FFFFh		;DELAY, weil viele Drucker nach Empfang
   RES2:DEC  CX 		;von RESET (ESC @) einige Zeit "taub" sind
	JCXZ RES3
	JMP  RES2
;
   RES3:POP  CX
	MOV BX,OFFSET GET0 ;Ruecksprungadresse in BX uebergeben
;
REINIT: 		  ;Routine zur RE-INITIALISIERUNG
			  ;AUFRUF mit CALL oder JUMP! Wegen der STACK-
			  ;Manipulation muss Ruecksprungadresse, bzw.
			  ;Adresse der nach REINIT auszufuehrenden
			  ;Befehle in BX uebergeben werden !
;
	CLI		  ;Interrupts sperren
	MOV  AX,CS
	MOV  SS,AX
	MOV  AX,OFFSET STAPEL+255 ;Stackpointer laden
	MOV  SP,AX
;
	MOV  AX,OFFSET A2 ;EINSPRUNGADRESSE B1 AUF STACK ABLEGEN,
	PUSH AX 	  ;DAMIT NACH "STACK-TAUSCH" AUS "PUT"
			  ;MIT RETURN NACH A2 GESPRUNGEN WERDEN KANN
;
	XOR  BP,BP	;*** STACK - AUFBEREITUNG ***
	PUSH BP 	;nach PUT --> SI
	PUSH BP 	;nach PUT --> BP
	PUSH BP 	;nach PUT --> BX
	PUSH BP 	;nach PUT --> CX
;
	MOV  UPSS,SS	;STAPELSEGMENT UND STACKPOINTER DES UNTER-
	MOV  UPSP,SP	;PROGRAMMES ABSPEICHERN.
;
	PUSH BX 	;Ruecksprungadresse war in BX aufgehoben, nun
			;am STACK ablegen, damit nach STACK-Aufbe-
			;reitung mit RET zur folgenden Routine
			;gesprungen werden kann ! (GET, INIT8, BRK2)
;
	STI		  ;Interrupts wieder zulassen
;
	MOV  AX,00FFh
	MOV  FLAG1,AL	;FLAGS wieder auf FFh setzen
	MOV  FLAG2,AL
	MOV  FLAG3,AL
	MOV  FLAG4,AL
	MOV  FLAG5,AH	;FLAG5 auf 0 setzen
;
	RET
;
;
DISPLAY:
	MOV  AH,09h		  ;Meldung ausgeben, DS:DX zeigt auf Beginn des
	INT  21h		  ;Textes, dieser ist mit $ abgeschlossen !!
	RET
;
;
;*I****************************************************************************
	;*********************************;
	;    PROGRAMM-INITIALISIERUNG	  ;
	;				  ;
	;** ROUTINE BEREITS RESIDENT ?	  ;
	;   AKTIVIEREN/INAKTIVIEREN ?	  ;
	;** VEKTOR VON INT 17h AENDERN	  ;
	;** RUECKSPRUNGADRESSEN AM STAPEL ;
	;   ABLEGEN			  ;
	;** ERFOLGSMELDUNG AUSGEBEN	  ;
	;				  ;
	;** BEENDEN ABER RESIDENT BLEIBEN ;
	;				  ;
	;*********************************;
;
;
;
;
INIT1:	MOV  AH,35h	;DOS-Fktn. 35h = Unterbrechungsvektor
	MOV  AL,17h	;des INT 17h (PRINTER I/O)) feststellen
	INT  21h	;DOS-Interrupt	  (Rueckgabe in ES:BX)
;
	MOV  AX,WORD PTR ES:TESTFLAG1 ;Wenn bereits im Speicher
	MOV  DX,WORD PTR CS:TESTFLAG1 ;Nunmehriger Progr.Aufruf
	CMP  AX,DX
	JNE  INIT2
;
	MOV  AX,WORD PTR ES:TESTFLAG2
	MOV  DX,WORD PTR CS:TESTFLAG1
	CMP  AX,DX		      ;zustzliche 2. Prfung
	JE   IN20	;wenn EQUAL, bereits resident, andernfalls...
;
INIT2:	PUSH ES 	;Interrupt-VEKTOR am STACK sichern
	PUSH BX
	PUSH CS
	POP  DS 		;Datensegment setzen
	MOV  AX,TESTFLAG1	;...wenn Prfung mit INT-VEKTOR negativ,
	MOV  BX,0040h		;zustzlich im Speicher suchen !
	MOV  ES,BX		;TESTFLAG mu an GERADER ADRESSE beginnen
	JMP  SHORT IN22
;
   IN20:JMP  INIT3		;SHORT Jump "OUT OF RANGE" !
;
   IN21:CMP  BX,0A000h
	JAE  IN25	;... nicht gefunden, Routine nicht installiert!
	ADD  BX, 0FF0h
	MOV  ES,BX
   IN22:CLD		;Clear Direction Flag ... DI wird incrementiert
	MOV  CX,32768
	XOR  DI,DI
   IN26:REPNE SCASW	;Word-String (TESTFLAG1 in AX) suchen
	JCXZ IN21
;
	DEC  DI 	;wenn gefunden zeigt DI auf das NCHSTE WORT !!
	DEC  DI
	PUSH AX
	PUSH BX
	MOV  BX,DIFF		;Differenz d. Offset-Adr. in BX
	ADD  BX,DI		;ES:BX sollte nun auf Testflag2 zeigen
	MOV  AX,WORD PTR ES:[BX]
	MOV  BX,TESTFLAG1
	CMP  AX,BX
	JE   IN27	;wenn gefunden O.K. ...
	POP  BX
	POP  AX
	INC  DI 	;... wenn nicht gefunden, DX wieder auf
	INC  DI 	;das nchste Wort stellen
	JMP  IN26	;und weiter suchen
;
   IN27:POP  BX
	POP  AX
	MOV  DX,OFFSET TESTFLAG1	;Testflag1 in ES:DI
	CMP  DX,DI			;allerdings "absolute Adresse"!
	JC   IN23
	SUB  DX,DI		;wenn DI < DX  dann  ES > CS
	MOV  CL,4
	SHR  DX,CL		;Differenz der Offset-Adressen um 1 Nibble
	SUB  BX,DX		;verschoben von ES (=BX) subtrahieren
	JMP  SHORT IN24

   IN23:SUB  DI,DX		; DI  >  DX
	MOV  CL,4
	SHR  DI,CL
	ADD  BX,DI
;
	MOV  ES,BX			;SEGMENT des Treibers nun in ES
;
   IN24:MOV  AX,WORD PTR ES:TESTFLAG2	;Nun 2. Test ausfhren
	MOV  DX,WORD PTR CS:TESTFLAG1	;Das heit, der Interrupt-
					;Vektor wurde von einem anderen
					;Programm nochmals verndert !
	CMP  AX,DX
	JE   IN29	;wenn EQUAL, bereits resident, andernfalls...
;
   IN25:POP  BX 		;Interrupt VEKTOR wieder vom STACK
	POP  ES 		;holen und ...
	MOV  INT17,BX	       ;... Interrupt-Vektor sichern
	MOV  INT17+2,ES
;
	MOV  DX,OFFSET START ;Neuen Vektor in (DS:DX = START-
	MOV  AH,25h	     ;Adresse des Treibers) ueber DOS-
	MOV  AL,17h	     ;Fktn. 25h auf INT 17h ersetzen
	INT  21h	     ;DOS-Interrupt
;
	MOV  BX,OFFSET INIT8 ;Ruecksprungadresse von REINIT vorerst
			     ;in BX sichern, weil mit JMP zu REINIT
			     ;hingesprungen wird, aber von dort mit
			     ;RET nach INIT8 zurueck !
	JMP  REINIT
;
   IN29:
	PUSH ES 		;Startadresse des bereits geladenen
	MOV  BX,OFFSET START	;Treibers in INT17 speichern und ...
	MOV  INT17,BX
	MOV  INT17+2,ES
;
	MOV  AX,001Bh		;... Treiber-Routine und Drucker mit
	XOR  DX,DX		;  ESC @    rcksetzen
	PUSHF
	CALL DWORD PTR INT17
	MOV  AX,0040h
	XOR  DX,DX
	PUSHF
	CALL DWORD PTR INT17
	POP  ES
;
	MOV  DX,OFFSET M8
	CALL DISPLAY
	POP  BX 	;STACK korrigieren, Interrupt-Vektor am  Stack
	POP  BX 	;Code-Segment des gefundenen Treibers nun in ES:
;
INIT3:	MOV  AX,WORD PTR ES:PRNUMMER
	ADD  AL,31h
	MOV  BYTE PTR PRN,AL	;fuer korrekte Meldung
	MOV  DX,OFFSET M1
	CALL DISPLAY		;Installationsmeldung ausgeben
;
	MOV  AX,ES:AKTIVFLAG
	OR   AX,AX
	JZ   IN35		;Aktivflag = 0

	MOV  DX,OFFSET M4	;Programm AKTIV, Aktivflag = FFh
	CALL DISPLAY
	MOV  DX,OFFSET M7
	CALL DISPLAY
	MOV  DX,OFFSET M5
	CALL DISPLAY
	MOV  DX,OFFSET M3
	CALL DISPLAY
	MOV  DX,OFFSET M6
	CALL DISPLAY
;
	MOV  AH,01h		; = Tastatureingabe mit Echo
	INT  21h		;DOS-Interrupt
	OR   AL,20h		; J und j gleichwertig
	CMP  AL,6Ah
	JNZ  INIT4			;jede andere Eingabe als J
	MOV  WORD PTR ES:AKTIVFLAG,0	;ndert den Zustand nicht !
	MOV  DX,OFFSET M1
	CALL DISPLAY
	MOV  DX,OFFSET M3
	CALL DISPLAY
	MOV  DX,OFFSET M7
	CALL DISPLAY
	JMP  SHORT INIT4

;
   IN35:MOV  DX,OFFSET M3	;Programm INAKTIV, Aktivflag = 0
	CALL DISPLAY
	MOV  DX,OFFSET M7
	CALL DISPLAY
	MOV  DX,OFFSET M5
	CALL DISPLAY
	MOV  DX,OFFSET M4
	CALL DISPLAY
	MOV  DX,OFFSET M6
	CALL DISPLAY
;
	MOV  AH,01h		; = Tastatureingabe mit Echo
	INT  21h		;DOS-Interrupt
	OR   AL,20h		;J = j
	CMP  AL,6Ah
	JNZ  INIT4
	MOV  WORD PTR ES:AKTIVFLAG,0FFh
	MOV  DX,OFFSET M1
	CALL DISPLAY
	MOV  DX,OFFSET M4
	CALL DISPLAY
	MOV  DX,OFFSET M7
	CALL DISPLAY
;
INIT4:	MOV  AH,4Ch	;Programm beenden
	INT  21h
;
;
INIT8:		;**** NORMALE  INITIALISIERUNG ****
;
	MOV  AL,BYTE PTR PRNUMMER
	ADD  AL,31h
	MOV  PRN,AL
;
	MOV  AX,TESTFLAG1
	MOV  TESTFLAG2,AX	;Programm im Speicher installiert!
;
	CALL SETBREAK
;
	MOV  DX,OFFSET M1	;Installationsmeldung ausgeben
	CALL DISPLAY
	MOV  DX,OFFSET M2
	CALL DISPLAY
	MOV  DX,OFFSET M7
	CALL DISPLAY
;
	MOV  DX,OFFSET INIT1	;FESTSTELLEN DER ERSTEN FREIEN ADRESSE
				;DES PROGRAMMS, DAMIT PROGRAMMLAENGE BEKANNT
				;BEENDEN, ABER IM SPEICHER RESIDENT BLEIBEN
				;(INIT-Routine wird nicht mehr benoetigt)

	MOV  CL,4
	SHR  DX,CL
	INC  DX
	MOV  AH,31h
	INT  21h
;
;
M1	DB  CR,LF,LF,"*** SEIKOSHA-DRUCKER-TREIBER  V 1.0 SYRO/TGM 1987 ***"
	DB  CR,LF,LF,"*** FR 8-BIT GRAPHIK (Q-DENSITY  NHERUNGSWEISE) ***"
	DB  CR,LF,LF,"*** FUER  PARALLEL - PRINTER  LPT "
    PRN DB  0,"$"
;
M2	DB  "  INSTALLIERT  $"
;
M3	DB  "    INAKTIV    $"
;
M4	DB  "     AKTIV     $"
;
M5	DB  CR,LF,LF,"*** SOLL  PROGRAMM $"
;
M6	DB  "WERDEN ?  J/N   ***",CR,LF,LF,"$"
;
M7	DB  "***",CR,LF,LF,"$"
;
M8	DB  CR,LF,LF,"*** INFORMATION: INTERRUPT-VEKTOR WURDE VERNDERT ***$"
;
ENDE	DW  0
;
START	ENDP
;
;
INIT	ENDP
;
;
CSEG	ENDS
;
END	INIT
;***********************************************************************
;  DC2  (ALT 18) (12 hex) Drucker von Eng- auf Normalschrift schalten
;***********************************************************************
