program ASCII;

(* Erzeugung von ASCII-Zeichen
   ===========================

Anlegen einer Datei mit einer aufsteigenden Folge von ASCII-Zeichen
Beginn und Ende sind whlbar

Die Datei hat die Bezeichnung : ASxxxyyy.TXT wobei
xxx...Der dezimale ASCII-Kode des Beginns und
yyy...Der dezimale ASCII-Kode des Endes der ASCII-Zeichen darstellt
Beispiele:

AS000255.TXT enthlt alle 8-bit-ASCII-Zeichen
AS032127.TXT enthlt alle abdruckbaren 7-bit-ASCII-Zeichen (default)
AS128255.TXT enthlt den erweiterten IBM-Zeichensatz
AS065065.TXT enthlt nur das Zeichen 'A'

*)

type
   string14=string(.14.);
var
   name:string14;
   t:Text;
   i:integer;
   z:string(.80.);
   a,e:byte;

function strg (zif:byte):string14;
   (* Bildet aus einer Zahl zif (bis 255)
      einen String strg mit fhrenden Nullen
        1 --> '001'
      128 --> '128'
       23 --> '023'
   *)
   var
      strgg:string14;
   begin
      str(zif,strgg);
      if zif<100 then strgg:='0'+strgg;
      if zif<10 then strgg:='0'+strgg;
      strg:=strgg
   end;

begin
   ClrScr;
   WriteLn ('Erzeugung einer Datei aus ASCII-Zeichen');
   a:=32;e:=127;
   Write ('von (>=  0,( 32)) : '); ReadLn (a);
   Write ('bis (<=255,(127)) : '); ReadLn (e);
   if a>e then begin
      WriteLn ('Bereichsfehler');
      exit
   end;
   name:='AS'+strg(a)+strg(e)+'.TXT';
   Assign (t,name);
   Rewrite (t);
   z:='';
   for i:=a to e do begin
      if (i mod 32)=0 then begin
         WriteLn (t,z);
         WriteLn (z);
         z:=''
      end;
      z:=z+chr(i)
   end;
   if not ((i mod 32)=0) then begin
      WriteLn (t,z);
      WriteLn (z)
   end;
   Close (t);
   WriteLn ('Datei ',name,' angelegt');
end.

