program ASYNC;
(*
Test der seriellen Schnittstelle mit Prfstecker
================================================
Es werden drei Tests ausgefhrt:
1. Zeichen $AA und $55 auf TX gesendet
   wenn mit RX empfangen --> OK sonst --> FEHLER

2. DTR=0, RTS=0 : geprft wird CTS, RLSD, DSR
   CTS=0, RLSD=0, DSR=0  --> OK sonst --> FEHLER

3. DTR=1, RTS=1 : geprft wird CTS, RLSD, DSR
   CTS=1, RLSD=1, DSR=1  --> OK sonst --> FEHLER
*)

const

   SERA = $3F8;
   SERB = $2F8;

var
   SER_TX,SER_RX,SER_DL,SER_DH,
   SER_IE,SER_II,SER_LC,SER_MC,
   SER_LS,SER_MS:integer;
   ser : integer;
   c   : char;
   TEST1,TEST2: byte;
   STATUS:byte;
   CTS,RLSD,DSR:boolean;

procedure StatusAnalyse;
   (* Analysiert den Schnittstellenstatus
      und gibt eine entsprechende Meldung aus *)
   begin
      STATUS:=Port(.SER_LS.);
      if STATUS>=64 then begin
         STATUS:=STATUS-64;
         WriteLn ('TX-Register empty')
      end;
      if STATUS>=32 then begin
         STATUS:=STATUS-32;
         WriteLn ('TX-Buffer loaded in TX-Register');
      end;
      if STATUS>=16 then begin
         STATUS:=STATUS-16;
         WriteLn ('BREAK Detected at SIN');
      end;
      if STATUS>=8 then begin
         STATUS:=STATUS-8;
         WriteLn ('Framing Error');
      end;
      if STATUS>=4 then begin
         STATUS:=STATUS-4;
         WriteLn ('Parity Error');
      end;
      if STATUS>=2 then begin
         STATUS:=STATUS-2;
         WriteLn ('Overrun Error');
      end;
      if STATUS>=1 then begin
         STATUS:=STATUS-1;
         WriteLn ('Data loaded in RX-Buffer');
      end;
   end;

begin
   ClrScr;
   WriteLn ('Test der seriellen Schnittstelle mit Prfstecker');
   WriteLn ('================================================');
   WriteLn;
   WriteLn ('Fr den Test der seriellen Schnittstelle bentigen Sie');
   WriteLn ('den Prfstecker fr die serielle Schnittstelle');
   WriteLn ('Pin 2,3 und 1,7 und 4,5,8 und 6,20 verbunden');
   WriteLn;
   WriteLn ('Test serielle Schnittstelle 1/2 ?');
   c:=' ';
   while NOT (c in (.'1','2'.)) do Read (kbd,c);
   c:=UpCase (c);
   case C of
      '1': ser:=SERA;
      '2': ser:=SERB;
   end;

   SER_TX:=0+ser;
   SER_RX:=0+ser;
   SER_DL:=0+ser;
   SER_DH:=1+ser;
   SER_IE:=1+ser;
   SER_II:=2+ser;
   SER_LC:=3+ser;
   SER_MC:=4+ser;
   SER_LS:=5+ser;
   SER_MS:=6+ser;

   Port (.SER_IE.):=0;
   WriteLn;
   WriteLn ('Test RX-TX');
   WriteLn ('----------');
   WriteLn ('Es werden zwei Prfzeichen gesendet und beim Empfang verglichen');
   WriteLn ('Prfzeichen $AA');
   Port (.SER_TX.):=$AA;
   Delay (1000);
   StatusAnalyse;
   TEST1:=Port (.SER_RX.);
   WriteLn ('Prfzeichen $55');
   Port (.SER_TX.):=$55;
   Delay (1000);
   StatusAnalyse;
   TEST2:=Port (.SER_RX.);

   if (TEST1=$AA) and (TEST2=$55)
      then WriteLn ('OK')
      else WriteLn ('Fehler');
   WriteLn ('Taste drcken');
   ReadLn;
   WriteLn;
   WriteLn ('Schnittstellenleitungen');
   WriteLn ('-----------------------');
   WriteLn ('DTR=0,RTS=0');
   Port (.SER_MC.):=0;
   CTS:=Port (.SER_MS.) and 16=16;
   RLSD:=Port (.SER_MS.) and 128=128;
   DSR:=Port (.SER_MS.) and 32=32;
   WriteLn ('CTS =',CTS);
   WriteLn ('RLSD=',RLSD);
   WriteLn ('DSR =',DSR);
   if not CTS and not RLSD and not DSR
      then WriteLn ('OK')
      else WriteLn ('FEHLER');
   WriteLn ('Taste drcken');
   ReadLn;
   WriteLn ('DTR=1,RTS=1');
   Port (.SER_MC.):=3;
   CTS:=Port (.SER_MS.) and 16=16;
   RLSD:=Port (.SER_MS.) and 128=128;
   DSR:=Port (.SER_MS.) and 32=32;
   WriteLn ('CTS =',CTS);
   WriteLn ('RLSD=',RLSD);
   WriteLn ('DSR =',DSR);
   if CTS and RLSD and DSR
      then WriteLn ('OK')
      else WriteLn ('FEHLER');
end.
