
program CHKDSKF;

(*
Zusammenfassung durch CHKDSK wiederhergestellter verlorener Bereiche
====================================================================
Annahme: Die verlorenen Bereiche sind Textdateien,
deren Rekonstruktion erscheint mglich.

Das Betriebssystemkommando CHKDSK erzeugt Dateien des Typs FILE????.CHK.
Diese Dateien werden durch das Programm CHKDSKF
zu einer einzigen Datei CHKDSKF.TXT zusammengefat.
*)

const
     BufSize         = 20;
     RecSize         = 128;
type
     Bearbeitung     = (Lesen,Aendern);
     Buffer          = record
        case Art : Bearbeitung of
          Lesen      : (Feld1:array(.1..RecSize,1..BufSize.)of Byte;);
          Aendern    : (Feld2:array(.1..10000.)of Byte);
        end;
     DatName         = string(.25.);
var
     z               : char;
     Eingabe,Ausgabe : file;
     Pfad,
     EinName,AusName : DatName;
     EingabeBuffer   : Buffer;
     AusgabeBuffer   : Buffer;
     RecsRead        : integer;
     num             : integer;
     nums            : string(.4.);
     LetzteDatei     : boolean;

procedure COPY;
begin
     LetzteDatei:=false;
     str(num,nums);
     if (num>=0) AND (num<10) then nums:='000'+nums;
     if (num>=10) AND (num<100) then nums:='00'+nums;
     if (num>=100) AND (num<1000) then nums:='0'+nums;
     EinName:=Pfad+'\FILE'+nums+'.CHK';
     WriteLn (EinName);

     Assign (Eingabe,EinName);
     (*$I-*) Reset (Eingabe); (*$I+*)
     if NOT (IOResult=0) then begin
        WriteLn ('Datei ',EinName,' nicht vorhanden');
        LetzteDatei:=true;
        exit
     end;

     repeat
        BlockRead (Eingabe,EingabeBuffer,BufSize,RecsRead);
        BlockWrite (Ausgabe,EingabeBuffer,RecsRead)
     until RecsRead=0;

     Close (Eingabe);
end;


begin
     Write ('Laufwerk/Pfad der FILE????.CHK : ');
     ReadLn (Pfad);
     EingabeBuffer.Art:=Lesen;
     AusgabeBuffer.Art:=Lesen;
     Assign (Ausgabe,'CHKDSKF.TXT');
     Rewrite (Ausgabe);

     num:=0;
     repeat
       Copy;
       num:=num+1
     until LetzteDatei;
     Close (Ausgabe);
end.
