program CR;

(*
Ersetzt CRLF durch CR
=====================
In einer Datei mit whlbaren Namen
werden alle Folgen von CR-LF ($0D-$0A)
durch CR ($0D) ersetzt.
Die neu angelegte Datei heit TEMP
und mu vor der weiteren Verwendung umbenannt werden
Maximale Dateigre : 10000 Zeichen.
*)

const
     BufSize         = 20;
     RecSize         = 128;
     Ende:boolean=true;
type
     Bearbeitung     = (Lesen,Aendern);
     Buffer          = record
        case Art : Bearbeitung of
          Lesen      : (Feld1:array(.1..RecSize,1..BufSize.)of Byte;);
          Aendern    : (Feld2:array(.1..10000.)of Byte);
        end;
     String5         = string(.5.);

var
     z               : char;
     Tr              : String5;
     Eingabe,Ausgabe : file;
     Name            : string(.25.);
     EingabeBuffer   : Buffer;
     AusgabeBuffer   : Buffer;
     RecsRead,Max    : integer;
     Ein,Aus         : integer;

procedure Get (var z:byte);
  var i:integer;
  begin
    if Ein=0 then begin
       for i:=0 to 10000 do EingabeBuffer.Feld2(.i.):=$20;
       BlockRead (Eingabe,EingabeBuffer,BufSize,RecsRead)
    end;
    z:=EingabeBuffer.Feld2(.Ein.);
    Ein:=Ein+1;
    if Ein=Max then Ein:=0
  end;

procedure Put (z:byte);
  var i:integer;
  begin
    AusgabeBuffer.Feld2(.Aus.):=z;
    Aus:=Aus+1;
    if Aus=Max then begin
       BlockWrite (Ausgabe,AusgabeBuffer,BufSize);
       for i:=0 to 10000 do AusgabeBuffer.Feld2(.i.):=$20;
       Aus:=0;
    end
  end;

procedure BufferModify;
  var
    z:byte;

  begin
     while NOT (RecsRead=0) do begin
        Get (z); Put (z);
        if z=13 then Put (10);
     end;
  end;

begin
     ClrScr;
     WriteLn ('Ersetzt CRLF durch CR');
     WriteLn ('---------------------');
     Max:= RecSize*BufSize;
     Write ('Dateiname : ');
     ReadLn (Name);

     Assign (Eingabe,Name);
     Assign (Ausgabe,'TEMP');

     Reset (Eingabe);
     Rewrite (Ausgabe);

     Ein:=0;Aus:=0;
     RecsRead:=1;
     BufferModify;
     Put (26);
     BlockWrite (Ausgabe,AusgabeBuffer,BufSize);
     Close (Eingabe);
     Close (Ausgabe);
     WriteLn ('Datei TEMP angelegt')
end.
