program CTRL;

(*
Ersezt Steuerzeichen durch SPACE
================================
In einer Datei mit whlbaren Namen
werden die ASCII-Zeichen 11,12 und 14-31
durch 32 (SPACE) ersetzt.
Die neu angelegte Datei heit TEMP
und mu vor der weiteren Verwendung umbenannt werden.
Maximale Dateigre : 10000 Zeichen.
*)

const
     BufSize         = 20;
     RecSize         = 128;
type
     Bearbeitung     = (Lesen,Aendern);
     Buffer          = record
        case Art : Bearbeitung of
          Lesen      : (Feld1:array(.1..RecSize,1..BufSize.)of Byte;);
          Aendern    : (Feld2:array(.1..10000.)of Byte);
        end;

var
     z               : char;
     Eingabe,Ausgabe : file;
     Name            : string(.25.);
     EingabeBuffer   : Buffer;
     AusgabeBuffer   : Buffer;
     RecsRead,Max    : integer;
     Ein,Aus         : integer;

procedure BufferModify;
  var
    z:integer;
  begin
     Ein:=0;Aus:=0;
     while NOT ((Aus=Max) or (Ein=Max)) do begin
        z:=EingabeBuffer.Feld2(.Ein.);
        if NOT( (z>31) or (z=13) or (z=10) or (z<10)) then z:=32;
        AusgabeBuffer.Feld2(.Aus.):=z;
        Ein:=Ein+1;Aus:=Aus+1;
     end;
     Write('.');
  end;

begin
     ClrScr;
     WriteLn ('Entfernt Steuerzeichen mit Ausnahme von CRLF');
     WriteLn ('============================================');
     WriteLn;
     Max:= RecSize*BufSize;
     Write ('Dateiname : ');
     ReadLn (Name);

     Assign (Eingabe,Name);
     Assign (Ausgabe,'TEMP');

     Reset (Eingabe);
     Rewrite (Ausgabe);

     repeat
        BlockRead (Eingabe,EingabeBuffer,BufSize,RecsRead);
        BufferModify;
        BlockWrite (Ausgabe,AusgabeBuffer,RecsRead);
     until RecsRead=0;

     Close (Eingabe);
     Close (Ausgabe);

end.

