program CTRLIBM;

(*
Ersetzt IBM-Bildschirmzeichen durch ASCII-Zeichen
=================================================
Im IBM-Zeichensatz sind Zeichen enthalten, die nur am Bildschirm,
nicht aber am Drucker dargestellt werden knnen.
Diese Bildschirmzeichen werden vorwiegend in HELP-Bildschirmen
verwendet. Wenn die HELP-Bildschirme ausgedruckt werden sollen,
ist ein Ersatz dieser Zeichen durch ausdruckbare Zeichen notwendig.

In einer Datei mit whlbaren Namen
werden die IBM-Bildschirmzeichen 4,7,16,17,24,25,26,27,30,31
durch hnliche ASCII-Zeichen ersetzt.

Es gilt folgende Tabelle:
           04 :  '*'
           07 :  ''
           16 :  '>'
           17 :  '<'
           30 :  '^'
           31 :  'v'
           24 :  '^'
           25 :  'v'
           26 :  '>'
           27 :  '<'

Die neu angelegte Datei heit TEMP
und mu vor der weiteren Verwendung umbenannt werden.
Maximale Dateigre : 10000 Zeichen.

*)

const
     BufSize         = 20;
     RecSize         = 128;
type
     Bearbeitung     = (Lesen,Aendern);
     Buffer          = record
        case Art : Bearbeitung of
          Lesen      : (Feld1:array(.1..RecSize,1..BufSize.)of Byte;);
          Aendern    : (Feld2:array(.1..10000.)of Byte);
        end;

var
     z               : char;
     Eingabe,Ausgabe : file;
     Name            : string(.25.);
     EingabeBuffer   : Buffer;
     AusgabeBuffer   : Buffer;
     RecsRead,Max    : integer;
     Ein,Aus         : integer;

procedure BufferModify;
  var
    z:integer;
  begin
     Ein:=0;Aus:=0;
     while NOT ((Aus=Max) or (Ein=Max)) do begin
        z:=EingabeBuffer.Feld2(.Ein.);
        case z of
           04 :  z:=ord('*');
           07 :  z:=ord('');
           16 :  z:=ord('>');
           17 :  z:=ord('<');
           30 :  z:=ord('^');
           31 :  z:=ord('v');
           24 :  z:=ord('^');
           25 :  z:=ord('v');
           26 :  z:=ord('>');
           27 :  z:=ord('<');
        end;
        AusgabeBuffer.Feld2(.Aus.):=z;
        Ein:=Ein+1;Aus:=Aus+1;
     end;
     Write('.');
  end;

begin
     ClrScr;
     WriteLn ('Ersetzt IBM-Bildschirmzeichen durch ASCII-Zeichen');
     WriteLn ('=================================================');
     WriteLn ;
     Max:= RecSize*BufSize;
     Write ('Dateiname : ');
     ReadLn (Name);

     Assign (Eingabe,Name);
     Assign (Ausgabe,'TEMP');

     Reset (Eingabe);
     Rewrite (Ausgabe);

     repeat
        BlockRead (Eingabe,EingabeBuffer,BufSize,RecsRead);
        BufferModify;
        BlockWrite (Ausgabe,AusgabeBuffer,RecsRead);
     until RecsRead=0;

     Close (Eingabe);
     Close (Ausgabe);

end.

