program FLINE;

(*
Filtern einzelner Zeilen aus Textdatei
======================================
Jede Zeile beginnt mit einer besonderen Zeichenfolge
Die markierten Zeilen werden herausgefiltert oder gelscht
Das gefilterte Ergebnis wird in der Datei TEMP abgelegt
*)

var  z               : string(.90.); (* Haelt das gelesene Zeichen fest *)
     Eingabe,Ausgabe : Text;
     Name            : string(.25.);
     Beginn          : string(.10.);
     Laenge          : byte;
     Zaehler         : integer;
     Filter          : char;

begin
     ClrScr;
     WriteLn ('Filtern einzelner Zeilen aus Textdatei');
     WriteLn ('======================================');
     WriteLn ('Jede Zeile beginnt mit einer besonderen Zeichenfolge');
     WriteLn ('Die markierten Zeilen werden herausgefiltert oder gelscht');
     Write ('Die markierten Zeile beginnen mit : ');
     Read (Beginn);
     Laenge:=ord(Beginn(.0.));
     WriteLn ('  Laenge :',Laenge);
     repeat
        Write ('Zeilen (L)schen oder (F)iltern   : '); ReadLn (Filter);
        Filter:=UpCase (Filter)
     until Filter in (.'L','F'.);

     Write ('Dateiname : ');
     ReadLn (Name);

     Assign (Eingabe,Name);
     Assign (Ausgabe,'TEMP');

     Reset (Eingabe);
     Rewrite (Ausgabe);

     (* Eingabedatei umkodieren *)
     Zaehler:=0;
     while not eof(Eingabe) do begin (* Datei lesen *)
               ReadLn (Eingabe,z);
               case Filter of
               'F': if (copy (z,1,Laenge)=Beginn) then
                    begin
                      Zaehler:=Zaehler+1;
                      WriteLn (Ausgabe,z);
                      WriteLn (z)
                    end;
               'L': if not (copy (z,1,Laenge)=Beginn) then
                    begin
                      Zaehler:=Zaehler+1;
                      WriteLn (Ausgabe,z);
                      WriteLn (z)
                    end;
               end;

     end; (* Datei lesen *)

     Close (Eingabe);
     Close (Ausgabe);
     WriteLn (Zaehler,' Zeilen in Datei TEMP angelegt')
end.

