program IBMTRAN;

(*
Ersetzt IBM-Grafikzeichen (128 <= z <= 255) durch ASCII-Zeichen
===============================================================
In einer Datei werden alle IBM-Sonderzeichen
durch eine 7-bit-ASCII-Kompromidarstellung ersetzt.

Zeichen:  ersetzt  Zeichen:  ersetzt  Zeichen:  ersetzt
          durch              durch              durch
0-8       -        166 : {} a        212 : {} +
9,10      9,10     167 : {} o        213 : {} +
11,12     -        168 : {} ?        214 : {} +
13        13       169 : {} +        215 : {} +
14-25     14-25    170 : {} +        216 : {} +
26      Dateiende  171 : {} 1/2      217 : {} +
27-31     -        172 : {} 1/4      218 : {} +
32-127    32-127   173 : {} !        219 : {} #
128 : {} C        174 : {} <        220 : {} #
129 : {} ue       175 : {} >        221 : {} #
130 : {} e        176 : {}          222 : {} #
131 : {} a        177 : {}          223 : {} #
132 : {} ae       178 : {}          224 : {} a
133 : {} a        179 : {} !        225 : {} sz
134 : {} a        180 : {} +        226 : {} c
135 : {} c        181 : {} +        227 : {} p
136 : {} e        182 : {} +        228 : {} e
137 : {} e        183 : {} +        229 : {} s
138 : {} e        184 : {} +        230 : {} m
139 : {} i        185 : {} +        231 : {} t       
140 : {} i        186 : {} !        232 : {} p       
141 : {} i        187 : {} +        233 : {} v       
142 : {} Ae       188 : {} +        234 : {} z       
143 : {} A        189 : {} +        235 : {} d       
144 : {} E        190 : {} +        236 : {} oo      
145 : {} ae       191 : {} +        237 : {} o       
146 : {} AE       192 : {} +        238 : {} E       
147 : {} o        193 : {} +        239 : {} n       
148 : {} oe       194 : {} +        240 : {} =       
149 : {} o        195 : {} +        241 : {} +-      
150 : {} u        196 : {} -        242 : {} >=      
151 : {} u        197 : {} +        243 : {} <=      
152 : {} y        198 : {} +        244 : {} (       
153 : {} Oe       199 : {} !        245 : {} )       
154 : {} Ue       200 : {} +        246 : {} /       
155 : {} c        201 : {} +        247 : {} .=      
156 : {} L        202 : {} +        248 : {} o
157 : {} Yen      203 : {} +        249 : {} .       
158 : {} Pt       204 : {} +        250 : {} .       
159 : {} Fr       205 : {} =        251 : {} \/      
160 : {} a        206 : {} +        252 : {} "       
161 : {} i        207 : {} +        253 : {} 2
162 : {} o        208 : {} +        254 : {} *       
163 : {} u        209 : {} +        255 : {}         
164 : {} n        210 : {} +        
165 : {} N        211 : {} +        

Maximale Dateilnge : 10000 Zeichen
*)

const
     BufSize         = 20;
     RecSize         = 128;
     Ende:boolean=true;
type
     Bearbeitung     = (Lesen,Aendern);
     Buffer          = record
        case Art : Bearbeitung of
          Lesen      : (Feld1:array(.1..RecSize,1..BufSize.)of Byte;);
          Aendern    : (Feld2:array(.1..10000.)of Byte);
        end;
     String5         = string(.5.);

var
     z               : char;
     Tr              : String5;
     Eingabe,Ausgabe : file;
     Name            : string(.25.);
     EingabeBuffer   : Buffer;
     AusgabeBuffer   : Buffer;
     RecsRead,Max    : integer;
     Ein,Aus         : integer;

procedure Get (var z:byte);
  begin
    if Ein=0 then BlockRead (Eingabe,EingabeBuffer,BufSize,RecsRead);
    z:=EingabeBuffer.Feld2(.Ein.);
    Ein:=Ein+1;
    if Ein=Max then Ein:=0
  end;

procedure Put (z:byte);
  begin
    AusgabeBuffer.Feld2(.Aus.):=z;
    Aus:=Aus+1;
    if Aus=Max then begin
       BlockWrite (Ausgabe,AusgabeBuffer,BufSize);
       Aus:=0;
    end
  end;

procedure BufferModify;
  var
    z:byte;

  procedure Trans (z:string5);
     var i:byte;
         c:char;
     begin
        for i:=1 to length(z) do begin
           c:=copy(z,i,1);
           Put(ord(c));
           Write (c)
        end
     end;

  begin
     while NOT (RecsRead=0) do begin
        Get (z);
        case z of
            0 : {} Trans('');
            1 : {} Trans('');
            2 : {} Trans('');
            3 : {} Trans('');
            4 : {} Trans('');
            5 : {} Trans('');
            6 : {} Trans('');
            7 : {} Trans('');
            8 : {} Trans('');
            9 : {} Trans(chr(9));
            10 : {} Trans(chr(10));
            11 : {} Trans('');
            12 : {} Trans('');
            13 : {} Trans(chr(13));
            14 : {} Trans('');
            15 : {} Trans('');
            16 : {} Trans('');
            17 : {} Trans('');
            18 : {} Trans('');
            19 : {} Trans('');
            20 : {} Trans('');
            21 : {} Trans('');
            22 : {} Trans('');
            23 : {} Trans('');
            24 : {} Trans('');
            25 : {} Trans('');
            26 : {} begin
                      Trans(chr(26));
                      Ende:=true;
                      exit
                    end;
            27 : {} Trans('');
            28 : {} Trans('');
            29 : {} Trans('');
            30 : {} Trans('');
            31 : {} Trans('');
            32 : { } Trans(' ');
            33 : {!} Trans('!');
            34 : {"} Trans('"');
            35 : {#} Trans('#');
            36 : { $ } Trans('$');
            37 : {%} Trans('%');
            38 : {&} Trans('&');
            39 : {'} Put(z);
            40 : {(} Trans('(');
            41 : {)} Trans(')');
            42 : {*} Trans('*');
            43 : {+} Trans('+');
            44 : {,} Trans(',');
            45 : {-} Trans('-');
            46 : {.} Trans('.');
            47 : {/} Trans('/');
            48 : {0} Trans('0');
            49 : {1} Trans('1');
            50 : {2} Trans('2');
            51 : {3} Trans('3');
            52 : {4} Trans('4');
            53 : {5} Trans('5');
            54 : {6} Trans('6');
            55 : {7} Trans('7');
            56 : {8} Trans('8');
            57 : {9} Trans('9');
            58 : {:} Trans(':');
            59 : {;} Trans(';');
            60 : {<} Trans('<');
            61 : {=} Trans('=');
            62 : {>} Trans('>');
            63 : {?} Trans('?');
            64 : {@} Trans('@');
            65 : {A} Trans('A');
            66 : {B} Trans('B');
            67 : {C} Trans('C');
            68 : {D} Trans('D');
            69 : {E} Trans('E');
            70 : {F} Trans('F');
            71 : {G} Trans('G');
            72 : {H} Trans('H');
            73 : {I} Trans('I');
            74 : {J} Trans('J');
            75 : {K} Trans('K');
            76 : {L} Trans('L');
            77 : {M} Trans('M');
            78 : {N} Trans('N');
            79 : {O} Trans('O');
            80 : {P} Trans('P');
            81 : {Q} Trans('Q');
            82 : {R} Trans('R');
            83 : {S} Trans('S');
            84 : {T} Trans('T');
            85 : {U} Trans('U');
            86 : {V} Trans('V');
            87 : {W} Trans('W');
            88 : {X} Trans('X');
            89 : {Y} Trans('Y');
            90 : {Z} Trans('Z');
            91 : {[} Trans('[');
            92 : {\} Trans('\');
            93 : {]} Trans(']');
            94 : {^} Trans('^');
            95 : {_} Trans('_');
            96 : {`} Trans('`');
            97 : {a} Trans('a');
            98 : {b} Trans('b');
            99 : {c} Trans('c');
            100 : {d} Trans('d');
            101 : {e} Trans('e');
            102 : {f} Trans('f');
            103 : {g} Trans('g');
            104 : {h} Trans('h');
            105 : {i} Trans('i');
            106 : {j} Trans('j');
            107 : {k} Trans('k');
            108 : {l} Trans('l');
            109 : {m} Trans('m');
            110 : {n} Trans('n');
            111 : {o} Trans('o');
            112 : {p} Trans('p');
            113 : {q} Trans('q');
            114 : {r} Trans('r');
            115 : {s} Trans('s');
            116 : {t} Trans('t');
            117 : {u} Trans('u');
            118 : {v} Trans('v');
            119 : {w} Trans('w');
            120 : {x} Trans('x');
            121 : {y} Trans('y');
            122 : {z} Trans('z');
            123 : { } Trans('{');
            124 : {|} Trans('|');
            125 : { } Trans('}');
            126 : {~} Trans('~');
            127 : {} Trans('');
            128 : {} Trans('C');
            129 : {} Trans('ue');
            130 : {} Trans('e');
            131 : {} Trans('a');
            132 : {} Trans('ae');
            133 : {} Trans('a');
            134 : {} Trans('a');
            135 : {} Trans('c');
            136 : {} Trans('e');
            137 : {} Trans('e');
            138 : {} Trans('e');
            139 : {} Trans('i');
            140 : {} Trans('i');
            141 : {} Trans('i');
            142 : {} Trans('Ae');
            143 : {} Trans('A');
            144 : {} Trans('E');
            145 : {} Trans('ae');
            146 : {} Trans('AE');
            147 : {} Trans('o');
            148 : {} Trans('oe');
            149 : {} Trans('o');
            150 : {} Trans('u');
            151 : {} Trans('u');
            152 : {} Trans('y');
            153 : {} Trans('Oe');
            154 : {} Trans('Ue');
            155 : {} Trans('c');
            156 : {} Trans('L');
            157 : {} Trans('Yen');
            158 : {} Trans('Pt');
            159 : {} Trans('Fr');
            160 : {} Trans('a');
            161 : {} Trans('i');
            162 : {} Trans('o');
            163 : {} Trans('u');
            164 : {} Trans('n');
            165 : {} Trans('N');
            166 : {} Trans('a');
            167 : {} Trans('o');
            168 : {} Trans('?');
            169 : {} Trans('+');
            170 : {} Trans('+');
            171 : {} Trans('1/2');
            172 : {} Trans('1/4');
            173 : {} Trans('!');
            174 : {} Trans('<');
            175 : {} Trans('>');
            176 : {} Trans(' ');
            177 : {} Trans(' ');
            178 : {} Trans(' ');
            179 : {} Trans('!');
            180 : {} Trans('+');
            181 : {} Trans('+');
            182 : {} Trans('+');
            183 : {} Trans('+');
            184 : {} Trans('+');
            185 : {} Trans('+');
            186 : {} Trans('!');
            187 : {} Trans('+');
            188 : {} Trans('+');
            189 : {} Trans('+');
            190 : {} Trans('+');
            191 : {} Trans('+');
            192 : {} Trans('+');
            193 : {} Trans('+');
            194 : {} Trans('+');
            195 : {} Trans('+');
            196 : {} Trans('-');
            197 : {} Trans('+');
            198 : {} Trans('+');
            199 : {} Trans('!');
            200 : {} Trans('+');
            201 : {} Trans('+');
            202 : {} Trans('+');
            203 : {} Trans('+');
            204 : {} Trans('+');
            205 : {} Trans('=');
            206 : {} Trans('+');
            207 : {} Trans('+');
            208 : {} Trans('+');
            209 : {} Trans('+');
            210 : {} Trans('+');
            211 : {} Trans('+');
            212 : {} Trans('+');
            213 : {} Trans('+');
            214 : {} Trans('+');
            215 : {} Trans('+');
            216 : {} Trans('+');
            217 : {} Trans('+');
            218 : {} Trans('+');
            219 : {} Trans('#');
            220 : {} Trans('#');
            221 : {} Trans('#');
            222 : {} Trans('#');
            223 : {} Trans('#');
            224 : {} Trans('a');
            225 : {} Trans('sz');
            226 : {} Trans('c');
            227 : {} Trans('p');
            228 : {} Trans('e');
            229 : {} Trans('s');
            230 : {} Trans('m');
            231 : {} Trans('t');
            232 : {} Trans('p');
            233 : {} Trans('v');
            234 : {} Trans('z');
            235 : {} Trans('d');
            236 : {} Trans('oo');
            237 : {} Trans('o');
            238 : {} Trans('E');
            239 : {} Trans('n');
            240 : {} Trans('=');
            241 : {} Trans('+-');
            242 : {} Trans('>=');
            243 : {} Trans('<=');
            244 : {} Trans('(');
            245 : {} Trans(')');
            246 : {} Trans('/');
            247 : {} Trans('.=');
            248 : {} Trans('o');
            249 : {} Trans('.');
            250 : {} Trans('.');
            251 : {} Trans('\/');
            252 : {} Trans('"');
            253 : {} Trans('2');
            254 : {} Trans('*');
            255 : {} Trans(' ');
        end;
     end;
  end;

begin
     ClrScr;
     WriteLn ('Ersetzt IBM-Grafikzeichen durch ASCII-Zeichen');
     WriteLn ('---------------------------------------------');
     Max:= RecSize*BufSize;
     Write ('Dateiname : ');
     ReadLn (Name);

     Assign (Eingabe,Name);
     Assign (Ausgabe,'TEMP');

     Reset (Eingabe);
     Rewrite (Ausgabe);

     Ein:=0;Aus:=0;
     RecsRead:=1;
     BufferModify;
     Put (26);
     BlockWrite (Ausgabe,AusgabeBuffer,BufSize);
     Close (Eingabe);
     Close (Ausgabe);

end.
