program COPYQ {Kopieren von Dateien-Gruppen mit Rckfrage};

{$I DIRDEF.P}
{$I PARAMSTR.P}  (*Kann ab Turbo-Pascal 3.0 weggelassen werden*)
{$I LISTE.P}
{$I MSDOS.P}     (*CPM-80.P oder CPM-86.P je nach Betriebssystem*)
{$I SCANDIR.P}
{$I QUERY.P}
{$I OKAY.P}

type   DriveCode = byte; (* 0 ist Bezugslaufwerk, 1 ist A: usw.*)
var    SourceDrive,
       AktDrive      : DriveCode;
       NochEinmal    : char;
       Directory     : Liste;

function ZielDrive : DriveCode;
  var Befehl : string[2];
  begin
    if ParamCount>=2 then begin
                            Befehl:=ParamStr(2);
                            ZielDrive:=ord(Befehl[1]) and 15
                          end
                     else ZielDrive:=0
  end;

procedure KopiereFiles(L : Liste; Quelle,Ziel : DriveCode);
  var QuellFile,
      ZielFile       : file;
      PufferGroesse,
      FileGroesse,
      Zaehler        : integer;
      PufferPtr      : ^integer; (*Ermoeglicht eine Art dynamischer Dimensionierung*)
      MemSize        : real;
      SName, DName   : string[2];
  function MIN(x,y:integer):integer;
    begin if x<y then MIN:=x else MIN:=y end;
  begin
    new(PufferPtr); (*Jetzt zeigt PufferPtr auf Heap-Anfang*)
    SName:=chr(64+Quelle)+':';
    DName:=chr(64+Ziel)+':';
    if MaxAvail>0 then MemSize:=SpeicherEinheit*MaxAvail
                  else MemSize:=SpeicherEinheit*(65536.0+MaxAvail);
    if MemSize>65535.0 then MemSize:=65535.0;
    writeln('Puffergroesse: ',MemSize:1:0,' Bytes.'); writeln;
    PufferGroesse:=trunc(MemSize/128); (*Nix anderes als DIV*)
    while L<>NIL do
      with L^,Eintrag do
        begin
          if Flag then
            begin
              assign(QuellFile,SName+DirName); reset(QuellFile);
              assign(ZielFile,DName+DirName); rewrite(ZielFile);
              writeln(SName+DirName,' -> ',DName);
              FileGroesse:=FileSize(QuellFile);
              while FileGroesse>0 do
                begin
                  Zaehler:=MIN(PufferGroesse,FileGroesse);
                  Blockread(QuellFile,PufferPtr^,Zaehler);
                  Blockwrite(ZielFile,PufferPtr^,Zaehler);
                  FileGroesse:=FileGroesse-Zaehler
                end;
              close(QuellFile); close(ZielFile)
            end;
          L:=Naechster
        end
  end;

begin
  ClrScr; writeln('COPYQ vers 1.1 Januar 1986 by U.K.'); writeln;
  AktDrive:=AktLaufwerk;
  if ZielDrive>0
    then begin
           LiesDirectory(Directory,SourceDrive);
           if SourceDrive=0 then SourceDrive:=AktDrive;
           if Directory=NIL then begin writeln('Kein File!'); halt end;
           Query(Directory,SourceDrive,'Kopieren');
           If Okay(Directory,SourceDrive,'Kopieren')
             then
               repeat
                 DiskReset;
                 KopiereFiles(Directory,SourceDrive,ZielDrive);
                 write('Noch eine Kopie (J/N) ? ');
                 repeat
                   read(kbd,NochEinmal);NochEinmal:=upcase(NochEinmal)
                 until NochEinmal in ['J','N'];
                 writeln(NochEinmal)
               until NochEinmal='N';
               DiskAnmelden(AktDrive)
         end
    else writeln('Illegale Device-Zuweisung')
end.
