(****************************************************************************)
(*  Bibliotheks-Modul LISTE.BIB                                             *)
(*           Listenoperationen fuer geordnete Listen                        *)
(*  Setzt das Vorhandensein des Typs 'ListenInhalt' sowie die Funktion      *)
(*  'kleiner' voraus, die zwei Werte vom Typ 'ListenInhalt' vergleicht      *)
(*  t Liste   definiert eine nach 'kleiner' geordnete Liste                 *)
(*  (f passt(X,Y:ListenInhalt):boolean wird war, wenn X und Y bezueglich    *)
(*                                     kleiner gleich sind)                 *)
(*  p Einfuegen(var L:Liste; E:ListenInhalt)                                *)
(*  p Suchen(L:Liste; E:ListenInhalt; var P:Liste) sucht das Element E in   *)
(*       in der Liste S und gibt das Ergebnis im Zeiger P zurueck. Falls    *)
(*       das Element E in S nicht vorhanden ist, erhaelt P den Wert NIL     *)
(*  p Loeschen(var L:Liste; P:Liste) loescht aus der Liste das Element, auf *)
(*      das P zeigt. Die Prozedur prueft nicht, ob P wirklich auf ein       *)
(*      ListenElement zeigt.                                                *)
(*  Es wurde keine eigene Prozedur InitListe aufgenomen, da die             *)
(*  Initialisierung einfach mit L:=NIL vorgenommen wird                     *)
(****************************************************************************)

type   Liste         = ^ListenEintrag;
       ListenEintrag = record
                         Eintrag   : ListenInhalt;
                         Naechster : Liste
                       end;

function passt(X, Y : ListenInhalt) : boolean;
  begin
    passt:=not(kleiner(X,Y) or kleiner(Y,X))
  end;

procedure Einfuegen(var L : Liste; E : ListenInhalt);
  var p,q : Liste;
  begin
    q:=NIL; p:=L;
    while p<>NIL do
      with p^ do
        if kleiner(Eintrag,E) then begin q:=p; p:=naechster end else p:=NIL;
    new(p); p^.Eintrag:=E;
    if q=NIL
      then begin p^.Naechster:=L; L:=p end
      else begin p^.Naechster:=q^.naechster; q^.Naechster:=p end;
  end;

procedure Loeschen(var L : Liste; P : Liste);
  var q : Liste;
  begin
    q:=P^.Naechster;
    if q<>NIL then begin P^:=q^; dispose(q) end
    else if P=L then begin L:=NIL; dispose(p) end
    else begin
           q:=L; while q^.Naechster<>P do q:=q^.Naechster;
           q^.Naechster:=P^.Naechster; dispose(P)
         end
  end;

procedure Suchen(L : Liste; E : ListenInhalt; var P : Liste);
var gefunden : boolean;
  begin
    P:=L;
    while (P<>NIL) and (not gefunden) do
      begin
        gefunden:=passt(P^.Eintrag,E);
        if not gefunden then P:=P^.Naechster
      end
  end;
