(****************************************************************************)
(*  Bibliotheks-Modul PARAMSTR.BIB                                          *)
(*             ParamCount und ParamStr(x) fuer Turbo-Pascal<3.0             *)
(* (t ParamString)                                                          *)
(* (v ParamBefehl)                                                          *)
(* f ParamCount:byte  erhaelt als Wert die Anzahl der mit dem Programm-     *)
(*               Aufruf uebergebenen Parameter. Als Trennzeichen zwischen   *)
(*               zwei Parametern werden Blanks und Tabs(^I) erkannt         *)
(* f ParamStr(x:Byte):string[127] erhaelt als Wert den x-ten Parameter,     *)
(*               falls vorhanden, ansonsten undefiniert                     *)
(* Unter CP/M-80 sollten die uebergebenen Parameter eine Gesamtlaenge von   *)
(* 32 Zeichen nicht ueberschreiten!                                         *)
(*************************************************<<laser hole>>*************)

type ParamString = string[127];
var ParamBefehl : ParamString absolute (* $80 bei CP/M-80*)
                                         CSEG:$80 (*bei MSDOS*);
                                       (*DSEG:$80 bei CP/M-86*)

function ParamCount:byte; {Uebergibt die Anzahl der Parameter. Blanks oder
                           Tabs werden als Trennzeichen interpretiert}
  var tempCount : byte;
      tempStr   : ParamString;
  begin
    tempStr:=ParamBefehl+' ';
    tempCount:=0;
    while pos(^I,tempStr)>0 do
      begin
        insert(' ',tempStr,pos(^I,tempStr));
        delete(tempStr,pos(^I,tempStr),1)
      end;
    repeat
      while pos(' ',tempStr)=1 do delete(tempStr,1,1);
      if pos(' ',tempStr)>0 then
        begin
          tempCount:=succ(tempCount);
          delete(tempStr,1,pos(' ',tempStr))
        end
    until tempStr='';
    ParamCount:=tempCount
  end;

function ParamStr(x:byte):ParamString;
  var tempCount : byte;
      tempStr   : ParamString;
  begin
    tempStr:=ParamBefehl+' ';
    tempCount:=0;
    while pos(^I,tempStr)>0 do
      begin
        insert(' ',tempStr,pos(^I,tempStr));
        delete(tempStr,pos(^I,tempStr),1)
      end;
    repeat
      while pos(' ',tempStr)=1 do delete(tempStr,1,1);
      if pos(' ',tempStr)>0 then
        begin
          tempCount:=succ(tempCount);
          if tempCount=x then ParamStr:=copy(tempStr,1,pos(' ',tempStr)-1);
          delete(tempStr,1,pos(' ',tempStr))
        end
    until (tempStr='') or (tempCount=x)
  end;
                                                                                          