{****************************************************************************}
{*                          Directory-Scanner                               *}
{****************************************************************************}

{Das Modul setzt das Vorhandensein der Kommandoparameter-Funktionen
 ParamStr und ParamCount voraus, den Typ anystring, ebenso die
 Betriebssystem-Prozeduren und Funktionen. Es liefert
 die Prozedur LiesDirectory(Liste,Quelldrive).}

{****************************************************************************}
{*                Das Einlesen des aktuellen Directories                    *}
{****************************************************************************}

procedure LiesDirectory(var DirListe : Liste; var SourceDrive : byte);

  var FCB         : string[35];
      Puffer      : array[0..127] of char;
      Name        : string[8];
      Ext         : string[3];
      gef         : byte;
      i           : integer;
      tempEintrag : ListenInhalt;
      Befehl      : anystring;

  procedure MachFCB; {Analysiert die uebergebenen Parameter und stellt einen
                      gueltigen FCB (=File Control Block) her.}

    {$V-}
    procedure ErsetzeSternchen(var wort : anystring; laenge : byte);
      begin
        if pos('*',Wort)>0
          then
            begin Wort:=copy(Wort,1,pos('*',Wort)-1);
               while length(Wort)<laenge do Wort:=Wort+'?'
            end
          else while length(Wort)<laenge do Wort:=Wort+' '
      end;

    begin
      fillchar(FCB,36,0);
      if ParamCount>0 then Befehl:=ParamStr(1) else Befehl:='';
      if pos(':',Befehl)=2
        then begin SourceDrive:=ord(Befehl[1]) and 15; delete(Befehl,1,2) end
        else SourceDrive:=0;
      if Befehl='' then Befehl:='*.*';
      if pos('.',Befehl)=0 then Befehl:=Befehl+'.   ';
      Name:=copy(Befehl,1,pos('.',Befehl)-1);
      Ext:=copy(Befehl,pos('.',Befehl)+1,length(Befehl)-pos('.',Befehl));
      ErsetzeSternchen(Name,8);
      ErsetzeSternchen(Ext,3);
      FCB:=Name+Ext; FCB[0]:=chr(SourceDrive);
    end;

  begin
    MachFCB;
    DirListe:=NIL;
    gef:=ErsterEintrag(FCB,Puffer);
    while gef<>255 do
      with tempEintrag do
        begin
          DirName:=copy(Puffer,gef*32+2,11); insert('.',DirName,9);
          for i:=1 to 12 do DirName[i]:=chr(ord(DirName[i]) and 127);
          while pos(' ',DirName)>0 do delete(DirName,pos(' ',DirName),1);
          Einfuegen(DirListe,tempEintrag);
          gef:=NaechsterEintrag
        end;
  end;
